/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.extra.mq.engine.rabbitmq;

import com.rabbitmq.client.Channel;
import java.io.IOException;
import java.util.Map;
import org.dromara.hutool.core.io.IoUtil;
import org.dromara.hutool.extra.mq.MQException;
import org.dromara.hutool.extra.mq.Message;
import org.dromara.hutool.extra.mq.Producer;

public class RabbitMQProducer
implements Producer {
    private final Channel channel;
    private String exchange = "";

    public RabbitMQProducer(Channel channel) {
        this.channel = channel;
    }

    public RabbitMQProducer setExchange(String exchange) {
        this.exchange = exchange;
        return this;
    }

    public RabbitMQProducer queueDeclare(String queue, boolean durable, boolean exclusive, boolean autoDelete, Map<String, Object> arguments) {
        try {
            this.channel.queueDeclare(queue, durable, exclusive, autoDelete, arguments);
        }
        catch (IOException e) {
            throw new MQException(e);
        }
        return this;
    }

    @Override
    public void send(Message message) {
        try {
            this.channel.basicPublish(this.exchange, message.topic(), null, message.content());
        }
        catch (IOException e) {
            throw new MQException(e);
        }
    }

    @Override
    public void close() {
        IoUtil.closeQuietly(new AutoCloseable[]{this.channel});
    }
}

