/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.cron.pattern;

import java.time.LocalDateTime;
import java.util.Calendar;
import org.dromara.hutool.core.date.Week;

class PatternUtil {
    PatternUtil() {
    }

    static int[] getFields(LocalDateTime dateTime, boolean isMatchSecond) {
        int second = isMatchSecond ? dateTime.getSecond() : -1;
        int minute = dateTime.getMinute();
        int hour = dateTime.getHour();
        int dayOfMonth = dateTime.getDayOfMonth();
        int month = dateTime.getMonthValue();
        int dayOfWeek = Week.of(dateTime.getDayOfWeek()).getValue() - 1;
        int year = dateTime.getYear();
        return new int[]{second, minute, hour, dayOfMonth, month, dayOfWeek, year};
    }

    static int[] getFields(Calendar calendar, boolean isMatchSecond) {
        int second = isMatchSecond ? calendar.get(13) : -1;
        int minute = calendar.get(12);
        int hour = calendar.get(11);
        int dayOfMonth = calendar.get(5);
        int monthBase1 = calendar.get(2) + 1;
        int dayOfWeekBase0 = calendar.get(7) - 1;
        int year = calendar.get(1);
        return new int[]{second, minute, hour, dayOfMonth, monthBase1, dayOfWeekBase0, year};
    }
}

