/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.core.xml;

import java.beans.XMLEncoder;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import org.dromara.hutool.core.bean.BeanUtil;
import org.dromara.hutool.core.bean.copier.CopyOptions;
import org.dromara.hutool.core.exception.HutoolException;
import org.dromara.hutool.core.io.IORuntimeException;
import org.dromara.hutool.core.io.IoUtil;
import org.dromara.hutool.core.io.file.FileUtil;
import org.dromara.hutool.core.lang.Assert;
import org.dromara.hutool.core.regex.ReUtil;
import org.dromara.hutool.core.text.StrUtil;
import org.dromara.hutool.core.util.CharsetUtil;
import org.dromara.hutool.core.xml.DocumentBuilderUtil;
import org.dromara.hutool.core.xml.XmlConstants;
import org.dromara.hutool.core.xml.XmlMapper;
import org.dromara.hutool.core.xml.XmlSaxReader;
import org.dromara.hutool.core.xml.XmlWriter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;

public class XmlUtil
extends XmlConstants {
    public static Document readXml(String pathOrContent) {
        if (StrUtil.startWith((CharSequence)(pathOrContent = StrUtil.trim(pathOrContent)), '<')) {
            return XmlUtil.parseXml(pathOrContent);
        }
        return XmlUtil.readXml(FileUtil.file(pathOrContent));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Document readXml(File file) {
        Assert.notNull(file, "Xml file is null !", new Object[0]);
        if (!file.exists()) {
            throw new HutoolException("File [{}] not a exist!", file.getAbsolutePath());
        }
        if (!file.isFile()) {
            throw new HutoolException("[{}] not a file!", file.getAbsolutePath());
        }
        try (BufferedInputStream in = FileUtil.getInputStream(file);){
            Document document = XmlUtil.readXml(in);
            return document;
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    public static Document readXml(InputStream inputStream) throws HutoolException {
        return XmlUtil.readXml(new InputSource(inputStream), true);
    }

    public static Document readXml(Reader reader) throws HutoolException {
        return XmlUtil.readXml(new InputSource(reader), true);
    }

    public static Document readXml(InputSource source, boolean namespaceAware) {
        DocumentBuilder builder = DocumentBuilderUtil.createDocumentBuilder(namespaceAware);
        try {
            return builder.parse(source);
        }
        catch (Exception e) {
            throw new HutoolException(e, "Parse XML from stream error!", new Object[0]);
        }
    }

    public static Document parseXml(String xmlStr) {
        if (StrUtil.isBlank(xmlStr)) {
            throw new IllegalArgumentException("XML content string is blank !");
        }
        return XmlUtil.readXml(StrUtil.getReader(XmlUtil.cleanInvalid(xmlStr)));
    }

    public static void readBySax(File file, ContentHandler contentHandler) {
        BufferedInputStream in = null;
        try {
            in = FileUtil.getInputStream(file);
            XmlUtil.readBySax(new InputSource(in), contentHandler);
        }
        catch (Throwable throwable) {
            IoUtil.closeQuietly(in);
            throw throwable;
        }
        IoUtil.closeQuietly(in);
    }

    public static void readBySax(Reader reader, ContentHandler contentHandler) {
        try {
            XmlUtil.readBySax(new InputSource(reader), contentHandler);
        }
        catch (Throwable throwable) {
            IoUtil.closeQuietly(reader);
            throw throwable;
        }
        IoUtil.closeQuietly(reader);
    }

    public static void readBySax(InputStream source, ContentHandler contentHandler) {
        try {
            XmlUtil.readBySax(new InputSource(source), contentHandler);
        }
        catch (Throwable throwable) {
            IoUtil.closeQuietly(source);
            throw throwable;
        }
        IoUtil.closeQuietly(source);
    }

    public static void readBySax(InputSource source, ContentHandler contentHandler) {
        XmlSaxReader.of(source).read(contentHandler);
    }

    public static String toStr(Node doc) {
        return XmlUtil.toStr(doc, false);
    }

    public static String toStr(Node doc, boolean isPretty) {
        return XmlUtil.toStr(doc, CharsetUtil.UTF_8, isPretty);
    }

    public static String toStr(Node doc, Charset charset, boolean isPretty) {
        return XmlUtil.toStr(doc, charset, isPretty, false);
    }

    public static String toStr(Node doc, Charset charset, boolean isPretty, boolean omitXmlDeclaration) {
        StringWriter writer = StrUtil.getWriter();
        XmlUtil.write(doc, writer, charset, isPretty ? 2 : 0, omitXmlDeclaration);
        return writer.toString();
    }

    public static String format(Document doc) {
        return XmlUtil.toStr(doc, true);
    }

    public static String format(String xmlStr) {
        return XmlUtil.format(XmlUtil.parseXml(xmlStr));
    }

    public static void write(Document doc, File file, Charset charset) {
        XmlWriter.of(doc).setCharset(charset).setIndent(2).setOmitXmlDeclaration(false).write(file);
    }

    public static void write(Node node, Writer writer, Charset charset, int indent) {
        XmlUtil.write(node, writer, charset, indent, false);
    }

    public static void write(Node node, Writer writer, Charset charset, int indent, boolean omitXmlDeclaration) {
        XmlWriter.of(node).setCharset(charset).setIndent(indent).setOmitXmlDeclaration(omitXmlDeclaration).write(writer);
    }

    public static void write(Node node, OutputStream out, Charset charset, int indent) {
        XmlUtil.write(node, out, charset, indent, false);
    }

    public static void write(Node node, OutputStream out, Charset charset, int indent, boolean omitXmlDeclaration) {
        XmlWriter.of(node).setCharset(charset).setIndent(indent).setOmitXmlDeclaration(omitXmlDeclaration).write(out);
    }

    public static Document createXml() {
        return DocumentBuilderUtil.createDocumentBuilder(true).newDocument();
    }

    public static Document createXml(String rootElementName) {
        return XmlUtil.createXml(rootElementName, null);
    }

    public static Document createXml(String rootElementName, String namespace) {
        Document doc = XmlUtil.createXml();
        doc.appendChild(null == namespace ? doc.createElement(rootElementName) : doc.createElementNS(namespace, rootElementName));
        return doc;
    }

    public static Element getRootElement(Document doc) {
        return null == doc ? null : doc.getDocumentElement();
    }

    public static Document getOwnerDocument(Node node) {
        return node instanceof Document ? (Document)node : node.getOwnerDocument();
    }

    public static String cleanInvalid(String xmlContent) {
        if (xmlContent == null) {
            return null;
        }
        return ReUtil.replaceAll((CharSequence)xmlContent, INVALID_PATTERN, "");
    }

    public static String cleanComment(String xmlContent) {
        if (xmlContent == null) {
            return null;
        }
        return ReUtil.replaceAll((CharSequence)xmlContent, COMMENT_PATTERN, "");
    }

    public static List<Element> getElements(Element element, String tagName) {
        NodeList nodeList = StrUtil.isBlank(tagName) ? element.getChildNodes() : element.getElementsByTagName(tagName);
        return XmlUtil.transElements(element, nodeList);
    }

    public static Element getElement(Element element, String tagName) {
        NodeList nodeList = element.getElementsByTagName(tagName);
        int length = nodeList.getLength();
        if (length < 1) {
            return null;
        }
        for (int i = 0; i < length; ++i) {
            Element childEle = (Element)nodeList.item(i);
            if (childEle != null && childEle.getParentNode() != element) continue;
            return childEle;
        }
        return null;
    }

    public static String elementText(Element element, String tagName) {
        Element child = XmlUtil.getElement(element, tagName);
        return child == null ? null : child.getTextContent();
    }

    public static String elementText(Element element, String tagName, String defaultValue) {
        Element child = XmlUtil.getElement(element, tagName);
        return child == null ? defaultValue : child.getTextContent();
    }

    public static List<Element> transElements(NodeList nodeList) {
        return XmlUtil.transElements(null, nodeList);
    }

    public static List<Element> transElements(Element parentEle, NodeList nodeList) {
        int length = nodeList.getLength();
        ArrayList<Element> elements = new ArrayList<Element>(length);
        for (int i = 0; i < length; ++i) {
            Node node = nodeList.item(i);
            if (1 != node.getNodeType()) continue;
            Element element = (Element)nodeList.item(i);
            if (parentEle != null && element.getParentNode() != parentEle) continue;
            elements.add(element);
        }
        return elements;
    }

    public static void writeObjectAsXml(File dest, Object bean) {
        XMLEncoder xmlenc = null;
        try {
            xmlenc = new XMLEncoder(FileUtil.getOutputStream(dest, new OpenOption[0]));
            xmlenc.writeObject(bean);
        }
        catch (Throwable throwable) {
            IoUtil.closeQuietly(xmlenc);
            throw throwable;
        }
        IoUtil.closeQuietly(xmlenc);
    }

    public static <T> T xmlToBean(Node node, Class<T> beanClass) {
        return XmlUtil.xmlToBean(node, beanClass, null);
    }

    public static <T> T xmlToBean(Node node, Class<T> beanClass, CopyOptions copyOptions) {
        return XmlMapper.of(node).toBean(beanClass, copyOptions);
    }

    public static Map<String, Object> xmlToMap(String xmlStr) {
        return XmlUtil.xmlToMap(xmlStr, new LinkedHashMap<String, Object>());
    }

    public static Map<String, Object> xmlToMap(String xmlStr, Map<String, Object> result) {
        Document doc = XmlUtil.parseXml(xmlStr);
        Element root = XmlUtil.getRootElement(doc);
        root.normalize();
        return XmlUtil.xmlToMap(root, result);
    }

    public static Map<String, Object> xmlToMap(Node node) {
        return XmlUtil.xmlToMap(node, new LinkedHashMap<String, Object>());
    }

    public static Map<String, Object> xmlToMap(Node node, Map<String, Object> result) {
        XmlMapper.of(node).toMap(result);
        return result;
    }

    public static String mapToXmlStr(Map<?, ?> data) {
        return XmlUtil.toStr(XmlUtil.mapToXml(data, "xml"));
    }

    public static String mapToXmlStr(Map<?, ?> data, boolean omitXmlDeclaration) {
        return XmlUtil.toStr(XmlUtil.mapToXml(data, "xml"), CharsetUtil.UTF_8, false, omitXmlDeclaration);
    }

    public static String mapToXmlStr(Map<?, ?> data, String rootName) {
        return XmlUtil.toStr(XmlUtil.mapToXml(data, rootName));
    }

    public static String mapToXmlStr(Map<?, ?> data, String rootName, String namespace) {
        return XmlUtil.toStr(XmlUtil.mapToXml(data, rootName, namespace));
    }

    public static String mapToXmlStr(Map<?, ?> data, String rootName, String namespace, boolean omitXmlDeclaration) {
        return XmlUtil.toStr(XmlUtil.mapToXml(data, rootName, namespace), CharsetUtil.UTF_8, false, omitXmlDeclaration);
    }

    public static String mapToXmlStr(Map<?, ?> data, String rootName, String namespace, boolean isPretty, boolean omitXmlDeclaration) {
        return XmlUtil.toStr(XmlUtil.mapToXml(data, rootName, namespace), CharsetUtil.UTF_8, isPretty, omitXmlDeclaration);
    }

    public static String mapToXmlStr(Map<?, ?> data, String rootName, String namespace, Charset charset, boolean isPretty, boolean omitXmlDeclaration) {
        return XmlUtil.toStr(XmlUtil.mapToXml(data, rootName, namespace), charset, isPretty, omitXmlDeclaration);
    }

    public static Document mapToXml(Map<?, ?> data, String rootName) {
        return XmlUtil.mapToXml(data, rootName, null);
    }

    public static Document mapToXml(Map<?, ?> data, String rootName, String namespace) {
        Document doc = XmlUtil.createXml();
        Element root = XmlUtil.appendChild(doc, rootName, namespace);
        XmlUtil.appendMap(doc, root, data);
        return doc;
    }

    public static Document beanToXml(Object bean) {
        return XmlUtil.beanToXml(bean, null);
    }

    public static Document beanToXml(Object bean, String namespace) {
        return XmlUtil.beanToXml(bean, namespace, false);
    }

    public static Document beanToXml(Object bean, String namespace, boolean ignoreNull) {
        if (null == bean) {
            return null;
        }
        return XmlUtil.mapToXml(BeanUtil.beanToMap(bean, false, ignoreNull), bean.getClass().getSimpleName(), namespace);
    }

    public static boolean isElement(Node node) {
        return null != node && 1 == node.getNodeType();
    }

    public static Element appendChild(Node node, String tagName) {
        return XmlUtil.appendChild(node, tagName, null);
    }

    public static Element appendChild(Node node, String tagName, String namespace) {
        Document doc = XmlUtil.getOwnerDocument(node);
        Element child = null == namespace ? doc.createElement(tagName) : doc.createElementNS(namespace, tagName);
        node.appendChild(child);
        return child;
    }

    public static Node appendText(Node node, CharSequence text) {
        return XmlUtil.appendText(XmlUtil.getOwnerDocument(node), node, text);
    }

    public static void append(Node node, Object data) {
        XmlUtil.append(XmlUtil.getOwnerDocument(node), node, data);
    }

    private static void append(Document doc, Node node, Object data) {
        if (data instanceof Map) {
            XmlUtil.appendMap(doc, node, (Map)data);
        } else if (data instanceof Iterator) {
            XmlUtil.appendIterator(doc, node, (Iterator)data);
        } else if (data instanceof Iterable) {
            XmlUtil.appendIterator(doc, node, ((Iterable)data).iterator());
        } else {
            XmlUtil.appendText(doc, node, data.toString());
        }
    }

    private static void appendMap(Document doc, Node node, Map data) {
        data.forEach((key, value) -> {
            if (null != key) {
                Element child = XmlUtil.appendChild(node, key.toString());
                if (null != value) {
                    XmlUtil.append(doc, child, value);
                }
            }
        });
    }

    private static void appendIterator(Document doc, Node node, Iterator data) {
        Node parentNode = node.getParentNode();
        boolean isFirst = true;
        while (data.hasNext()) {
            Object eleData = data.next();
            if (isFirst) {
                XmlUtil.append(doc, node, eleData);
                isFirst = false;
                continue;
            }
            Node cloneNode = node.cloneNode(false);
            parentNode.appendChild(cloneNode);
            XmlUtil.append(doc, cloneNode, eleData);
        }
    }

    private static Node appendText(Document doc, Node node, CharSequence text) {
        return node.appendChild(doc.createTextNode(StrUtil.toStringOrEmpty(text)));
    }
}

