/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.core.io.stream;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import org.dromara.hutool.core.io.IORuntimeException;

public class LineCounter
implements Closeable {
    private final InputStream is;
    private final int bufferSize;
    private int count = -1;

    public LineCounter(InputStream is, int bufferSize) {
        this.is = is;
        this.bufferSize = bufferSize < 1 ? 1024 : bufferSize;
    }

    public int getCount() {
        if (this.count < 0) {
            try {
                this.count = this.count();
            }
            catch (IOException e) {
                throw new IORuntimeException(e);
            }
        }
        return this.count;
    }

    @Override
    public void close() throws IOException {
        if (null != this.is) {
            this.is.close();
        }
    }

    private int count() throws IOException {
        int pre;
        int i;
        byte[] buf = new byte[this.bufferSize];
        int readChars = this.is.read(buf);
        if (readChars == -1) {
            return 0;
        }
        int count = 1;
        int c = 0;
        while (readChars == this.bufferSize) {
            for (i = 0; i < this.bufferSize; ++i) {
                pre = c;
                c = buf[i];
                if (c != 10 && pre != 13) continue;
                ++count;
            }
            readChars = this.is.read(buf);
        }
        while (readChars != -1) {
            for (i = 0; i < readChars; ++i) {
                pre = c;
                c = buf[i];
                if (c != 10 && pre != 13) continue;
                ++count;
            }
            readChars = this.is.read(buf);
        }
        if (c == 13) {
            ++count;
        }
        return count;
    }
}

