/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.core.io;

import java.io.Writer;

public final class FastStringWriter
extends Writer {
    private static final int DEFAULT_CAPACITY = 16;
    private final StringBuilder stringBuilder;

    public FastStringWriter() {
        this(16);
    }

    public FastStringWriter(int initialSize) {
        if (initialSize < 0) {
            initialSize = 16;
        }
        this.stringBuilder = new StringBuilder(initialSize);
    }

    @Override
    public FastStringWriter append(char c) {
        this.stringBuilder.append(c);
        return this;
    }

    @Override
    public FastStringWriter append(CharSequence csq, int start, int end) {
        this.stringBuilder.append(csq, start, end);
        return this;
    }

    @Override
    public FastStringWriter append(CharSequence csq) {
        this.stringBuilder.append(csq);
        return this;
    }

    @Override
    public void write(int c) {
        this.stringBuilder.append((char)c);
    }

    @Override
    public void write(String str) {
        this.stringBuilder.append(str);
    }

    @Override
    public void write(String str, int off, int len) {
        this.stringBuilder.append(str, off, off + len);
    }

    @Override
    public void write(char[] cbuf) {
        this.stringBuilder.append(cbuf, 0, cbuf.length);
    }

    @Override
    public void write(char[] cbuf, int off, int len) {
        if (off < 0 || off > cbuf.length || len < 0 || off + len > cbuf.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return;
        }
        this.stringBuilder.append(cbuf, off, len);
    }

    @Override
    public void flush() {
    }

    @Override
    public void close() {
    }

    public String toString() {
        return this.stringBuilder.toString();
    }
}

