/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.core.data.masking;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.dromara.hutool.core.data.masking.MaskingHandler;
import org.dromara.hutool.core.data.masking.MaskingType;
import org.dromara.hutool.core.text.StrUtil;

public class MaskingManager {
    public static final char DEFAULT_MASK_CHAR = '*';
    public static final MaskingManager EMPTY = new MaskingManager(null);
    private final Map<String, MaskingHandler> handlerMap;
    private final char maskChar;

    public static MaskingManager getInstance() {
        return SingletonHolder.INSTANCE;
    }

    public static MaskingManager ofDefault(char maskChar) {
        return MaskingManager.registerDefault(maskChar);
    }

    public MaskingManager(Map<String, MaskingHandler> handlerMap) {
        this(handlerMap, '*');
    }

    public MaskingManager(Map<String, MaskingHandler> handlerMap, char maskChar) {
        this.handlerMap = handlerMap;
        this.maskChar = maskChar;
    }

    public MaskingManager register(String type, MaskingHandler handler) {
        this.handlerMap.put(type, handler);
        return this;
    }

    public String masking(String type, CharSequence value) {
        MaskingHandler handler;
        if (StrUtil.isEmpty(type)) {
            type = MaskingType.CLEAR_TO_NULL.name();
        }
        return null == (handler = this.handlerMap.get(type)) ? null : handler.handle(value);
    }

    private static MaskingManager registerDefault(char maskChar) {
        MaskingManager manager = new MaskingManager(new ConcurrentHashMap<String, MaskingHandler>(15, 1.0f), maskChar);
        manager.register(MaskingType.USER_ID.name(), str -> "0");
        manager.register(MaskingType.CHINESE_NAME.name(), manager::firstMask);
        manager.register(MaskingType.ID_CARD.name(), str -> manager.idCardNum(str, 1, 2));
        manager.register(MaskingType.FIXED_PHONE.name(), manager::fixedPhone);
        manager.register(MaskingType.MOBILE_PHONE.name(), manager::mobilePhone);
        manager.register(MaskingType.ADDRESS.name(), str -> manager.address(str, 8));
        manager.register(MaskingType.EMAIL.name(), manager::email);
        manager.register(MaskingType.PASSWORD.name(), manager::password);
        manager.register(MaskingType.CAR_LICENSE.name(), manager::carLicense);
        manager.register(MaskingType.BANK_CARD.name(), manager::bankCard);
        manager.register(MaskingType.IPV4.name(), manager::ipv4);
        manager.register(MaskingType.IPV6.name(), manager::ipv6);
        manager.register(MaskingType.FIRST_MASK.name(), manager::firstMask);
        manager.register(MaskingType.CLEAR_TO_EMPTY.name(), str -> "");
        manager.register(MaskingType.CLEAR_TO_NULL.name(), str -> null);
        return manager;
    }

    public String firstMask(CharSequence str) {
        if (StrUtil.isBlank(str)) {
            return "";
        }
        return StrUtil.replaceByCodePoint(str, 1, str.length(), this.maskChar);
    }

    public String idCardNum(CharSequence idCardNum, int front, int end) {
        if (StrUtil.isBlank(idCardNum)) {
            return "";
        }
        if (front + end > idCardNum.length()) {
            return "";
        }
        if (front < 0 || end < 0) {
            return "";
        }
        return StrUtil.replaceByCodePoint(idCardNum, front, idCardNum.length() - end, this.maskChar);
    }

    public String fixedPhone(CharSequence num) {
        if (StrUtil.isBlank(num)) {
            return "";
        }
        return StrUtil.replaceByCodePoint(num, 4, num.length() - 2, this.maskChar);
    }

    public String mobilePhone(CharSequence num) {
        if (StrUtil.isBlank(num)) {
            return "";
        }
        return StrUtil.replaceByCodePoint(num, 3, num.length() - 4, this.maskChar);
    }

    public String address(CharSequence address, int sensitiveSize) {
        if (StrUtil.isBlank(address)) {
            return "";
        }
        int length = address.length();
        return StrUtil.replaceByCodePoint(address, length - sensitiveSize, length, this.maskChar);
    }

    public String email(CharSequence email) {
        if (StrUtil.isBlank(email)) {
            return "";
        }
        int index = StrUtil.indexOf(email, '@');
        if (index <= 1) {
            return email.toString();
        }
        return StrUtil.replaceByCodePoint(email, 1, index, this.maskChar);
    }

    public String password(CharSequence password) {
        if (StrUtil.isBlank(password)) {
            return "";
        }
        return StrUtil.repeat(this.maskChar, 10);
    }

    public String carLicense(CharSequence carLicense) {
        if (StrUtil.isBlank(carLicense)) {
            return "";
        }
        if (carLicense.length() == 7) {
            carLicense = StrUtil.replaceByCodePoint(carLicense, 3, 6, this.maskChar);
        } else if (carLicense.length() == 8) {
            carLicense = StrUtil.replaceByCodePoint(carLicense, 3, 7, this.maskChar);
        }
        return carLicense.toString();
    }

    public String bankCard(CharSequence bankCardNo) {
        if (StrUtil.isBlank(bankCardNo)) {
            return StrUtil.toStringOrNull(bankCardNo);
        }
        if ((bankCardNo = StrUtil.cleanBlank(bankCardNo)).length() < 9) {
            return bankCardNo.toString();
        }
        int length = bankCardNo.length();
        int endLength = length % 4 == 0 ? 4 : length % 4;
        int midLength = length - 4 - endLength;
        StringBuilder buf = new StringBuilder();
        buf.append(bankCardNo, 0, 4);
        for (int i = 0; i < midLength; ++i) {
            if (i % 4 == 0) {
                buf.append(' ');
            }
            buf.append(this.maskChar);
        }
        buf.append(' ').append(bankCardNo, length - endLength, length);
        return buf.toString();
    }

    public String ipv4(CharSequence ipv4) {
        return StrUtil.subBefore(ipv4, '.', false) + StrUtil.repeat("." + this.maskChar, 3);
    }

    public String ipv6(CharSequence ipv6) {
        return StrUtil.subBefore(ipv6, ':', false) + StrUtil.repeat(":" + this.maskChar, 7);
    }

    static /* synthetic */ MaskingManager access$000(char x0) {
        return MaskingManager.registerDefault(x0);
    }

    private static class SingletonHolder {
        private static final MaskingManager INSTANCE = MaskingManager.access$000('*');

        private SingletonHolder() {
        }
    }
}

