/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.core.convert;

import java.io.Serializable;
import java.lang.reflect.Type;
import java.util.LinkedHashSet;
import java.util.Set;
import org.dromara.hutool.core.convert.ConvertException;
import org.dromara.hutool.core.convert.Converter;
import org.dromara.hutool.core.convert.ConverterWithRoot;
import org.dromara.hutool.core.convert.MatcherConverter;
import org.dromara.hutool.core.convert.impl.ArrayConverter;
import org.dromara.hutool.core.convert.impl.CastConverter;
import org.dromara.hutool.core.convert.impl.ClassConverter;
import org.dromara.hutool.core.convert.impl.CollectionConverter;
import org.dromara.hutool.core.convert.impl.DateConverter;
import org.dromara.hutool.core.convert.impl.EmptyBeanConverter;
import org.dromara.hutool.core.convert.impl.EntryConverter;
import org.dromara.hutool.core.convert.impl.EnumConverter;
import org.dromara.hutool.core.convert.impl.KBeanConverter;
import org.dromara.hutool.core.convert.impl.MapConverter;
import org.dromara.hutool.core.convert.impl.NumberConverter;
import org.dromara.hutool.core.convert.impl.PrimitiveConverter;
import org.dromara.hutool.core.convert.impl.RecordConverter;
import org.dromara.hutool.core.convert.impl.TimeZoneConverter;
import org.dromara.hutool.core.convert.impl.ZoneIdConverter;
import org.dromara.hutool.core.lang.Assert;
import org.dromara.hutool.core.reflect.TypeUtil;
import org.dromara.hutool.core.stream.StreamUtil;

public class SpecialConverter
extends ConverterWithRoot
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final Set<MatcherConverter> converterSet;

    public SpecialConverter(Converter rootConverter) {
        super(rootConverter);
        this.converterSet = SpecialConverter.initDefault(Assert.notNull(rootConverter));
    }

    @Override
    public Object convert(Type targetType, Object value) throws ConvertException {
        return this.convert(targetType, TypeUtil.getClass(targetType), value);
    }

    public Object convert(Type targetType, Class<?> rawType, Object value) throws ConvertException {
        Converter converter = this.getConverter(targetType, rawType, value);
        return null == converter ? null : converter.convert(targetType, value);
    }

    public Converter getConverter(Type type, Class<?> rawType, Object value) {
        return SpecialConverter.getConverterFromSet(this.converterSet, type, rawType, value);
    }

    private static Converter getConverterFromSet(Set<? extends MatcherConverter> converterSet, Type type, Class<?> rawType, Object value) {
        return StreamUtil.of(converterSet).filter(predicate -> predicate.match(type, rawType, value)).findFirst().orElse(null);
    }

    private static Set<MatcherConverter> initDefault(Converter rootConverter) {
        LinkedHashSet<MatcherConverter> converterSet = new LinkedHashSet<MatcherConverter>(64);
        converterSet.add(CollectionConverter.INSTANCE);
        converterSet.add(new MapConverter(rootConverter));
        converterSet.add(new EntryConverter(rootConverter));
        converterSet.add(CastConverter.INSTANCE);
        converterSet.add(DateConverter.INSTANCE);
        converterSet.add(PrimitiveConverter.INSTANCE);
        converterSet.add(NumberConverter.INSTANCE);
        converterSet.add(EnumConverter.INSTANCE);
        converterSet.add(ArrayConverter.INSTANCE);
        converterSet.add(RecordConverter.INSTANCE);
        converterSet.add(KBeanConverter.INSTANCE);
        converterSet.add(ClassConverter.INSTANCE);
        converterSet.add(EmptyBeanConverter.INSTANCE);
        converterSet.add(TimeZoneConverter.INSTANCE);
        converterSet.add(ZoneIdConverter.INSTANCE);
        return converterSet;
    }
}

