/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.core.cache.impl;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.locks.ReentrantLock;
import org.dromara.hutool.core.cache.GlobalPruneTimer;
import org.dromara.hutool.core.cache.impl.CacheObj;
import org.dromara.hutool.core.cache.impl.LockedCache;
import org.dromara.hutool.core.lang.Assert;
import org.dromara.hutool.core.lang.mutable.Mutable;
import org.dromara.hutool.core.thread.lock.NoLock;

public class TimedCache<K, V>
extends LockedCache<K, V> {
    private static final long serialVersionUID = 1L;
    private ScheduledFuture<?> pruneJobFuture;

    public TimedCache(long timeout) {
        this(timeout, new HashMap<Mutable<K>, CacheObj<K, V>>());
    }

    public TimedCache(long timeout, Map<Mutable<K>, CacheObj<K, V>> map) {
        this.capacity = 0;
        this.timeout = timeout;
        this.lock = map instanceof ConcurrentMap ? NoLock.INSTANCE : new ReentrantLock();
        this.cacheMap = Assert.isNotInstanceOf(LinkedHashMap.class, map);
    }

    @Override
    protected int pruneCache() {
        int count = 0;
        Iterator values = this.cacheObjIter();
        while (values.hasNext()) {
            CacheObj co = values.next();
            if (!co.isExpired()) continue;
            values.remove();
            this.onRemove(co.key, co.obj);
            ++count;
        }
        return count;
    }

    public TimedCache<K, V> schedulePrune(long delay) {
        this.pruneJobFuture = GlobalPruneTimer.INSTANCE.schedule(this::prune, delay);
        return this;
    }

    public void cancelPruneSchedule() {
        if (null != this.pruneJobFuture) {
            this.pruneJobFuture.cancel(true);
        }
    }
}

