/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.common.utils;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.alibaba.fastjson.serializer.SerializeConfig;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class JsonUtils {
    private static SerializeConfig mapping = new SerializeConfig();

    public static String object2json(Object obj) {
        if (obj == null) {
            return "{}";
        }
        return JSON.toJSONString((Object)obj, (SerializeConfig)mapping, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue});
    }

    public static String clearNullAttr(String json) {
        String result = "";
        if (!json.equals("")) {
            LinkedHashMap jsonMap = (LinkedHashMap)JSON.parseObject((String)json, (TypeReference)new TypeReference<LinkedHashMap<String, Object>>(){}, (Feature[])new Feature[0]);
            JSONObject jsonObject = new JSONObject(true);
            jsonObject.putAll((Map)jsonMap);
            for (Object keyTemp : jsonObject.keySet()) {
                if (keyTemp != null) continue;
                jsonObject.remove(keyTemp);
            }
            if (jsonObject != null) {
                result = JSON.toJSONString((Object)jsonObject);
            }
        }
        return result;
    }

    public static String linkedMap2Json(LinkedHashMap<? extends String, ? extends Object> map) {
        JSONObject jsonObject = new JSONObject(true);
        jsonObject.putAll(map);
        return jsonObject.toJSONString();
    }

    public static String getSortKeyJson(Map<String, Object> param) {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        ArrayList<String> keys = new ArrayList<String>(param.keySet());
        Collections.sort(keys);
        int size = keys.size();
        for (int i = 0; i < size; ++i) {
            result.put((String)keys.get(i), param.get(keys.get(i)));
        }
        return JsonUtils.linkedMap2Json(result);
    }

    public static Map<String, Integer> getKeyIndex(Map<String, Object> param) {
        LinkedHashMap<String, Integer> result = new LinkedHashMap<String, Integer>();
        ArrayList<String> keys = new ArrayList<String>(param.keySet());
        Collections.sort(keys);
        int size = keys.size();
        for (int i = 0; i < size; ++i) {
            result.put((String)keys.get(i), i);
        }
        return result;
    }

    public static String bean2json(Object bean) {
        return JsonUtils.object2json(bean);
    }

    public static String list2json(List<?> list) {
        if (list == null) {
            return "[]";
        }
        return JsonUtils.object2json(list);
    }

    public static String array2json(Object[] array) {
        if (array == null) {
            return "[]";
        }
        return JsonUtils.object2json(array);
    }

    public static String map2json(Map<?, ?> map) {
        return JsonUtils.object2json(map);
    }

    public static String set2json(Set<?> set) {
        if (set == null) {
            return "[]";
        }
        return JsonUtils.object2json(set);
    }

    public static String string2json(String s) {
        if (null == s) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        block10: for (int i = 0; i < s.length(); ++i) {
            char ch = s.charAt(i);
            switch (ch) {
                case '\"': {
                    sb.append("\\\\\"");
                    continue block10;
                }
                case '\\': {
                    sb.append("\\\\");
                    continue block10;
                }
                case '\b': {
                    sb.append("\\b");
                    continue block10;
                }
                case '\f': {
                    sb.append("\\f");
                    continue block10;
                }
                case '\n': {
                    sb.append("\\n");
                    continue block10;
                }
                case '\r': {
                    sb.append("\\r");
                    continue block10;
                }
                case '\t': {
                    sb.append("\\t");
                    continue block10;
                }
                case '/': {
                    sb.append("\\/");
                    continue block10;
                }
                default: {
                    if (ch >= '\u0000' && ch <= '\u001f') {
                        String ss = Integer.toHexString(ch);
                        sb.append("\\u");
                        for (int k = 0; k < 4 - ss.length(); ++k) {
                            sb.append('0');
                        }
                        sb.append(ss.toUpperCase());
                        continue block10;
                    }
                    sb.append(ch);
                }
            }
        }
        return sb.toString();
    }

    public static List<Map<String, Object>> parseJSON2List(String jsonStr) {
        JSONArray jsonArr = JSONArray.parseArray((String)jsonStr);
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        Iterator it = jsonArr.iterator();
        while (it.hasNext()) {
            JSONObject json2 = JSONObject.parseObject((String)JSON.toJSONString(it.next(), (SerializeConfig)mapping, (SerializerFeature[])new SerializerFeature[0]));
            list.add(JsonUtils.parseJSON2Map(json2.toString()));
        }
        return list;
    }

    public static Map<String, Object> parseJSON2Map(String jsonStr) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        JSONObject json = JSONObject.parseObject((String)jsonStr);
        for (Object k : json.keySet()) {
            Object v = json.get(k);
            if (v instanceof JSONArray) {
                ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
                Iterator it = ((JSONArray)v).iterator();
                while (it.hasNext()) {
                    JSONObject json2 = JSONObject.parseObject((String)JSON.toJSONString(it.next(), (SerializeConfig)mapping, (SerializerFeature[])new SerializerFeature[0]));
                    list.add(JsonUtils.parseJSON2Map(json2.toString()));
                }
                map.put(k.toString(), list);
                continue;
            }
            map.put(k.toString(), v);
        }
        return map;
    }

    public static String format(String jsonStr) {
        int level = 0;
        StringBuffer jsonForMatStr = new StringBuffer();
        block5: for (int i = 0; i < jsonStr.length(); ++i) {
            char c = jsonStr.charAt(i);
            if (level > 0 && '\n' == jsonForMatStr.charAt(jsonForMatStr.length() - 1)) {
                jsonForMatStr.append(JsonUtils.getLevelStr(level));
            }
            switch (c) {
                case '[': 
                case '{': {
                    jsonForMatStr.append(c + "\n");
                    ++level;
                    continue block5;
                }
                case ',': {
                    jsonForMatStr.append(c + "\n");
                    continue block5;
                }
                case ']': 
                case '}': {
                    jsonForMatStr.append("\n");
                    jsonForMatStr.append(JsonUtils.getLevelStr(--level));
                    jsonForMatStr.append(c);
                    continue block5;
                }
                default: {
                    jsonForMatStr.append(c);
                }
            }
        }
        return jsonForMatStr.toString();
    }

    private static String getLevelStr(int level) {
        StringBuffer levelStr = new StringBuffer();
        for (int levelI = 0; levelI < level; ++levelI) {
            levelStr.append("\t");
        }
        return levelStr.toString();
    }
}

