/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.common.spring;

import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.framework.AdvisedSupport;
import org.springframework.aop.framework.AopProxy;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class SpringContextUtil
implements ApplicationContextAware {
    private static final Logger log = LoggerFactory.getLogger(SpringContextUtil.class);
    private static ApplicationContext applicationContext = null;
    private static final Map<String, Object> CACHE_MAP = new HashMap<String, Object>();

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        log.info("------SpringContextUtil setApplicationContext-------");
        SpringContextUtil.applicationContext = applicationContext;
    }

    public static void setStaticApplicationContext(ApplicationContext applicationContext) throws BeansException {
        log.info("------SpringContextUtil setApplicationContext-------");
        SpringContextUtil.applicationContext = applicationContext;
    }

    public static ApplicationContext getApplicationContext() {
        return applicationContext;
    }

    public static Object getBean(String name) throws BeansException {
        return applicationContext.getBean(name);
    }

    public static <T> T getBeanByName(Class<T> clazz) throws BeansException {
        try {
            return (T)applicationContext.getBean(clazz);
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u5bf9\u8c61\u9519\u8bef:" + e.getMessage());
            return null;
        }
    }

    public static <T> T getBeanByClass(Class<T> clazz) throws BeansException {
        try {
            return (T)SpringContextUtil.getTarget(applicationContext.getBean(clazz));
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u5bf9\u8c61\u9519\u8bef:" + e.getMessage());
            return null;
        }
    }

    public static <T> List<T> getBeansByClass(Class<T> clazz) {
        String[] names = SpringContextUtil.getApplicationContext().getBeanNamesForType(clazz);
        ArrayList<Object> result = new ArrayList<Object>();
        for (String name : names) {
            result.add(SpringContextUtil.getBean(name));
        }
        return result;
    }

    public static <T> T getBeanByClassForApi(Class<T> clazz) {
        String[] names = SpringContextUtil.getApplicationContext().getBeanNamesForType(clazz);
        Object resultBean = null;
        String serviceName = clazz.getName();
        if (names.length > 1) {
            for (String name : names) {
                if (name.equals(serviceName)) continue;
                resultBean = SpringContextUtil.getBean(name);
                break;
            }
        }
        if (resultBean == null) {
            resultBean = SpringContextUtil.getBean(serviceName);
        }
        return (T)resultBean;
    }

    public static Object getTarget(Object proxy) {
        if (!AopUtils.isAopProxy((Object)proxy)) {
            return proxy;
        }
        if (AopUtils.isJdkDynamicProxy((Object)proxy)) {
            try {
                proxy = SpringContextUtil.getJdkDynamicProxyTargetObject(proxy);
            }
            catch (Exception e) {
                log.error("\u83b7\u53d6\u5bf9\u8c61\u9519\u8bef:" + e.getMessage());
                return proxy;
            }
        }
        try {
            proxy = SpringContextUtil.getCglibProxyTargetObject(proxy);
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u5bf9\u8c61\u9519\u8bef:" + e.getMessage());
            return proxy;
        }
        return SpringContextUtil.getTarget(proxy);
    }

    private static Object getCglibProxyTargetObject(Object proxy) throws Exception {
        Field h = proxy.getClass().getDeclaredField("CGLIB$CALLBACK_0");
        h.setAccessible(true);
        Object dynamicAdvisedInterceptor = h.get(proxy);
        Field advised = dynamicAdvisedInterceptor.getClass().getDeclaredField("advised");
        advised.setAccessible(true);
        Object target = ((AdvisedSupport)advised.get(dynamicAdvisedInterceptor)).getTargetSource().getTarget();
        return target;
    }

    private static Object getJdkDynamicProxyTargetObject(Object proxy) throws Exception {
        Field h = proxy.getClass().getSuperclass().getDeclaredField("h");
        h.setAccessible(true);
        AopProxy aopProxy = (AopProxy)h.get(proxy);
        Field advised = aopProxy.getClass().getDeclaredField("advised");
        advised.setAccessible(true);
        Object target = ((AdvisedSupport)advised.get(aopProxy)).getTargetSource().getTarget();
        return target;
    }

    public static <T> T getBeanByClass(Class<T> clazz, String[] actualTypeArguments) {
        StringBuilder sBuilder = new StringBuilder();
        String cacheKey = null;
        for (String actualTypeArgument : actualTypeArguments) {
            sBuilder.append("_" + actualTypeArgument);
        }
        cacheKey = clazz.getName() + sBuilder.toString();
        if (CACHE_MAP.containsKey(cacheKey)) {
            return (T)CACHE_MAP.get(cacheKey);
        }
        String[] candidateNames = applicationContext.getBeanNamesForType(clazz);
        Object object = null;
        Type[] types = null;
        for (String candidateName : candidateNames) {
            object = SpringContextUtil.getBean(candidateName);
            types = object.getClass().getName().contains("EnhancerBySpringCGLIB") ? ((ParameterizedType)object.getClass().getSuperclass().getGenericSuperclass()).getActualTypeArguments() : ((ParameterizedType)object.getClass().getGenericSuperclass()).getActualTypeArguments();
            boolean isThisObj = true;
            for (int i = 0; i < actualTypeArguments.length; ++i) {
                if (actualTypeArguments[i].equals(types[i].getTypeName())) continue;
                isThisObj = false;
                break;
            }
            if (!isThisObj) continue;
            CACHE_MAP.put(cacheKey, object);
            return (T)object;
        }
        return null;
    }

    public static <T> T getBeanByClass(Class<T> clazz, String actualTypeArgument, int index) {
        String[] candidateNames = applicationContext.getBeanNamesForType(clazz);
        Object object = null;
        Type[] types = null;
        for (String candidateName : candidateNames) {
            object = SpringContextUtil.getBean(candidateName);
            types = object.getClass().getName().contains("EnhancerBySpringCGLIB") ? ((ParameterizedType)object.getClass().getSuperclass().getGenericSuperclass()).getActualTypeArguments() : ((ParameterizedType)object.getClass().getGenericSuperclass()).getActualTypeArguments();
            if (!actualTypeArgument.equals(types[index].getTypeName())) continue;
            return (T)object;
        }
        return null;
    }

    public static boolean containsBean(String name) {
        return applicationContext.containsBean(name);
    }

    public static boolean isSingleton(String name) throws NoSuchBeanDefinitionException {
        return applicationContext.isSingleton(name);
    }
}

