/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.easyes.spring.factory;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.dromara.easyes.common.enums.ProcessIndexStrategyEnum;
import org.dromara.easyes.common.strategy.AutoProcessIndexStrategy;
import org.dromara.easyes.common.utils.ExceptionUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class IndexStrategyFactory
implements ApplicationContextAware,
InitializingBean {
    private static final Integer DEFAULT_SIZE = 4;
    private ApplicationContext applicationContext;
    private static final Map<Integer, AutoProcessIndexStrategy> SERVICE_MAP = new HashMap<Integer, AutoProcessIndexStrategy>(DEFAULT_SIZE);

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public void afterPropertiesSet() {
        Map beansOfType = this.applicationContext.getBeansOfType(AutoProcessIndexStrategy.class);
        if (beansOfType.isEmpty()) {
            throw ExceptionUtils.eee((String)"AutoProcessIndexStrategy must have implementation. AutoProcessIndexStrategy\u7d22\u5f15\u7b56\u7565\u63a5\u53e3\u5fc5\u987b\u8981\u6709\u5b9e\u73b0\u5e76\u6ce8\u518c\u5230\u5bb9\u5668\u3002");
        }
        ProcessIndexStrategyEnum strategy = (ProcessIndexStrategyEnum)this.applicationContext.getEnvironment().getProperty("easy-es.global-config.process-index-mode", ProcessIndexStrategyEnum.class, (Object)ProcessIndexStrategyEnum.MANUAL);
        if (!ProcessIndexStrategyEnum.MANUAL.equals((Object)strategy)) {
            beansOfType.values().forEach(v -> SERVICE_MAP.putIfAbsent(v.getStrategyType(), (AutoProcessIndexStrategy)v));
        }
    }

    public AutoProcessIndexStrategy getByStrategyType(Integer strategyType) {
        return Optional.ofNullable(SERVICE_MAP.get(strategyType)).orElseThrow(() -> ExceptionUtils.eee((String)"no such service strategyType:{}", (Object[])new Object[]{strategyType}));
    }
}

