/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.easyes.spring.config;

import java.util.Map;
import lombok.Generated;
import lombok.NonNull;
import org.dromara.easyes.common.property.EasyEsDynamicProperties;
import org.dromara.easyes.common.property.EasyEsProperties;
import org.dromara.easyes.common.strategy.AutoProcessIndexStrategy;
import org.dromara.easyes.common.utils.EsClientUtils;
import org.dromara.easyes.core.index.AutoProcessIndexNotSmoothlyStrategy;
import org.dromara.easyes.core.index.AutoProcessIndexSmoothlyStrategy;
import org.dromara.easyes.spring.factory.IndexStrategyFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.EnvironmentAware;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;
import org.springframework.util.Assert;

@Configuration
public class EasyEsConfiguration
implements InitializingBean,
EnvironmentAware {
    private Environment environment;
    @Autowired(required=false)
    private EasyEsProperties easyEsProperties;
    @Autowired(required=false)
    private EasyEsDynamicProperties easyEsDynamicProperties;

    public void setEnvironment(@NonNull Environment environment) {
        if (environment == null) {
            throw new NullPointerException("environment is marked non-null but is null");
        }
        this.environment = environment;
    }

    public void afterPropertiesSet() {
        Boolean enable = (Boolean)this.environment.getProperty("easy-es.enable", Boolean.class, (Object)Boolean.TRUE);
        if (enable.booleanValue()) {
            Assert.notNull((Object)this.easyEsProperties, (String)"easyEsProperties must is A bean. easy-es\u914d\u7f6e\u7c7b\u5fc5\u987b\u7ed9\u914d\u7f6e\u4e00\u4e2abean");
        }
    }

    @Bean
    public IndexStrategyFactory indexStrategyFactory() {
        return new IndexStrategyFactory();
    }

    @Bean
    public EsClientUtils esClientUtils() {
        Map datasourceMap;
        EsClientUtils esClientUtils = new EsClientUtils();
        if (this.easyEsDynamicProperties == null) {
            this.easyEsDynamicProperties = new EasyEsDynamicProperties();
        }
        if ((datasourceMap = this.easyEsDynamicProperties.getDatasource()).isEmpty()) {
            datasourceMap.put("DEFAULT_DS", this.easyEsProperties);
        }
        for (String key : datasourceMap.keySet()) {
            EasyEsProperties easyEsConfigProperties = (EasyEsProperties)datasourceMap.get(key);
            EsClientUtils.registerClient((String)key, () -> EsClientUtils.buildClient((EasyEsProperties)easyEsConfigProperties));
        }
        return esClientUtils;
    }

    @Bean
    public AutoProcessIndexStrategy autoProcessIndexSmoothlyStrategy() {
        return new AutoProcessIndexSmoothlyStrategy();
    }

    @Bean
    public AutoProcessIndexStrategy autoProcessIndexNotSmoothlyStrategy() {
        return new AutoProcessIndexNotSmoothlyStrategy();
    }

    @Generated
    public void setEasyEsProperties(EasyEsProperties easyEsProperties) {
        this.easyEsProperties = easyEsProperties;
    }

    @Generated
    public void setEasyEsDynamicProperties(EasyEsDynamicProperties easyEsDynamicProperties) {
        this.easyEsDynamicProperties = easyEsDynamicProperties;
    }
}

