/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.easyes.common.utils;

import co.elastic.clients.elasticsearch.ElasticsearchClient;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.jackson.JacksonJsonpMapper;
import co.elastic.clients.transport.ElasticsearchTransport;
import co.elastic.clients.transport.rest_client.RestClientTransport;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.http.Header;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.TrustStrategy;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.nio.client.HttpAsyncClientBuilder;
import org.apache.http.message.BasicHeader;
import org.apache.http.nio.conn.SchemeIOSessionStrategy;
import org.apache.http.nio.conn.ssl.SSLIOSessionStrategy;
import org.apache.http.ssl.SSLContextBuilder;
import org.dromara.easyes.common.enums.SchemaEnum;
import org.dromara.easyes.common.property.EasyEsProperties;
import org.dromara.easyes.common.utils.ExceptionUtils;
import org.dromara.easyes.common.utils.LogUtils;
import org.dromara.easyes.common.utils.StringUtils;
import org.dromara.easyes.common.utils.jackson.JsonUtils;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.client.RestClientBuilder;

public class EsClientUtils {
    public static final String DEFAULT_DS = "DEFAULT_DS";
    private static final Map<String, ElasticsearchClient> restHighLevelClientMap = new ConcurrentHashMap<String, ElasticsearchClient>();

    public static ElasticsearchClient getElasticsearchClient(String restHighLevelClientId) {
        if (DEFAULT_DS.equals(restHighLevelClientId)) {
            return restHighLevelClientMap.values().stream().findFirst().orElseThrow(() -> ExceptionUtils.eee("Could not found ElasticsearchClient,restHighLevelClientId:%s", restHighLevelClientId));
        }
        ElasticsearchClient client = restHighLevelClientMap.get(restHighLevelClientId);
        if (client == null) {
            LogUtils.formatError("restHighLevelClientId: %s can not find any data source, please check your config", restHighLevelClientId);
            throw ExceptionUtils.eee("Cloud not found ElasticsearchClient,restHighLevelClientId:%s", restHighLevelClientId);
        }
        return client;
    }

    public static void registerClient(String restHighLevelClientId, Supplier<ElasticsearchClient> restHighLevelClient) {
        restHighLevelClientMap.putIfAbsent(restHighLevelClientId, restHighLevelClient.get());
    }

    public static ElasticsearchClient buildClient(EasyEsProperties easyEsConfigProperties) {
        String address = easyEsConfigProperties.getAddress();
        if (StringUtils.isEmpty(address)) {
            throw ExceptionUtils.eee("please config the es address");
        }
        if (!address.contains(":")) {
            throw ExceptionUtils.eee("the address must contains port and separate by ':'");
        }
        String schema = StringUtils.isEmpty(easyEsConfigProperties.getSchema()) ? "http" : easyEsConfigProperties.getSchema();
        ArrayList hostList = new ArrayList();
        Arrays.stream(easyEsConfigProperties.getAddress().split(",")).forEach(item -> hostList.add(new HttpHost(item.split(":")[0], Integer.parseInt(item.split(":")[1]), schema)));
        HttpHost[] httpHost = hostList.toArray(new HttpHost[0]);
        RestClientBuilder builder = RestClient.builder((HttpHost[])httpHost);
        builder.setHttpClientConfigCallback(httpClientBuilder -> {
            Optional.ofNullable(easyEsConfigProperties.getKeepAliveMillis()).ifPresent(p -> httpClientBuilder.setKeepAliveStrategy((response, context) -> p.intValue()));
            Optional.ofNullable(easyEsConfigProperties.getMaxConnTotal()).ifPresent(arg_0 -> ((HttpAsyncClientBuilder)httpClientBuilder).setMaxConnTotal(arg_0));
            Optional.ofNullable(easyEsConfigProperties.getMaxConnPerRoute()).ifPresent(arg_0 -> ((HttpAsyncClientBuilder)httpClientBuilder).setMaxConnPerRoute(arg_0));
            String username = easyEsConfigProperties.getUsername();
            String password = easyEsConfigProperties.getPassword();
            if (StringUtils.isNotEmpty(username) && StringUtils.isNotEmpty(password)) {
                BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
                credentialsProvider.setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(username, password));
                httpClientBuilder.setDefaultCredentialsProvider((CredentialsProvider)credentialsProvider);
            }
            if (SchemaEnum.https.name().equals(schema)) {
                try {
                    SSLContext sslContext = new SSLContextBuilder().loadTrustMaterial(null, (org.apache.http.ssl.TrustStrategy)((TrustStrategy)(chain, authType) -> true)).build();
                    SSLIOSessionStrategy sessionStrategy = new SSLIOSessionStrategy(sslContext, (HostnameVerifier)NoopHostnameVerifier.INSTANCE);
                    httpClientBuilder.disableAuthCaching();
                    httpClientBuilder.setSSLStrategy((SchemeIOSessionStrategy)sessionStrategy);
                }
                catch (Exception e) {
                    LogUtils.error("restHighLevelClient build SSLContext exception: %s", e.getMessage());
                    e.printStackTrace();
                    throw ExceptionUtils.eee(e);
                }
            }
            if (easyEsConfigProperties.isCompatible()) {
                EsClientUtils.buildCompatible(httpClientBuilder);
            }
            return httpClientBuilder;
        });
        builder.setRequestConfigCallback(requestConfigBuilder -> {
            Optional.ofNullable(easyEsConfigProperties.getConnectTimeout()).ifPresent(arg_0 -> ((RequestConfig.Builder)requestConfigBuilder).setConnectTimeout(arg_0));
            Optional.ofNullable(easyEsConfigProperties.getSocketTimeout()).ifPresent(arg_0 -> ((RequestConfig.Builder)requestConfigBuilder).setSocketTimeout(arg_0));
            Optional.ofNullable(easyEsConfigProperties.getConnectionRequestTimeout()).ifPresent(arg_0 -> ((RequestConfig.Builder)requestConfigBuilder).setConnectionRequestTimeout(arg_0));
            return requestConfigBuilder;
        });
        return new ElasticsearchClient((ElasticsearchTransport)new RestClientTransport(builder.build(), (JsonpMapper)new JacksonJsonpMapper(JsonUtils.OM_DEFAULT)));
    }

    private static void buildCompatible(HttpAsyncClientBuilder httpClientBuilder) {
        httpClientBuilder.addInterceptorFirst((request, context) -> request.setHeader("Accept", "application/json"));
        httpClientBuilder.setDefaultHeaders((Collection)new ArrayList<Header>(){
            {
                this.add(new BasicHeader("Accept", "application/json"));
                this.add(new BasicHeader("Content-Type", "application/json"));
                this.add(new BasicHeader("Connection", "Keep-Alive"));
                this.add(new BasicHeader("Charset", "UTF-8"));
            }
        });
        httpClientBuilder.addInterceptorLast((response, context) -> response.addHeader("X-Elastic-Product", "Elasticsearch"));
    }

    public ElasticsearchClient getClient(String clientId) {
        return EsClientUtils.getElasticsearchClient(clientId);
    }
}

