/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.easyes.common.utils;

import co.elastic.clients.elasticsearch.ElasticsearchClient;
import java.io.IOException;
import java.util.Optional;
import lombok.Generated;
import org.dromara.easyes.common.utils.LogUtils;

public class EEVersionUtils {
    public static <T> String getJarVersion(Class<T> objectClass) {
        return Optional.ofNullable(objectClass.getPackage().getImplementationVersion()).orElse("UNKNOWN");
    }

    public static String getClientVersion(ElasticsearchClient restHighLevelClient) {
        try {
            return restHighLevelClient.info().version().number();
        }
        catch (IOException e) {
            LogUtils.formatWarn("get client version error", new Object[0]);
            return "unknown";
        }
    }

    @Generated
    private EEVersionUtils() {
    }
}

