/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.samples;

import java.io.File;
import java.io.FileInputStream;
import java.util.concurrent.atomic.AtomicInteger;
import javax.xml.bind.JAXBContext;
import org.docx4j.XmlUtils;
import org.docx4j.jaxb.Context;
import org.docx4j.model.datastorage.BindingHandler;
import org.docx4j.model.datastorage.CustomXmlDataStoragePartSelector;
import org.docx4j.model.datastorage.OpenDoPEHandler;
import org.docx4j.model.datastorage.OpenDoPEIntegrity;
import org.docx4j.model.datastorage.RemovalHandler;
import org.docx4j.openpackaging.exceptions.Docx4JException;
import org.docx4j.openpackaging.io.SaveToZipFile;
import org.docx4j.openpackaging.packages.OpcPackage;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;
import org.docx4j.openpackaging.parts.CustomXmlPart;
import org.docx4j.openpackaging.parts.JaxbXmlPart;

public class ContentControlsMergeXML281 {
    public static JAXBContext context = Context.jc;
    private static final boolean DEBUG = true;
    private static final boolean SAVE = true;

    public static void main(String[] args) throws Exception {
        String input_DOCX = System.getProperty("user.dir") + "/sample-docs/word/databinding/binding-simple.docx";
        String input_XML = System.getProperty("user.dir") + "/sample-docs/word/databinding/binding-simple-data.xml";
        String OUTPUT_DOCX = System.getProperty("user.dir") + "/OUT_ContentControlsMergeXML.docx";
        WordprocessingMLPackage wordMLPackage = WordprocessingMLPackage.load((File)new File(input_DOCX));
        CustomXmlPart customXmlDataStoragePart = CustomXmlDataStoragePartSelector.getCustomXmlDataStoragePart((WordprocessingMLPackage)wordMLPackage);
        if (customXmlDataStoragePart == null) {
            System.out.println("Couldn't find CustomXmlDataStoragePart! exiting..");
            return;
        }
        System.out.println("Getting " + input_XML);
        FileInputStream fis = new FileInputStream(new File(input_XML));
        customXmlDataStoragePart.setXML(XmlUtils.getNewDocumentBuilder().parse(fis));
        SaveToZipFile saver = new SaveToZipFile((OpcPackage)wordMLPackage);
        OpenDoPEHandler odh = null;
        try {
            odh = new OpenDoPEHandler(wordMLPackage);
            odh.preprocess();
            OpenDoPEIntegrity odi = new OpenDoPEIntegrity();
            odi.process(wordMLPackage);
            String save_preprocessed = OUTPUT_DOCX.lastIndexOf(".") == -1 ? OUTPUT_DOCX + "_INT.docx" : OUTPUT_DOCX.substring(0, OUTPUT_DOCX.lastIndexOf(".")) + "_INT.docx";
            saver.save(save_preprocessed);
            System.out.println("Saved: " + save_preprocessed);
        }
        catch (Docx4JException d) {
            System.out.println(d.getMessage());
        }
        BindingHandler.setHyperlinkStyle((String)"Hyperlink");
        AtomicInteger bookmarkId = odh.getNextBookmarkId();
        BindingHandler bh = new BindingHandler(wordMLPackage);
        bh.setStartingIdForNewBookmarks(bookmarkId);
        bh.applyBindings((JaxbXmlPart)wordMLPackage.getMainDocumentPart());
        RemovalHandler rh = new RemovalHandler();
        rh.removeSDTs(wordMLPackage, RemovalHandler.Quantifier.ALL, new String[0]);
        saver.save(OUTPUT_DOCX);
        System.out.println("Saved: " + OUTPUT_DOCX);
    }
}

