/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.versions.api;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.ArtifactUtils;
import org.apache.maven.artifact.metadata.ArtifactMetadataRetrievalException;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.InvalidVersionSpecificationException;
import org.apache.maven.artifact.versioning.OverConstrainedVersionException;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.maven.plugin.MojoExecutionException;
import org.codehaus.mojo.versions.Property;
import org.codehaus.mojo.versions.api.AbstractVersionDetails;
import org.codehaus.mojo.versions.api.ArtifactAssociation;
import org.codehaus.mojo.versions.api.ArtifactVersions;
import org.codehaus.mojo.versions.api.VersionsHelper;
import org.codehaus.mojo.versions.ordering.VersionComparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyVersions
extends AbstractVersionDetails {
    private final String name;
    private final String profileId;
    private final Set<ArtifactAssociation> associations;
    private final VersionsHelper helper;
    private final SortedSet<ArtifactVersion> versions;
    private final PropertyVersionComparator comparator;

    PropertyVersions(String profileId, String name, VersionsHelper helper, Set<ArtifactAssociation> associations) throws ArtifactMetadataRetrievalException {
        this.profileId = profileId;
        this.name = name;
        this.helper = helper;
        this.associations = new TreeSet<ArtifactAssociation>(associations);
        this.comparator = new PropertyVersionComparator();
        this.versions = PropertyVersions.resolveAssociatedVersions(helper, associations, this.comparator);
    }

    private static SortedSet<ArtifactVersion> resolveAssociatedVersions(VersionsHelper helper, Set<ArtifactAssociation> associations, VersionComparator versionComparator) throws ArtifactMetadataRetrievalException {
        TreeSet<ArtifactVersion> versions = null;
        for (ArtifactAssociation association : associations) {
            ArtifactVersions associatedVersions = helper.lookupArtifactVersions(association.getArtifact(), association.isUsePluginRepositories());
            if (versions != null) {
                ArtifactVersion[] artifactVersions = associatedVersions.getVersions(true);
                Iterator j = versions.iterator();
                while (j.hasNext()) {
                    boolean contains = false;
                    ArtifactVersion version = (ArtifactVersion)j.next();
                    for (ArtifactVersion artifactVersion : artifactVersions) {
                        if (version.compareTo((Object)artifactVersion) != 0) continue;
                        contains = true;
                        break;
                    }
                    if (contains) continue;
                    j.remove();
                }
                continue;
            }
            versions = new TreeSet<ArtifactVersion>(versionComparator);
            versions.addAll(Arrays.asList(associatedVersions.getVersions(true)));
        }
        if (versions == null) {
            versions = new TreeSet<ArtifactVersion>(versionComparator);
        }
        return Collections.unmodifiableSortedSet(versions);
    }

    @Override
    public VersionComparator getVersionComparator() {
        return this.comparator;
    }

    public ArtifactAssociation[] getAssociations() {
        return this.associations.toArray(new ArtifactAssociation[this.associations.size()]);
    }

    private VersionComparator[] lookupComparators() {
        HashSet<VersionComparator> result = new HashSet<VersionComparator>();
        for (ArtifactAssociation association : this.associations) {
            result.add(this.helper.getVersionComparator(association.getArtifact()));
        }
        return result.toArray(new VersionComparator[result.size()]);
    }

    public ArtifactVersion[] getVersions(Collection<Artifact> artifacts) throws MojoExecutionException {
        ArrayList<ArtifactVersion> result = new ArrayList<ArtifactVersion>();
        for (ArtifactAssociation association : this.associations) {
            for (Artifact artifact : artifacts) {
                if (!association.getGroupId().equals(artifact.getGroupId()) || !association.getArtifactId().equals(artifact.getArtifactId())) continue;
                try {
                    result.add(artifact.getSelectedVersion());
                }
                catch (OverConstrainedVersionException e) {}
            }
        }
        Iterator k = result.iterator();
        block6: while (k.hasNext()) {
            ArtifactVersion candidate = (ArtifactVersion)k.next();
            block7: for (ArtifactAssociation association : this.associations) {
                for (Artifact artifact : artifacts) {
                    if (!association.getGroupId().equals(artifact.getGroupId()) || !association.getArtifactId().equals(artifact.getArtifactId())) continue;
                    try {
                        if (!candidate.toString().equals(artifact.getSelectedVersion().toString())) continue;
                        continue block7;
                    }
                    catch (OverConstrainedVersionException e) {
                    }
                }
                k.remove();
                continue block6;
            }
        }
        return this.asArtifactVersionArray(result);
    }

    @Override
    public synchronized ArtifactVersion[] getVersions(boolean includeSnapshots) {
        SortedSet<ArtifactVersion> result;
        if (includeSnapshots) {
            result = this.versions;
        } else {
            result = new TreeSet<ArtifactVersion>(this.getVersionComparator());
            for (ArtifactVersion candidate : this.versions) {
                if (ArtifactUtils.isSnapshot((String)candidate.toString())) continue;
                result.add(candidate);
            }
        }
        return this.asArtifactVersionArray(result);
    }

    private ArtifactVersion[] asArtifactVersionArray(Collection<ArtifactVersion> result) {
        if (result == null || result.isEmpty()) {
            return new ArtifactVersion[0];
        }
        Object[] answer = result.toArray(new ArtifactVersion[result.size()]);
        VersionComparator[] rules = this.lookupComparators();
        assert (rules.length > 0);
        Arrays.sort(answer, rules[0]);
        if (rules.length == 1 || answer.length == 1) {
            return answer;
        }
        Object[] alt = (ArtifactVersion[])answer.clone();
        for (int j = 1; j < rules.length; ++j) {
            Arrays.sort(alt, rules[j]);
            if (Arrays.equals(alt, answer)) continue;
            throw new IllegalStateException("Property " + this.name + " is associated with multiple artifacts" + " and these artifacts use different version sorting rules and these rules are effectively" + " incompatible for the set of versions available to this property.\nFirst rule says: " + Arrays.asList(answer) + "\nSecond rule says: " + Arrays.asList(alt));
        }
        return answer;
    }

    public String getName() {
        return this.name;
    }

    public String getProfileId() {
        return this.profileId;
    }

    public boolean isAssociated() {
        return !this.associations.isEmpty();
    }

    public String toString() {
        return "PropertyVersions{" + (this.profileId == null ? "" : "profileId='" + this.profileId + "', ") + "name='" + this.name + '\'' + ", associations=" + this.associations + '}';
    }

    public ArtifactVersion getNewestVersion(String currentVersion, Property property, boolean allowSnapshots, List reactorProjects, VersionsHelper helper) throws MojoExecutionException {
        return this.getNewestVersion(currentVersion, property, allowSnapshots, reactorProjects, helper, false, -1);
    }

    public ArtifactVersion getNewestVersion(String currentVersion, Property property, boolean allowSnapshots, List reactorProjects, VersionsHelper helper, boolean allowDowngrade, int segment) throws MojoExecutionException {
        VersionRange range;
        boolean includeSnapshots = !property.isBanSnapshots() && allowSnapshots;
        helper.getLog().debug((CharSequence)("getNewestVersion(): includeSnapshots='" + includeSnapshots + "'"));
        helper.getLog().debug((CharSequence)("Property ${" + property.getName() + "}: Set of valid available versions is " + Arrays.asList(this.getVersions(includeSnapshots))));
        try {
            if (property.getVersion() != null) {
                range = VersionRange.createFromVersionSpec((String)property.getVersion());
                helper.getLog().debug((CharSequence)("Property ${" + property.getName() + "}: Restricting results to " + range));
            } else {
                range = null;
                helper.getLog().debug((CharSequence)("Property ${" + property.getName() + "}: Restricting results to " + range));
            }
        }
        catch (InvalidVersionSpecificationException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
        }
        ArtifactVersion lowerBoundArtifactVersion = null;
        if (allowDowngrade) {
            helper.getLog().debug((CharSequence)("lowerBoundArtifactVersion is null based on allowDowngrade:" + allowDowngrade));
        } else {
            lowerBoundArtifactVersion = helper.createArtifactVersion(currentVersion);
            helper.getLog().debug((CharSequence)("lowerBoundArtifactVersion: " + lowerBoundArtifactVersion.toString()));
        }
        ArtifactVersion upperBound = null;
        if (segment != -1) {
            upperBound = this.getVersionComparator().incrementSegment(lowerBoundArtifactVersion, segment);
            helper.getLog().debug((CharSequence)("Property ${" + property.getName() + "}: upperBound is: " + upperBound));
        }
        Object result = this.getNewestVersion(range, lowerBoundArtifactVersion, upperBound, includeSnapshots, false, false);
        helper.getLog().debug((CharSequence)("Property ${" + property.getName() + "}: Current winner is: " + result));
        if (property.isSearchReactor()) {
            helper.getLog().debug((CharSequence)("Property ${" + property.getName() + "}: Searching reactor for a valid version..."));
            Set<Artifact> reactorArtifacts = helper.extractArtifacts(reactorProjects);
            ArtifactVersion[] reactorVersions = this.getVersions(reactorArtifacts);
            helper.getLog().debug((CharSequence)("Property ${" + property.getName() + "}: Set of valid available versions from the reactor is " + Arrays.asList(reactorVersions)));
            Object fromReactor = null;
            if (reactorVersions.length > 0) {
                for (int j = reactorVersions.length - 1; j >= 0; --j) {
                    if (range != null && !ArtifactVersions.isVersionInRange(reactorVersions[j], range)) continue;
                    fromReactor = reactorVersions[j];
                    helper.getLog().debug((CharSequence)("Property ${" + property.getName() + "}: Reactor has version " + fromReactor));
                    break;
                }
            }
            if (!(fromReactor == null || result == null && currentVersion.equals(fromReactor.toString()))) {
                if (property.isPreferReactor()) {
                    helper.getLog().debug((CharSequence)("Property ${" + property.getName() + "}: Reactor has a version and we prefer the reactor"));
                    result = fromReactor;
                } else if (result == null) {
                    helper.getLog().debug((CharSequence)("Property ${" + property.getName() + "}: Reactor has the only version"));
                    result = fromReactor;
                } else if (this.getVersionComparator().compare(result, fromReactor) < 0) {
                    helper.getLog().debug((CharSequence)("Property ${" + property.getName() + "}: Reactor has a newer version"));
                    result = fromReactor;
                } else {
                    helper.getLog().debug((CharSequence)("Property ${" + property.getName() + "}: Reactor has the same or older version"));
                }
            }
        }
        return result;
    }

    private ArtifactVersion getNewestVersion(String currentVersion, VersionsHelper helper, int segment, boolean includeSnapshots, VersionRange range) {
        ArtifactVersion lowerBound = helper.createArtifactVersion(currentVersion);
        ArtifactVersion upperBound = null;
        if (segment != -1) {
            upperBound = this.getVersionComparator().incrementSegment(lowerBound, segment);
        }
        return this.getNewestVersion(range, lowerBound, upperBound, includeSnapshots, false, false);
    }

    private final class PropertyVersionComparator
    implements VersionComparator {
        private PropertyVersionComparator() {
        }

        public int compare(ArtifactVersion v1, ArtifactVersion v2) {
            return this.innerCompare(v1, v2);
        }

        private int innerCompare(ArtifactVersion v1, ArtifactVersion v2) {
            if (!PropertyVersions.this.isAssociated()) {
                throw new IllegalStateException("Cannot compare versions for a property with no associations");
            }
            VersionComparator[] comparators = PropertyVersions.this.lookupComparators();
            assert (comparators.length >= 1) : "we have at least one association => at least one comparator";
            int result = comparators[0].compare(v1, v2);
            for (int i = 1; i < comparators.length; ++i) {
                int alt = comparators[i].compare(v1, v2);
                if ((result == alt || result < 0 || alt >= 0) && (result > 0 || alt <= 0)) continue;
                throw new IllegalStateException("Property " + PropertyVersions.this.name + " is associated with multiple artifacts" + " and these artifacts use different version sorting rules and these rules are effectively" + " incompatible for the two of versions being compared.\nFirst rule says compare(\"" + v1 + "\", \"" + v2 + "\") = " + result + "\nSecond rule says compare(\"" + v1 + "\", \"" + v2 + "\") = " + alt);
            }
            return result;
        }

        public int getSegmentCount(ArtifactVersion v) {
            if (!PropertyVersions.this.isAssociated()) {
                throw new IllegalStateException("Cannot compare versions for a property with no associations");
            }
            VersionComparator[] comparators = PropertyVersions.this.lookupComparators();
            assert (comparators.length >= 1) : "we have at least one association => at least one comparator";
            int result = comparators[0].getSegmentCount(v);
            for (int i = 1; i < comparators.length; ++i) {
                int alt = comparators[i].getSegmentCount(v);
                if (result == alt) continue;
                throw new IllegalStateException("Property " + PropertyVersions.this.name + " is associated with multiple artifacts" + " and these artifacts use different version sorting rules and these rules are effectively" + " incompatible for the two of versions being compared.\nFirst rule says getSegmentCount(\"" + v + "\") = " + result + "\nSecond rule says getSegmentCount(\"" + v + "\") = " + alt);
            }
            return result;
        }

        public ArtifactVersion incrementSegment(ArtifactVersion v, int segment) {
            if (!PropertyVersions.this.isAssociated()) {
                throw new IllegalStateException("Cannot compare versions for a property with no associations");
            }
            VersionComparator[] comparators = PropertyVersions.this.lookupComparators();
            assert (comparators.length >= 1) : "we have at least one association => at least one comparator";
            ArtifactVersion result = comparators[0].incrementSegment(v, segment);
            for (int i = 1; i < comparators.length; ++i) {
                ArtifactVersion alt = comparators[i].incrementSegment(v, segment);
                if (result.toString().equals(alt.toString())) continue;
                throw new IllegalStateException("Property " + PropertyVersions.this.name + " is associated with multiple artifacts" + " and these artifacts use different version sorting rules and these rules are effectively" + " incompatible for the two of versions being compared.\nFirst rule says incrementSegment(\"" + v + "\", " + segment + ") = " + result + "\nSecond rule says incrementSegment(\"" + v + "\", " + segment + ") = " + alt);
            }
            return result;
        }
    }
}

