/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.versions;

import java.util.ArrayList;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import org.apache.maven.artifact.metadata.ArtifactMetadataRetrievalException;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.codehaus.mojo.versions.AbstractVersionsDisplayMojo;
import org.codehaus.mojo.versions.Property;
import org.codehaus.mojo.versions.api.PropertyVersions;
import org.codehaus.mojo.versions.rewriting.ModifiedPomXMLEventReader;

@Mojo(name="display-property-updates", requiresProject=true, requiresDirectInvocation=true)
public class DisplayPropertyUpdatesMojo
extends AbstractVersionsDisplayMojo {
    private static final int INFO_PAD_SIZE = 68;
    @Parameter
    private Property[] properties;
    @Parameter(property="includeProperties")
    private String includeProperties = null;
    @Parameter(property="excludeProperties")
    private String excludeProperties = null;
    @Parameter(property="autoLinkItems", defaultValue="true")
    private boolean autoLinkItems;

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.logInit();
        ArrayList<String> current = new ArrayList<String>();
        ArrayList<String> updates = new ArrayList<String>();
        Map<Property, PropertyVersions> propertyVersions = this.getHelper().getVersionPropertiesMap(this.getProject(), this.properties, this.includeProperties, this.excludeProperties, this.autoLinkItems);
        for (Map.Entry<Property, PropertyVersions> entry : propertyVersions.entrySet()) {
            StringBuilder buf;
            Property property = entry.getKey();
            PropertyVersions version = entry.getValue();
            String currentVersion = this.getProject().getProperties().getProperty(property.getName());
            if (currentVersion == null) continue;
            ArtifactVersion winner = version.getNewestVersion(currentVersion, property, this.allowSnapshots, this.reactorProjects, this.getHelper(), false, -1);
            if (winner != null && !currentVersion.equals(winner.toString())) {
                buf = new StringBuilder();
                buf.append("${");
                buf.append(property.getName());
                buf.append("} ");
                String newVersion = winner.toString();
                int padding = 68 - currentVersion.length() - newVersion.length() - 4;
                while (buf.length() < padding) {
                    buf.append('.');
                }
                buf.append(' ');
                buf.append(currentVersion);
                buf.append(" -> ");
                buf.append(newVersion);
                updates.add(buf.toString());
                continue;
            }
            buf = new StringBuilder();
            buf.append("${");
            buf.append(property.getName());
            buf.append("} ");
            int padding = 68 - currentVersion.length();
            while (buf.length() < padding) {
                buf.append('.');
            }
            buf.append(' ');
            buf.append(currentVersion);
            current.add(buf.toString());
        }
        this.logLine(false, "");
        if (!current.isEmpty()) {
            this.logLine(false, "The following version properties are referencing the newest available version:");
            for (String s : current) {
                this.logLine(false, "  " + s);
            }
        }
        if (updates.isEmpty() && current.isEmpty()) {
            this.logLine(false, "This project does not have any properties associated with versions.");
        } else if (updates.isEmpty()) {
            this.logLine(false, "All version properties are referencing the newest version available.");
        }
        if (!updates.isEmpty()) {
            this.logLine(false, "The following version property updates are available:");
            for (String update : updates) {
                this.logLine(false, "  " + update);
            }
        }
        this.logLine(false, "");
    }

    protected void update(ModifiedPomXMLEventReader pom) throws MojoExecutionException, MojoFailureException, XMLStreamException, ArtifactMetadataRetrievalException {
    }
}

