/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.versions;

import java.util.Collections;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.maven.artifact.metadata.ArtifactMetadataRetrievalException;
import org.apache.maven.artifact.versioning.InvalidVersionSpecificationException;
import org.apache.maven.doxia.sink.Sink;
import org.apache.maven.model.Dependency;
import org.apache.maven.reporting.MavenReportException;
import org.codehaus.mojo.versions.AbstractVersionsReport;
import org.codehaus.mojo.versions.DependencyUpdatesRenderer;
import org.codehaus.mojo.versions.api.ArtifactVersions;
import org.codehaus.mojo.versions.utils.DependencyComparator;
import org.codehaus.plexus.util.StringUtils;

public class DependencyUpdatesReport
extends AbstractVersionsReport {
    public boolean isExternalReport() {
        return false;
    }

    public boolean canGenerateReport() {
        return true;
    }

    protected void doGenerateReport(Locale locale, Sink sink) throws MavenReportException {
        TreeSet<Dependency> dependencyManagement = new TreeSet<Dependency>(new DependencyComparator());
        dependencyManagement.addAll(this.getProject().getDependencyManagement() == null ? Collections.EMPTY_LIST : this.getProject().getDependencyManagement().getDependencies());
        Set<Object> dependencies = new TreeSet<Dependency>(new DependencyComparator());
        dependencies.addAll(this.getProject().getDependencies());
        dependencies = DependencyUpdatesReport.removeDependencyManagment(dependencies, dependencyManagement);
        try {
            Map<Dependency, ArtifactVersions> dependencyUpdates = this.getHelper().lookupDependenciesUpdates(dependencies, false);
            Map<Dependency, ArtifactVersions> dependencyManagementUpdates = this.getHelper().lookupDependenciesUpdates(dependencyManagement, false);
            DependencyUpdatesRenderer renderer = new DependencyUpdatesRenderer(sink, this.getI18n(), this.getOutputName(), locale, dependencyUpdates, dependencyManagementUpdates);
            renderer.render();
        }
        catch (InvalidVersionSpecificationException e) {
            throw new MavenReportException(e.getMessage(), (Exception)((Object)e));
        }
        catch (ArtifactMetadataRetrievalException e) {
            throw new MavenReportException(e.getMessage(), (Exception)((Object)e));
        }
    }

    private static Set removeDependencyManagment(Set dependencies, Set dependencyManagement) {
        TreeSet<Dependency> result = new TreeSet<Dependency>(new DependencyComparator());
        for (Dependency c : dependencies) {
            boolean matched = false;
            Iterator j = dependencyManagement.iterator();
            while (!matched && j.hasNext()) {
                Dependency t = (Dependency)j.next();
                if (!StringUtils.equals((String)t.getGroupId(), (String)c.getGroupId()) || !StringUtils.equals((String)t.getArtifactId(), (String)c.getArtifactId()) || t.getScope() != null && !StringUtils.equals((String)t.getScope(), (String)c.getScope()) || t.getClassifier() != null && !StringUtils.equals((String)t.getClassifier(), (String)c.getClassifier()) || c.getVersion() != null && t.getVersion() != null && !StringUtils.equals((String)t.getVersion(), (String)c.getVersion())) continue;
                matched = true;
                break;
            }
            if (matched) continue;
            result.add(c);
        }
        return result;
    }

    public String getOutputName() {
        return "dependency-updates-report";
    }
}

