/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.versions.reporting;

import java.util.Collection;
import java.util.Optional;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.codehaus.mojo.versions.api.AbstractVersionDetails;
import org.codehaus.mojo.versions.api.ArtifactVersionsCache;
import org.codehaus.mojo.versions.api.Segment;

public class OverviewStats {
    private int major;
    private int minor;
    private int incremental;
    private int any;
    private int upToDate;

    public static <T extends OverviewStats, V extends AbstractVersionDetails> T fromUpdates(Collection<V> updates, ArtifactVersionsCache cache, boolean allowSnapshots) {
        OverviewStats stats = new OverviewStats();
        updates.forEach(details -> {
            if (OverviewStats.getNewestUpdate(cache, details, Optional.of(Segment.SUBINCREMENTAL), allowSnapshots) != null) {
                stats.incrementAny();
            } else if (OverviewStats.getNewestUpdate(cache, details, Optional.of(Segment.INCREMENTAL), allowSnapshots) != null) {
                stats.incrementIncremental();
            } else if (OverviewStats.getNewestUpdate(cache, details, Optional.of(Segment.MINOR), allowSnapshots) != null) {
                stats.incrementMinor();
            } else if (OverviewStats.getNewestUpdate(cache, details, Optional.of(Segment.MAJOR), allowSnapshots) != null) {
                stats.incrementMajor();
            } else {
                stats.incrementUpToDate();
            }
        });
        return (T)stats;
    }

    protected static <V extends AbstractVersionDetails> ArtifactVersion getNewestUpdate(ArtifactVersionsCache cache, V details, Optional<Segment> segment, boolean allowSnapshots) {
        return cache != null ? (ArtifactVersion)cache.get(details, segment, allowSnapshots) : details.getNewestUpdate(segment, allowSnapshots);
    }

    public int getMajor() {
        return this.major;
    }

    public void incrementMajor() {
        ++this.major;
    }

    public int getMinor() {
        return this.minor;
    }

    public void incrementMinor() {
        ++this.minor;
    }

    public int getIncremental() {
        return this.incremental;
    }

    public void incrementIncremental() {
        ++this.incremental;
    }

    public int getAny() {
        return this.any;
    }

    public void incrementAny() {
        ++this.any;
    }

    public int getUpToDate() {
        return this.upToDate;
    }

    public void incrementUpToDate() {
        ++this.upToDate;
    }
}

