/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.license.download;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.codehaus.mojo.license.spdx.SpdxLicenseList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UrlReplacements {
    private static final Logger LOG = LoggerFactory.getLogger(UrlReplacements.class);
    private final List<SpdxLicenseList.Attachments.UrlReplacement> replacements;

    public static Builder builder() {
        return new Builder();
    }

    UrlReplacements(List<SpdxLicenseList.Attachments.UrlReplacement> replacements) {
        this.replacements = replacements;
    }

    public String rewriteIfNecessary(String originalLicenseUrl) {
        String resultUrl = originalLicenseUrl;
        for (SpdxLicenseList.Attachments.UrlReplacement r : this.replacements) {
            resultUrl = r.getUrlPattern().matcher(resultUrl).replaceAll(r.getReplacement());
        }
        if (LOG.isDebugEnabled() && !resultUrl.equals(originalLicenseUrl)) {
            LOG.debug("Rewrote URL {} => {}", (Object)originalLicenseUrl, (Object)resultUrl);
        }
        return resultUrl;
    }

    public static class Builder {
        private List<SpdxLicenseList.Attachments.UrlReplacement> replacements = new ArrayList<SpdxLicenseList.Attachments.UrlReplacement>();
        private boolean useDefaults;
        private Set<String> ids = new HashSet<String>();

        public Builder replacement(String id, String urlPattern, String replacement) {
            if (id != null) {
                this.ids.add(id);
            } else {
                id = urlPattern + "_" + replacement;
            }
            this.replacements.add(SpdxLicenseList.Attachments.UrlReplacement.compile(id, urlPattern, replacement));
            return this;
        }

        public Builder useDefaults(boolean useDefaults) {
            this.useDefaults = useDefaults;
            return this;
        }

        public UrlReplacements build() {
            if (this.useDefaults) {
                Collection<SpdxLicenseList.Attachments.UrlReplacement> defaults = SpdxLicenseList.getLatest().getAttachments().getUrlReplacements().values();
                int usedDefaults = 0;
                for (SpdxLicenseList.Attachments.UrlReplacement r : defaults) {
                    if (this.ids.contains(r.getId())) continue;
                    this.replacements.add(r);
                    ++usedDefaults;
                }
                if (usedDefaults > 0 && LOG.isDebugEnabled()) {
                    StringBuilder sb = new StringBuilder();
                    sb.append("Appending " + usedDefaults + " default licenseUrlReplacements:\n").append("<licenseUrlReplacements>\n");
                    for (SpdxLicenseList.Attachments.UrlReplacement r : defaults) {
                        if (this.ids.contains(r.getId())) continue;
                        sb.append("  <licenseUrlReplacement>\n").append("    <id>").append(r.getId()).append("</id>\n").append("    <regexp>").append(r.getUrlPattern()).append("</regexp>\n").append("    <replacement>").append(r.getReplacement()).append("</replacement>\n").append("  <licenseUrlReplacement>\n");
                    }
                    sb.append("</licenseUrlReplacements>\n");
                    LOG.debug(sb.toString());
                }
            }
            List<SpdxLicenseList.Attachments.UrlReplacement> rs = Collections.unmodifiableList(this.replacements);
            this.replacements = null;
            return new UrlReplacements(rs);
        }
    }
}

