/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.jaxb2.schemageneration.postprocessing.javadoc;

import com.thoughtworks.qdox.JavaProjectBuilder;
import com.thoughtworks.qdox.model.JavaAnnotatedElement;
import com.thoughtworks.qdox.model.JavaClass;
import com.thoughtworks.qdox.model.JavaField;
import com.thoughtworks.qdox.model.JavaMethod;
import com.thoughtworks.qdox.model.JavaPackage;
import com.thoughtworks.qdox.model.JavaSource;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import org.apache.maven.plugin.logging.Log;
import org.codehaus.mojo.jaxb2.schemageneration.postprocessing.javadoc.JavaDocData;
import org.codehaus.mojo.jaxb2.schemageneration.postprocessing.javadoc.SearchableDocumentation;
import org.codehaus.mojo.jaxb2.schemageneration.postprocessing.javadoc.SortableLocation;
import org.codehaus.mojo.jaxb2.schemageneration.postprocessing.javadoc.location.ClassLocation;
import org.codehaus.mojo.jaxb2.schemageneration.postprocessing.javadoc.location.FieldLocation;
import org.codehaus.mojo.jaxb2.schemageneration.postprocessing.javadoc.location.MethodLocation;
import org.codehaus.mojo.jaxb2.schemageneration.postprocessing.javadoc.location.PackageLocation;
import org.codehaus.mojo.jaxb2.shared.FileSystemUtilities;
import org.codehaus.mojo.jaxb2.shared.Validate;

public class JavaDocExtractor {
    private JavaProjectBuilder builder;
    private Log log;

    public JavaDocExtractor(Log log) {
        Validate.notNull(log, "log");
        this.log = log;
        this.builder = new JavaProjectBuilder();
    }

    public JavaDocExtractor addSourceFiles(List<File> sourceCodeFiles) throws IllegalArgumentException {
        Validate.notNull(sourceCodeFiles, "addSourceFiles");
        for (File current : sourceCodeFiles) {
            try {
                this.builder.addSource(current);
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Could not add file [" + FileSystemUtilities.getCanonicalPath(current) + "]", e);
            }
        }
        return this;
    }

    public JavaDocExtractor addSourceURLs(List<URL> sourceCodeURLs) throws IllegalArgumentException {
        Validate.notNull(sourceCodeURLs, "sourceCodeURLs");
        for (URL current : sourceCodeURLs) {
            try {
                this.builder.addSource(current);
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Could not add URL [" + current.toString() + "]", e);
            }
        }
        return this;
    }

    public SearchableDocumentation process() {
        TreeMap<SortableLocation, JavaDocData> dataHolder = new TreeMap<SortableLocation, JavaDocData>();
        Collection sources = this.builder.getSources();
        if (this.log.isInfoEnabled()) {
            this.log.info((CharSequence)("Processing [" + sources.size() + "]\u00a0java sources."));
        }
        for (JavaSource current : sources) {
            JavaPackage currentPackage = current.getPackage();
            String packageName = currentPackage.getName();
            this.addEntry(dataHolder, new PackageLocation(packageName), (JavaAnnotatedElement)currentPackage);
            if (this.log.isDebugEnabled()) {
                this.log.debug((CharSequence)("Added package-level JavaDoc for [" + packageName + "]"));
            }
            for (JavaClass currentClass : current.getClasses()) {
                String simpleClassName = currentClass.getName();
                ClassLocation classLocation = new ClassLocation(packageName, simpleClassName);
                this.addEntry(dataHolder, classLocation, (JavaAnnotatedElement)currentClass);
                if (this.log.isDebugEnabled()) {
                    this.log.debug((CharSequence)("Added class-level JavaDoc for [" + classLocation + "]"));
                }
                for (JavaField currentField : currentClass.getFields()) {
                    FieldLocation fieldLocation = new FieldLocation(packageName, simpleClassName, currentField.getName());
                    this.addEntry(dataHolder, fieldLocation, (JavaAnnotatedElement)currentField);
                    if (!this.log.isDebugEnabled()) continue;
                    this.log.debug((CharSequence)("Added field-level JavaDoc for [" + fieldLocation + "]"));
                }
                for (JavaMethod currentMethod : currentClass.getMethods()) {
                    MethodLocation location = new MethodLocation(packageName, simpleClassName, currentMethod.getName(), currentMethod.getParameters());
                    this.addEntry(dataHolder, location, (JavaAnnotatedElement)currentMethod);
                    if (!this.log.isDebugEnabled()) continue;
                    this.log.debug((CharSequence)("Added method-level JavaDoc for [" + location + "]"));
                }
            }
        }
        return new ReadOnlySearchableDocumentation(dataHolder);
    }

    private void addEntry(SortedMap<SortableLocation, JavaDocData> map, SortableLocation key, JavaAnnotatedElement value) {
        if (map.containsKey(key)) {
            JavaDocData existing = (JavaDocData)map.get(key);
            if (key instanceof PackageLocation) {
                boolean emptyGiven;
                boolean emptyExisting = existing.getComment() == null || existing.getComment().isEmpty();
                boolean bl = emptyGiven = value.getComment() == null || value.getComment().isEmpty();
                if (emptyGiven) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((CharSequence)("Skipping processing empty Package javadoc from [" + key + "]"));
                    }
                    return;
                }
                if (emptyExisting && this.log.isWarnEnabled()) {
                    this.log.warn((CharSequence)("Overwriting empty Package javadoc from [" + key + "]"));
                }
            } else {
                String given = "[" + value.getClass().getName() + "]: " + value.getComment();
                throw new IllegalArgumentException("Not processing duplicate SortableLocation [" + key + "]. " + "\n Existing: " + existing + ".\n Given: [" + given + "]");
            }
        }
        map.put(key, new JavaDocData(value.getComment(), value.getTags()));
    }

    class ReadOnlySearchableDocumentation
    implements SearchableDocumentation {
        private TreeMap<String, SortableLocation> keyMap;
        private SortedMap<? extends SortableLocation, JavaDocData> valueMap;

        ReadOnlySearchableDocumentation(SortedMap<SortableLocation, JavaDocData> valueMap) {
            this.valueMap = valueMap;
            this.keyMap = new TreeMap();
            for (Map.Entry<SortableLocation, JavaDocData> current : valueMap.entrySet()) {
                SortableLocation key = current.getKey();
                this.keyMap.put(key.getPath(), key);
            }
        }

        @Override
        public SortedSet<String> getPaths() {
            return Collections.unmodifiableSortedSet(this.keyMap.navigableKeySet());
        }

        @Override
        public JavaDocData getJavaDoc(String path) {
            Validate.notNull(path, "path");
            Object location = this.getLocation(path);
            return location == null ? null : (JavaDocData)this.valueMap.get(location);
        }

        @Override
        public <T extends SortableLocation> T getLocation(String path) {
            Validate.notNull(path, "path");
            return (T)this.keyMap.get(path);
        }

        @Override
        public SortedMap<SortableLocation, JavaDocData> getAll() {
            return Collections.unmodifiableSortedMap(this.valueMap);
        }

        @Override
        public <T extends SortableLocation> SortedMap<T, JavaDocData> getAll(Class<T> type) {
            Validate.notNull(type, "type");
            TreeMap<SortableLocation, JavaDocData> toReturn = new TreeMap<SortableLocation, JavaDocData>();
            for (Map.Entry<? extends SortableLocation, JavaDocData> current : this.valueMap.entrySet()) {
                if (type != current.getKey().getClass()) continue;
                toReturn.put(current.getKey(), current.getValue());
            }
            return toReturn;
        }
    }
}

