/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.javacc;

import java.io.File;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.codehaus.mojo.javacc.AbstractJavaCCMojo;
import org.codehaus.mojo.javacc.GrammarInfo;
import org.codehaus.mojo.javacc.JJTree;
import org.codehaus.mojo.javacc.JavaCC;
import org.codehaus.plexus.util.FileUtils;

public class JJTreeJavaCCMojo
extends AbstractJavaCCMojo {
    private Boolean buildNodeFiles;
    private Boolean multi;
    private Boolean nodeDefaultVoid;
    private Boolean nodeFactory;
    private String nodePackage;
    private String nodePrefix;
    private Boolean nodeScopeHook;
    private Boolean nodeUsesParser;
    private Boolean visitor;
    private String visitorException;
    private File sourceDirectory;
    private File interimDirectory;
    private File outputDirectory;
    private String[] includes;
    private String[] excludes;
    private int staleMillis;

    protected File getSourceDirectory() {
        return this.sourceDirectory;
    }

    protected String[] getIncludes() {
        if (this.includes != null) {
            return this.includes;
        }
        return new String[]{"**/*.jj", "**/*.JJ", "**/*.jjt", "**/*.JJT"};
    }

    protected String[] getExcludes() {
        return this.excludes;
    }

    protected File getOutputDirectory() {
        return this.outputDirectory;
    }

    protected int getStaleMillis() {
        return this.staleMillis;
    }

    private File getInterimDirectory() {
        return this.interimDirectory;
    }

    protected void processGrammar(GrammarInfo grammarInfo) throws MojoExecutionException, MojoFailureException {
        File jjtFile = grammarInfo.getGrammarFile();
        File jjtDirectory = jjtFile.getParentFile();
        File jjDirectory = new File(this.getInterimDirectory(), grammarInfo.getParserDirectory());
        File parserDirectory = new File(this.getOutputDirectory(), grammarInfo.getParserDirectory());
        String nodePackageName = grammarInfo.resolvePackageName(this.nodePackage);
        File nodeDirectory = nodePackageName != null ? new File(nodePackageName.replace('.', File.separatorChar)) : new File(grammarInfo.getParserDirectory());
        nodeDirectory = new File(this.getOutputDirectory(), nodeDirectory.getPath());
        JJTree jjtree = this.newJJTree();
        jjtree.setInputFile(jjtFile);
        jjtree.setOutputDirectory(jjDirectory);
        jjtree.setNodePackage(nodePackageName);
        jjtree.run();
        try {
            this.getLog().debug((CharSequence)("Copying tree nodes files: " + jjDirectory + " -> " + nodeDirectory));
            FileUtils.copyDirectory((File)jjDirectory, (File)nodeDirectory, (String)"*.java", (String)"");
        }
        catch (Exception e) {
            throw new MojoExecutionException("Failed to copy tree nodes files to output directory: " + jjDirectory + " -> " + nodeDirectory, e);
        }
        try {
            this.getLog().debug((CharSequence)("Copying custom source files: " + jjtDirectory + " -> " + parserDirectory));
            FileUtils.copyDirectory((File)jjtDirectory, (File)parserDirectory, (String)"*.java", (String)"");
        }
        catch (Exception e) {
            throw new MojoExecutionException("Failed to copy custom source files to output directory:" + jjtDirectory + " -> " + parserDirectory, e);
        }
        JavaCC javacc = this.newJavaCC();
        javacc.setInputFile(jjtree.getOutputFile());
        javacc.setOutputDirectory(parserDirectory);
        javacc.run();
    }

    protected JJTree newJJTree() {
        JJTree jjtree = new JJTree();
        jjtree.setLog(this.getLog());
        jjtree.setJdkVersion(this.getJdkVersion());
        jjtree.setStatic(this.getIsStatic());
        jjtree.setBuildNodeFiles(this.buildNodeFiles);
        jjtree.setMulti(this.multi);
        jjtree.setNodeDefaultVoid(this.nodeDefaultVoid);
        jjtree.setNodeFactory(this.nodeFactory);
        jjtree.setNodePrefix(this.nodePrefix);
        jjtree.setNodeScopeHook(this.nodeScopeHook);
        jjtree.setNodeUsesParser(this.nodeUsesParser);
        jjtree.setVisitor(this.visitor);
        jjtree.setVisitorException(this.visitorException);
        return jjtree;
    }
}

