/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.javacc;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.codehaus.mojo.javacc.JavaCCUtil;
import org.codehaus.plexus.compiler.util.scan.InclusionScanException;
import org.codehaus.plexus.compiler.util.scan.StaleSourceScanner;
import org.codehaus.plexus.compiler.util.scan.mapping.SourceMapping;
import org.codehaus.plexus.compiler.util.scan.mapping.SuffixMapping;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.StringUtils;
import org.javacc.parser.Main;

public class JavaCCMojo
extends AbstractMojo {
    private Integer lookAhead;
    private Integer choiceAmbiguityCheck;
    private Integer otherAmbiguityCheck;
    private Boolean isStatic;
    private Boolean debugParser;
    private Boolean debugLookAhead;
    private Boolean debugTokenManager;
    private Boolean errorReporting;
    private Boolean javaUnicodeEscape;
    private Boolean unicodeInput;
    private Boolean ignoreCase;
    private Boolean commonTokenAction;
    private Boolean userTokenManager;
    private Boolean userCharStream;
    private Boolean buildParser;
    private Boolean buildTokenManager;
    private Boolean tokenManagerUsesParser;
    private String tokenExtends;
    private String tokenFactory;
    private Boolean sanityCheck;
    private Boolean forceLaCheck;
    private Boolean cacheTokens;
    private Boolean keepLineColumn;
    private String packageName;
    private File sourceDirectory;
    private File outputDirectory;
    private File timestampDirectory;
    private int staleMillis;
    private Set includes;
    private Set excludes;
    private MavenProject project;

    public void execute() throws MojoExecutionException {
        Set staleGrammars;
        if (this.packageName != null) {
            this.packageName = StringUtils.replace((String)this.packageName, (char)'.', (char)File.separatorChar);
        }
        if (!this.sourceDirectory.isDirectory()) {
            this.getLog().warn((CharSequence)("Source directory '" + this.sourceDirectory + "' does not exist. Skipping..."));
            return;
        }
        if (!this.timestampDirectory.exists()) {
            this.timestampDirectory.mkdirs();
        }
        if (this.includes == null) {
            this.includes = Collections.singleton("**/*");
        }
        if (this.excludes == null) {
            this.excludes = Collections.EMPTY_SET;
        }
        if ((staleGrammars = this.computeStaleGrammars(this.sourceDirectory, this.timestampDirectory)).isEmpty()) {
            this.getLog().info((CharSequence)("Nothing to process - all grammars in " + this.sourceDirectory + " are up to date."));
        } else {
            Iterator i = staleGrammars.iterator();
            while (i.hasNext()) {
                File javaccFile = (File)i.next();
                String outputPackage = this.packageName;
                if (StringUtils.isEmpty((String)outputPackage)) {
                    outputPackage = JavaCCUtil.getDeclaredPackage(javaccFile);
                }
                File outputDirectoryPackage = this.outputDirectory;
                if (outputPackage != null) {
                    outputDirectoryPackage = new File(this.outputDirectory, outputPackage);
                }
                if (!outputDirectoryPackage.exists()) {
                    outputDirectoryPackage.mkdirs();
                }
                try {
                    FileUtils.copyDirectory((File)javaccFile.getParentFile(), (File)outputDirectoryPackage, (String)"*.java", (String)"*.jj,*.JJ");
                }
                catch (IOException e) {
                    throw new MojoExecutionException("Unable to copy overriden java files.", (Exception)e);
                }
                try {
                    Main.mainProgram((String[])this.generateJavaCCArgumentList(javaccFile, outputDirectoryPackage));
                    URI relativeURI = this.sourceDirectory.toURI().relativize(javaccFile.toURI());
                    File timestampFile = new File(this.timestampDirectory.toURI().resolve(relativeURI));
                    FileUtils.copyFile((File)javaccFile, (File)timestampFile);
                }
                catch (Exception e) {
                    throw new MojoExecutionException("JavaCC execution failed", e);
                }
            }
        }
        if (this.project != null) {
            this.project.addCompileSourceRoot(this.outputDirectory.getPath());
        }
    }

    private String[] generateJavaCCArgumentList(File javaccInput, File outputDir) throws MojoExecutionException {
        ArrayList<String> argsList = new ArrayList<String>();
        if (this.lookAhead != null) {
            argsList.add("-LOOKAHEAD=" + this.lookAhead);
        }
        if (this.choiceAmbiguityCheck != null) {
            argsList.add("-CHOICE_AMBIGUITY_CHECK=" + this.choiceAmbiguityCheck);
        }
        if (this.otherAmbiguityCheck != null) {
            argsList.add("-OTHER_AMBIGUITY_CHECK=" + this.otherAmbiguityCheck);
        }
        if (this.isStatic != null) {
            argsList.add("-STATIC=" + this.isStatic);
        }
        if (this.debugParser != null) {
            argsList.add("-DEBUG_PARSER=" + this.debugParser);
        }
        if (this.debugLookAhead != null) {
            argsList.add("-DEBUG_LOOKAHEAD=" + this.debugLookAhead);
        }
        if (this.debugTokenManager != null) {
            argsList.add("-DEBUG_TOKEN_MANAGER=" + this.debugTokenManager);
        }
        if (this.errorReporting != null) {
            argsList.add("-ERROR_REPORTING=" + this.errorReporting);
        }
        if (this.javaUnicodeEscape != null) {
            argsList.add("-JAVA_UNICODE_ESCAPE=" + this.javaUnicodeEscape);
        }
        if (this.unicodeInput != null) {
            argsList.add("-UNICODE_INPUT=" + this.unicodeInput);
        }
        if (this.ignoreCase != null) {
            argsList.add("-IGNORE_CASE=" + this.ignoreCase);
        }
        if (this.commonTokenAction != null) {
            argsList.add("-COMMON_TOKEN_ACTION=" + this.commonTokenAction);
        }
        if (this.userTokenManager != null) {
            argsList.add("-USER_TOKEN_MANAGER=" + this.userTokenManager);
        }
        if (this.userCharStream != null) {
            argsList.add("-USER_CHAR_STREAM=" + this.userCharStream);
        }
        if (this.buildParser != null) {
            argsList.add("-BUILD_PARSER=" + this.buildParser);
        }
        if (this.buildTokenManager != null) {
            argsList.add("-BUILD_TOKEN_MANAGER=" + this.buildTokenManager);
        }
        if (this.tokenManagerUsesParser != null) {
            argsList.add("-TOKEN_MANAGER_USES_PARSER=" + this.tokenManagerUsesParser);
        }
        if (this.tokenExtends != null) {
            argsList.add("-TOKEN_EXTENDS=" + this.tokenExtends);
        }
        if (this.tokenFactory != null) {
            argsList.add("-TOKEN_FACTORY=" + this.tokenFactory);
        }
        if (this.sanityCheck != null) {
            argsList.add("-SANITY_CHECK=" + this.sanityCheck);
        }
        if (this.forceLaCheck != null) {
            argsList.add("-FORCE_LA_CHECK=" + this.forceLaCheck);
        }
        if (this.cacheTokens != null) {
            argsList.add("-CACHE_TOKENS=" + this.cacheTokens);
        }
        if (this.keepLineColumn != null) {
            argsList.add("-KEEP_LINE_COLUMN=" + this.keepLineColumn);
        }
        argsList.add("-OUTPUT_DIRECTORY:" + outputDir);
        argsList.add(javaccInput.getPath());
        this.getLog().debug((CharSequence)("argslist: " + argsList.toString()));
        return argsList.toArray(new String[argsList.size()]);
    }

    private Set computeStaleGrammars(File sourceDir, File timestampDir) throws MojoExecutionException {
        SuffixMapping mapping = new SuffixMapping(".jj", ".jj");
        SuffixMapping mappingCAP = new SuffixMapping(".JJ", ".JJ");
        StaleSourceScanner scanner = new StaleSourceScanner((long)this.staleMillis, this.includes, this.excludes);
        scanner.addSourceMapping((SourceMapping)mapping);
        scanner.addSourceMapping((SourceMapping)mappingCAP);
        HashSet staleSources = new HashSet();
        try {
            staleSources.addAll(scanner.getIncludedSources(sourceDir, timestampDir));
        }
        catch (InclusionScanException e) {
            throw new MojoExecutionException("Error scanning source root: '" + sourceDir + "' for stale grammars to reprocess.", (Exception)((Object)e));
        }
        return staleSources;
    }
}

