/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.flatten;

import java.io.File;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.codehaus.mojo.flatten.AbstractFlattenMojo;

@Mojo(name="clean", defaultPhase=LifecyclePhase.CLEAN, requiresProject=true, requiresDirectInvocation=false, executionStrategy="once-per-session", threadSafe=true)
public class CleanMojo
extends AbstractFlattenMojo {
    @Parameter(property="flatten.clean.skip", defaultValue="false")
    private boolean skipClean;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.shouldSkip()) {
            this.getLog().info((CharSequence)"Clean skipped.");
            return;
        }
        File flattenedPomFile = this.getFlattenedPomFile();
        if (flattenedPomFile.isFile()) {
            this.getLog().info((CharSequence)("Deleting " + flattenedPomFile.getPath()));
            boolean deleted = flattenedPomFile.delete();
            if (!deleted) {
                throw new MojoFailureException("Could not delete " + flattenedPomFile.getAbsolutePath());
            }
        }
    }

    @Override
    protected boolean shouldSkipGoal() {
        return this.skipClean;
    }
}

