/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.flatten;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.inject.Inject;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Activation;
import org.apache.maven.model.Build;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Exclusion;
import org.apache.maven.model.Model;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.Profile;
import org.apache.maven.model.Repository;
import org.apache.maven.model.RepositoryPolicy;
import org.apache.maven.model.building.DefaultModelBuildingRequest;
import org.apache.maven.model.building.ModelBuildingException;
import org.apache.maven.model.building.ModelBuildingRequest;
import org.apache.maven.model.building.ModelBuildingResult;
import org.apache.maven.model.building.ModelProblemCollector;
import org.apache.maven.model.interpolation.ModelInterpolator;
import org.apache.maven.model.io.xpp3.MavenXpp3Writer;
import org.apache.maven.model.profile.ProfileActivationContext;
import org.apache.maven.model.profile.ProfileInjector;
import org.apache.maven.model.profile.ProfileSelector;
import org.apache.maven.model.resolution.ModelResolver;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.dependencies.resolve.DependencyResolver;
import org.apache.maven.shared.dependency.tree.DependencyNode;
import org.apache.maven.shared.dependency.tree.DependencyTreeBuilder;
import org.apache.maven.shared.dependency.tree.DependencyTreeBuilderException;
import org.apache.maven.shared.dependency.tree.traversal.DependencyNodeVisitor;
import org.codehaus.mojo.flatten.AbstractFlattenMojo;
import org.codehaus.mojo.flatten.Dependencies;
import org.codehaus.mojo.flatten.ElementHandling;
import org.codehaus.mojo.flatten.FlattenDependencyMode;
import org.codehaus.mojo.flatten.FlattenDescriptor;
import org.codehaus.mojo.flatten.FlattenMode;
import org.codehaus.mojo.flatten.LoggingModelProblemCollector;
import org.codehaus.mojo.flatten.ModelBuilderThreadSafetyWorkaround;
import org.codehaus.mojo.flatten.PomProperty;
import org.codehaus.mojo.flatten.cifriendly.CiInterpolator;
import org.codehaus.mojo.flatten.model.resolution.FlattenModelResolver;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.impl.ArtifactDescriptorReader;
import org.eclipse.aether.resolution.ArtifactDescriptorException;
import org.eclipse.aether.resolution.ArtifactDescriptorRequest;
import org.eclipse.aether.resolution.ArtifactDescriptorResult;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.ext.DefaultHandler2;
import org.xml.sax.helpers.DefaultHandler;

@Mojo(name="flatten", requiresProject=true, requiresDirectInvocation=false, executionStrategy="once-per-session", requiresDependencyCollection=ResolutionScope.RUNTIME, threadSafe=true)
public class FlattenMojo
extends AbstractFlattenMojo {
    private static final int INITIAL_POM_WRITER_SIZE = 4096;
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    private MavenProject project;
    @Parameter(property="updatePomFile")
    private Boolean updatePomFile;
    @Parameter(defaultValue="${localRepository}", readonly=true, required=true)
    private ArtifactRepository localRepository;
    @Parameter(defaultValue="false")
    private Boolean embedBuildProfileDependencies;
    @Parameter(defaultValue="${mojo}", readonly=true, required=true)
    private MojoExecution mojoExecution;
    @Parameter(required=false)
    private FlattenDescriptor pomElements;
    @Parameter(property="flatten.mode", required=false)
    private FlattenMode flattenMode;
    @Parameter(property="flatten.dependency.mode", required=false)
    private FlattenDependencyMode flattenDependencyMode;
    @Component
    private ArtifactFactory artifactFactory;
    @Component(role=ModelInterpolator.class)
    private ModelInterpolator modelInterpolator;
    @Component(role=CiInterpolator.class)
    private CiInterpolator modelCiFriendlyInterpolator;
    @Parameter(defaultValue="${session}", readonly=true, required=true)
    private MavenSession session;
    @Component
    private DependencyResolver dependencyResolver;
    @Component(hint="default")
    private DependencyTreeBuilder dependencyTreeBuilder;
    @Component(role=ArtifactDescriptorReader.class)
    private ArtifactDescriptorReader artifactDescriptorReader;
    @Inject
    private ModelBuilderThreadSafetyWorkaround modelBuilderThreadSafetyWorkaround;

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.getLog().info((CharSequence)("Generating flattened POM of project " + this.project.getId() + "..."));
        File originalPomFile = this.project.getFile();
        Model flattenedPom = this.createFlattenedPom(originalPomFile);
        String headerComment = this.extractHeaderComment(originalPomFile);
        File flattenedPomFile = this.getFlattenedPomFile();
        this.writePom(flattenedPom, flattenedPomFile, headerComment);
        if (this.isUpdatePomFile()) {
            this.project.setPomFile(flattenedPomFile);
        }
    }

    protected String extractHeaderComment(File xmlFile) throws MojoExecutionException {
        try {
            SAXParser parser = SAXParserFactory.newInstance().newSAXParser();
            SaxHeaderCommentHandler handler = new SaxHeaderCommentHandler();
            parser.setProperty("http://xml.org/sax/properties/lexical-handler", handler);
            parser.parse(xmlFile, (DefaultHandler)handler);
            return handler.getHeaderComment();
        }
        catch (Exception e) {
            throw new MojoExecutionException("Failed to parse XML from " + xmlFile, e);
        }
    }

    protected void writePom(Model pom, File pomFile, String headerComment) throws MojoExecutionException {
        boolean success;
        File parentFile = pomFile.getParentFile();
        if (!parentFile.exists() && !(success = parentFile.mkdirs())) {
            throw new MojoExecutionException("Failed to create directory " + pomFile.getParent());
        }
        MavenXpp3Writer pomWriter = new MavenXpp3Writer();
        StringWriter stringWriter = new StringWriter(4096);
        try {
            pomWriter.write((Writer)stringWriter, pom);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Internal I/O error!", (Exception)e);
        }
        StringBuffer buffer = stringWriter.getBuffer();
        if (!StringUtils.isEmpty((String)headerComment)) {
            int projectStartIndex = buffer.indexOf("<project");
            if (projectStartIndex >= 0) {
                buffer.insert(projectStartIndex, "<!--" + headerComment + "-->\n");
            } else {
                this.getLog().warn((CharSequence)"POM XML post-processing failed: no project tag found!");
            }
        }
        this.writeStringToFile(buffer.toString(), pomFile, pom.getModelEncoding());
    }

    protected void writeStringToFile(String data, File file, String encoding) throws MojoExecutionException {
        byte[] binaryData;
        block20: {
            if (System.getProperty("os.name").contains("Windows")) {
                data = data.replaceAll("\n", "\r\n");
            }
            try {
                binaryData = data.getBytes(encoding);
                if (file.isFile() && file.canRead() && file.length() == (long)binaryData.length) {
                    try (FileInputStream inputStream = new FileInputStream(file);){
                        byte[] buffer = new byte[binaryData.length];
                        ((InputStream)inputStream).read(buffer);
                        if (Arrays.equals(buffer, binaryData)) {
                            this.getLog().debug((CharSequence)"Arrays.equals( buffer, binaryData ) ");
                            return;
                        }
                        this.getLog().debug((CharSequence)"Not Arrays.equals( buffer, binaryData ) ");
                        break block20;
                    }
                    catch (IOException e) {
                        this.getLog().debug((CharSequence)("Issue reading file: " + file.getPath()), (Throwable)e);
                    }
                    break block20;
                }
                this.getLog().debug((CharSequence)("file: " + file + ",file.length(): " + file.length() + ", binaryData.length: " + binaryData.length));
            }
            catch (IOException e) {
                throw new MojoExecutionException("cannot read String as bytes", (Exception)e);
            }
        }
        try (FileOutputStream outStream = new FileOutputStream(file);){
            ((OutputStream)outStream).write(binaryData);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to write to " + file, (Exception)e);
        }
    }

    protected Model createFlattenedPom(File pomFile) throws MojoExecutionException, MojoFailureException {
        ModelBuildingRequest buildingRequest = this.createModelBuildingRequest(pomFile);
        Model effectivePom = this.createEffectivePom(buildingRequest, this.isEmbedBuildProfileDependencies(), this.flattenMode);
        Model flattenedPom = new Model();
        String modelEncoding = effectivePom.getModelEncoding();
        if (StringUtils.isEmpty((String)modelEncoding)) {
            modelEncoding = "UTF-8";
        }
        flattenedPom.setModelEncoding(modelEncoding);
        Model cleanPom = null;
        try {
            cleanPom = this.createCleanPom(effectivePom);
        }
        catch (Exception e) {
            throw new MojoExecutionException("failed to create a clean pom", e);
        }
        FlattenDescriptor descriptor = this.getFlattenDescriptor();
        Model originalPom = this.project.getOriginalModel();
        Model resolvedPom = this.project.getModel();
        Model interpolatedPom = this.createResolvedPom(buildingRequest);
        for (PomProperty<?> property : PomProperty.getPomProperties()) {
            if (!property.isElement()) continue;
            Model sourceModel = this.getSourceModel(descriptor, property, effectivePom, originalPom, resolvedPom, interpolatedPom, cleanPom);
            if (sourceModel == null) {
                if (!property.isRequired()) continue;
                throw new MojoFailureException("Property " + property.getName() + " is required and can not be removed!");
            }
            property.copy(sourceModel, flattenedPom);
        }
        return flattenedPom;
    }

    private Model createResolvedPom(ModelBuildingRequest buildingRequest) {
        LoggingModelProblemCollector problems = new LoggingModelProblemCollector(this.getLog());
        Model originalModel = this.project.getOriginalModel().clone();
        if (this.flattenMode == FlattenMode.resolveCiFriendliesOnly) {
            return this.modelCiFriendlyInterpolator.interpolateModel(originalModel, this.project.getModel().getProjectDirectory(), buildingRequest, problems);
        }
        return this.modelInterpolator.interpolateModel(originalModel, this.project.getModel().getProjectDirectory(), buildingRequest, (ModelProblemCollector)problems);
    }

    protected Model createCleanPom(Model effectivePom) throws MojoExecutionException {
        Model cleanPom = new Model();
        cleanPom.setGroupId(effectivePom.getGroupId());
        cleanPom.setArtifactId(effectivePom.getArtifactId());
        cleanPom.setVersion(effectivePom.getVersion());
        cleanPom.setPackaging(effectivePom.getPackaging());
        cleanPom.setLicenses(effectivePom.getLicenses());
        cleanPom.setModelVersion("4.0.0");
        Build build = effectivePom.getBuild();
        if (build != null) {
            for (Object plugin : build.getPlugins()) {
                if (!plugin.isExtensions()) continue;
                Build cleanBuild = cleanPom.getBuild();
                if (cleanBuild == null) {
                    cleanBuild = new Build();
                    cleanPom.setBuild(cleanBuild);
                }
                Plugin cleanPlugin = new Plugin();
                cleanPlugin.setGroupId(plugin.getGroupId());
                cleanPlugin.setArtifactId(plugin.getArtifactId());
                cleanPlugin.setVersion(plugin.getVersion());
                cleanPlugin.setExtensions(true);
                cleanBuild.addPlugin(cleanPlugin);
            }
        }
        Dependencies managedDependencies = new Dependencies();
        if (effectivePom.getDependencyManagement() != null && effectivePom.getDependencyManagement().getDependencies() != null) {
            managedDependencies.addAll(effectivePom.getDependencyManagement().getDependencies());
        }
        for (Profile profile : effectivePom.getProfiles()) {
            if (this.isEmbedBuildProfileDependencies() && FlattenMojo.isBuildTimeDriven(profile.getActivation()) || this.isEmpty(profile.getDependencies()) && this.isEmpty(profile.getRepositories())) continue;
            ArrayList<Dependency> strippedDependencies = new ArrayList<Dependency>();
            for (Dependency dep : profile.getDependencies()) {
                Dependency flattenedDep;
                Dependency parsedDep = dep.clone();
                if (managedDependencies.contains(parsedDep)) {
                    parsedDep.setVersion(managedDependencies.resolve(parsedDep).getVersion());
                    parsedDep.setScope(managedDependencies.resolve(parsedDep).getScope());
                    if (parsedDep.getScope() == null) {
                        parsedDep.setScope("compile");
                    }
                    parsedDep.setOptional(managedDependencies.resolve(parsedDep).getOptional());
                    if (parsedDep.getOptional() == null) {
                        parsedDep.setOptional("false");
                    }
                }
                if ((flattenedDep = this.createFlattenedDependency(parsedDep)) == null) continue;
                strippedDependencies.add(flattenedDep);
            }
            if (strippedDependencies.isEmpty() && this.isEmpty(profile.getRepositories())) continue;
            Profile strippedProfile = new Profile();
            strippedProfile.setId(profile.getId());
            strippedProfile.setActivation(profile.getActivation());
            strippedProfile.setDependencies(strippedDependencies.isEmpty() ? null : strippedDependencies);
            strippedProfile.setRepositories(profile.getRepositories());
            cleanPom.addProfile(strippedProfile);
        }
        List<Dependency> dependencies = this.createFlattenedDependencies(effectivePom);
        cleanPom.setDependencies(dependencies);
        return cleanPom;
    }

    private Model getSourceModel(FlattenDescriptor descriptor, PomProperty<?> property, Model effectivePom, Model originalPom, Model resolvedPom, Model interpolatedPom, Model cleanPom) {
        ElementHandling handling = descriptor.getHandling(property);
        this.getLog().debug((CharSequence)("Property " + property.getName() + " will be handled using " + (Object)((Object)handling) + " in flattened POM."));
        switch (handling) {
            case expand: {
                return effectivePom;
            }
            case keep: {
                return originalPom;
            }
            case resolve: {
                return resolvedPom;
            }
            case interpolate: {
                return interpolatedPom;
            }
            case flatten: {
                return cleanPom;
            }
            case remove: {
                return null;
            }
        }
        throw new IllegalStateException(handling.toString());
    }

    protected static List<Repository> createFlattenedRepositories(List<Repository> repositories) {
        if (repositories != null) {
            ArrayList<Repository> flattenedRepositories = new ArrayList<Repository>(repositories.size());
            for (Repository repo : repositories) {
                if (FlattenMojo.isCentralRepositoryFromSuperPom(repo)) continue;
                flattenedRepositories.add(repo);
            }
            return flattenedRepositories;
        }
        return repositories;
    }

    private FlattenDescriptor getFlattenDescriptor() throws MojoFailureException {
        FlattenDescriptor descriptor = this.pomElements;
        if (descriptor == null) {
            FlattenMode mode = this.flattenMode;
            if (mode == null) {
                mode = FlattenMode.defaults;
            } else if (this.flattenMode == FlattenMode.minimum) {
                this.getLog().warn((CharSequence)("FlattenMode " + (Object)((Object)FlattenMode.minimum) + " is deprecated!"));
            }
            descriptor = mode.getDescriptor();
            if ("maven-plugin".equals(this.project.getPackaging())) {
                descriptor.setPrerequisites(ElementHandling.expand);
            }
        } else {
            if (descriptor.isEmpty()) {
                Xpp3Dom rawDescriptor = this.mojoExecution.getConfiguration().getChild("pomElements");
                descriptor = new FlattenDescriptor(rawDescriptor);
            }
            if (this.flattenMode != null) {
                descriptor = descriptor.merge(this.flattenMode.getDescriptor());
            }
        }
        return descriptor;
    }

    private static boolean isCentralRepositoryFromSuperPom(Repository repo) {
        RepositoryPolicy snapshots;
        return repo != null && "central".equals(repo.getId()) && (snapshots = repo.getSnapshots()) != null && !snapshots.isEnabled();
    }

    private ModelBuildingRequest createModelBuildingRequest(File pomFile) {
        FlattenModelResolver resolver = new FlattenModelResolver(this.localRepository, this.artifactFactory, this.dependencyResolver, this.session.getProjectBuildingRequest(), this.getReactorModelsFromSession());
        Properties userProperties = this.session.getUserProperties();
        List activeProfiles = this.session.getRequest().getActiveProfiles();
        DefaultModelBuildingRequest buildingRequest = new DefaultModelBuildingRequest().setUserProperties(userProperties).setSystemProperties(System.getProperties()).setPomFile(pomFile).setModelResolver((ModelResolver)resolver).setActiveProfileIds(activeProfiles);
        return buildingRequest;
    }

    private List<MavenProject> getReactorModelsFromSession() {
        List<MavenProject> models = this.session.getAllProjects();
        if (models == null) {
            models = this.session.getProjects();
        }
        if (models == null) {
            models = Collections.emptyList();
        }
        return models;
    }

    protected Model createEffectivePom(ModelBuildingRequest buildingRequest, final boolean embedBuildProfileDependencies, FlattenMode flattenMode) throws MojoExecutionException {
        ModelBuildingResult buildingResult;
        try {
            ProfileInjector customInjector = new ProfileInjector(){

                public void injectProfile(Model model, Profile profile, ModelBuildingRequest request, ModelProblemCollector problems) {
                    List activeProfileIds = request.getActiveProfileIds();
                    if (activeProfileIds.contains(profile.getId())) {
                        Properties merged = new Properties();
                        merged.putAll((Map<?, ?>)model.getProperties());
                        merged.putAll((Map<?, ?>)profile.getProperties());
                        model.setProperties(merged);
                    }
                }
            };
            ProfileSelector customSelector = new ProfileSelector(){

                public List<Profile> getActiveProfiles(Collection<Profile> profiles, ProfileActivationContext context, ModelProblemCollector problems) {
                    ArrayList<Profile> activeProfiles = new ArrayList<Profile>(profiles.size());
                    for (Profile profile : profiles) {
                        Activation activation = profile.getActivation();
                        if (embedBuildProfileDependencies && !FlattenMojo.isBuildTimeDriven(activation)) continue;
                        activeProfiles.add(profile);
                    }
                    return activeProfiles;
                }
            };
            buildingResult = this.modelBuilderThreadSafetyWorkaround.build(buildingRequest, customInjector, customSelector);
        }
        catch (ModelBuildingException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
        }
        Model effectivePom = buildingResult.getEffectiveModel();
        effectivePom.setRepositories(FlattenMojo.createFlattenedRepositories(effectivePom.getRepositories()));
        return effectivePom;
    }

    private boolean isEmpty(Collection<?> collection) {
        if (collection == null) {
            return true;
        }
        return collection.isEmpty();
    }

    public boolean isEmbedBuildProfileDependencies() {
        return this.embedBuildProfileDependencies;
    }

    protected static boolean isBuildTimeDriven(Activation activation) {
        if (activation == null) {
            return true;
        }
        return StringUtils.isEmpty((String)activation.getJdk()) && activation.getOs() == null;
    }

    protected List<Dependency> createFlattenedDependencies(Model effectiveModel) throws MojoExecutionException {
        ArrayList<Dependency> flattenedDependencies = new ArrayList<Dependency>();
        try {
            this.createFlattenedDependencies(effectiveModel, flattenedDependencies);
        }
        catch (Exception e) {
            throw new MojoExecutionException("unable to create flattened dependencies", e);
        }
        if (this.isEmbedBuildProfileDependencies()) {
            Model projectModel = this.project.getModel();
            Dependencies modelDependencies = new Dependencies();
            modelDependencies.addAll(projectModel.getDependencies());
            for (Profile profile : projectModel.getProfiles()) {
                if (!FlattenMojo.isBuildTimeDriven(profile.getActivation())) continue;
                List profileDependencies = profile.getDependencies();
                for (Dependency profileDependency : profileDependencies) {
                    if (!modelDependencies.contains(profileDependency)) continue;
                    flattenedDependencies.add(modelDependencies.resolve(profileDependency));
                }
            }
            this.getLog().debug((CharSequence)("Resolved " + flattenedDependencies.size() + " dependency/-ies for flattened POM."));
        }
        return flattenedDependencies;
    }

    private void createFlattenedDependenciesDirect(List<Dependency> projectDependencies, List<Dependency> flattenedDependencies) {
        for (Dependency projectDependency : projectDependencies) {
            Dependency flattenedDependency = this.createFlattenedDependency(projectDependency);
            if (flattenedDependency == null) continue;
            flattenedDependencies.add(flattenedDependency);
        }
    }

    private void createFlattenedDependenciesAll(List<Dependency> projectDependencies, List<Dependency> flattenedDependencies) throws DependencyTreeBuilderException, ArtifactDescriptorException {
        final LinkedList<DependencyNode> dependencyNodeLinkedList = new LinkedList<DependencyNode>(){};
        HashSet<String> processedDependencies = new HashSet<String>();
        final Artifact projectArtifact = this.project.getArtifact();
        DependencyNode dependencyNode = this.dependencyTreeBuilder.buildDependencyTree(this.project, this.localRepository, null);
        dependencyNode.accept(new DependencyNodeVisitor(){

            public boolean visit(DependencyNode node) {
                if (node.getArtifact().getGroupId().equals(projectArtifact.getGroupId()) && node.getArtifact().getArtifactId().equals(projectArtifact.getArtifactId())) {
                    return true;
                }
                if (node.getState() != 0) {
                    return true;
                }
                dependencyNodeLinkedList.add(node);
                return true;
            }

            public boolean endVisit(DependencyNode node) {
                return true;
            }
        });
        while (!dependencyNodeLinkedList.isEmpty()) {
            Dependency flattenedDependency;
            DependencyNode node = (DependencyNode)dependencyNodeLinkedList.poll();
            Artifact artifact = node.getArtifact();
            Dependency dependency = new Dependency();
            dependency.setGroupId(artifact.getGroupId());
            dependency.setArtifactId(artifact.getArtifactId());
            dependency.setVersion(artifact.getVersion());
            dependency.setClassifier(artifact.getClassifier());
            dependency.setOptional(artifact.isOptional());
            dependency.setScope(artifact.getScope());
            dependency.setType(artifact.getType());
            LinkedList<Exclusion> exclusions = new LinkedList<Exclusion>();
            DefaultArtifact aetherArtifact = new DefaultArtifact(artifact.getGroupId(), artifact.getArtifactId(), null, artifact.getVersion());
            ArtifactDescriptorRequest request = new ArtifactDescriptorRequest((org.eclipse.aether.artifact.Artifact)aetherArtifact, null, null);
            ArtifactDescriptorResult artifactDescriptorResult = this.artifactDescriptorReader.readArtifactDescriptor(this.session.getRepositorySession(), request);
            for (org.eclipse.aether.graph.Dependency artifactDependency : artifactDescriptorResult.getDependencies()) {
                if ("test".equals(artifactDependency.getScope())) continue;
                Exclusion exclusion = new Exclusion();
                exclusion.setGroupId(artifactDependency.getArtifact().getGroupId());
                exclusion.setArtifactId(artifactDependency.getArtifact().getArtifactId());
                exclusions.add(exclusion);
            }
            dependency.setExclusions(exclusions);
            String dependencyString = dependency.getManagementKey();
            if (!processedDependencies.add(dependencyString) || (flattenedDependency = this.createFlattenedDependency(dependency)) == null) continue;
            flattenedDependencies.add(flattenedDependency);
        }
    }

    protected void createFlattenedDependencies(Model effectiveModel, List<Dependency> flattenedDependencies) throws MojoExecutionException {
        this.getLog().debug((CharSequence)("Resolving dependencies of " + effectiveModel.getId()));
        List projectDependencies = effectiveModel.getDependencies();
        if (this.flattenDependencyMode == null | this.flattenDependencyMode == FlattenDependencyMode.direct) {
            this.createFlattenedDependenciesDirect(projectDependencies, flattenedDependencies);
        } else if (this.flattenDependencyMode == FlattenDependencyMode.all) {
            try {
                this.createFlattenedDependenciesAll(projectDependencies, flattenedDependencies);
            }
            catch (Exception e) {
                throw new MojoExecutionException("caught exception when flattening dependencies", e);
            }
        }
    }

    protected Dependency createFlattenedDependency(Dependency projectDependency) {
        return "test".equals(projectDependency.getScope()) ? null : projectDependency;
    }

    public boolean isUpdatePomFile() {
        if (this.updatePomFile == null) {
            if (this.flattenMode == FlattenMode.bom) {
                return true;
            }
            return !this.project.getPackaging().equals("pom");
        }
        return this.updatePomFile;
    }

    private class SaxHeaderCommentHandler
    extends DefaultHandler2 {
        private boolean rootTagSeen = false;
        private String headerComment;

        public String getHeaderComment() {
            return this.headerComment;
        }

        @Override
        public void comment(char[] ch, int start, int length) throws SAXException {
            if (!this.rootTagSeen) {
                if (this.headerComment == null) {
                    this.headerComment = new String(ch, start, length);
                } else {
                    FlattenMojo.this.getLog().warn((CharSequence)"Ignoring multiple XML header comment!");
                }
            }
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
            this.rootTagSeen = true;
        }
    }
}

