/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.exec;

import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.maven.RepositoryUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.codehaus.mojo.exec.ExecutableDependency;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.collection.CollectRequest;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.graph.DependencyFilter;
import org.eclipse.aether.resolution.ArtifactResult;
import org.eclipse.aether.resolution.DependencyRequest;
import org.eclipse.aether.resolution.DependencyResolutionException;
import org.eclipse.aether.resolution.DependencyResult;
import org.eclipse.aether.util.filter.DependencyFilterUtils;

public abstract class AbstractExecMojo
extends AbstractMojo {
    @Component
    protected RepositorySystem repositorySystem;
    @Parameter(defaultValue="${project}", readonly=true)
    protected MavenProject project;
    @Parameter(defaultValue="${session}", readonly=true, required=true)
    private MavenSession session;
    @Parameter(readonly=true, defaultValue="${plugin.artifacts}")
    private List<Artifact> pluginDependencies;
    @Parameter
    protected ExecutableDependency executableDependency;
    @Parameter(property="sourceRoot")
    private File sourceRoot;
    @Parameter(property="testSourceRoot")
    private File testSourceRoot;
    @Parameter(property="exec.args")
    private String commandlineArgs;
    @Parameter(property="exec.classpathScope", defaultValue="runtime")
    protected String classpathScope;
    @Parameter(property="exec.skip", defaultValue="false", alias="skip")
    private boolean skip;
    @Parameter(property="addResourcesToClasspath", defaultValue="false")
    private boolean addResourcesToClasspath;
    @Parameter(property="addOutputToClasspath", defaultValue="true")
    private boolean addOutputToClasspath;
    @Parameter(property="exec.includePluginsDependencies", defaultValue="false")
    protected boolean includePluginDependencies;

    protected void collectProjectArtifactsAndClasspath(List<Artifact> artifacts, List<Path> theClasspathFiles) {
        if (this.addResourcesToClasspath) {
            for (Resource r : this.project.getBuild().getResources()) {
                theClasspathFiles.add(Paths.get(r.getDirectory(), new String[0]));
            }
        }
        if ("compile".equals(this.classpathScope)) {
            artifacts.addAll(this.project.getCompileArtifacts());
            if (this.addOutputToClasspath) {
                theClasspathFiles.add(Paths.get(this.project.getBuild().getOutputDirectory(), new String[0]));
            }
        } else if ("test".equals(this.classpathScope)) {
            artifacts.addAll(this.project.getTestArtifacts());
            if (this.addOutputToClasspath) {
                theClasspathFiles.add(Paths.get(this.project.getBuild().getTestOutputDirectory(), new String[0]));
                theClasspathFiles.add(Paths.get(this.project.getBuild().getOutputDirectory(), new String[0]));
            }
        } else if ("runtime".equals(this.classpathScope)) {
            artifacts.addAll(this.project.getRuntimeArtifacts());
            if (this.addOutputToClasspath) {
                theClasspathFiles.add(Paths.get(this.project.getBuild().getOutputDirectory(), new String[0]));
            }
        } else if ("provided".equals(this.classpathScope)) {
            HashSet artifactSet = new HashSet(this.project.getCompileArtifacts());
            artifactSet.addAll(this.project.getRuntimeArtifacts());
            artifacts.addAll(artifactSet);
            if (this.addOutputToClasspath) {
                theClasspathFiles.add(Paths.get(this.project.getBuild().getOutputDirectory(), new String[0]));
            }
        } else if ("system".equals(this.classpathScope)) {
            artifacts.addAll(this.project.getSystemArtifacts());
        } else {
            throw new IllegalStateException("Invalid classpath scope: " + this.classpathScope);
        }
        this.getLog().debug((CharSequence)("Collected project artifacts " + artifacts));
        this.getLog().debug((CharSequence)("Collected project classpath " + theClasspathFiles));
    }

    protected String[] parseCommandlineArgs() throws MojoExecutionException {
        if (this.commandlineArgs == null) {
            return null;
        }
        try {
            return CommandLineUtils.translateCommandline((String)this.commandlineArgs);
        }
        catch (Exception e) {
            throw new MojoExecutionException(e.getMessage());
        }
    }

    protected boolean hasCommandlineArgs() {
        return this.commandlineArgs != null;
    }

    protected void registerSourceRoots() {
        if (this.sourceRoot != null) {
            this.getLog().info((CharSequence)("Registering compile source root " + this.sourceRoot));
            this.project.addCompileSourceRoot(this.sourceRoot.toString());
        }
        if (this.testSourceRoot != null) {
            this.getLog().info((CharSequence)("Registering compile test source root " + this.testSourceRoot));
            this.project.addTestCompileSourceRoot(this.testSourceRoot.toString());
        }
    }

    protected boolean isSkip() {
        return this.skip;
    }

    protected final MavenSession getSession() {
        return this.session;
    }

    protected final List<Artifact> getPluginDependencies() {
        return this.pluginDependencies;
    }

    protected Artifact findExecutableArtifact() throws MojoExecutionException {
        Artifact executableTool = null;
        for (Artifact pluginDep : this.pluginDependencies) {
            if (!this.executableDependency.matches(pluginDep)) continue;
            executableTool = pluginDep;
            break;
        }
        if (executableTool == null) {
            throw new MojoExecutionException("No dependency of the plugin matches the specified executableDependency.  Specified executableToolAssembly is: " + this.executableDependency.toString());
        }
        return executableTool;
    }

    protected Set<Artifact> determineRelevantPluginDependencies() throws MojoExecutionException {
        Set<Artifact> relevantDependencies;
        if (this.includePluginDependencies) {
            if (this.executableDependency == null) {
                this.getLog().debug((CharSequence)"All Plugin Dependencies will be included.");
                relevantDependencies = new HashSet<Artifact>(this.getPluginDependencies());
            } else {
                this.getLog().debug((CharSequence)"Selected plugin Dependencies will be included.");
                Artifact executableArtifact = this.findExecutableArtifact();
                relevantDependencies = this.resolveExecutableDependencies(executableArtifact);
            }
        } else {
            relevantDependencies = Collections.emptySet();
            this.getLog().debug((CharSequence)"Plugin Dependencies will be excluded.");
        }
        return relevantDependencies;
    }

    private Set<Artifact> resolveExecutableDependencies(Artifact executableArtifact) throws MojoExecutionException {
        try {
            CollectRequest collectRequest = new CollectRequest();
            collectRequest.setRoot(new Dependency(RepositoryUtils.toArtifact((Artifact)executableArtifact), this.classpathScope));
            collectRequest.setRepositories(this.project.getRemotePluginRepositories());
            DependencyFilter classpathFilter = DependencyFilterUtils.classpathFilter((String[])new String[]{this.classpathScope});
            DependencyRequest dependencyRequest = new DependencyRequest(collectRequest, classpathFilter);
            DependencyResult dependencyResult = this.repositorySystem.resolveDependencies(this.getSession().getRepositorySession(), dependencyRequest);
            return dependencyResult.getArtifactResults().stream().map(ArtifactResult::getArtifact).map(RepositoryUtils::toArtifact).collect(Collectors.toSet());
        }
        catch (DependencyResolutionException ex) {
            throw new MojoExecutionException("Encountered problems resolving dependencies of the executable in preparation for its execution.", (Exception)((Object)ex));
        }
    }
}

