/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.aspectj;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Date;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.ArtifactUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.codehaus.mojo.aspectj.AbstractAjcMojo;
import org.codehaus.mojo.aspectj.Module;
import org.codehaus.plexus.util.StringUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class EclipseAjcMojo
extends AbstractAjcMojo {
    public static final String FILE_SEPARATOR = System.getProperty("file.separator");
    private final String[] ASPECT_LIBRARIES_KEYS = new String[]{"org.eclipse.ajdt.ui.aspectPath.contentKind", "org.eclipse.ajdt.ui.aspectPath.entryKind", "org.eclipse.ajdt.ui.aspectPath"};
    private final String[] WEAVE_DEPENDENCIES_KEYS = new String[]{"org.eclipse.ajdt.ui.inPath.contentKind", "org.eclipse.ajdt.ui.inPath.entryKind", "org.eclipse.ajdt.ui.inPath"};
    private static final String AJ_BUILDER = "org.eclipse.ajdt.core.ajbuilder";
    private static final String M2_BUILDER = "org.maven.ide.eclipse.maven2Builder";
    private static final String AJ_NATURE = "org.eclipse.ajdt.ui.ajnature";

    public void execute() throws MojoExecutionException {
        if ("pom".endsWith(this.project.getPackaging()) || "ear".endsWith(this.project.getPackaging())) {
            return;
        }
        File prefs = new File(this.basedir, ".settings" + FILE_SEPARATOR + "org.eclipse.ajdt.ui.prefs");
        try {
            prefs.getParentFile().mkdirs();
            prefs.createNewFile();
        }
        catch (IOException e) {
            throw new MojoExecutionException("Can't create file: " + prefs.getPath());
        }
        PrintWriter out = null;
        try {
            out = new PrintWriter(new FileOutputStream(prefs));
        }
        catch (FileNotFoundException e) {
            // empty catch block
        }
        out.println("#" + new Date());
        out.println("eclipse.preferences.version=1");
        this.writePaths(out, this.aspectLibraries, this.ASPECT_LIBRARIES_KEYS);
        this.writePaths(out, this.weaveDependencies, this.WEAVE_DEPENDENCIES_KEYS);
        out.close();
        File dotProject = new File(this.basedir, ".project");
        if (dotProject.exists()) {
            this.mergeProject(dotProject);
        }
    }

    protected List getOutputDirectories() {
        return null;
    }

    protected List getSourceDirectories() {
        return null;
    }

    private final void writePaths(PrintWriter out, Module[] modules, String[] keys) throws MojoExecutionException {
        int i;
        if (modules == null || modules.length == 0) {
            return;
        }
        String[] paths = new String[modules.length];
        for (i = 0; i < modules.length; ++i) {
            Module module = modules[i];
            String key = ArtifactUtils.versionlessKey((String)module.getGroupId(), (String)module.getArtifactId());
            Artifact artifact = (Artifact)this.project.getArtifactMap().get(key);
            if (artifact == null) {
                throw new MojoExecutionException("The artifact " + key + " referenced in aspectj plugin as an aspect library, is not found the project dependencies");
            }
            paths[i] = artifact.getFile().getPath();
        }
        for (i = 1; i <= paths.length; ++i) {
            out.println("org.eclipse.ajdt.ui.aspectPath.contentKind" + i + "=BINARY");
        }
        for (i = 1; i <= paths.length; ++i) {
            out.println("org.eclipse.ajdt.ui.aspectPath.entryKind" + i + "=LIBRARY");
        }
        for (i = 0; i < paths.length; ++i) {
            out.print("org.eclipse.ajdt.ui.aspectPath" + i + "=");
            String path = paths[i];
            path = StringUtils.replace((String)path, (String)"\\", (String)"/");
            path = StringUtils.replace((String)path, (String)":", (String)"\\:");
            out.println(path);
        }
    }

    private void mergeProject(File file) throws MojoExecutionException {
        try {
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document document = builder.parse(file);
            boolean builderMerged = this.mergeBuilders(document);
            boolean natureMerged = this.mergeNatures(document);
            if (builderMerged || natureMerged) {
                this.writeDocument(document, file);
            }
        }
        catch (ParserConfigurationException ex) {
            throw new MojoExecutionException("Can't create doom parser configuration", (Exception)ex);
        }
        catch (SAXException ex) {
            throw new MojoExecutionException("Can't parse .project file", (Exception)ex);
        }
        catch (Exception ex) {
            throw new MojoExecutionException("Can't merge .project file", ex);
        }
    }

    private boolean mergeBuilders(Document document) throws MojoExecutionException {
        NodeList buildCommandList = document.getElementsByTagName("buildCommand");
        for (int i = 0; i < buildCommandList.getLength(); ++i) {
            Element buildCommand = (Element)buildCommandList.item(i);
            NodeList nameList = buildCommand.getElementsByTagName("name");
            for (int j = 0; j < nameList.getLength(); ++j) {
                Element name = (Element)nameList.item(j);
                if (name.getNodeValue().equals(AJ_BUILDER)) {
                    return false;
                }
                if (!name.getNodeValue().equals(M2_BUILDER)) continue;
                return false;
            }
        }
        NodeList buildSpecList = document.getElementsByTagName("buildSpec");
        if (0 == buildSpecList.getLength()) {
            NodeList nodes = document.getElementsByTagName("natures");
            if (0 == nodes.getLength()) {
                throw new MojoExecutionException("At least one nature must be specified in .project file!");
            }
            Element buildSpec = document.createElement("buildSpec");
            document.insertBefore(buildSpec, nodes.item(0));
            buildSpecList = document.getElementsByTagName("buildSpec");
        }
        Element buildSpec = (Element)buildSpecList.item(0);
        Element buildCommand = document.createElement("buildCommand");
        Element name = document.createElement("name");
        name.setNodeValue(AJ_BUILDER);
        buildCommand.appendChild(name);
        buildCommand.appendChild(document.createElement("arguments"));
        buildSpec.insertBefore(buildCommand, buildSpec.getFirstChild());
        return true;
    }

    private boolean mergeNatures(Document document) throws MojoExecutionException {
        NodeList naturesList = document.getElementsByTagName("natures");
        for (int i = 0; i < naturesList.getLength(); ++i) {
            Element natures = (Element)naturesList.item(i);
            NodeList natureList = natures.getElementsByTagName("nature");
            for (int j = 0; j < natureList.getLength(); ++j) {
                Element nature = (Element)natureList.item(j);
                if (!nature.getNodeValue().equals(AJ_NATURE)) continue;
                return false;
            }
        }
        Element natures = (Element)naturesList.item(0);
        Element nature = document.createElement("nature");
        nature.setNodeValue(AJ_NATURE);
        natures.appendChild(nature);
        return true;
    }

    private void writeDocument(Document document, File file) throws TransformerException, FileNotFoundException {
        document.normalize();
        DOMSource source = new DOMSource(document);
        StreamResult result = new StreamResult(new FileOutputStream(file));
        Transformer transformer = TransformerFactory.newInstance().newTransformer();
        transformer.setOutputProperty("indent", "yes");
        transformer.transform(source, result);
    }
}

