/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.checker.regex.util;

import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.checkerframework.checker.index.qual.GTENegativeOne;
import org.checkerframework.checker.lock.qual.GuardSatisfied;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.regex.qual.Regex;
import org.checkerframework.dataflow.qual.Pure;
import org.checkerframework.dataflow.qual.SideEffectFree;
import org.checkerframework.framework.qual.EnsuresQualifierIf;

public final class RegexUtil {
    private RegexUtil() {
        throw new Error("do not instantiate");
    }

    @Pure
    @EnsuresQualifierIf(result=true, expression={"#1"}, qualifier=Regex.class)
    public static boolean isRegex(String s) {
        return RegexUtil.isRegex(s, 0);
    }

    @Pure
    @EnsuresQualifierIf(result=true, expression={"#1"}, qualifier=Regex.class)
    public static boolean isRegex(String s, int groups) {
        Pattern p;
        try {
            p = Pattern.compile(s);
        }
        catch (PatternSyntaxException e) {
            return false;
        }
        return RegexUtil.getGroupCount(p) >= groups;
    }

    @Pure
    @EnsuresQualifierIf(result=true, expression={"#1"}, qualifier=Regex.class)
    public static boolean isRegex(char c) {
        return RegexUtil.isRegex(Character.toString(c));
    }

    @SideEffectFree
    public static @Nullable String regexError(String s) {
        return RegexUtil.regexError(s, 0);
    }

    @SideEffectFree
    public static @Nullable String regexError(String s, int groups) {
        try {
            Pattern p = Pattern.compile(s);
            int actualGroups = RegexUtil.getGroupCount(p);
            if (actualGroups < groups) {
                return RegexUtil.regexErrorMessage(s, groups, actualGroups);
            }
        }
        catch (PatternSyntaxException e) {
            return e.getMessage();
        }
        return null;
    }

    @SideEffectFree
    public static @Nullable PatternSyntaxException regexException(String s) {
        return RegexUtil.regexException(s, 0);
    }

    @SideEffectFree
    public static @Nullable PatternSyntaxException regexException(String s, int groups) {
        try {
            Pattern p = Pattern.compile(s);
            int actualGroups = RegexUtil.getGroupCount(p);
            if (actualGroups < groups) {
                return new PatternSyntaxException(RegexUtil.regexErrorMessage(s, groups, actualGroups), s, -1);
            }
        }
        catch (PatternSyntaxException pse) {
            return pse;
        }
        return null;
    }

    @SideEffectFree
    public static @Regex String asRegex(String s) {
        return RegexUtil.asRegex(s, 0);
    }

    @SideEffectFree
    public static @Regex String asRegex(String s, int groups) {
        try {
            Pattern p = Pattern.compile(s);
            int actualGroups = RegexUtil.getGroupCount(p);
            if (actualGroups < groups) {
                throw new Error(RegexUtil.regexErrorMessage(s, groups, actualGroups));
            }
            return s;
        }
        catch (PatternSyntaxException e) {
            throw new Error(e);
        }
    }

    @SideEffectFree
    private static String regexErrorMessage(String s, int expectedGroups, int actualGroups) {
        return "regex \"" + s + "\" has " + actualGroups + " groups, but " + expectedGroups + " groups are needed.";
    }

    @Pure
    private static int getGroupCount(Pattern p) {
        return p.matcher("").groupCount();
    }

    public static class CheckedPatternSyntaxException
    extends Exception {
        private static final long serialVersionUID = 6266881831979001480L;
        private final PatternSyntaxException pse;

        public CheckedPatternSyntaxException(PatternSyntaxException pse) {
            this.pse = pse;
        }

        public CheckedPatternSyntaxException(String desc, String regex, @GTENegativeOne int index) {
            this(new PatternSyntaxException(desc, regex, index));
        }

        public String getDescription() {
            return this.pse.getDescription();
        }

        public int getIndex() {
            return this.pse.getIndex();
        }

        @Override
        @Pure
        public String getMessage(@GuardSatisfied CheckedPatternSyntaxException this) {
            return this.pse.getMessage();
        }

        public String getPattern() {
            return this.pse.getPattern();
        }
    }
}

