/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.connect.httpclient.impl;

import connectjar.org.apache.http.Header;
import connectjar.org.apache.http.client.methods.CloseableHttpResponse;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.camunda.commons.utils.IoUtil;
import org.camunda.connect.httpclient.HttpResponse;
import org.camunda.connect.httpclient.impl.HttpConnectorLogger;
import org.camunda.connect.httpclient.impl.HttpLogger;
import org.camunda.connect.impl.AbstractCloseableConnectorResponse;

public class HttpResponseImpl
extends AbstractCloseableConnectorResponse
implements HttpResponse {
    private final HttpConnectorLogger LOG = HttpLogger.HTTP_LOGGER;
    protected CloseableHttpResponse httpResponse;

    public HttpResponseImpl(CloseableHttpResponse httpResponse) {
        this.httpResponse = httpResponse;
    }

    @Override
    public Integer getStatusCode() {
        return (Integer)this.getResponseParameter("statusCode");
    }

    @Override
    public String getResponse() {
        return (String)this.getResponseParameter("response");
    }

    @Override
    public Map<String, String> getHeaders() {
        return (Map)this.getResponseParameter("headers");
    }

    @Override
    public String getHeader(String field) {
        Map<String, String> headers = this.getHeaders();
        if (headers != null) {
            return headers.get(field);
        }
        return null;
    }

    protected void collectResponseParameters(Map<String, Object> responseParameters) {
        if (this.httpResponse.getStatusLine() != null) {
            responseParameters.put("statusCode", this.httpResponse.getStatusLine().getStatusCode());
        }
        this.collectResponseHeaders();
        if (this.httpResponse.getEntity() != null) {
            try {
                String response = IoUtil.inputStreamAsString((InputStream)this.httpResponse.getEntity().getContent());
                responseParameters.put("response", response);
            }
            catch (IOException e) {
                throw this.LOG.unableToReadResponse(e);
            }
            finally {
                IoUtil.closeSilently((Closeable)this.httpResponse);
            }
        }
    }

    protected void collectResponseHeaders() {
        HashMap<String, String> headers = new HashMap<String, String>();
        for (Header header : this.httpResponse.getAllHeaders()) {
            headers.put(header.getName(), header.getValue());
        }
        this.responseParameters.put("headers", headers);
    }

    protected Closeable getClosable() {
        return this.httpResponse;
    }
}

