/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.util;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.List;
import org.camunda.bpm.engine.ArtifactFactory;
import org.camunda.bpm.engine.impl.ProcessEngineLogger;
import org.camunda.bpm.engine.impl.bpmn.parser.FieldDeclaration;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.util.EngineUtilLogger;
import org.camunda.bpm.engine.impl.util.EnsureUtil;
import org.camunda.bpm.engine.impl.util.ReflectUtil;

public class ClassDelegateUtil {
    private static final EngineUtilLogger LOG = ProcessEngineLogger.UTIL_LOGGER;

    public static Object instantiateDelegate(Class<?> clazz, List<FieldDeclaration> fieldDeclarations) {
        return ClassDelegateUtil.instantiateDelegate(clazz.getName(), fieldDeclarations);
    }

    public static Object instantiateDelegate(String className, List<FieldDeclaration> fieldDeclarations) {
        ArtifactFactory artifactFactory = Context.getProcessEngineConfiguration().getArtifactFactory();
        try {
            Class<?> clazz = ReflectUtil.loadClass(className);
            Object object = artifactFactory.getArtifact(clazz);
            ClassDelegateUtil.applyFieldDeclaration(fieldDeclarations, object);
            return object;
        }
        catch (Exception e) {
            throw LOG.exceptionWhileInstantiatingClass(className, e);
        }
    }

    public static void applyFieldDeclaration(List<FieldDeclaration> fieldDeclarations, Object target) {
        if (fieldDeclarations != null) {
            for (FieldDeclaration declaration : fieldDeclarations) {
                ClassDelegateUtil.applyFieldDeclaration(declaration, target);
            }
        }
    }

    public static void applyFieldDeclaration(FieldDeclaration declaration, Object target) {
        Method setterMethod = ReflectUtil.getSetter(declaration.getName(), target.getClass(), declaration.getValue().getClass());
        if (setterMethod != null) {
            try {
                setterMethod.invoke(target, declaration.getValue());
            }
            catch (Exception e) {
                throw LOG.exceptionWhileApplyingFieldDeclatation(declaration.getName(), target.getClass().getName(), e);
            }
        } else {
            Field field = ReflectUtil.getField(declaration.getName(), target);
            EnsureUtil.ensureNotNull("Field definition uses unexisting field '" + declaration.getName() + "' on class " + target.getClass().getName(), "field", (Object)field);
            if (!ClassDelegateUtil.fieldTypeCompatible(declaration, field)) {
                throw LOG.incompatibleTypeForFieldDeclaration(declaration, target, field);
            }
            ReflectUtil.setField(field, target, declaration.getValue());
        }
    }

    public static boolean fieldTypeCompatible(FieldDeclaration declaration, Field field) {
        if (declaration.getValue() != null) {
            return field.getType().isAssignableFrom(declaration.getValue().getClass());
        }
        return true;
    }
}

