/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.migration.instance;

import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.history.HistoryLevel;
import org.camunda.bpm.engine.impl.history.event.HistoryEvent;
import org.camunda.bpm.engine.impl.history.event.HistoryEventProcessor;
import org.camunda.bpm.engine.impl.history.event.HistoryEventTypes;
import org.camunda.bpm.engine.impl.history.producer.HistoryEventProducer;
import org.camunda.bpm.engine.impl.migration.instance.MigratingInstance;
import org.camunda.bpm.engine.impl.migration.instance.MigratingScopeInstance;
import org.camunda.bpm.engine.impl.migration.instance.MigratingTransitionInstance;
import org.camunda.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.camunda.bpm.engine.impl.persistence.entity.IncidentEntity;
import org.camunda.bpm.engine.impl.pvm.process.ScopeImpl;

public class MigratingIncident
implements MigratingInstance {
    protected IncidentEntity incident;
    protected ScopeImpl targetScope;
    protected String targetJobDefinitionId;

    public MigratingIncident(IncidentEntity incident, ScopeImpl targetScope) {
        this.incident = incident;
        this.targetScope = targetScope;
    }

    public void setTargetJobDefinitionId(String targetJobDefinitionId) {
        this.targetJobDefinitionId = targetJobDefinitionId;
    }

    @Override
    public boolean isDetached() {
        return this.incident.getExecutionId() == null;
    }

    @Override
    public void detachState() {
        this.incident.setExecution(null);
    }

    @Override
    public void attachState(MigratingScopeInstance newOwningInstance) {
        this.attachTo(newOwningInstance.resolveRepresentativeExecution());
    }

    @Override
    public void attachState(MigratingTransitionInstance targetTransitionInstance) {
        this.attachTo(targetTransitionInstance.resolveRepresentativeExecution());
    }

    @Override
    public void migrateState() {
        this.incident.setActivityId(this.targetScope.getId());
        this.incident.setProcessDefinitionId(this.targetScope.getProcessDefinition().getId());
        this.incident.setJobDefinitionId(this.targetJobDefinitionId);
        this.migrateHistory();
    }

    protected void migrateHistory() {
        HistoryLevel historyLevel = Context.getProcessEngineConfiguration().getHistoryLevel();
        if (historyLevel.isHistoryEventProduced(HistoryEventTypes.INCIDENT_MIGRATE, this)) {
            HistoryEventProcessor.processHistoryEvents(new HistoryEventProcessor.HistoryEventCreator(){

                @Override
                public HistoryEvent createHistoryEvent(HistoryEventProducer producer) {
                    return producer.createHistoricIncidentMigrateEvt(MigratingIncident.this.incident);
                }
            });
        }
    }

    @Override
    public void migrateDependentEntities() {
    }

    protected void attachTo(ExecutionEntity execution) {
        this.incident.setExecution(execution);
    }
}

