/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.cmmn.model;

import java.util.ArrayDeque;
import java.util.Deque;
import org.camunda.bpm.engine.delegate.CaseExecutionListener;
import org.camunda.bpm.engine.impl.cmmn.behavior.CmmnActivityBehavior;
import org.camunda.bpm.engine.impl.cmmn.behavior.StageActivityBehavior;
import org.camunda.bpm.engine.impl.cmmn.model.CmmnActivity;
import org.camunda.bpm.engine.impl.cmmn.model.CmmnCaseDefinition;
import org.camunda.bpm.engine.impl.core.model.CoreModelElement;

public class CaseDefinitionBuilder {
    protected CmmnCaseDefinition caseDefinition;
    protected CmmnActivity casePlanModel;
    protected Deque<CmmnActivity> activityStack = new ArrayDeque<CmmnActivity>();
    protected CoreModelElement processElement = this.caseDefinition;

    public CaseDefinitionBuilder() {
        this(null);
    }

    public CaseDefinitionBuilder(String caseDefinitionId) {
        this.caseDefinition = new CmmnCaseDefinition(caseDefinitionId);
        this.activityStack.push(this.caseDefinition);
        this.createActivity(caseDefinitionId);
        this.behavior(new StageActivityBehavior());
    }

    public CaseDefinitionBuilder createActivity(String id) {
        CmmnActivity activity = this.activityStack.peek().createActivity(id);
        this.activityStack.push(activity);
        this.processElement = activity;
        return this;
    }

    public CaseDefinitionBuilder endActivity() {
        this.activityStack.pop();
        this.processElement = this.activityStack.peek();
        return this;
    }

    public CaseDefinitionBuilder behavior(CmmnActivityBehavior behavior) {
        this.getActivity().setActivityBehavior(behavior);
        return this;
    }

    public CaseDefinitionBuilder autoComplete(boolean autoComplete) {
        this.getActivity().setProperty("autoComplete", autoComplete);
        return this;
    }

    protected CmmnActivity getActivity() {
        return this.activityStack.peek();
    }

    public CmmnCaseDefinition buildCaseDefinition() {
        return this.caseDefinition;
    }

    public CaseDefinitionBuilder listener(String eventName, CaseExecutionListener planItemListener) {
        this.activityStack.peek().addListener(eventName, planItemListener);
        return this;
    }

    public CaseDefinitionBuilder property(String name, Object value) {
        this.activityStack.peek().setProperty(name, value);
        return this;
    }
}

