/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.cmmn.entity.repository;

import java.util.HashMap;
import java.util.List;
import org.camunda.bpm.engine.impl.Page;
import org.camunda.bpm.engine.impl.ProcessEngineLogger;
import org.camunda.bpm.engine.impl.cmmn.entity.repository.CaseDefinitionEntity;
import org.camunda.bpm.engine.impl.cmmn.entity.repository.CaseDefinitionQueryImpl;
import org.camunda.bpm.engine.impl.db.EnginePersistenceLogger;
import org.camunda.bpm.engine.impl.db.ListQueryParameterObject;
import org.camunda.bpm.engine.impl.persistence.AbstractManager;
import org.camunda.bpm.engine.impl.persistence.AbstractResourceDefinitionManager;
import org.camunda.bpm.engine.repository.CaseDefinition;

public class CaseDefinitionManager
extends AbstractManager
implements AbstractResourceDefinitionManager<CaseDefinitionEntity> {
    protected static final EnginePersistenceLogger LOG = ProcessEngineLogger.PERSISTENCE_LOGGER;

    public void insertCaseDefinition(CaseDefinitionEntity caseDefinition) {
        this.getDbEntityManager().insert(caseDefinition);
    }

    public void deleteCaseDefinitionsByDeploymentId(String deploymentId) {
        this.getDbEntityManager().delete(CaseDefinitionEntity.class, "deleteCaseDefinitionsByDeploymentId", deploymentId);
    }

    public CaseDefinitionEntity findCaseDefinitionById(String caseDefinitionId) {
        return this.getDbEntityManager().selectById(CaseDefinitionEntity.class, caseDefinitionId);
    }

    public CaseDefinitionEntity findLatestCaseDefinitionByKey(String caseDefinitionKey) {
        List caseDefinitions = this.getDbEntityManager().selectList("selectLatestCaseDefinitionByKey", this.configureParameterizedQuery(caseDefinitionKey));
        if (caseDefinitions.isEmpty()) {
            return null;
        }
        if (caseDefinitions.size() == 1) {
            return (CaseDefinitionEntity)caseDefinitions.iterator().next();
        }
        throw LOG.multipleTenantsForCaseDefinitionKeyException(caseDefinitionKey);
    }

    public CaseDefinitionEntity findLatestCaseDefinitionByKeyAndTenantId(String caseDefinitionKey, String tenantId) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("caseDefinitionKey", caseDefinitionKey);
        parameters.put("tenantId", tenantId);
        if (tenantId == null) {
            return (CaseDefinitionEntity)this.getDbEntityManager().selectOne("selectLatestCaseDefinitionByKeyWithoutTenantId", parameters);
        }
        return (CaseDefinitionEntity)this.getDbEntityManager().selectOne("selectLatestCaseDefinitionByKeyAndTenantId", parameters);
    }

    public CaseDefinitionEntity findCaseDefinitionByKeyVersionAndTenantId(String caseDefinitionKey, Integer caseDefinitionVersion, String tenantId) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("caseDefinitionVersion", caseDefinitionVersion);
        parameters.put("caseDefinitionKey", caseDefinitionKey);
        parameters.put("tenantId", tenantId);
        return (CaseDefinitionEntity)this.getDbEntityManager().selectOne("selectCaseDefinitionByKeyVersionAndTenantId", parameters);
    }

    public CaseDefinitionEntity findCaseDefinitionByDeploymentAndKey(String deploymentId, String caseDefinitionKey) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("deploymentId", deploymentId);
        parameters.put("caseDefinitionKey", caseDefinitionKey);
        return (CaseDefinitionEntity)this.getDbEntityManager().selectOne("selectCaseDefinitionByDeploymentAndKey", parameters);
    }

    public String findPreviousCaseDefinitionId(String caseDefinitionKey, Integer version, String tenantId) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("key", caseDefinitionKey);
        params.put("version", version);
        params.put("tenantId", tenantId);
        return (String)this.getDbEntityManager().selectOne("selectPreviousCaseDefinitionId", params);
    }

    public List<CaseDefinition> findCaseDefinitionsByQueryCriteria(CaseDefinitionQueryImpl caseDefinitionQuery, Page page) {
        this.configureCaseDefinitionQuery(caseDefinitionQuery);
        return this.getDbEntityManager().selectList("selectCaseDefinitionsByQueryCriteria", caseDefinitionQuery, page);
    }

    public long findCaseDefinitionCountByQueryCriteria(CaseDefinitionQueryImpl caseDefinitionQuery) {
        this.configureCaseDefinitionQuery(caseDefinitionQuery);
        return (Long)this.getDbEntityManager().selectOne("selectCaseDefinitionCountByQueryCriteria", caseDefinitionQuery);
    }

    public List<CaseDefinition> findCaseDefinitionByDeploymentId(String deploymentId) {
        return this.getDbEntityManager().selectList("selectCaseDefinitionByDeploymentId", deploymentId);
    }

    protected void configureCaseDefinitionQuery(CaseDefinitionQueryImpl query) {
        this.getTenantManager().configureQuery(query);
    }

    protected ListQueryParameterObject configureParameterizedQuery(Object parameter) {
        return this.getTenantManager().configureQuery(parameter);
    }

    @Override
    public CaseDefinitionEntity findLatestDefinitionByKey(String key) {
        return this.findLatestCaseDefinitionByKey(key);
    }

    @Override
    public CaseDefinitionEntity findLatestDefinitionById(String id) {
        return this.findCaseDefinitionById(id);
    }

    @Override
    public CaseDefinitionEntity getCachedResourceDefinitionEntity(String definitionId) {
        return this.getDbEntityManager().getCachedEntity(CaseDefinitionEntity.class, definitionId);
    }

    @Override
    public CaseDefinitionEntity findLatestDefinitionByKeyAndTenantId(String definitionKey, String tenantId) {
        return this.findLatestCaseDefinitionByKeyAndTenantId(definitionKey, tenantId);
    }

    @Override
    public CaseDefinitionEntity findDefinitionByKeyVersionTagAndTenantId(String definitionKey, String definitionVersionTag, String tenantId) {
        throw new UnsupportedOperationException("Currently finding case definition by version tag and tenant is not implemented.");
    }

    @Override
    public CaseDefinitionEntity findDefinitionByKeyVersionAndTenantId(String definitionKey, Integer definitionVersion, String tenantId) {
        return this.findCaseDefinitionByKeyVersionAndTenantId(definitionKey, definitionVersion, tenantId);
    }

    @Override
    public CaseDefinitionEntity findDefinitionByDeploymentAndKey(String deploymentId, String definitionKey) {
        return this.findCaseDefinitionByDeploymentAndKey(deploymentId, definitionKey);
    }
}

