/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.cmd;

import java.io.Serializable;
import java.util.Map;
import org.camunda.bpm.engine.impl.cfg.CommandChecker;
import org.camunda.bpm.engine.impl.form.handler.TaskFormHandler;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.camunda.bpm.engine.impl.persistence.entity.ExecutionVariableSnapshotObserver;
import org.camunda.bpm.engine.impl.persistence.entity.TaskEntity;
import org.camunda.bpm.engine.impl.persistence.entity.TaskManager;
import org.camunda.bpm.engine.impl.task.TaskDefinition;
import org.camunda.bpm.engine.impl.util.EnsureUtil;
import org.camunda.bpm.engine.task.DelegationState;
import org.camunda.bpm.engine.variable.VariableMap;
import org.camunda.bpm.engine.variable.Variables;

public class SubmitTaskFormCmd
implements Command<VariableMap>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected String taskId;
    protected VariableMap properties;
    protected boolean returnVariables;
    protected boolean deserializeValues;

    public SubmitTaskFormCmd(String taskId, Map<String, Object> properties, boolean returnVariables, boolean deserializeValues) {
        this.taskId = taskId;
        this.properties = Variables.fromMap(properties);
        this.returnVariables = returnVariables;
        this.deserializeValues = deserializeValues;
    }

    @Override
    public VariableMap execute(CommandContext commandContext) {
        EnsureUtil.ensureNotNull("taskId", (Object)this.taskId);
        TaskManager taskManager = commandContext.getTaskManager();
        TaskEntity task = taskManager.findTaskById(this.taskId);
        EnsureUtil.ensureNotNull("Cannot find task with id " + this.taskId, "task", (Object)task);
        for (CommandChecker checker : commandContext.getProcessEngineConfiguration().getCommandCheckers()) {
            checker.checkTaskWork(task);
        }
        TaskDefinition taskDefinition = task.getTaskDefinition();
        if (taskDefinition != null) {
            TaskFormHandler taskFormHandler = taskDefinition.getTaskFormHandler();
            taskFormHandler.submitFormVariables(this.properties, task);
        } else {
            task.setVariables((Map<String, ?>)this.properties);
        }
        ExecutionEntity execution = task.getProcessInstance();
        ExecutionVariableSnapshotObserver variablesListener = null;
        if (this.returnVariables && execution != null) {
            variablesListener = new ExecutionVariableSnapshotObserver(execution, false, this.deserializeValues);
        }
        if (DelegationState.PENDING.equals((Object)task.getDelegationState())) {
            task.resolve();
            task.logUserOperation("Resolve");
            task.triggerUpdateEvent();
        } else {
            task.logUserOperation("Complete");
            task.complete();
        }
        if (this.returnVariables) {
            if (variablesListener != null) {
                return variablesListener.getVariables();
            }
            return task.getCaseDefinitionId() == null ? null : task.getVariablesTyped(false);
        }
        return null;
    }
}

