/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.cmd;

import java.util.Collections;
import org.camunda.bpm.engine.impl.cfg.CommandChecker;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.persistence.entity.PropertyChange;
import org.camunda.bpm.engine.impl.persistence.entity.PropertyEntity;
import org.camunda.bpm.engine.impl.persistence.entity.PropertyManager;

public class SetPropertyCmd
implements Command<Object> {
    protected String name;
    protected String value;

    public SetPropertyCmd(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public Object execute(CommandContext commandContext) {
        commandContext.getAuthorizationManager().checkCamundaAdminOrPermission(CommandChecker::checkSetProperty);
        PropertyManager propertyManager = commandContext.getPropertyManager();
        PropertyEntity property = propertyManager.findPropertyById(this.name);
        String operation = null;
        if (property != null) {
            property.setValue(this.value);
            operation = "Update";
        } else {
            property = new PropertyEntity(this.name, this.value);
            propertyManager.insert(property);
            operation = "Create";
        }
        commandContext.getOperationLogManager().logPropertyOperation(operation, Collections.singletonList(new PropertyChange("name", null, this.name)));
        return null;
    }
}

