/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.cmd;

import java.util.List;
import java.util.concurrent.Callable;
import org.camunda.bpm.engine.MismatchingMessageCorrelationException;
import org.camunda.bpm.engine.impl.MessageCorrelationBuilderImpl;
import org.camunda.bpm.engine.impl.ProcessEngineLogger;
import org.camunda.bpm.engine.impl.cmd.AbstractCorrelateMessageCmd;
import org.camunda.bpm.engine.impl.cmd.CommandLogger;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.runtime.CorrelationHandler;
import org.camunda.bpm.engine.impl.runtime.CorrelationHandlerResult;
import org.camunda.bpm.engine.impl.runtime.CorrelationSet;
import org.camunda.bpm.engine.impl.runtime.MessageCorrelationResultImpl;
import org.camunda.bpm.engine.impl.util.EnsureUtil;

public class CorrelateMessageCmd
extends AbstractCorrelateMessageCmd
implements Command<MessageCorrelationResultImpl> {
    private static final CommandLogger LOG = ProcessEngineLogger.CMD_LOGGER;
    protected boolean startMessageOnly;

    public CorrelateMessageCmd(MessageCorrelationBuilderImpl messageCorrelationBuilderImpl, boolean collectVariables, boolean deserializeVariableValues, boolean startMessageOnly) {
        super(messageCorrelationBuilderImpl, collectVariables, deserializeVariableValues);
        this.startMessageOnly = startMessageOnly;
    }

    @Override
    public MessageCorrelationResultImpl execute(final CommandContext commandContext) {
        EnsureUtil.ensureAtLeastOneNotNull("At least one of the following correlation criteria has to be present: messageName, businessKey, correlationKeys, processInstanceId", this.messageName, this.builder.getBusinessKey(), this.builder.getCorrelationProcessInstanceVariables(), this.builder.getProcessInstanceId());
        final CorrelationHandler correlationHandler = Context.getProcessEngineConfiguration().getCorrelationHandler();
        final CorrelationSet correlationSet = new CorrelationSet(this.builder);
        CorrelationHandlerResult correlationResult = null;
        if (this.startMessageOnly) {
            List<CorrelationHandlerResult> correlationResults = commandContext.runWithoutAuthorization(new Callable<List<CorrelationHandlerResult>>(){

                @Override
                public List<CorrelationHandlerResult> call() throws Exception {
                    return correlationHandler.correlateStartMessages(commandContext, CorrelateMessageCmd.this.messageName, correlationSet);
                }
            });
            if (correlationResults.isEmpty()) {
                throw new MismatchingMessageCorrelationException(this.messageName, "No process definition matches the parameters");
            }
            if (correlationResults.size() > 1) {
                throw LOG.exceptionCorrelateMessageToSingleProcessDefinition(this.messageName, correlationResults.size(), correlationSet);
            }
            correlationResult = correlationResults.get(0);
        } else {
            correlationResult = commandContext.runWithoutAuthorization(new Callable<CorrelationHandlerResult>(){

                @Override
                public CorrelationHandlerResult call() throws Exception {
                    return correlationHandler.correlateMessage(commandContext, CorrelateMessageCmd.this.messageName, correlationSet);
                }
            });
            if (correlationResult == null) {
                throw new MismatchingMessageCorrelationException(this.messageName, "No process definition or execution matches the parameters");
            }
        }
        this.checkAuthorization(correlationResult);
        return this.createMessageCorrelationResult(commandContext, correlationResult);
    }
}

