/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.batch.history;

import org.camunda.bpm.engine.BadUserRequestException;
import org.camunda.bpm.engine.impl.batch.history.HistoricBatchEntity;
import org.camunda.bpm.engine.impl.cfg.CommandChecker;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.persistence.entity.PropertyChange;
import org.camunda.bpm.engine.impl.util.EnsureUtil;

public class DeleteHistoricBatchCmd
implements Command<Object> {
    protected String batchId;

    public DeleteHistoricBatchCmd(String batchId) {
        this.batchId = batchId;
    }

    @Override
    public Object execute(CommandContext commandContext) {
        EnsureUtil.ensureNotNull(BadUserRequestException.class, "Historic batch id must not be null", "historic batch id", (Object)this.batchId);
        HistoricBatchEntity historicBatch = commandContext.getHistoricBatchManager().findHistoricBatchById(this.batchId);
        EnsureUtil.ensureNotNull(BadUserRequestException.class, "Historic batch for id '" + this.batchId + "' cannot be found", "historic batch", (Object)historicBatch);
        this.checkAccess(commandContext, historicBatch);
        this.writeUserOperationLog(commandContext, historicBatch.getTenantId());
        historicBatch.delete();
        return null;
    }

    protected void checkAccess(CommandContext commandContext, HistoricBatchEntity batch) {
        for (CommandChecker checker : commandContext.getProcessEngineConfiguration().getCommandCheckers()) {
            checker.checkDeleteHistoricBatch(batch);
        }
    }

    protected void writeUserOperationLog(CommandContext commandContext, String tenantId) {
        commandContext.getOperationLogManager().logBatchOperation("DeleteHistory", this.batchId, tenantId, PropertyChange.EMPTY_CHANGE);
    }
}

