/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.container.impl.deployment;

import java.util.List;
import org.camunda.bpm.application.ProcessApplicationInterface;
import org.camunda.bpm.application.ProcessApplicationReference;
import org.camunda.bpm.container.impl.ContainerIntegrationLogger;
import org.camunda.bpm.container.impl.jmx.services.JmxManagedProcessApplication;
import org.camunda.bpm.container.impl.spi.DeploymentOperation;
import org.camunda.bpm.container.impl.spi.DeploymentOperationStep;
import org.camunda.bpm.container.impl.spi.PlatformServiceContainer;
import org.camunda.bpm.container.impl.spi.ServiceTypes;
import org.camunda.bpm.engine.impl.ProcessEngineLogger;

public class StopProcessApplicationsStep
extends DeploymentOperationStep {
    private static final ContainerIntegrationLogger LOG = ProcessEngineLogger.CONTAINER_INTEGRATION_LOGGER;

    @Override
    public String getName() {
        return "Stopping process applications";
    }

    @Override
    public void performOperationStep(DeploymentOperation operationContext) {
        PlatformServiceContainer serviceContainer = operationContext.getServiceContainer();
        List processApplicationsReferences = serviceContainer.getServiceValuesByType(ServiceTypes.PROCESS_APPLICATION);
        for (JmxManagedProcessApplication processApplication : processApplicationsReferences) {
            this.stopProcessApplication(processApplication.getProcessApplicationReference());
        }
    }

    protected void stopProcessApplication(ProcessApplicationReference processApplicationReference) {
        try {
            ProcessApplicationInterface processApplication = processApplicationReference.getProcessApplication();
            processApplication.undeploy();
        }
        catch (Throwable t) {
            LOG.exceptionWhileStopping("Process Application", processApplicationReference.getName(), t);
        }
    }
}

