// Targeted by JavaCPP version 1.5.4: DO NOT EDIT THIS FILE

package org.bytedeco.videoinput;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;

import static org.bytedeco.videoinput.global.videoInputLib.*;





//////////////////////////////////////   VIDEO INPUT   /////////////////////////////////////



@NoOffset @Properties(inherit = org.bytedeco.videoinput.presets.videoInputLib.class)
public class videoInput extends Pointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public videoInput(Pointer p) { super(p); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public videoInput(long size) { super((Pointer)null); allocateArray(size); }
    private native void allocateArray(long size);
    @Override public videoInput position(long position) {
        return (videoInput)super.position(position);
    }
    @Override public videoInput getPointer(long i) {
        return new videoInput(this).position(position + i);
    }

		public videoInput() { super((Pointer)null); allocate(); }
		private native void allocate();

		//turns off console messages - default is to print messages
		public static native void setVerbose(@Cast("bool") boolean _verbose);

		//this allows for multithreaded use of VI ( default is single threaded ).
		//call this before any videoInput calls. 
		//note if your app has other COM calls then you should set VIs COM usage to match the other COM mode 
		public static native void setComMultiThreaded(@Cast("bool") boolean bMulti);

		//Functions in rough order they should be used.
		public static native int listDevices(@Cast("bool") boolean silent/*=false*/);
		public static native int listDevices();
		public static native @ByVal StringVector getDeviceList(); 

		//needs to be called after listDevices - otherwise returns NULL
		public static native @Cast("const char*") BytePointer getDeviceName(int deviceID);
		public static native int getDeviceIDFromName(@Cast("const char*") BytePointer name);
		public static native int getDeviceIDFromName(String name);

		//needs to be called after listDevices - otherwise returns empty string
		public static native @StdWString CharPointer getUniqueDeviceName(int deviceID);
		public static native int getDeviceIDFromUniqueName(@StdWString CharPointer uniqueName);
		public static native int getDeviceIDFromUniqueName(@StdWString IntPointer uniqueName);

		//choose to use callback based capture - or single threaded
		public native void setUseCallback(@Cast("bool") boolean useCallback);

		//call before setupDevice
		//directshow will try and get the closest possible framerate to what is requested
		public native void setIdealFramerate(int deviceID, int idealFramerate);

		//some devices will stop delivering frames after a while - this method gives you the option to try and reconnect
		//to a device if videoInput detects that a device has stopped delivering frames.
		//you MUST CALL isFrameNew every app loop for this to have any effect
		public native void setAutoReconnectOnFreeze(int deviceNumber, @Cast("bool") boolean doReconnect, int numMissedFramesBeforeReconnect);

		//Choose one of these four to setup your device
		public native @Cast("bool") boolean setupDevice(int deviceID);
		public native @Cast("bool") boolean setupDevice(int deviceID, int w, int h);

		//These two are only for capture cards
		//USB and Firewire cameras souldn't specify connection
		public native @Cast("bool") boolean setupDevice(int deviceID, int connection);
		public native @Cast("bool") boolean setupDevice(int deviceID, int w, int h, int connection);

		//If you need to you can set your NTSC/PAL/SECAM
		//preference here. if it is available it will be used.
		//see #defines above for available formats - eg VI_NTSC_M or VI_PAL_B
		//should be called after setupDevice
		//can be called multiple times
		public native @Cast("bool") boolean setFormat(int deviceNumber, int format);
		public native void setRequestedMediaSubType(int mediatype); // added by gameover

		//Tells you when a new frame has arrived - you should call this if you have specified setAutoReconnectOnFreeze to true
		public native @Cast("bool") boolean isFrameNew(int deviceID);

		public native @Cast("bool") boolean isDeviceSetup(int deviceID);

		//Returns the pixels - flipRedAndBlue toggles RGB/BGR flipping - and you can flip the image too
		public native @Cast("unsigned char*") BytePointer getPixels(int deviceID, @Cast("bool") boolean flipRedAndBlue/*=true*/, @Cast("bool") boolean flipImage/*=false*/);
		public native @Cast("unsigned char*") BytePointer getPixels(int deviceID);

		//Or pass in a buffer for getPixels to fill returns true if successful.
		public native @Cast("bool") boolean getPixels(int id, @Cast("unsigned char*") BytePointer pixels, @Cast("bool") boolean flipRedAndBlue/*=true*/, @Cast("bool") boolean flipImage/*=false*/);
		public native @Cast("bool") boolean getPixels(int id, @Cast("unsigned char*") BytePointer pixels);
		public native @Cast("bool") boolean getPixels(int id, @Cast("unsigned char*") ByteBuffer pixels, @Cast("bool") boolean flipRedAndBlue/*=true*/, @Cast("bool") boolean flipImage/*=false*/);
		public native @Cast("bool") boolean getPixels(int id, @Cast("unsigned char*") ByteBuffer pixels);
		public native @Cast("bool") boolean getPixels(int id, @Cast("unsigned char*") byte[] pixels, @Cast("bool") boolean flipRedAndBlue/*=true*/, @Cast("bool") boolean flipImage/*=false*/);
		public native @Cast("bool") boolean getPixels(int id, @Cast("unsigned char*") byte[] pixels);

		//Launches a pop up settings window
		//For some reason in GLUT you have to call it twice each time.
		public native void showSettingsWindow(int deviceID);

		//Manual control over settings thanks.....
		//These are experimental for now.
		public native @Cast("bool") boolean setVideoSettingFilter(int deviceID, @Cast("long") int Property, @Cast("long") int lValue, @Cast("long") int Flags/*=0*/, @Cast("bool") boolean useDefaultValue/*=false*/);
		public native @Cast("bool") boolean setVideoSettingFilter(int deviceID, @Cast("long") int Property, @Cast("long") int lValue);
		public native @Cast("bool") boolean setVideoSettingFilterPct(int deviceID, @Cast("long") int Property, float pctValue, @Cast("long") int Flags/*=0*/);
		public native @Cast("bool") boolean setVideoSettingFilterPct(int deviceID, @Cast("long") int Property, float pctValue);
		public native @Cast("bool") boolean getVideoSettingFilter(int deviceID, @Cast("long") int Property, @Cast("long*") @ByRef IntPointer min, @Cast("long*") @ByRef IntPointer max, @Cast("long*") @ByRef IntPointer SteppingDelta, @Cast("long*") @ByRef IntPointer currentValue, @Cast("long*") @ByRef IntPointer flags, @Cast("long*") @ByRef IntPointer defaultValue);
		public native @Cast("bool") boolean getVideoSettingFilter(int deviceID, @Cast("long") int Property, @Cast("long*") @ByRef IntBuffer min, @Cast("long*") @ByRef IntBuffer max, @Cast("long*") @ByRef IntBuffer SteppingDelta, @Cast("long*") @ByRef IntBuffer currentValue, @Cast("long*") @ByRef IntBuffer flags, @Cast("long*") @ByRef IntBuffer defaultValue);
		public native @Cast("bool") boolean getVideoSettingFilter(int deviceID, @Cast("long") int Property, @Cast("long*") @ByRef int[] min, @Cast("long*") @ByRef int[] max, @Cast("long*") @ByRef int[] SteppingDelta, @Cast("long*") @ByRef int[] currentValue, @Cast("long*") @ByRef int[] flags, @Cast("long*") @ByRef int[] defaultValue);

		public native @Cast("bool") boolean setVideoSettingCamera(int deviceID, @Cast("long") int Property, @Cast("long") int lValue, @Cast("long") int Flags/*=0*/, @Cast("bool") boolean useDefaultValue/*=false*/);
		public native @Cast("bool") boolean setVideoSettingCamera(int deviceID, @Cast("long") int Property, @Cast("long") int lValue);
		public native @Cast("bool") boolean setVideoSettingCameraPct(int deviceID, @Cast("long") int Property, float pctValue, @Cast("long") int Flags/*=0*/);
		public native @Cast("bool") boolean setVideoSettingCameraPct(int deviceID, @Cast("long") int Property, float pctValue);
		public native @Cast("bool") boolean getVideoSettingCamera(int deviceID, @Cast("long") int Property, @Cast("long*") @ByRef IntPointer min, @Cast("long*") @ByRef IntPointer max, @Cast("long*") @ByRef IntPointer SteppingDelta, @Cast("long*") @ByRef IntPointer currentValue, @Cast("long*") @ByRef IntPointer flags, @Cast("long*") @ByRef IntPointer defaultValue);
		public native @Cast("bool") boolean getVideoSettingCamera(int deviceID, @Cast("long") int Property, @Cast("long*") @ByRef IntBuffer min, @Cast("long*") @ByRef IntBuffer max, @Cast("long*") @ByRef IntBuffer SteppingDelta, @Cast("long*") @ByRef IntBuffer currentValue, @Cast("long*") @ByRef IntBuffer flags, @Cast("long*") @ByRef IntBuffer defaultValue);
		public native @Cast("bool") boolean getVideoSettingCamera(int deviceID, @Cast("long") int Property, @Cast("long*") @ByRef int[] min, @Cast("long*") @ByRef int[] max, @Cast("long*") @ByRef int[] SteppingDelta, @Cast("long*") @ByRef int[] currentValue, @Cast("long*") @ByRef int[] flags, @Cast("long*") @ByRef int[] defaultValue);

		//bool setVideoSettingCam(int deviceID, long Property, long lValue, long Flags = 0, bool useDefaultValue = false);

		//get width, height and number of pixels
		public native int getWidth(int deviceID);
		public native int getHeight(int deviceID);
		public native int getSize(int deviceID);

		//completely stops and frees a device
		public native void stopDevice(int deviceID);

		//as above but then sets it up with same settings
		public native @Cast("bool") boolean restartDevice(int deviceID);

		//number of devices available
		public native int devicesFound(); public native videoInput devicesFound(int setter);

		public native @Cast("long") int propBrightness(); public native videoInput propBrightness(int setter);
		public native @Cast("long") int propContrast(); public native videoInput propContrast(int setter);
		public native @Cast("long") int propHue(); public native videoInput propHue(int setter);
		public native @Cast("long") int propSaturation(); public native videoInput propSaturation(int setter);
		public native @Cast("long") int propSharpness(); public native videoInput propSharpness(int setter);
		public native @Cast("long") int propGamma(); public native videoInput propGamma(int setter);
		public native @Cast("long") int propColorEnable(); public native videoInput propColorEnable(int setter);
		public native @Cast("long") int propWhiteBalance(); public native videoInput propWhiteBalance(int setter);
		public native @Cast("long") int propBacklightCompensation(); public native videoInput propBacklightCompensation(int setter);
		public native @Cast("long") int propGain(); public native videoInput propGain(int setter);

		public native @Cast("long") int propPan(); public native videoInput propPan(int setter);
		public native @Cast("long") int propTilt(); public native videoInput propTilt(int setter);
		public native @Cast("long") int propRoll(); public native videoInput propRoll(int setter);
		public native @Cast("long") int propZoom(); public native videoInput propZoom(int setter);
		public native @Cast("long") int propExposure(); public native videoInput propExposure(int setter);
		public native @Cast("long") int propIris(); public native videoInput propIris(int setter);
		public native @Cast("long") int propFocus(); public native videoInput propFocus(int setter);

}
