/*
 * Decompiled with CFR 0.152.
 */
package org.bytedeco.pytorch;

import java.util.Arrays;
import org.bytedeco.javacpp.Loader;
import org.bytedeco.javacpp.Pointer;
import org.bytedeco.javacpp.annotation.ByRef;
import org.bytedeco.javacpp.annotation.ByVal;
import org.bytedeco.javacpp.annotation.Cast;
import org.bytedeco.javacpp.annotation.Const;
import org.bytedeco.javacpp.annotation.Index;
import org.bytedeco.javacpp.annotation.Name;
import org.bytedeco.javacpp.annotation.NoOffset;
import org.bytedeco.javacpp.annotation.Properties;
import org.bytedeco.pytorch.SymIntOptional;
import org.bytedeco.pytorch.presets.torch;

@Name(value={"std::vector<std::optional<c10::SymInt> >"})
@Properties(inherit={torch.class})
public class SymIntOptionalVector
extends Pointer {
    public SymIntOptionalVector(Pointer p) {
        super(p);
    }

    public SymIntOptionalVector(SymIntOptional value) {
        this(1L);
        this.put(0L, value);
    }

    public SymIntOptionalVector(SymIntOptional ... array) {
        this(array.length);
        this.put(array);
    }

    public SymIntOptionalVector() {
        this.allocate();
    }

    public SymIntOptionalVector(long n) {
        this.allocate(n);
    }

    private native void allocate();

    private native void allocate(@Cast(value={"size_t"}) long var1);

    @Name(value={"operator ="})
    @ByRef
    public native SymIntOptionalVector put(@ByRef SymIntOptionalVector var1);

    public boolean empty() {
        return this.size() == 0L;
    }

    public native long size();

    public void clear() {
        this.resize(0L);
    }

    public native void resize(@Cast(value={"size_t"}) long var1);

    public SymIntOptional front() {
        return this.get(0L);
    }

    public SymIntOptional back() {
        return this.get(this.size() - 1L);
    }

    @Index(function="at")
    @ByRef
    public native SymIntOptional get(@Cast(value={"size_t"}) long var1);

    public native SymIntOptionalVector put(@Cast(value={"size_t"}) long var1, SymIntOptional var3);

    @ByVal
    public native Iterator insert(@ByVal Iterator var1, @ByRef SymIntOptional var2);

    @ByVal
    public native Iterator erase(@ByVal Iterator var1);

    @ByVal
    public native Iterator begin();

    @ByVal
    public native Iterator end();

    public SymIntOptional[] get() {
        SymIntOptional[] array = new SymIntOptional[this.size() < Integer.MAX_VALUE ? (int)this.size() : Integer.MAX_VALUE];
        for (int i = 0; i < array.length; ++i) {
            array[i] = this.get(i);
        }
        return array;
    }

    public String toString() {
        return Arrays.toString((Object[])this.get());
    }

    public SymIntOptional pop_back() {
        long size = this.size();
        SymIntOptional value = this.get(size - 1L);
        this.resize(size - 1L);
        return value;
    }

    public SymIntOptionalVector push_back(SymIntOptional value) {
        long size = this.size();
        this.resize(size + 1L);
        return this.put(size, value);
    }

    public SymIntOptionalVector put(SymIntOptional value) {
        if (this.size() != 1L) {
            this.resize(1L);
        }
        return this.put(0L, value);
    }

    public SymIntOptionalVector put(SymIntOptional ... array) {
        if (this.size() != (long)array.length) {
            this.resize(array.length);
        }
        for (int i = 0; i < array.length; ++i) {
            this.put(i, array[i]);
        }
        return this;
    }

    static {
        Loader.load();
    }

    @NoOffset
    @Name(value={"iterator"})
    public static class Iterator
    extends Pointer {
        public Iterator(Pointer p) {
            super(p);
        }

        public Iterator() {
        }

        @Name(value={"operator ++"})
        @ByRef
        public native Iterator increment();

        @Name(value={"operator =="})
        public native boolean equals(@ByRef Iterator var1);

        @Name(value={"operator *"})
        @ByRef
        @Const
        public native SymIntOptional get();
    }
}

