/*
 * Decompiled with CFR 0.152.
 */
package org.bytedeco.pytorch;

import java.util.Arrays;
import org.bytedeco.javacpp.BytePointer;
import org.bytedeco.javacpp.Loader;
import org.bytedeco.javacpp.Pointer;
import org.bytedeco.javacpp.annotation.ByRef;
import org.bytedeco.javacpp.annotation.ByVal;
import org.bytedeco.javacpp.annotation.Cast;
import org.bytedeco.javacpp.annotation.Index;
import org.bytedeco.javacpp.annotation.Name;
import org.bytedeco.javacpp.annotation.NoOffset;
import org.bytedeco.javacpp.annotation.Properties;
import org.bytedeco.javacpp.annotation.ValueSetter;
import org.bytedeco.pytorch.StringView;
import org.bytedeco.pytorch.presets.torch;

@Name(value={"std::vector<c10::string_view>"})
@Properties(inherit={torch.class})
public class StringViewVector
extends Pointer {
    public StringViewVector(Pointer p) {
        super(p);
    }

    public StringViewVector(BytePointer value) {
        this(1L);
        this.put(0L, value);
    }

    public StringViewVector(BytePointer ... array) {
        this(array.length);
        this.put(array);
    }

    public StringViewVector(String value) {
        this(1L);
        this.put(0L, value);
    }

    public StringViewVector(String ... array) {
        this(array.length);
        this.put(array);
    }

    public StringViewVector() {
        this.allocate();
    }

    public StringViewVector(long n) {
        this.allocate(n);
    }

    private native void allocate();

    private native void allocate(@Cast(value={"size_t"}) long var1);

    @Name(value={"operator ="})
    @ByRef
    public native StringViewVector put(@ByRef StringViewVector var1);

    public boolean empty() {
        return this.size() == 0L;
    }

    public native long size();

    public void clear() {
        this.resize(0L);
    }

    public native void resize(@Cast(value={"size_t"}) long var1);

    public BytePointer front() {
        return this.get(0L);
    }

    public BytePointer back() {
        return this.get(this.size() - 1L);
    }

    @Index(function="at")
    @StringView
    public native BytePointer get(@Cast(value={"size_t"}) long var1);

    public native StringViewVector put(@Cast(value={"size_t"}) long var1, BytePointer var3);

    @ValueSetter
    @Index(function="at")
    public native StringViewVector put(@Cast(value={"size_t"}) long var1, @StringView String var3);

    @ByVal
    public native Iterator insert(@ByVal Iterator var1, @StringView BytePointer var2);

    @ByVal
    public native Iterator erase(@ByVal Iterator var1);

    @ByVal
    public native Iterator begin();

    @ByVal
    public native Iterator end();

    public BytePointer[] get() {
        BytePointer[] array = new BytePointer[this.size() < Integer.MAX_VALUE ? (int)this.size() : Integer.MAX_VALUE];
        for (int i = 0; i < array.length; ++i) {
            array[i] = this.get(i);
        }
        return array;
    }

    public String toString() {
        return Arrays.toString(this.get());
    }

    public BytePointer pop_back() {
        long size = this.size();
        BytePointer value = this.get(size - 1L);
        this.resize(size - 1L);
        return value;
    }

    public StringViewVector push_back(BytePointer value) {
        long size = this.size();
        this.resize(size + 1L);
        return this.put(size, value);
    }

    public StringViewVector put(BytePointer value) {
        if (this.size() != 1L) {
            this.resize(1L);
        }
        return this.put(0L, value);
    }

    public StringViewVector put(BytePointer ... array) {
        if (this.size() != (long)array.length) {
            this.resize(array.length);
        }
        for (int i = 0; i < array.length; ++i) {
            this.put((long)i, array[i]);
        }
        return this;
    }

    public StringViewVector push_back(String value) {
        long size = this.size();
        this.resize(size + 1L);
        return this.put(size, value);
    }

    public StringViewVector put(String value) {
        if (this.size() != 1L) {
            this.resize(1L);
        }
        return this.put(0L, value);
    }

    public StringViewVector put(String ... array) {
        if (this.size() != (long)array.length) {
            this.resize(array.length);
        }
        for (int i = 0; i < array.length; ++i) {
            this.put((long)i, array[i]);
        }
        return this;
    }

    static {
        Loader.load();
    }

    @NoOffset
    @Name(value={"iterator"})
    public static class Iterator
    extends Pointer {
        public Iterator(Pointer p) {
            super(p);
        }

        public Iterator() {
        }

        @Name(value={"operator ++"})
        @ByRef
        public native Iterator increment();

        @Name(value={"operator =="})
        public native boolean equals(@ByRef Iterator var1);

        @Name(value={"operator *"})
        @StringView
        public native BytePointer get();
    }
}

