/*
 * Decompiled with CFR 0.152.
 */
package org.bytedeco.pytorch;

import java.util.Arrays;
import org.bytedeco.javacpp.Loader;
import org.bytedeco.javacpp.Pointer;
import org.bytedeco.javacpp.annotation.ByRef;
import org.bytedeco.javacpp.annotation.ByVal;
import org.bytedeco.javacpp.annotation.Cast;
import org.bytedeco.javacpp.annotation.Const;
import org.bytedeco.javacpp.annotation.Index;
import org.bytedeco.javacpp.annotation.Name;
import org.bytedeco.javacpp.annotation.NoOffset;
import org.bytedeco.javacpp.annotation.Properties;
import org.bytedeco.javacpp.annotation.SharedPtr;
import org.bytedeco.pytorch.Graph;
import org.bytedeco.pytorch.presets.torch;

@Name(value={"std::vector<std::shared_ptr<torch::jit::Graph> >"})
@Properties(inherit={torch.class})
public class GraphVector
extends Pointer {
    public GraphVector(Pointer p) {
        super(p);
    }

    public GraphVector(Graph value) {
        this(1L);
        this.put(0L, value);
    }

    public GraphVector(Graph ... array) {
        this(array.length);
        this.put(array);
    }

    public GraphVector() {
        this.allocate();
    }

    public GraphVector(long n) {
        this.allocate(n);
    }

    private native void allocate();

    private native void allocate(@Cast(value={"size_t"}) long var1);

    @Name(value={"operator ="})
    @ByRef
    public native GraphVector put(@ByRef GraphVector var1);

    public boolean empty() {
        return this.size() == 0L;
    }

    public native long size();

    public void clear() {
        this.resize(0L);
    }

    public native void resize(@Cast(value={"size_t"}) long var1);

    public Graph front() {
        return this.get(0L);
    }

    public Graph back() {
        return this.get(this.size() - 1L);
    }

    @Index(function="at")
    @SharedPtr(value="torch::jit::Graph")
    public native Graph get(@Cast(value={"size_t"}) long var1);

    public native GraphVector put(@Cast(value={"size_t"}) long var1, Graph var3);

    @ByVal
    public native Iterator insert(@ByVal Iterator var1, @SharedPtr(value="torch::jit::Graph") Graph var2);

    @ByVal
    public native Iterator erase(@ByVal Iterator var1);

    @ByVal
    public native Iterator begin();

    @ByVal
    public native Iterator end();

    public Graph[] get() {
        Graph[] array = new Graph[this.size() < Integer.MAX_VALUE ? (int)this.size() : Integer.MAX_VALUE];
        for (int i = 0; i < array.length; ++i) {
            array[i] = this.get(i);
        }
        return array;
    }

    public String toString() {
        return Arrays.toString((Object[])this.get());
    }

    public Graph pop_back() {
        long size = this.size();
        Graph value = this.get(size - 1L);
        this.resize(size - 1L);
        return value;
    }

    public GraphVector push_back(Graph value) {
        long size = this.size();
        this.resize(size + 1L);
        return this.put(size, value);
    }

    public GraphVector put(Graph value) {
        if (this.size() != 1L) {
            this.resize(1L);
        }
        return this.put(0L, value);
    }

    public GraphVector put(Graph ... array) {
        if (this.size() != (long)array.length) {
            this.resize(array.length);
        }
        for (int i = 0; i < array.length; ++i) {
            this.put(i, array[i]);
        }
        return this;
    }

    static {
        Loader.load();
    }

    @NoOffset
    @Name(value={"iterator"})
    public static class Iterator
    extends Pointer {
        public Iterator(Pointer p) {
            super(p);
        }

        public Iterator() {
        }

        @Name(value={"operator ++"})
        @ByRef
        public native Iterator increment();

        @Name(value={"operator =="})
        public native boolean equals(@ByRef Iterator var1);

        @Name(value={"operator *"})
        @SharedPtr(value="torch::jit::Graph")
        @Const
        public native Graph get();
    }
}

