/*
 * Decompiled with CFR 0.152.
 */
package org.bytedeco.pytorch;

import java.util.Arrays;
import org.bytedeco.javacpp.Loader;
import org.bytedeco.javacpp.Pointer;
import org.bytedeco.javacpp.annotation.ByRef;
import org.bytedeco.javacpp.annotation.ByVal;
import org.bytedeco.javacpp.annotation.Cast;
import org.bytedeco.javacpp.annotation.Index;
import org.bytedeco.javacpp.annotation.Name;
import org.bytedeco.javacpp.annotation.NoOffset;
import org.bytedeco.javacpp.annotation.Properties;
import org.bytedeco.pytorch.Future;
import org.bytedeco.pytorch.IntrusivePtr;
import org.bytedeco.pytorch.presets.torch;

@Name(value={"std::vector<c10::intrusive_ptr<c10::ivalue::Future> >"})
@Properties(inherit={torch.class})
public class FutureVector
extends Pointer {
    public FutureVector(Pointer p) {
        super(p);
    }

    public FutureVector(@Cast(value={"", "c10::intrusive_ptr<c10::ivalue::Future>&"}) Future value) {
        this(1L);
        this.put(0L, value);
    }

    public FutureVector(Future ... array) {
        this(array.length);
        this.put(array);
    }

    public FutureVector() {
        this.allocate();
    }

    public FutureVector(long n) {
        this.allocate(n);
    }

    private native void allocate();

    private native void allocate(@Cast(value={"size_t"}) long var1);

    @Name(value={"operator ="})
    @ByRef
    public native FutureVector put(@ByRef FutureVector var1);

    public boolean empty() {
        return this.size() == 0L;
    }

    public native long size();

    public void clear() {
        this.resize(0L);
    }

    public native void resize(@Cast(value={"size_t"}) long var1);

    public Future front() {
        return this.get(0L);
    }

    public Future back() {
        return this.get(this.size() - 1L);
    }

    @Index(function="at")
    @IntrusivePtr(value="c10::ivalue::Future")
    @Cast(value={"", "c10::intrusive_ptr<c10::ivalue::Future>&"})
    public native Future get(@Cast(value={"size_t"}) long var1);

    public native FutureVector put(@Cast(value={"size_t"}) long var1, Future var3);

    @ByVal
    public native Iterator insert(@ByVal Iterator var1, @IntrusivePtr(value="c10::ivalue::Future") @Cast(value={"", "c10::intrusive_ptr<c10::ivalue::Future>&"}) Future var2);

    @ByVal
    public native Iterator erase(@ByVal Iterator var1);

    @ByVal
    public native Iterator begin();

    @ByVal
    public native Iterator end();

    public Future[] get() {
        Future[] array = new Future[this.size() < Integer.MAX_VALUE ? (int)this.size() : Integer.MAX_VALUE];
        for (int i = 0; i < array.length; ++i) {
            array[i] = this.get(i);
        }
        return array;
    }

    public String toString() {
        return Arrays.toString((Object[])this.get());
    }

    public Future pop_back() {
        long size = this.size();
        Future value = this.get(size - 1L);
        this.resize(size - 1L);
        return value;
    }

    public FutureVector push_back(Future value) {
        long size = this.size();
        this.resize(size + 1L);
        return this.put(size, value);
    }

    public FutureVector put(Future value) {
        if (this.size() != 1L) {
            this.resize(1L);
        }
        return this.put(0L, value);
    }

    public FutureVector put(Future ... array) {
        if (this.size() != (long)array.length) {
            this.resize(array.length);
        }
        for (int i = 0; i < array.length; ++i) {
            this.put(i, array[i]);
        }
        return this;
    }

    static {
        Loader.load();
    }

    @NoOffset
    @Name(value={"iterator"})
    public static class Iterator
    extends Pointer {
        public Iterator(Pointer p) {
            super(p);
        }

        public Iterator() {
        }

        @Name(value={"operator ++"})
        @ByRef
        public native Iterator increment();

        @Name(value={"operator =="})
        public native boolean equals(@ByRef Iterator var1);

        @Name(value={"operator *"})
        @IntrusivePtr(value="c10::ivalue::Future")
        @Cast(value={"", "c10::intrusive_ptr<c10::ivalue::Future>&"})
        public native Future get();
    }
}

