// Targeted by JavaCPP version 1.4.4: DO NOT EDIT THIS FILE

package org.bytedeco.javacpp;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.opencv_core.*;
import static org.bytedeco.javacpp.opencv_ml.*;
import static org.bytedeco.javacpp.opencv_imgproc.*;
import static org.bytedeco.javacpp.opencv_imgcodecs.*;
import static org.bytedeco.javacpp.opencv_videoio.*;
import static org.bytedeco.javacpp.opencv_highgui.*;
import static org.bytedeco.javacpp.opencv_flann.*;
import static org.bytedeco.javacpp.opencv_features2d.*;
import static org.bytedeco.javacpp.opencv_calib3d.*;
import static org.bytedeco.javacpp.opencv_shape.*;

public class opencv_xfeatures2d extends org.bytedeco.javacpp.presets.opencv_xfeatures2d {
    static { Loader.load(); }

// Parsed from <opencv2/xfeatures2d.hpp>

/*
By downloading, copying, installing or using the software you agree to this
license. If you do not agree to this license, do not download, install,
copy or use the software.

                          License Agreement
               For Open Source Computer Vision Library
                       (3-clause BSD License)

Copyright (C) 2013, OpenCV Foundation, all rights reserved.
Third party copyrights are property of their respective owners.

Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:

  * Redistributions of source code must retain the above copyright notice,
    this list of conditions and the following disclaimer.

  * Redistributions in binary form must reproduce the above copyright notice,
    this list of conditions and the following disclaimer in the documentation
    and/or other materials provided with the distribution.

  * Neither the names of the copyright holders nor the names of the contributors
    may be used to endorse or promote products derived from this software
    without specific prior written permission.

This software is provided by the copyright holders and contributors "as is" and
any express or implied warranties, including, but not limited to, the implied
warranties of merchantability and fitness for a particular purpose are
disclaimed. In no event shall copyright holders or contributors be liable for
any direct, indirect, incidental, special, exemplary, or consequential damages
(including, but not limited to, procurement of substitute goods or services;
loss of use, data, or profits; or business interruption) however caused
and on any theory of liability, whether in contract, strict liability,
or tort (including negligence or otherwise) arising in any way out of
the use of this software, even if advised of the possibility of such damage.
*/

// #ifndef __OPENCV_XFEATURES2D_HPP__
// #define __OPENCV_XFEATURES2D_HPP__

// #include "opencv2/features2d.hpp"
// #include "opencv2/xfeatures2d/nonfree.hpp"

/** \defgroup xfeatures2d Extra 2D Features Framework
\{
    \defgroup xfeatures2d_experiment Experimental 2D Features Algorithms
<p>
This section describes experimental algorithms for 2d feature detection.
    <p>
    \defgroup xfeatures2d_nonfree Non-free 2D Features Algorithms
<p>
This section describes two popular algorithms for 2d feature detection, SIFT and SURF, that are
known to be patented. You need to set the OPENCV_ENABLE_NONFREE option in cmake to use those. Use them at your own risk.
    <p>
    \defgroup xfeatures2d_match Experimental 2D Features Matching Algorithm
<p>
This section describes the GMS (Grid-based Motion Statistics) matching strategy.
<p>
\}
*/

/** \addtogroup xfeatures2d_experiment
 *  \{
<p>
/** \brief Class implementing the FREAK (*Fast Retina Keypoint*) keypoint descriptor, described in \cite AOV12 .
<p>
The algorithm propose a novel keypoint descriptor inspired by the human visual system and more
precisely the retina, coined Fast Retina Key- point (FREAK). A cascade of binary strings is
computed by efficiently comparing image intensities over a retinal sampling pattern. FREAKs are in
general faster to compute with lower memory load and also more robust than SIFT, SURF or BRISK.
They are competitive alternatives to existing keypoints in particular for embedded applications.
<p>
\note
   -   An example on how to use the FREAK descriptor can be found at
        opencv_source_code/samples/cpp/freak_demo.cpp
 */
@Namespace("cv::xfeatures2d") @NoOffset public static class FREAK extends Feature2D {
    static { Loader.load(); }
    /** Default native constructor. */
    public FREAK() { super((Pointer)null); allocate(); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public FREAK(long size) { super((Pointer)null); allocateArray(size); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public FREAK(Pointer p) { super(p); }
    private native void allocate();
    private native void allocateArray(long size);
    @Override public FREAK position(long position) {
        return (FREAK)super.position(position);
    }


    @MemberGetter public static native int NB_SCALES();
    public static final int NB_SCALES = NB_SCALES();
    @MemberGetter public static native int NB_PAIRS();
    public static final int NB_PAIRS = NB_PAIRS();
    @MemberGetter public static native int NB_ORIENPAIRS();
    public static final int NB_ORIENPAIRS = NB_ORIENPAIRS();

    /**
    @param orientationNormalized Enable orientation normalization.
    @param scaleNormalized Enable scale normalization.
    @param patternScale Scaling of the description pattern.
    @param nOctaves Number of octaves covered by the detected keypoints.
    @param selectedPairs (Optional) user defined selected pairs indexes,
     */
    public static native @Ptr FREAK create(@Cast("bool") boolean orientationNormalized/*=true*/,
                                 @Cast("bool") boolean scaleNormalized/*=true*/,
                                 float patternScale/*=22.0f*/,
                                 int nOctaves/*=4*/,
                                 @StdVector IntPointer selectedPairs/*=std::vector<int>()*/);
    public static native @Ptr FREAK create();
    public static native @Ptr FREAK create(@Cast("bool") boolean orientationNormalized/*=true*/,
                                 @Cast("bool") boolean scaleNormalized/*=true*/,
                                 float patternScale/*=22.0f*/,
                                 int nOctaves/*=4*/,
                                 @StdVector IntBuffer selectedPairs/*=std::vector<int>()*/);
    public static native @Ptr FREAK create(@Cast("bool") boolean orientationNormalized/*=true*/,
                                 @Cast("bool") boolean scaleNormalized/*=true*/,
                                 float patternScale/*=22.0f*/,
                                 int nOctaves/*=4*/,
                                 @StdVector int[] selectedPairs/*=std::vector<int>()*/);
}


/** \brief The class implements the keypoint detector introduced by \cite Agrawal08, synonym of StarDetector. :
 */
@Namespace("cv::xfeatures2d") public static class StarDetector extends Feature2D {
    static { Loader.load(); }
    /** Default native constructor. */
    public StarDetector() { super((Pointer)null); allocate(); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public StarDetector(long size) { super((Pointer)null); allocateArray(size); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public StarDetector(Pointer p) { super(p); }
    private native void allocate();
    private native void allocateArray(long size);
    @Override public StarDetector position(long position) {
        return (StarDetector)super.position(position);
    }

    /** the full constructor */
    public static native @Ptr StarDetector create(int maxSize/*=45*/, int responseThreshold/*=30*/,
                             int lineThresholdProjected/*=10*/,
                             int lineThresholdBinarized/*=8*/,
                             int suppressNonmaxSize/*=5*/);
    public static native @Ptr StarDetector create();
}

/*
 * BRIEF Descriptor
 */

/** \brief Class for computing BRIEF descriptors described in \cite calon2010 .
<p>
@param bytes legth of the descriptor in bytes, valid values are: 16, 32 (default) or 64 .
@param use_orientation sample patterns using keypoints orientation, disabled by default.
 <p>
 */
@Namespace("cv::xfeatures2d") public static class BriefDescriptorExtractor extends Feature2D {
    static { Loader.load(); }
    /** Default native constructor. */
    public BriefDescriptorExtractor() { super((Pointer)null); allocate(); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public BriefDescriptorExtractor(long size) { super((Pointer)null); allocateArray(size); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public BriefDescriptorExtractor(Pointer p) { super(p); }
    private native void allocate();
    private native void allocateArray(long size);
    @Override public BriefDescriptorExtractor position(long position) {
        return (BriefDescriptorExtractor)super.position(position);
    }

    public static native @Ptr BriefDescriptorExtractor create( int bytes/*=32*/, @Cast("bool") boolean use_orientation/*=false*/ );
    public static native @Ptr BriefDescriptorExtractor create( );
}

/** \brief Class implementing the locally uniform comparison image descriptor, described in \cite LUCID
<p>
An image descriptor that can be computed very fast, while being
about as robust as, for example, SURF or BRIEF.
<p>
\note It requires a color image as input.
 */
@Namespace("cv::xfeatures2d") public static class LUCID extends Feature2D {
    static { Loader.load(); }
    /** Default native constructor. */
    public LUCID() { super((Pointer)null); allocate(); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public LUCID(long size) { super((Pointer)null); allocateArray(size); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public LUCID(Pointer p) { super(p); }
    private native void allocate();
    private native void allocateArray(long size);
    @Override public LUCID position(long position) {
        return (LUCID)super.position(position);
    }

    /**
     * @param lucid_kernel kernel for descriptor construction, where 1=3x3, 2=5x5, 3=7x7 and so forth
     * @param blur_kernel kernel for blurring image prior to descriptor construction, where 1=3x3, 2=5x5, 3=7x7 and so forth
     */
    public static native @Ptr LUCID create(int lucid_kernel/*=1*/, int blur_kernel/*=2*/);
    public static native @Ptr LUCID create();
}


/*
* LATCH Descriptor
*/

/** latch Class for computing the LATCH descriptor.
If you find this code useful, please add a reference to the following paper in your work:
Gil Levi and Tal Hassner, "LATCH: Learned Arrangements of Three Patch Codes", arXiv preprint arXiv:1501.03719, 15 Jan. 2015
<p>
LATCH is a binary descriptor based on learned comparisons of triplets of image patches.
<p>
* bytes is the size of the descriptor - can be 64, 32, 16, 8, 4, 2 or 1
* rotationInvariance - whether or not the descriptor should compansate for orientation changes.
* half_ssd_size - the size of half of the mini-patches size. For example, if we would like to compare triplets of patches of size 7x7x
    then the half_ssd_size should be (7-1)/2 = 3.
* sigma - sigma value for GaussianBlur smoothing of the source image. Source image will be used without smoothing in case sigma value is 0.
<p>
Note: the descriptor can be coupled with any keypoint extractor. The only demand is that if you use set rotationInvariance = True then
    you will have to use an extractor which estimates the patch orientation (in degrees). Examples for such extractors are ORB and SIFT.
<p>
Note: a complete example can be found under /samples/cpp/tutorial_code/xfeatures2D/latch_match.cpp
<p>
*/
@Namespace("cv::xfeatures2d") public static class LATCH extends Feature2D {
    static { Loader.load(); }
    /** Default native constructor. */
    public LATCH() { super((Pointer)null); allocate(); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public LATCH(long size) { super((Pointer)null); allocateArray(size); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public LATCH(Pointer p) { super(p); }
    private native void allocate();
    private native void allocateArray(long size);
    @Override public LATCH position(long position) {
        return (LATCH)super.position(position);
    }

    public static native @Ptr LATCH create(int bytes/*=32*/, @Cast("bool") boolean rotationInvariance/*=true*/, int half_ssd_size/*=3*/, double sigma/*=2.0*/);
    public static native @Ptr LATCH create();
}

/** \brief Class implementing DAISY descriptor, described in \cite Tola10
<p>
@param radius radius of the descriptor at the initial scale
@param q_radius amount of radial range division quantity
@param q_theta amount of angular range division quantity
@param q_hist amount of gradient orientations range division quantity
@param norm choose descriptors normalization type, where
DAISY::NRM_NONE will not do any normalization (default),
DAISY::NRM_PARTIAL mean that histograms are normalized independently for L2 norm equal to 1.0,
DAISY::NRM_FULL mean that descriptors are normalized for L2 norm equal to 1.0,
DAISY::NRM_SIFT mean that descriptors are normalized for L2 norm equal to 1.0 but no individual one is bigger than 0.154 as in SIFT
@param H optional 3x3 homography matrix used to warp the grid of daisy but sampling keypoints remains unwarped on image
@param interpolation switch to disable interpolation for speed improvement at minor quality loss
@param use_orientation sample patterns using keypoints orientation, disabled by default.
 <p>
 */
@Namespace("cv::xfeatures2d") public static class DAISY extends Feature2D {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public DAISY(Pointer p) { super(p); }

    /** enum cv::xfeatures2d::DAISY::NormalizationType */
    public static final int
        NRM_NONE = 100, NRM_PARTIAL = 101, NRM_FULL = 102, NRM_SIFT = 103;
    public static native @Ptr DAISY create( float radius/*=15*/, int q_radius/*=3*/, int q_theta/*=8*/,
                    int q_hist/*=8*/, @Cast("cv::xfeatures2d::DAISY::NormalizationType") int norm/*=cv::xfeatures2d::DAISY::NRM_NONE*/, @ByVal(nullValue = "cv::InputArray(cv::noArray())") Mat H,
                    @Cast("bool") boolean interpolation/*=true*/, @Cast("bool") boolean use_orientation/*=false*/ );
    public static native @Ptr DAISY create( );
    public static native @Ptr DAISY create( float radius/*=15*/, int q_radius/*=3*/, int q_theta/*=8*/,
                    int q_hist/*=8*/, @Cast("cv::xfeatures2d::DAISY::NormalizationType") int norm/*=cv::xfeatures2d::DAISY::NRM_NONE*/, @ByVal(nullValue = "cv::InputArray(cv::noArray())") UMat H,
                    @Cast("bool") boolean interpolation/*=true*/, @Cast("bool") boolean use_orientation/*=false*/ );
    public static native @Ptr DAISY create( float radius/*=15*/, int q_radius/*=3*/, int q_theta/*=8*/,
                    int q_hist/*=8*/, @Cast("cv::xfeatures2d::DAISY::NormalizationType") int norm/*=cv::xfeatures2d::DAISY::NRM_NONE*/, @ByVal(nullValue = "cv::InputArray(cv::noArray())") GpuMat H,
                    @Cast("bool") boolean interpolation/*=true*/, @Cast("bool") boolean use_orientation/*=false*/ );

    /** \overload
     * @param image image to extract descriptors
     * @param keypoints of interest within image
     * @param descriptors resulted descriptors array
     */
    public native @Override void compute( @ByVal Mat image, @ByRef KeyPointVector keypoints, @ByVal Mat descriptors );
    public native @Override void compute( @ByVal UMat image, @ByRef KeyPointVector keypoints, @ByVal UMat descriptors );
    public native @Override void compute( @ByVal GpuMat image, @ByRef KeyPointVector keypoints, @ByVal GpuMat descriptors );

    public native @Override void compute( @ByVal MatVector images,
                              @ByRef KeyPointVectorVector keypoints,
                              @ByVal MatVector descriptors );
    public native @Override void compute( @ByVal UMatVector images,
                              @ByRef KeyPointVectorVector keypoints,
                              @ByVal UMatVector descriptors );
    public native @Override void compute( @ByVal GpuMatVector images,
                              @ByRef KeyPointVectorVector keypoints,
                              @ByVal GpuMatVector descriptors );

    /** \overload
     * @param image image to extract descriptors
     * @param roi region of interest within image
     * @param descriptors resulted descriptors array for roi image pixels
     */
    public native void compute( @ByVal Mat image, @ByVal Rect roi, @ByVal Mat descriptors );
    public native void compute( @ByVal UMat image, @ByVal Rect roi, @ByVal UMat descriptors );
    public native void compute( @ByVal GpuMat image, @ByVal Rect roi, @ByVal GpuMat descriptors );

    /**\overload
     * @param image image to extract descriptors
     * @param descriptors resulted descriptors array for all image pixels
     */
    public native void compute( @ByVal Mat image, @ByVal Mat descriptors );
    public native void compute( @ByVal UMat image, @ByVal UMat descriptors );
    public native void compute( @ByVal GpuMat image, @ByVal GpuMat descriptors );

    /**
     * @param y position y on image
     * @param x position x on image
     * @param orientation orientation on image (0->360)
     * @param descriptor supplied array for descriptor storage
     */
    public native void GetDescriptor( double y, double x, int orientation, FloatPointer descriptor );
    public native void GetDescriptor( double y, double x, int orientation, FloatBuffer descriptor );
    public native void GetDescriptor( double y, double x, int orientation, float[] descriptor );

    /**
     * @param y position y on image
     * @param x position x on image
     * @param orientation orientation on image (0->360)
     * @param descriptor supplied array for descriptor storage
     * @param H homography matrix for warped grid
     */
    public native @Cast("bool") boolean GetDescriptor( double y, double x, int orientation, FloatPointer descriptor, DoublePointer H );
    public native @Cast("bool") boolean GetDescriptor( double y, double x, int orientation, FloatBuffer descriptor, DoubleBuffer H );
    public native @Cast("bool") boolean GetDescriptor( double y, double x, int orientation, float[] descriptor, double[] H );

    /**
     * @param y position y on image
     * @param x position x on image
     * @param orientation orientation on image (0->360)
     * @param descriptor supplied array for descriptor storage
     */
    public native void GetUnnormalizedDescriptor( double y, double x, int orientation, FloatPointer descriptor );
    public native void GetUnnormalizedDescriptor( double y, double x, int orientation, FloatBuffer descriptor );
    public native void GetUnnormalizedDescriptor( double y, double x, int orientation, float[] descriptor );

    /**
     * @param y position y on image
     * @param x position x on image
     * @param orientation orientation on image (0->360)
     * @param descriptor supplied array for descriptor storage
     * @param H homography matrix for warped grid
     */
    public native @Cast("bool") boolean GetUnnormalizedDescriptor( double y, double x, int orientation, FloatPointer descriptor, DoublePointer H );
    public native @Cast("bool") boolean GetUnnormalizedDescriptor( double y, double x, int orientation, FloatBuffer descriptor, DoubleBuffer H );
    public native @Cast("bool") boolean GetUnnormalizedDescriptor( double y, double x, int orientation, float[] descriptor, double[] H );

}

/** \brief Class implementing the MSD (*Maximal Self-Dissimilarity*) keypoint detector, described in \cite Tombari14.
<p>
The algorithm implements a novel interest point detector stemming from the intuition that image patches
which are highly dissimilar over a relatively large extent of their surroundings hold the property of
being repeatable and distinctive. This concept of "contextual self-dissimilarity" reverses the key
paradigm of recent successful techniques such as the Local Self-Similarity descriptor and the Non-Local
Means filter, which build upon the presence of similar - rather than dissimilar - patches. Moreover,
it extends to contextual information the local self-dissimilarity notion embedded in established
detectors of corner-like interest points, thereby achieving enhanced repeatability, distinctiveness and
localization accuracy.
<p>
*/

@Namespace("cv::xfeatures2d") public static class MSDDetector extends Feature2D {
    static { Loader.load(); }
    /** Default native constructor. */
    public MSDDetector() { super((Pointer)null); allocate(); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public MSDDetector(long size) { super((Pointer)null); allocateArray(size); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public MSDDetector(Pointer p) { super(p); }
    private native void allocate();
    private native void allocateArray(long size);
    @Override public MSDDetector position(long position) {
        return (MSDDetector)super.position(position);
    }


    public static native @Ptr MSDDetector create(int m_patch_radius/*=3*/, int m_search_area_radius/*=5*/,
                int m_nms_radius/*=5*/, int m_nms_scale_radius/*=0*/, float m_th_saliency/*=250.0f*/, int m_kNN/*=4*/,
                float m_scale_factor/*=1.25f*/, int m_n_scales/*=-1*/, @Cast("bool") boolean m_compute_orientation/*=false*/);
    public static native @Ptr MSDDetector create();
}

/** \brief Class implementing VGG (Oxford Visual Geometry Group) descriptor trained end to end
using "Descriptor Learning Using Convex Optimisation" (DLCO) aparatus described in \cite Simonyan14.
<p>
@param desc type of descriptor to use, VGG::VGG_120 is default (120 dimensions float)
Available types are VGG::VGG_120, VGG::VGG_80, VGG::VGG_64, VGG::VGG_48
@param isigma gaussian kernel value for image blur (default is 1.4f)
@param img_normalize use image sample intensity normalization (enabled by default)
@param use_orientation sample patterns using keypoints orientation, enabled by default
@param scale_factor adjust the sampling window of detected keypoints to 64.0f (VGG sampling window)
6.25f is default and fits for KAZE, SURF detected keypoints window ratio
6.75f should be the scale for SIFT detected keypoints window ratio
5.00f should be the scale for AKAZE, MSD, AGAST, FAST, BRISK keypoints window ratio
0.75f should be the scale for ORB keypoints ratio
<p>
@param dsc_normalize clamp descriptors to 255 and convert to uchar CV_8UC1 (disabled by default)
 <p>
 */
@Namespace("cv::xfeatures2d") public static class VGG extends Feature2D {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public VGG(Pointer p) { super(p); }


    /** enum cv::xfeatures2d::VGG:: */
    public static final int
        VGG_120 = 100, VGG_80 = 101, VGG_64 = 102, VGG_48 = 103;

    public static native @Ptr VGG create( int desc/*=cv::xfeatures2d::VGG::VGG_120*/, float isigma/*=1.4f*/,
                                        @Cast("bool") boolean img_normalize/*=true*/, @Cast("bool") boolean use_scale_orientation/*=true*/,
                                        float scale_factor/*=6.25f*/, @Cast("bool") boolean dsc_normalize/*=false*/ );
    public static native @Ptr VGG create( );

    public native void setSigma(float isigma);
    public native float getSigma();

    public native void setUseNormalizeImage(@Cast("const bool") boolean img_normalize);
    public native @Cast("bool") boolean getUseNormalizeImage();

    public native void setUseScaleOrientation(@Cast("const bool") boolean use_scale_orientation);
    public native @Cast("bool") boolean getUseScaleOrientation();

    public native void setScaleFactor(float scale_factor);
    public native float getScaleFactor();

    public native void setUseNormalizeDescriptor(@Cast("const bool") boolean dsc_normalize);
    public native @Cast("bool") boolean getUseNormalizeDescriptor();
}

/** \brief Class implementing BoostDesc (Learning Image Descriptors with Boosting), described in
\cite Trzcinski13a and \cite Trzcinski13b.
<p>
@param desc type of descriptor to use, BoostDesc::BINBOOST_256 is default (256 bit long dimension)
Available types are: BoostDesc::BGM, BoostDesc::BGM_HARD, BoostDesc::BGM_BILINEAR, BoostDesc::LBGM,
BoostDesc::BINBOOST_64, BoostDesc::BINBOOST_128, BoostDesc::BINBOOST_256
@param use_orientation sample patterns using keypoints orientation, enabled by default
@param scale_factor adjust the sampling window of detected keypoints
6.25f is default and fits for KAZE, SURF detected keypoints window ratio
6.75f should be the scale for SIFT detected keypoints window ratio
5.00f should be the scale for AKAZE, MSD, AGAST, FAST, BRISK keypoints window ratio
0.75f should be the scale for ORB keypoints ratio
1.50f was the default in original implementation
<p>
\note BGM is the base descriptor where each binary dimension is computed as the output of a single weak learner.
BGM_HARD and BGM_BILINEAR refers to same BGM but use different type of gradient binning. In the BGM_HARD that
use ASSIGN_HARD binning type the gradient is assigned to the nearest orientation bin. In the BGM_BILINEAR that use
ASSIGN_BILINEAR binning type the gradient is assigned to the two neighbouring bins. In the BGM and all other modes that use
ASSIGN_SOFT binning type the gradient is assigned to 8 nearest bins according to the cosine value between the gradient
angle and the bin center. LBGM (alias FP-Boost) is the floating point extension where each dimension is computed
as a linear combination of the weak learner responses. BINBOOST and subvariants are the binary extensions of LBGM
where each bit is computed as a thresholded linear combination of a set of weak learners.
BoostDesc header files (boostdesc_*.i) was exported from original binaries with export-boostdesc.py script from
samples subfolder.
<p>
*/

@Namespace("cv::xfeatures2d") public static class BoostDesc extends Feature2D {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public BoostDesc(Pointer p) { super(p); }


    /** enum cv::xfeatures2d::BoostDesc:: */
    public static final int
       BGM = 100, BGM_HARD = 101, BGM_BILINEAR = 102, LBGM = 200,
       BINBOOST_64 = 300, BINBOOST_128 = 301, BINBOOST_256 = 302;

    public static native @Ptr BoostDesc create( int desc/*=cv::xfeatures2d::BoostDesc::BINBOOST_256*/,
                        @Cast("bool") boolean use_scale_orientation/*=true*/, float scale_factor/*=6.25f*/ );
    public static native @Ptr BoostDesc create( );

    public native void setUseScaleOrientation(@Cast("const bool") boolean use_scale_orientation);
    public native @Cast("bool") boolean getUseScaleOrientation();

    public native void setScaleFactor(float scale_factor);
    public native float getScaleFactor();
}


/*
* Position-Color-Texture signatures
*/

/**
* \brief Class implementing PCT (position-color-texture) signature extraction
*       as described in \cite KrulisLS16.
*       The algorithm is divided to a feature sampler and a clusterizer.
*       Feature sampler produces samples at given set of coordinates.
*       Clusterizer then produces clusters of these samples using k-means algorithm.
*       Resulting set of clusters is the signature of the input image.
*
*       A signature is an array of SIGNATURE_DIMENSION-dimensional points.
*       Used dimensions are:
*       weight, x, y position; lab color, contrast, entropy.
* \cite KrulisLS16
* \cite BeecksUS10
*/
@Namespace("cv::xfeatures2d") public static class PCTSignatures extends Algorithm {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public PCTSignatures(Pointer p) { super(p); }

    /**
    * \brief Lp distance function selector.
    */
    /** enum cv::xfeatures2d::PCTSignatures::DistanceFunction */
    public static final int
        L0_25 = 0, L0_5 = 1, L1 = 2, L2 = 3, L2SQUARED = 4, L5 = 5, L_INFINITY = 6;

    /**
    * \brief Point distributions supported by random point generator.
    */
    /** enum cv::xfeatures2d::PCTSignatures::PointDistribution */
    public static final int
        /** Generate numbers uniformly. */
        UNIFORM = 0,
        /** Generate points in a regular grid. */
        REGULAR = 1,
        /** Generate points with normal (gaussian) distribution. */
        NORMAL = 2;

    /**
    * \brief Similarity function selector.
    * @see
    *       Christian Beecks, Merih Seran Uysal, Thomas Seidl.
    *       Signature quadratic form distance.
    *       In Proceedings of the ACM International Conference on Image and Video Retrieval, pages 438-445.
    *       ACM, 2010.
    * \cite BeecksUS10
    * \note For selected distance function: \f[ d(c_i, c_j) \f]  and parameter: \f[ \alpha \f]
    */
    /** enum cv::xfeatures2d::PCTSignatures::SimilarityFunction */
    public static final int
        /** \f[ -d(c_i, c_j) \f] */
        MINUS = 0,
        /** \f[ e^{ -\alpha * d^2(c_i, c_j)} \f] */
        GAUSSIAN = 1,
        /** \f[ \frac{1}{\alpha + d(c_i, c_j)} \f] */
        HEURISTIC = 2;


    /**
    * \brief Creates PCTSignatures algorithm using sample and seed count.
    *       It generates its own sets of sampling points and clusterization seed indexes.
    * @param initSampleCount Number of points used for image sampling.
    * @param initSeedCount Number of initial clusterization seeds.
    *       Must be lower or equal to initSampleCount
    * @param pointDistribution Distribution of generated points. Default: UNIFORM.
    *       Available: UNIFORM, REGULAR, NORMAL.
    * @return Created algorithm.
    */
    public static native @Ptr PCTSignatures create(
            int initSampleCount/*=2000*/,
            int initSeedCount/*=400*/,
            int pointDistribution/*=0*/);
    public static native @Ptr PCTSignatures create();

    /**
    * \brief Creates PCTSignatures algorithm using pre-generated sampling points
    *       and number of clusterization seeds. It uses the provided
    *       sampling points and generates its own clusterization seed indexes.
    * @param initSamplingPoints Sampling points used in image sampling.
    * @param initSeedCount Number of initial clusterization seeds.
    *       Must be lower or equal to initSamplingPoints.size().
    * @return Created algorithm.
    */
    public static native @Ptr PCTSignatures create(
            @Const @ByRef Point2fVector initSamplingPoints,
            int initSeedCount);

    /**
    * \brief Creates PCTSignatures algorithm using pre-generated sampling points
    *       and clusterization seeds indexes.
    * @param initSamplingPoints Sampling points used in image sampling.
    * @param initClusterSeedIndexes Indexes of initial clusterization seeds.
    *       Its size must be lower or equal to initSamplingPoints.size().
    * @return Created algorithm.
    */
    public static native @Ptr PCTSignatures create(
            @Const @ByRef Point2fVector initSamplingPoints,
            @StdVector IntPointer initClusterSeedIndexes);
    public static native @Ptr PCTSignatures create(
            @Const @ByRef Point2fVector initSamplingPoints,
            @StdVector IntBuffer initClusterSeedIndexes);
    public static native @Ptr PCTSignatures create(
            @Const @ByRef Point2fVector initSamplingPoints,
            @StdVector int[] initClusterSeedIndexes);



    /**
    * \brief Computes signature of given image.
    * @param image Input image of CV_8U type.
    * @param signature Output computed signature.
    */
    public native void computeSignature(
            @ByVal Mat image,
            @ByVal Mat signature);
    public native void computeSignature(
            @ByVal UMat image,
            @ByVal UMat signature);
    public native void computeSignature(
            @ByVal GpuMat image,
            @ByVal GpuMat signature);

    /**
    * \brief Computes signatures for multiple images in parallel.
    * @param images Vector of input images of CV_8U type.
    * @param signatures Vector of computed signatures.
    */
    public native void computeSignatures(
            @Const @ByRef MatVector images,
            @ByRef MatVector signatures);

    /**
    * \brief Draws signature in the source image and outputs the result.
    *       Signatures are visualized as a circle
    *       with radius based on signature weight
    *       and color based on signature color.
    *       Contrast and entropy are not visualized.
    * @param source Source image.
    * @param signature Image signature.
    * @param result Output result.
    * @param radiusToShorterSideRatio Determines maximal radius of signature in the output image.
    * @param borderThickness Border thickness of the visualized signature.
    */
    public static native void drawSignature(
            @ByVal Mat source,
            @ByVal Mat signature,
            @ByVal Mat result,
            float radiusToShorterSideRatio/*=1.0 / 8*/,
            int borderThickness/*=1*/);
    public static native void drawSignature(
            @ByVal Mat source,
            @ByVal Mat signature,
            @ByVal Mat result);
    public static native void drawSignature(
            @ByVal UMat source,
            @ByVal UMat signature,
            @ByVal UMat result,
            float radiusToShorterSideRatio/*=1.0 / 8*/,
            int borderThickness/*=1*/);
    public static native void drawSignature(
            @ByVal UMat source,
            @ByVal UMat signature,
            @ByVal UMat result);
    public static native void drawSignature(
            @ByVal GpuMat source,
            @ByVal GpuMat signature,
            @ByVal GpuMat result,
            float radiusToShorterSideRatio/*=1.0 / 8*/,
            int borderThickness/*=1*/);
    public static native void drawSignature(
            @ByVal GpuMat source,
            @ByVal GpuMat signature,
            @ByVal GpuMat result);

    /**
    * \brief Generates initial sampling points according to selected point distribution.
    * @param initPoints Output vector where the generated points will be saved.
    * @param count Number of points to generate.
    * @param pointDistribution Point distribution selector.
    *       Available: UNIFORM, REGULAR, NORMAL.
    * \note Generated coordinates are in range [0..1)
    */
    public static native void generateInitPoints(
            @ByRef Point2fVector initPoints,
            int count,
            int pointDistribution);


    /**** sampler ****/

    /**
    * \brief Number of initial samples taken from the image.
    */
    public native int getSampleCount();

    /**
    * \brief Color resolution of the greyscale bitmap represented in allocated bits
    *       (i.e., value 4 means that 16 shades of grey are used).
    *       The greyscale bitmap is used for computing contrast and entropy values.
    */
    public native int getGrayscaleBits();
    /**
    * \brief Color resolution of the greyscale bitmap represented in allocated bits
    *       (i.e., value 4 means that 16 shades of grey are used).
    *       The greyscale bitmap is used for computing contrast and entropy values.
    */
    public native void setGrayscaleBits(int grayscaleBits);

    /**
    * \brief Size of the texture sampling window used to compute contrast and entropy
    *       (center of the window is always in the pixel selected by x,y coordinates
    *       of the corresponding feature sample).
    */
    public native int getWindowRadius();
    /**
    * \brief Size of the texture sampling window used to compute contrast and entropy
    *       (center of the window is always in the pixel selected by x,y coordinates
    *       of the corresponding feature sample).
    */
    public native void setWindowRadius(int radius);


    /**
    * \brief Weights (multiplicative constants) that linearly stretch individual axes of the feature space
    *       (x,y = position; L,a,b = color in CIE Lab space; c = contrast. e = entropy)
    */
    public native float getWeightX();
    /**
    * \brief Weights (multiplicative constants) that linearly stretch individual axes of the feature space
    *       (x,y = position; L,a,b = color in CIE Lab space; c = contrast. e = entropy)
    */
    public native void setWeightX(float weight);

    /**
    * \brief Weights (multiplicative constants) that linearly stretch individual axes of the feature space
    *       (x,y = position; L,a,b = color in CIE Lab space; c = contrast. e = entropy)
    */
    public native float getWeightY();
    /**
    * \brief Weights (multiplicative constants) that linearly stretch individual axes of the feature space
    *       (x,y = position; L,a,b = color in CIE Lab space; c = contrast. e = entropy)
    */
    public native void setWeightY(float weight);

    /**
    * \brief Weights (multiplicative constants) that linearly stretch individual axes of the feature space
    *       (x,y = position; L,a,b = color in CIE Lab space; c = contrast. e = entropy)
    */
    public native float getWeightL();
    /**
    * \brief Weights (multiplicative constants) that linearly stretch individual axes of the feature space
    *       (x,y = position; L,a,b = color in CIE Lab space; c = contrast. e = entropy)
    */
    public native void setWeightL(float weight);

    /**
    * \brief Weights (multiplicative constants) that linearly stretch individual axes of the feature space
    *       (x,y = position; L,a,b = color in CIE Lab space; c = contrast. e = entropy)
    */
    public native float getWeightA();
    /**
    * \brief Weights (multiplicative constants) that linearly stretch individual axes of the feature space
    *       (x,y = position; L,a,b = color in CIE Lab space; c = contrast. e = entropy)
    */
    public native void setWeightA(float weight);

    /**
    * \brief Weights (multiplicative constants) that linearly stretch individual axes of the feature space
    *       (x,y = position; L,a,b = color in CIE Lab space; c = contrast. e = entropy)
    */
    public native float getWeightB();
    /**
    * \brief Weights (multiplicative constants) that linearly stretch individual axes of the feature space
    *       (x,y = position; L,a,b = color in CIE Lab space; c = contrast. e = entropy)
    */
    public native void setWeightB(float weight);

    /**
    * \brief Weights (multiplicative constants) that linearly stretch individual axes of the feature space
    *       (x,y = position; L,a,b = color in CIE Lab space; c = contrast. e = entropy)
    */
    public native float getWeightContrast();
    /**
    * \brief Weights (multiplicative constants) that linearly stretch individual axes of the feature space
    *       (x,y = position; L,a,b = color in CIE Lab space; c = contrast. e = entropy)
    */
    public native void setWeightContrast(float weight);

    /**
    * \brief Weights (multiplicative constants) that linearly stretch individual axes of the feature space
    *       (x,y = position; L,a,b = color in CIE Lab space; c = contrast. e = entropy)
    */
    public native float getWeightEntropy();
    /**
    * \brief Weights (multiplicative constants) that linearly stretch individual axes of the feature space
    *       (x,y = position; L,a,b = color in CIE Lab space; c = contrast. e = entropy)
    */
    public native void setWeightEntropy(float weight);

    /**
    * \brief Initial samples taken from the image.
    *       These sampled features become the input for clustering.
    */
    public native @ByVal Point2fVector getSamplingPoints();



    /**
    * \brief Weights (multiplicative constants) that linearly stretch individual axes of the feature space.
    * @param idx ID of the weight
    * @param value Value of the weight
    * \note
    *       WEIGHT_IDX = 0;
    *       X_IDX = 1;
    *       Y_IDX = 2;
    *       L_IDX = 3;
    *       A_IDX = 4;
    *       B_IDX = 5;
    *       CONTRAST_IDX = 6;
    *       ENTROPY_IDX = 7;
    */
    public native void setWeight(int idx, float value);
    /**
    * \brief Weights (multiplicative constants) that linearly stretch individual axes of the feature space.
    * @param weights Values of all weights.
    * \note
    *       WEIGHT_IDX = 0;
    *       X_IDX = 1;
    *       Y_IDX = 2;
    *       L_IDX = 3;
    *       A_IDX = 4;
    *       B_IDX = 5;
    *       CONTRAST_IDX = 6;
    *       ENTROPY_IDX = 7;
    */
    public native void setWeights(@StdVector FloatPointer weights);
    public native void setWeights(@StdVector FloatBuffer weights);
    public native void setWeights(@StdVector float[] weights);

    /**
    * \brief Translations of the individual axes of the feature space.
    * @param idx ID of the translation
    * @param value Value of the translation
    * \note
    *       WEIGHT_IDX = 0;
    *       X_IDX = 1;
    *       Y_IDX = 2;
    *       L_IDX = 3;
    *       A_IDX = 4;
    *       B_IDX = 5;
    *       CONTRAST_IDX = 6;
    *       ENTROPY_IDX = 7;
    */
    public native void setTranslation(int idx, float value);
    /**
    * \brief Translations of the individual axes of the feature space.
    * @param translations Values of all translations.
    * \note
    *       WEIGHT_IDX = 0;
    *       X_IDX = 1;
    *       Y_IDX = 2;
    *       L_IDX = 3;
    *       A_IDX = 4;
    *       B_IDX = 5;
    *       CONTRAST_IDX = 6;
    *       ENTROPY_IDX = 7;
    */
    public native void setTranslations(@StdVector FloatPointer translations);
    public native void setTranslations(@StdVector FloatBuffer translations);
    public native void setTranslations(@StdVector float[] translations);

    /**
    * \brief Sets sampling points used to sample the input image.
    * @param samplingPoints Vector of sampling points in range [0..1)
    * \note Number of sampling points must be greater or equal to clusterization seed count.
    */
    public native void setSamplingPoints(@ByVal Point2fVector samplingPoints);



    /**** clusterizer ****/
    /**
    * \brief Initial seeds (initial number of clusters) for the k-means algorithm.
    */
    public native @StdVector IntPointer getInitSeedIndexes();
    /**
    * \brief Initial seed indexes for the k-means algorithm.
    */
    public native void setInitSeedIndexes(@StdVector IntPointer initSeedIndexes);
    public native void setInitSeedIndexes(@StdVector IntBuffer initSeedIndexes);
    public native void setInitSeedIndexes(@StdVector int[] initSeedIndexes);
    /**
    * \brief Number of initial seeds (initial number of clusters) for the k-means algorithm.
    */
    public native int getInitSeedCount();

    /**
    * \brief Number of iterations of the k-means clustering.
    *       We use fixed number of iterations, since the modified clustering is pruning clusters
    *       (not iteratively refining k clusters).
    */
    public native int getIterationCount();
    /**
    * \brief Number of iterations of the k-means clustering.
    *       We use fixed number of iterations, since the modified clustering is pruning clusters
    *       (not iteratively refining k clusters).
    */
    public native void setIterationCount(int iterationCount);

    /**
    * \brief Maximal number of generated clusters. If the number is exceeded,
    *       the clusters are sorted by their weights and the smallest clusters are cropped.
    */
    public native int getMaxClustersCount();
    /**
    * \brief Maximal number of generated clusters. If the number is exceeded,
    *       the clusters are sorted by their weights and the smallest clusters are cropped.
    */
    public native void setMaxClustersCount(int maxClustersCount);

    /**
    * \brief This parameter multiplied by the index of iteration gives lower limit for cluster size.
    *       Clusters containing fewer points than specified by the limit have their centroid dismissed
    *       and points are reassigned.
    */
    public native int getClusterMinSize();
    /**
    * \brief This parameter multiplied by the index of iteration gives lower limit for cluster size.
    *       Clusters containing fewer points than specified by the limit have their centroid dismissed
    *       and points are reassigned.
    */
    public native void setClusterMinSize(int clusterMinSize);

    /**
    * \brief Threshold euclidean distance between two centroids.
    *       If two cluster centers are closer than this distance,
    *       one of the centroid is dismissed and points are reassigned.
    */
    public native float getJoiningDistance();
    /**
    * \brief Threshold euclidean distance between two centroids.
    *       If two cluster centers are closer than this distance,
    *       one of the centroid is dismissed and points are reassigned.
    */
    public native void setJoiningDistance(float joiningDistance);

    /**
    * \brief Remove centroids in k-means whose weight is lesser or equal to given threshold.
    */
    public native float getDropThreshold();
    /**
    * \brief Remove centroids in k-means whose weight is lesser or equal to given threshold.
    */
    public native void setDropThreshold(float dropThreshold);

    /**
    * \brief Distance function selector used for measuring distance between two points in k-means.
    */
    public native int getDistanceFunction();
    /**
    * \brief Distance function selector used for measuring distance between two points in k-means.
    *       Available: L0_25, L0_5, L1, L2, L2SQUARED, L5, L_INFINITY.
    */
    public native void setDistanceFunction(int distanceFunction);

}

/**
* \brief Class implementing Signature Quadratic Form Distance (SQFD).
* @see Christian Beecks, Merih Seran Uysal, Thomas Seidl.
*   Signature quadratic form distance.
*   In Proceedings of the ACM International Conference on Image and Video Retrieval, pages 438-445.
*   ACM, 2010.
* \cite BeecksUS10
*/
@Namespace("cv::xfeatures2d") public static class PCTSignaturesSQFD extends Algorithm {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public PCTSignaturesSQFD(Pointer p) { super(p); }


    /**
    * \brief Creates the algorithm instance using selected distance function,
    *       similarity function and similarity function parameter.
    * @param distanceFunction Distance function selector. Default: L2
    *       Available: L0_25, L0_5, L1, L2, L2SQUARED, L5, L_INFINITY
    * @param similarityFunction Similarity function selector. Default: HEURISTIC
    *       Available: MINUS, GAUSSIAN, HEURISTIC
    * @param similarityParameter Parameter of the similarity function.
    */
    public static native @Ptr PCTSignaturesSQFD create(
            int distanceFunction/*=3*/,
            int similarityFunction/*=2*/,
            float similarityParameter/*=1.0f*/);
    public static native @Ptr PCTSignaturesSQFD create();

    /**
    * \brief Computes Signature Quadratic Form Distance of two signatures.
    * @param _signature0 The first signature.
    * @param _signature1 The second signature.
    */
    public native float computeQuadraticFormDistance(
            @ByVal Mat _signature0,
            @ByVal Mat _signature1);
    public native float computeQuadraticFormDistance(
            @ByVal UMat _signature0,
            @ByVal UMat _signature1);
    public native float computeQuadraticFormDistance(
            @ByVal GpuMat _signature0,
            @ByVal GpuMat _signature1);

    /**
    * \brief Computes Signature Quadratic Form Distance between the reference signature
    *       and each of the other image signatures.
    * @param sourceSignature The signature to measure distance of other signatures from.
    * @param imageSignatures Vector of signatures to measure distance from the source signature.
    * @param distances Output vector of measured distances.
    */
    public native void computeQuadraticFormDistances(
            @Const @ByRef Mat sourceSignature,
            @Const @ByRef MatVector imageSignatures,
            @StdVector FloatPointer distances);
    public native void computeQuadraticFormDistances(
            @Const @ByRef Mat sourceSignature,
            @Const @ByRef MatVector imageSignatures,
            @StdVector FloatBuffer distances);
    public native void computeQuadraticFormDistances(
            @Const @ByRef Mat sourceSignature,
            @Const @ByRef MatVector imageSignatures,
            @StdVector float[] distances);

}

/**
* \brief Elliptic region around an interest point.
*/
@Namespace("cv::xfeatures2d") @NoOffset public static class Elliptic_KeyPoint extends KeyPoint {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public Elliptic_KeyPoint(Pointer p) { super(p); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public Elliptic_KeyPoint(long size) { super((Pointer)null); allocateArray(size); }
    private native void allocateArray(long size);
    @Override public Elliptic_KeyPoint position(long position) {
        return (Elliptic_KeyPoint)super.position(position);
    }

    /** the lengths of the major and minor ellipse axes */
    public native @ByRef Size2f axes(); public native Elliptic_KeyPoint axes(Size2f axes);
    /** the integration scale at which the parameters were estimated */
    public native float si(); public native Elliptic_KeyPoint si(float si);
    /** the transformation between image space and local patch space */
    public native @ByRef @Cast("cv::Matx23f*") FloatPointer transf(); public native Elliptic_KeyPoint transf(FloatPointer transf);
    public Elliptic_KeyPoint() { super((Pointer)null); allocate(); }
    private native void allocate();
    public Elliptic_KeyPoint(@ByVal Point2f pt, float angle, @ByVal Size axes, float size, float si) { super((Pointer)null); allocate(pt, angle, axes, size, si); }
    private native void allocate(@ByVal Point2f pt, float angle, @ByVal Size axes, float size, float si);
}

/**
 * \brief Class implementing the Harris-Laplace feature detector as described in \cite Mikolajczyk2004.
 */
@Namespace("cv::xfeatures2d") public static class HarrisLaplaceFeatureDetector extends Feature2D {
    static { Loader.load(); }
    /** Default native constructor. */
    public HarrisLaplaceFeatureDetector() { super((Pointer)null); allocate(); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public HarrisLaplaceFeatureDetector(long size) { super((Pointer)null); allocateArray(size); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public HarrisLaplaceFeatureDetector(Pointer p) { super(p); }
    private native void allocate();
    private native void allocateArray(long size);
    @Override public HarrisLaplaceFeatureDetector position(long position) {
        return (HarrisLaplaceFeatureDetector)super.position(position);
    }

    /**
     * \brief Creates a new implementation instance.
     *
     * @param numOctaves the number of octaves in the scale-space pyramid
     * @param corn_thresh the threshold for the Harris cornerness measure
     * @param DOG_thresh the threshold for the Difference-of-Gaussians scale selection
     * @param maxCorners the maximum number of corners to consider
     * @param num_layers the number of intermediate scales per octave
     */
    public static native @Ptr HarrisLaplaceFeatureDetector create(
                int numOctaves/*=6*/,
                float corn_thresh/*=0.01f*/,
                float DOG_thresh/*=0.01f*/,
                int maxCorners/*=5000*/,
                int num_layers/*=4*/);
    public static native @Ptr HarrisLaplaceFeatureDetector create();
}

/**
 * \brief Class implementing affine adaptation for key points.
 *
 * A \ref FeatureDetector and a \ref DescriptorExtractor are wrapped to augment the
 * detected points with their affine invariant elliptic region and to compute
 * the feature descriptors on the regions after warping them into circles.
 *
 * The interface is equivalent to \ref Feature2D, adding operations for
 * \ref Elliptic_KeyPoint "Elliptic_KeyPoints" instead of \ref KeyPoint "KeyPoints".
 */
@Namespace("cv::xfeatures2d") public static class AffineFeature2D extends Feature2D {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public AffineFeature2D(Pointer p) { super(p); }

    /**
     * \brief Creates an instance wrapping the given keypoint detector and
     * descriptor extractor.
     */
    public static native @Ptr AffineFeature2D create(
            @Cast("cv::FeatureDetector*") @Ptr Feature2D keypoint_detector,
            @Cast("cv::DescriptorExtractor*") @Ptr Feature2D descriptor_extractor);

    /**
     * \brief Creates an instance where keypoint detector and descriptor
     * extractor are identical.
     */
    public static native @Ptr AffineFeature2D create(
            @Cast("cv::FeatureDetector*") @Ptr Feature2D keypoint_detector); // overload, don't hide
    /**
     * \brief Detects keypoints in the image using the wrapped detector and
     * performs affine adaptation to augment them with their elliptic regions.
     */
    public native void detect(
            @ByVal Mat image,
            @StdVector Elliptic_KeyPoint keypoints,
            @ByVal(nullValue = "cv::InputArray(cv::noArray())") Mat mask );
    public native void detect(
            @ByVal Mat image,
            @StdVector Elliptic_KeyPoint keypoints );
    public native void detect(
            @ByVal UMat image,
            @StdVector Elliptic_KeyPoint keypoints,
            @ByVal(nullValue = "cv::InputArray(cv::noArray())") UMat mask );
    public native void detect(
            @ByVal UMat image,
            @StdVector Elliptic_KeyPoint keypoints );
    public native void detect(
            @ByVal GpuMat image,
            @StdVector Elliptic_KeyPoint keypoints,
            @ByVal(nullValue = "cv::InputArray(cv::noArray())") GpuMat mask );
    public native void detect(
            @ByVal GpuMat image,
            @StdVector Elliptic_KeyPoint keypoints ); // overload, don't hide
    /**
     * \brief Detects keypoints and computes descriptors for their surrounding
     * regions, after warping them into circles.
     */
    public native void detectAndCompute(
            @ByVal Mat image,
            @ByVal Mat mask,
            @StdVector Elliptic_KeyPoint keypoints,
            @ByVal Mat descriptors,
            @Cast("bool") boolean useProvidedKeypoints/*=false*/ );
    public native void detectAndCompute(
            @ByVal Mat image,
            @ByVal Mat mask,
            @StdVector Elliptic_KeyPoint keypoints,
            @ByVal Mat descriptors );
    public native void detectAndCompute(
            @ByVal UMat image,
            @ByVal UMat mask,
            @StdVector Elliptic_KeyPoint keypoints,
            @ByVal UMat descriptors,
            @Cast("bool") boolean useProvidedKeypoints/*=false*/ );
    public native void detectAndCompute(
            @ByVal UMat image,
            @ByVal UMat mask,
            @StdVector Elliptic_KeyPoint keypoints,
            @ByVal UMat descriptors );
    public native void detectAndCompute(
            @ByVal GpuMat image,
            @ByVal GpuMat mask,
            @StdVector Elliptic_KeyPoint keypoints,
            @ByVal GpuMat descriptors,
            @Cast("bool") boolean useProvidedKeypoints/*=false*/ );
    public native void detectAndCompute(
            @ByVal GpuMat image,
            @ByVal GpuMat mask,
            @StdVector Elliptic_KeyPoint keypoints,
            @ByVal GpuMat descriptors );
}


/** \brief Estimates cornerness for prespecified KeyPoints using the FAST algorithm
<p>
@param image grayscale image where keypoints (corners) are detected.
@param keypoints keypoints which should be tested to fit the FAST criteria. Keypoints not beeing
detected as corners are removed.
@param threshold threshold on difference between intensity of the central pixel and pixels of a
circle around this pixel.
@param nonmaxSuppression if true, non-maximum suppression is applied to detected corners
(keypoints).
@param type one of the three neighborhoods as defined in the paper:
FastFeatureDetector::TYPE_9_16, FastFeatureDetector::TYPE_7_12,
FastFeatureDetector::TYPE_5_8
<p>
Detects corners using the FAST algorithm by \cite Rosten06 .
 */
@Namespace("cv::xfeatures2d") public static native void FASTForPointSet( @ByVal Mat image, @ByRef KeyPointVector keypoints,
                      int threshold, @Cast("bool") boolean nonmaxSuppression/*=true*/, @Cast("cv::FastFeatureDetector::DetectorType") int type/*=cv::FastFeatureDetector::TYPE_9_16*/);
@Namespace("cv::xfeatures2d") public static native void FASTForPointSet( @ByVal Mat image, @ByRef KeyPointVector keypoints,
                      int threshold);
@Namespace("cv::xfeatures2d") public static native void FASTForPointSet( @ByVal UMat image, @ByRef KeyPointVector keypoints,
                      int threshold, @Cast("bool") boolean nonmaxSuppression/*=true*/, @Cast("cv::FastFeatureDetector::DetectorType") int type/*=cv::FastFeatureDetector::TYPE_9_16*/);
@Namespace("cv::xfeatures2d") public static native void FASTForPointSet( @ByVal UMat image, @ByRef KeyPointVector keypoints,
                      int threshold);
@Namespace("cv::xfeatures2d") public static native void FASTForPointSet( @ByVal GpuMat image, @ByRef KeyPointVector keypoints,
                      int threshold, @Cast("bool") boolean nonmaxSuppression/*=true*/, @Cast("cv::FastFeatureDetector::DetectorType") int type/*=cv::FastFeatureDetector::TYPE_9_16*/);
@Namespace("cv::xfeatures2d") public static native void FASTForPointSet( @ByVal GpuMat image, @ByRef KeyPointVector keypoints,
                      int threshold);


/** \}
 <p>
 <p>
 *  \addtogroup xfeatures2d_match
 *  \{
<p>
/** \brief GMS  (Grid-based Motion Statistics) feature matching strategy by \cite Bian2017gms .
    @param size1 Input size of image1.
    @param size2 Input size of image2.
    @param keypoints1 Input keypoints of image1.
    @param keypoints2 Input keypoints of image2.
    @param matches1to2 Input 1-nearest neighbor matches.
    @param matchesGMS Matches returned by the GMS matching strategy.
    @param withRotation Take rotation transformation into account.
    @param withScale Take scale transformation into account.
    @param thresholdFactor The higher, the less matches.
    \note
        Since GMS works well when the number of features is large, we recommend to use the ORB feature and set FastThreshold to 0 to get as many as possible features quickly.
        If matching results are not satisfying, please add more features. (We use 10000 for images with 640 X 480).
        If your images have big rotation and scale changes, please set withRotation or withScale to true.
 */

@Namespace("cv::xfeatures2d") public static native void matchGMS( @Const @ByRef Size size1, @Const @ByRef Size size2, @Const @ByRef KeyPointVector keypoints1, @Const @ByRef KeyPointVector keypoints2,
                          @Const @ByRef DMatchVector matches1to2, @ByRef DMatchVector matchesGMS, @Cast("const bool") boolean withRotation/*=false*/,
                          @Cast("const bool") boolean withScale/*=false*/, double thresholdFactor/*=6.0*/ );
@Namespace("cv::xfeatures2d") public static native void matchGMS( @Const @ByRef Size size1, @Const @ByRef Size size2, @Const @ByRef KeyPointVector keypoints1, @Const @ByRef KeyPointVector keypoints2,
                          @Const @ByRef DMatchVector matches1to2, @ByRef DMatchVector matchesGMS );

/** \} */




// #endif


// Parsed from <opencv2/xfeatures2d/nonfree.hpp>

/*M///////////////////////////////////////////////////////////////////////////////////////
//
//  IMPORTANT: READ BEFORE DOWNLOADING, COPYING, INSTALLING OR USING.
//
//  By downloading, copying, installing or using the software you agree to this license.
//  If you do not agree to this license, do not download, install,
//  copy or use the software.
//
//
//                           License Agreement
//                For Open Source Computer Vision Library
//
// Copyright (C) 2000-2008, Intel Corporation, all rights reserved.
// Copyright (C) 2009, Willow Garage Inc., all rights reserved.
// Third party copyrights are property of their respective owners.
//
// Redistribution and use in source and binary forms, with or without modification,
// are permitted provided that the following conditions are met:
//
//   * Redistribution's of source code must retain the above copyright notice,
//     this list of conditions and the following disclaimer.
//
//   * Redistribution's in binary form must reproduce the above copyright notice,
//     this list of conditions and the following disclaimer in the documentation
//     and/or other materials provided with the distribution.
//
//   * The name of the copyright holders may not be used to endorse or promote products
//     derived from this software without specific prior written permission.
//
// This software is provided by the copyright holders and contributors "as is" and
// any express or implied warranties, including, but not limited to, the implied
// warranties of merchantability and fitness for a particular purpose are disclaimed.
// In no event shall the Intel Corporation or contributors be liable for any direct,
// indirect, incidental, special, exemplary, or consequential damages
// (including, but not limited to, procurement of substitute goods or services;
// loss of use, data, or profits; or business interruption) however caused
// and on any theory of liability, whether in contract, strict liability,
// or tort (including negligence or otherwise) arising in any way out of
// the use of this software, even if advised of the possibility of such damage.
//
//M*/

// #ifndef __OPENCV_XFEATURES2D_FEATURES_2D_HPP__
// #define __OPENCV_XFEATURES2D_FEATURES_2D_HPP__

// #include "opencv2/features2d.hpp"

/** \addtogroup xfeatures2d_nonfree
 *  \{
<p>
/** \brief Class for extracting keypoints and computing descriptors using the Scale Invariant Feature Transform
(SIFT) algorithm by D. Lowe \cite Lowe04 .
 */
@Namespace("cv::xfeatures2d") public static class SIFT extends Feature2D {
    static { Loader.load(); }
    /** Default native constructor. */
    public SIFT() { super((Pointer)null); allocate(); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public SIFT(long size) { super((Pointer)null); allocateArray(size); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public SIFT(Pointer p) { super(p); }
    private native void allocate();
    private native void allocateArray(long size);
    @Override public SIFT position(long position) {
        return (SIFT)super.position(position);
    }

    /**
    @param nfeatures The number of best features to retain. The features are ranked by their scores
    (measured in SIFT algorithm as the local contrast)
    <p>
    @param nOctaveLayers The number of layers in each octave. 3 is the value used in D. Lowe paper. The
    number of octaves is computed automatically from the image resolution.
    <p>
    @param contrastThreshold The contrast threshold used to filter out weak features in semi-uniform
    (low-contrast) regions. The larger the threshold, the less features are produced by the detector.
    <p>
    @param edgeThreshold The threshold used to filter out edge-like features. Note that the its meaning
    is different from the contrastThreshold, i.e. the larger the edgeThreshold, the less features are
    filtered out (more features are retained).
    <p>
    @param sigma The sigma of the Gaussian applied to the input image at the octave \#0. If your image
    is captured with a weak camera with soft lenses, you might want to reduce the number.
     */
    public static native @Ptr SIFT create( int nfeatures/*=0*/, int nOctaveLayers/*=3*/,
                                        double contrastThreshold/*=0.04*/, double edgeThreshold/*=10*/,
                                        double sigma/*=1.6*/);
    public static native @Ptr SIFT create();
}

/** \brief Class for extracting Speeded Up Robust Features from an image \cite Bay06 .
<p>
The algorithm parameters:
-   member int extended
    -   0 means that the basic descriptors (64 elements each) shall be computed
    -   1 means that the extended descriptors (128 elements each) shall be computed
-   member int upright
    -   0 means that detector computes orientation of each feature.
    -   1 means that the orientation is not computed (which is much, much faster). For example,
if you match images from a stereo pair, or do image stitching, the matched features
likely have very similar angles, and you can speed up feature extraction by setting
upright=1.
-   member double hessianThreshold
Threshold for the keypoint detector. Only features, whose hessian is larger than
hessianThreshold are retained by the detector. Therefore, the larger the value, the less
keypoints you will get. A good default value could be from 300 to 500, depending from the
image contrast.
-   member int nOctaves
The number of a gaussian pyramid octaves that the detector uses. It is set to 4 by default.
If you want to get very large features, use the larger value. If you want just small
features, decrease it.
-   member int nOctaveLayers
The number of images within each octave of a gaussian pyramid. It is set to 2 by default.
\note
   -   An example using the SURF feature detector can be found at
        opencv_source_code/samples/cpp/generic_descriptor_match.cpp
    -   Another example using the SURF feature detector, extractor and matcher can be found at
        opencv_source_code/samples/cpp/matcher_simple.cpp
 */
@Namespace("cv::xfeatures2d") public static class SURF extends Feature2D {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public SURF(Pointer p) { super(p); }

    /**
    @param hessianThreshold Threshold for hessian keypoint detector used in SURF.
    @param nOctaves Number of pyramid octaves the keypoint detector will use.
    @param nOctaveLayers Number of octave layers within each octave.
    @param extended Extended descriptor flag (true - use extended 128-element descriptors; false - use
    64-element descriptors).
    @param upright Up-right or rotated features flag (true - do not compute orientation of features;
    false - compute orientation).
     */
    public static native @Ptr SURF create(double hessianThreshold/*=100*/,
                      int nOctaves/*=4*/, int nOctaveLayers/*=3*/,
                      @Cast("bool") boolean extended/*=false*/, @Cast("bool") boolean upright/*=false*/);
    public static native @Ptr SURF create();

    public native void setHessianThreshold(double hessianThreshold);
    public native double getHessianThreshold();

    public native void setNOctaves(int nOctaves);
    public native int getNOctaves();

    public native void setNOctaveLayers(int nOctaveLayers);
    public native int getNOctaveLayers();

    public native void setExtended(@Cast("bool") boolean extended);
    public native @Cast("bool") boolean getExtended();

    public native void setUpright(@Cast("bool") boolean upright);
    public native @Cast("bool") boolean getUpright();
}

/** \} */


 /* namespace cv */

// #endif


}
