// Targeted by JavaCPP version 1.4.4: DO NOT EDIT THIS FILE

package org.bytedeco.javacpp;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.opencv_core.*;
import static org.bytedeco.javacpp.opencv_imgproc.*;
import static org.bytedeco.javacpp.opencv_imgcodecs.*;
import static org.bytedeco.javacpp.opencv_videoio.*;
import static org.bytedeco.javacpp.opencv_highgui.*;
import static org.bytedeco.javacpp.opencv_flann.*;
import static org.bytedeco.javacpp.opencv_features2d.*;
import static org.bytedeco.javacpp.opencv_calib3d.*;

public class opencv_video extends org.bytedeco.javacpp.helper.opencv_video {
    static { Loader.load(); }

// Parsed from <opencv2/video.hpp>

/*M///////////////////////////////////////////////////////////////////////////////////////
//
//  IMPORTANT: READ BEFORE DOWNLOADING, COPYING, INSTALLING OR USING.
//
//  By downloading, copying, installing or using the software you agree to this license.
//  If you do not agree to this license, do not download, install,
//  copy or use the software.
//
//
//                          License Agreement
//                For Open Source Computer Vision Library
//
// Copyright (C) 2000-2008, Intel Corporation, all rights reserved.
// Copyright (C) 2009, Willow Garage Inc., all rights reserved.
// Copyright (C) 2013, OpenCV Foundation, all rights reserved.
// Third party copyrights are property of their respective owners.
//
// Redistribution and use in source and binary forms, with or without modification,
// are permitted provided that the following conditions are met:
//
//   * Redistribution's of source code must retain the above copyright notice,
//     this list of conditions and the following disclaimer.
//
//   * Redistribution's in binary form must reproduce the above copyright notice,
//     this list of conditions and the following disclaimer in the documentation
//     and/or other materials provided with the distribution.
//
//   * The name of the copyright holders may not be used to endorse or promote products
//     derived from this software without specific prior written permission.
//
// This software is provided by the copyright holders and contributors "as is" and
// any express or implied warranties, including, but not limited to, the implied
// warranties of merchantability and fitness for a particular purpose are disclaimed.
// In no event shall the Intel Corporation or contributors be liable for any direct,
// indirect, incidental, special, exemplary, or consequential damages
// (including, but not limited to, procurement of substitute goods or services;
// loss of use, data, or profits; or business interruption) however caused
// and on any theory of liability, whether in contract, strict liability,
// or tort (including negligence or otherwise) arising in any way out of
// the use of this software, even if advised of the possibility of such damage.
//
//M*/

// #ifndef OPENCV_VIDEO_HPP
// #define OPENCV_VIDEO_HPP

/**
  \defgroup video Video Analysis
  \{
    \defgroup video_motion Motion Analysis
    \defgroup video_track Object Tracking
    \defgroup video_c C API
  \}
*/

// #include "opencv2/video/tracking.hpp"
// #include "opencv2/video/background_segm.hpp"

// #endif //OPENCV_VIDEO_HPP


// Parsed from <opencv2/video/tracking.hpp>

/*M///////////////////////////////////////////////////////////////////////////////////////
//
//  IMPORTANT: READ BEFORE DOWNLOADING, COPYING, INSTALLING OR USING.
//
//  By downloading, copying, installing or using the software you agree to this license.
//  If you do not agree to this license, do not download, install,
//  copy or use the software.
//
//
//                          License Agreement
//                For Open Source Computer Vision Library
//
// Copyright (C) 2000-2008, Intel Corporation, all rights reserved.
// Copyright (C) 2009, Willow Garage Inc., all rights reserved.
// Copyright (C) 2013, OpenCV Foundation, all rights reserved.
// Third party copyrights are property of their respective owners.
//
// Redistribution and use in source and binary forms, with or without modification,
// are permitted provided that the following conditions are met:
//
//   * Redistribution's of source code must retain the above copyright notice,
//     this list of conditions and the following disclaimer.
//
//   * Redistribution's in binary form must reproduce the above copyright notice,
//     this list of conditions and the following disclaimer in the documentation
//     and/or other materials provided with the distribution.
//
//   * The name of the copyright holders may not be used to endorse or promote products
//     derived from this software without specific prior written permission.
//
// This software is provided by the copyright holders and contributors "as is" and
// any express or implied warranties, including, but not limited to, the implied
// warranties of merchantability and fitness for a particular purpose are disclaimed.
// In no event shall the Intel Corporation or contributors be liable for any direct,
// indirect, incidental, special, exemplary, or consequential damages
// (including, but not limited to, procurement of substitute goods or services;
// loss of use, data, or profits; or business interruption) however caused
// and on any theory of liability, whether in contract, strict liability,
// or tort (including negligence or otherwise) arising in any way out of
// the use of this software, even if advised of the possibility of such damage.
//
//M*/

// #ifndef OPENCV_TRACKING_HPP
// #define OPENCV_TRACKING_HPP

// #include "opencv2/core.hpp"
// #include "opencv2/imgproc.hpp"

/** \addtogroup video_track
 *  \{ */

/** enum cv:: */
public static final int OPTFLOW_USE_INITIAL_FLOW     = 4,
       OPTFLOW_LK_GET_MIN_EIGENVALS = 8,
       OPTFLOW_FARNEBACK_GAUSSIAN   = 256;

/** \brief Finds an object center, size, and orientation.
<p>
@param probImage Back projection of the object histogram. See calcBackProject.
@param window Initial search window.
@param criteria Stop criteria for the underlying meanShift.
returns
(in old interfaces) Number of iterations CAMSHIFT took to converge
The function implements the CAMSHIFT object tracking algorithm \cite Bradski98 . First, it finds an
object center using meanShift and then adjusts the window size and finds the optimal rotation. The
function returns the rotated rectangle structure that includes the object position, size, and
orientation. The next position of the search window can be obtained with RotatedRect::boundingRect()
<p>
See the OpenCV sample camshiftdemo.c that tracks colored objects.
<p>
\note
-   (Python) A sample explaining the camshift tracking algorithm can be found at
    opencv_source_code/samples/python/camshift.py
 */
@Namespace("cv") public static native @ByVal RotatedRect CamShift( @ByVal Mat probImage, @ByRef Rect window,
                                   @ByVal TermCriteria criteria );
@Namespace("cv") public static native @ByVal RotatedRect CamShift( @ByVal UMat probImage, @ByRef Rect window,
                                   @ByVal TermCriteria criteria );
@Namespace("cv") public static native @ByVal RotatedRect CamShift( @ByVal GpuMat probImage, @ByRef Rect window,
                                   @ByVal TermCriteria criteria );
/** \example samples/cpp/camshiftdemo.cpp
An example using the mean-shift tracking algorithm
*/

/** \brief Finds an object on a back projection image.
<p>
@param probImage Back projection of the object histogram. See calcBackProject for details.
@param window Initial search window.
@param criteria Stop criteria for the iterative search algorithm.
returns
:   Number of iterations CAMSHIFT took to converge.
The function implements the iterative object search algorithm. It takes the input back projection of
an object and the initial position. The mass center in window of the back projection image is
computed and the search window center shifts to the mass center. The procedure is repeated until the
specified number of iterations criteria.maxCount is done or until the window center shifts by less
than criteria.epsilon. The algorithm is used inside CamShift and, unlike CamShift , the search
window size or orientation do not change during the search. You can simply pass the output of
calcBackProject to this function. But better results can be obtained if you pre-filter the back
projection and remove the noise. For example, you can do this by retrieving connected components
with findContours , throwing away contours with small area ( contourArea ), and rendering the
remaining contours with drawContours.
 <p>
 */
@Namespace("cv") public static native int meanShift( @ByVal Mat probImage, @ByRef Rect window, @ByVal TermCriteria criteria );
@Namespace("cv") public static native int meanShift( @ByVal UMat probImage, @ByRef Rect window, @ByVal TermCriteria criteria );
@Namespace("cv") public static native int meanShift( @ByVal GpuMat probImage, @ByRef Rect window, @ByVal TermCriteria criteria );

/** \brief Constructs the image pyramid which can be passed to calcOpticalFlowPyrLK.
<p>
@param img 8-bit input image.
@param pyramid output pyramid.
@param winSize window size of optical flow algorithm. Must be not less than winSize argument of
calcOpticalFlowPyrLK. It is needed to calculate required padding for pyramid levels.
@param maxLevel 0-based maximal pyramid level number.
@param withDerivatives set to precompute gradients for the every pyramid level. If pyramid is
constructed without the gradients then calcOpticalFlowPyrLK will calculate them internally.
@param pyrBorder the border mode for pyramid layers.
@param derivBorder the border mode for gradients.
@param tryReuseInputImage put ROI of input image into the pyramid if possible. You can pass false
to force data copying.
@return number of levels in constructed pyramid. Can be less than maxLevel.
 */
@Namespace("cv") public static native int buildOpticalFlowPyramid( @ByVal Mat img, @ByVal MatVector pyramid,
                                          @ByVal Size winSize, int maxLevel, @Cast("bool") boolean withDerivatives/*=true*/,
                                          int pyrBorder/*=cv::BORDER_REFLECT_101*/,
                                          int derivBorder/*=cv::BORDER_CONSTANT*/,
                                          @Cast("bool") boolean tryReuseInputImage/*=true*/ );
@Namespace("cv") public static native int buildOpticalFlowPyramid( @ByVal Mat img, @ByVal MatVector pyramid,
                                          @ByVal Size winSize, int maxLevel );
@Namespace("cv") public static native int buildOpticalFlowPyramid( @ByVal Mat img, @ByVal UMatVector pyramid,
                                          @ByVal Size winSize, int maxLevel, @Cast("bool") boolean withDerivatives/*=true*/,
                                          int pyrBorder/*=cv::BORDER_REFLECT_101*/,
                                          int derivBorder/*=cv::BORDER_CONSTANT*/,
                                          @Cast("bool") boolean tryReuseInputImage/*=true*/ );
@Namespace("cv") public static native int buildOpticalFlowPyramid( @ByVal Mat img, @ByVal UMatVector pyramid,
                                          @ByVal Size winSize, int maxLevel );
@Namespace("cv") public static native int buildOpticalFlowPyramid( @ByVal Mat img, @ByVal GpuMatVector pyramid,
                                          @ByVal Size winSize, int maxLevel, @Cast("bool") boolean withDerivatives/*=true*/,
                                          int pyrBorder/*=cv::BORDER_REFLECT_101*/,
                                          int derivBorder/*=cv::BORDER_CONSTANT*/,
                                          @Cast("bool") boolean tryReuseInputImage/*=true*/ );
@Namespace("cv") public static native int buildOpticalFlowPyramid( @ByVal Mat img, @ByVal GpuMatVector pyramid,
                                          @ByVal Size winSize, int maxLevel );
@Namespace("cv") public static native int buildOpticalFlowPyramid( @ByVal UMat img, @ByVal MatVector pyramid,
                                          @ByVal Size winSize, int maxLevel, @Cast("bool") boolean withDerivatives/*=true*/,
                                          int pyrBorder/*=cv::BORDER_REFLECT_101*/,
                                          int derivBorder/*=cv::BORDER_CONSTANT*/,
                                          @Cast("bool") boolean tryReuseInputImage/*=true*/ );
@Namespace("cv") public static native int buildOpticalFlowPyramid( @ByVal UMat img, @ByVal MatVector pyramid,
                                          @ByVal Size winSize, int maxLevel );
@Namespace("cv") public static native int buildOpticalFlowPyramid( @ByVal UMat img, @ByVal UMatVector pyramid,
                                          @ByVal Size winSize, int maxLevel, @Cast("bool") boolean withDerivatives/*=true*/,
                                          int pyrBorder/*=cv::BORDER_REFLECT_101*/,
                                          int derivBorder/*=cv::BORDER_CONSTANT*/,
                                          @Cast("bool") boolean tryReuseInputImage/*=true*/ );
@Namespace("cv") public static native int buildOpticalFlowPyramid( @ByVal UMat img, @ByVal UMatVector pyramid,
                                          @ByVal Size winSize, int maxLevel );
@Namespace("cv") public static native int buildOpticalFlowPyramid( @ByVal UMat img, @ByVal GpuMatVector pyramid,
                                          @ByVal Size winSize, int maxLevel, @Cast("bool") boolean withDerivatives/*=true*/,
                                          int pyrBorder/*=cv::BORDER_REFLECT_101*/,
                                          int derivBorder/*=cv::BORDER_CONSTANT*/,
                                          @Cast("bool") boolean tryReuseInputImage/*=true*/ );
@Namespace("cv") public static native int buildOpticalFlowPyramid( @ByVal UMat img, @ByVal GpuMatVector pyramid,
                                          @ByVal Size winSize, int maxLevel );
@Namespace("cv") public static native int buildOpticalFlowPyramid( @ByVal GpuMat img, @ByVal MatVector pyramid,
                                          @ByVal Size winSize, int maxLevel, @Cast("bool") boolean withDerivatives/*=true*/,
                                          int pyrBorder/*=cv::BORDER_REFLECT_101*/,
                                          int derivBorder/*=cv::BORDER_CONSTANT*/,
                                          @Cast("bool") boolean tryReuseInputImage/*=true*/ );
@Namespace("cv") public static native int buildOpticalFlowPyramid( @ByVal GpuMat img, @ByVal MatVector pyramid,
                                          @ByVal Size winSize, int maxLevel );
@Namespace("cv") public static native int buildOpticalFlowPyramid( @ByVal GpuMat img, @ByVal UMatVector pyramid,
                                          @ByVal Size winSize, int maxLevel, @Cast("bool") boolean withDerivatives/*=true*/,
                                          int pyrBorder/*=cv::BORDER_REFLECT_101*/,
                                          int derivBorder/*=cv::BORDER_CONSTANT*/,
                                          @Cast("bool") boolean tryReuseInputImage/*=true*/ );
@Namespace("cv") public static native int buildOpticalFlowPyramid( @ByVal GpuMat img, @ByVal UMatVector pyramid,
                                          @ByVal Size winSize, int maxLevel );
@Namespace("cv") public static native int buildOpticalFlowPyramid( @ByVal GpuMat img, @ByVal GpuMatVector pyramid,
                                          @ByVal Size winSize, int maxLevel, @Cast("bool") boolean withDerivatives/*=true*/,
                                          int pyrBorder/*=cv::BORDER_REFLECT_101*/,
                                          int derivBorder/*=cv::BORDER_CONSTANT*/,
                                          @Cast("bool") boolean tryReuseInputImage/*=true*/ );
@Namespace("cv") public static native int buildOpticalFlowPyramid( @ByVal GpuMat img, @ByVal GpuMatVector pyramid,
                                          @ByVal Size winSize, int maxLevel );

/** \example samples/cpp/lkdemo.cpp
An example using the Lucas-Kanade optical flow algorithm
*/

/** \brief Calculates an optical flow for a sparse feature set using the iterative Lucas-Kanade method with
pyramids.
<p>
@param prevImg first 8-bit input image or pyramid constructed by buildOpticalFlowPyramid.
@param nextImg second input image or pyramid of the same size and the same type as prevImg.
@param prevPts vector of 2D points for which the flow needs to be found; point coordinates must be
single-precision floating-point numbers.
@param nextPts output vector of 2D points (with single-precision floating-point coordinates)
containing the calculated new positions of input features in the second image; when
OPTFLOW_USE_INITIAL_FLOW flag is passed, the vector must have the same size as in the input.
@param status output status vector (of unsigned chars); each element of the vector is set to 1 if
the flow for the corresponding features has been found, otherwise, it is set to 0.
@param err output vector of errors; each element of the vector is set to an error for the
corresponding feature, type of the error measure can be set in flags parameter; if the flow wasn't
found then the error is not defined (use the status parameter to find such cases).
@param winSize size of the search window at each pyramid level.
@param maxLevel 0-based maximal pyramid level number; if set to 0, pyramids are not used (single
level), if set to 1, two levels are used, and so on; if pyramids are passed to input then
algorithm will use as many levels as pyramids have but no more than maxLevel.
@param criteria parameter, specifying the termination criteria of the iterative search algorithm
(after the specified maximum number of iterations criteria.maxCount or when the search window
moves by less than criteria.epsilon.
@param flags operation flags:
 -   **OPTFLOW_USE_INITIAL_FLOW** uses initial estimations, stored in nextPts; if the flag is
     not set, then prevPts is copied to nextPts and is considered the initial estimate.
 -   **OPTFLOW_LK_GET_MIN_EIGENVALS** use minimum eigen values as an error measure (see
     minEigThreshold description); if the flag is not set, then L1 distance between patches
     around the original and a moved point, divided by number of pixels in a window, is used as a
     error measure.
@param minEigThreshold the algorithm calculates the minimum eigen value of a 2x2 normal matrix of
optical flow equations (this matrix is called a spatial gradient matrix in \cite Bouguet00), divided
by number of pixels in a window; if this value is less than minEigThreshold, then a corresponding
feature is filtered out and its flow is not processed, so it allows to remove bad points and get a
performance boost.
<p>
The function implements a sparse iterative version of the Lucas-Kanade optical flow in pyramids. See
\cite Bouguet00 . The function is parallelized with the TBB library.
<p>
\note
<p>
-   An example using the Lucas-Kanade optical flow algorithm can be found at
    opencv_source_code/samples/cpp/lkdemo.cpp
-   (Python) An example using the Lucas-Kanade optical flow algorithm can be found at
    opencv_source_code/samples/python/lk_track.py
-   (Python) An example using the Lucas-Kanade tracker for homography matching can be found at
    opencv_source_code/samples/python/lk_homography.py
 */
@Namespace("cv") public static native void calcOpticalFlowPyrLK( @ByVal Mat prevImg, @ByVal Mat nextImg,
                                        @ByVal Mat prevPts, @ByVal Mat nextPts,
                                        @ByVal Mat status, @ByVal Mat err,
                                        @ByVal(nullValue = "cv::Size(21,21)") Size winSize, int maxLevel/*=3*/,
                                        @ByVal(nullValue = "cv::TermCriteria(cv::TermCriteria::COUNT+cv::TermCriteria::EPS, 30, 0.01)") TermCriteria criteria,
                                        int flags/*=0*/, double minEigThreshold/*=1e-4*/ );
@Namespace("cv") public static native void calcOpticalFlowPyrLK( @ByVal Mat prevImg, @ByVal Mat nextImg,
                                        @ByVal Mat prevPts, @ByVal Mat nextPts,
                                        @ByVal Mat status, @ByVal Mat err );
@Namespace("cv") public static native void calcOpticalFlowPyrLK( @ByVal UMat prevImg, @ByVal UMat nextImg,
                                        @ByVal UMat prevPts, @ByVal UMat nextPts,
                                        @ByVal UMat status, @ByVal UMat err,
                                        @ByVal(nullValue = "cv::Size(21,21)") Size winSize, int maxLevel/*=3*/,
                                        @ByVal(nullValue = "cv::TermCriteria(cv::TermCriteria::COUNT+cv::TermCriteria::EPS, 30, 0.01)") TermCriteria criteria,
                                        int flags/*=0*/, double minEigThreshold/*=1e-4*/ );
@Namespace("cv") public static native void calcOpticalFlowPyrLK( @ByVal UMat prevImg, @ByVal UMat nextImg,
                                        @ByVal UMat prevPts, @ByVal UMat nextPts,
                                        @ByVal UMat status, @ByVal UMat err );
@Namespace("cv") public static native void calcOpticalFlowPyrLK( @ByVal GpuMat prevImg, @ByVal GpuMat nextImg,
                                        @ByVal GpuMat prevPts, @ByVal GpuMat nextPts,
                                        @ByVal GpuMat status, @ByVal GpuMat err,
                                        @ByVal(nullValue = "cv::Size(21,21)") Size winSize, int maxLevel/*=3*/,
                                        @ByVal(nullValue = "cv::TermCriteria(cv::TermCriteria::COUNT+cv::TermCriteria::EPS, 30, 0.01)") TermCriteria criteria,
                                        int flags/*=0*/, double minEigThreshold/*=1e-4*/ );
@Namespace("cv") public static native void calcOpticalFlowPyrLK( @ByVal GpuMat prevImg, @ByVal GpuMat nextImg,
                                        @ByVal GpuMat prevPts, @ByVal GpuMat nextPts,
                                        @ByVal GpuMat status, @ByVal GpuMat err );

/** \brief Computes a dense optical flow using the Gunnar Farneback's algorithm.
<p>
@param prev first 8-bit single-channel input image.
@param next second input image of the same size and the same type as prev.
@param flow computed flow image that has the same size as prev and type CV_32FC2.
@param pyr_scale parameter, specifying the image scale (\<1) to build pyramids for each image;
pyr_scale=0.5 means a classical pyramid, where each next layer is twice smaller than the previous
one.
@param levels number of pyramid layers including the initial image; levels=1 means that no extra
layers are created and only the original images are used.
@param winsize averaging window size; larger values increase the algorithm robustness to image
noise and give more chances for fast motion detection, but yield more blurred motion field.
@param iterations number of iterations the algorithm does at each pyramid level.
@param poly_n size of the pixel neighborhood used to find polynomial expansion in each pixel;
larger values mean that the image will be approximated with smoother surfaces, yielding more
robust algorithm and more blurred motion field, typically poly_n =5 or 7.
@param poly_sigma standard deviation of the Gaussian that is used to smooth derivatives used as a
basis for the polynomial expansion; for poly_n=5, you can set poly_sigma=1.1, for poly_n=7, a
good value would be poly_sigma=1.5.
@param flags operation flags that can be a combination of the following:
 -   **OPTFLOW_USE_INITIAL_FLOW** uses the input flow as an initial flow approximation.
 -   **OPTFLOW_FARNEBACK_GAUSSIAN** uses the Gaussian \f$\texttt{winsize}\times\texttt{winsize}\f$
     filter instead of a box filter of the same size for optical flow estimation; usually, this
     option gives z more accurate flow than with a box filter, at the cost of lower speed;
     normally, winsize for a Gaussian window should be set to a larger value to achieve the same
     level of robustness.
<p>
The function finds an optical flow for each prev pixel using the \cite Farneback2003 algorithm so that
<p>
\f[\texttt{prev} (y,x)  \sim \texttt{next} ( y + \texttt{flow} (y,x)[1],  x + \texttt{flow} (y,x)[0])\f]
<p>
\note
<p>
-   An example using the optical flow algorithm described by Gunnar Farneback can be found at
    opencv_source_code/samples/cpp/fback.cpp
-   (Python) An example using the optical flow algorithm described by Gunnar Farneback can be
    found at opencv_source_code/samples/python/opt_flow.py
 */
@Namespace("cv") public static native void calcOpticalFlowFarneback( @ByVal Mat prev, @ByVal Mat next, @ByVal Mat flow,
                                            double pyr_scale, int levels, int winsize,
                                            int iterations, int poly_n, double poly_sigma,
                                            int flags );
@Namespace("cv") public static native void calcOpticalFlowFarneback( @ByVal UMat prev, @ByVal UMat next, @ByVal UMat flow,
                                            double pyr_scale, int levels, int winsize,
                                            int iterations, int poly_n, double poly_sigma,
                                            int flags );
@Namespace("cv") public static native void calcOpticalFlowFarneback( @ByVal GpuMat prev, @ByVal GpuMat next, @ByVal GpuMat flow,
                                            double pyr_scale, int levels, int winsize,
                                            int iterations, int poly_n, double poly_sigma,
                                            int flags );

/** \brief Computes an optimal affine transformation between two 2D point sets.
<p>
@param src First input 2D point set stored in std::vector or Mat, or an image stored in Mat.
@param dst Second input 2D point set of the same size and the same type as A, or another image.
@param fullAffine If true, the function finds an optimal affine transformation with no additional
restrictions (6 degrees of freedom). Otherwise, the class of transformations to choose from is
limited to combinations of translation, rotation, and uniform scaling (4 degrees of freedom).
<p>
The function finds an optimal affine transform *[A|b]* (a 2 x 3 floating-point matrix) that
approximates best the affine transformation between:
<p>
*   Two point sets
*   Two raster images. In this case, the function first finds some features in the src image and
    finds the corresponding features in dst image. After that, the problem is reduced to the first
    case.
In case of point sets, the problem is formulated as follows: you need to find a 2x2 matrix *A* and
2x1 vector *b* so that:
<p>
\f[[A^*|b^*] = arg  \min _{[A|b]}  \sum _i  \| \texttt{dst}[i] - A { \texttt{src}[i]}^T - b  \| ^2\f]
where src[i] and dst[i] are the i-th points in src and dst, respectively
\f$[A|b]\f$ can be either arbitrary (when fullAffine=true ) or have a form of
\f[\begin{bmatrix} a_{11} & a_{12} & b_1  \\ -a_{12} & a_{11} & b_2  \end{bmatrix}\f]
when fullAffine=false.
<p>
@deprecated Use cv::estimateAffine2D, cv::estimateAffinePartial2D instead. If you are using this fuction
with images, extract points using cv::calcOpticalFlowPyrLK and then use the estimation fuctions.
<p>
\sa
estimateAffine2D, estimateAffinePartial2D, getAffineTransform, getPerspectiveTransform, findHomography
 */
@Namespace("cv") public static native @Deprecated @ByVal Mat estimateRigidTransform( @ByVal Mat src, @ByVal Mat dst, @Cast("bool") boolean fullAffine );
@Namespace("cv") public static native @Deprecated @ByVal Mat estimateRigidTransform( @ByVal UMat src, @ByVal UMat dst, @Cast("bool") boolean fullAffine );
@Namespace("cv") public static native @Deprecated @ByVal Mat estimateRigidTransform( @ByVal GpuMat src, @ByVal GpuMat dst, @Cast("bool") boolean fullAffine );

/** enum cv:: */
public static final int
    MOTION_TRANSLATION = 0,
    MOTION_EUCLIDEAN   = 1,
    MOTION_AFFINE      = 2,
    MOTION_HOMOGRAPHY  = 3;

/** \example samples/cpp/image_alignment.cpp
An example using the image alignment ECC algorithm
*/

/** \brief Finds the geometric transform (warp) between two images in terms of the ECC criterion \cite EP08 .
<p>
@param templateImage single-channel template image; CV_8U or CV_32F array.
@param inputImage single-channel input image which should be warped with the final warpMatrix in
order to provide an image similar to templateImage, same type as temlateImage.
@param warpMatrix floating-point \f$2\times 3\f$ or \f$3\times 3\f$ mapping matrix (warp).
@param motionType parameter, specifying the type of motion:
 -   **MOTION_TRANSLATION** sets a translational motion model; warpMatrix is \f$2\times 3\f$ with
     the first \f$2\times 2\f$ part being the unity matrix and the rest two parameters being
     estimated.
 -   **MOTION_EUCLIDEAN** sets a Euclidean (rigid) transformation as motion model; three
     parameters are estimated; warpMatrix is \f$2\times 3\f$.
 -   **MOTION_AFFINE** sets an affine motion model (DEFAULT); six parameters are estimated;
     warpMatrix is \f$2\times 3\f$.
 -   **MOTION_HOMOGRAPHY** sets a homography as a motion model; eight parameters are
     estimated;\{@code warpMatrix\} is \f$3\times 3\f$.
@param criteria parameter, specifying the termination criteria of the ECC algorithm;
criteria.epsilon defines the threshold of the increment in the correlation coefficient between two
iterations (a negative criteria.epsilon makes criteria.maxcount the only termination criterion).
Default values are shown in the declaration above.
@param inputMask An optional mask to indicate valid values of inputImage.
<p>
The function estimates the optimum transformation (warpMatrix) with respect to ECC criterion
(\cite EP08), that is
<p>
\f[\texttt{warpMatrix} = \texttt{warpMatrix} = \arg\max_{W} \texttt{ECC}(\texttt{templateImage}(x,y),\texttt{inputImage}(x',y'))\f]
<p>
where
<p>
\f[\begin{bmatrix} x' \\ y' \end{bmatrix} = W \cdot \begin{bmatrix} x \\ y \\ 1 \end{bmatrix}\f]
<p>
(the equation holds with homogeneous coordinates for homography). It returns the final enhanced
correlation coefficient, that is the correlation coefficient between the template image and the
final warped input image. When a \f$3\times 3\f$ matrix is given with motionType =0, 1 or 2, the third
row is ignored.
<p>
Unlike findHomography and estimateRigidTransform, the function findTransformECC implements an
area-based alignment that builds on intensity similarities. In essence, the function updates the
initial transformation that roughly aligns the images. If this information is missing, the identity
warp (unity matrix) is used as an initialization. Note that if images undergo strong
displacements/rotations, an initial transformation that roughly aligns the images is necessary
(e.g., a simple euclidean/similarity transform that allows for the images showing the same image
content approximately). Use inverse warping in the second image to take an image close to the first
one, i.e. use the flag WARP_INVERSE_MAP with warpAffine or warpPerspective. See also the OpenCV
sample image_alignment.cpp that demonstrates the use of the function. Note that the function throws
an exception if algorithm does not converges.
<p>
\sa
estimateAffine2D, estimateAffinePartial2D, findHomography
 */
@Namespace("cv") public static native double findTransformECC( @ByVal Mat templateImage, @ByVal Mat inputImage,
                                      @ByVal Mat warpMatrix, int motionType/*=cv::MOTION_AFFINE*/,
                                      @ByVal(nullValue = "cv::TermCriteria(cv::TermCriteria::COUNT+cv::TermCriteria::EPS, 50, 0.001)") TermCriteria criteria,
                                      @ByVal(nullValue = "cv::InputArray(cv::noArray())") Mat inputMask);
@Namespace("cv") public static native double findTransformECC( @ByVal Mat templateImage, @ByVal Mat inputImage,
                                      @ByVal Mat warpMatrix);
@Namespace("cv") public static native double findTransformECC( @ByVal UMat templateImage, @ByVal UMat inputImage,
                                      @ByVal UMat warpMatrix, int motionType/*=cv::MOTION_AFFINE*/,
                                      @ByVal(nullValue = "cv::TermCriteria(cv::TermCriteria::COUNT+cv::TermCriteria::EPS, 50, 0.001)") TermCriteria criteria,
                                      @ByVal(nullValue = "cv::InputArray(cv::noArray())") UMat inputMask);
@Namespace("cv") public static native double findTransformECC( @ByVal UMat templateImage, @ByVal UMat inputImage,
                                      @ByVal UMat warpMatrix);
@Namespace("cv") public static native double findTransformECC( @ByVal GpuMat templateImage, @ByVal GpuMat inputImage,
                                      @ByVal GpuMat warpMatrix, int motionType/*=cv::MOTION_AFFINE*/,
                                      @ByVal(nullValue = "cv::TermCriteria(cv::TermCriteria::COUNT+cv::TermCriteria::EPS, 50, 0.001)") TermCriteria criteria,
                                      @ByVal(nullValue = "cv::InputArray(cv::noArray())") GpuMat inputMask);
@Namespace("cv") public static native double findTransformECC( @ByVal GpuMat templateImage, @ByVal GpuMat inputImage,
                                      @ByVal GpuMat warpMatrix);

/** \example samples/cpp/kalman.cpp
An example using the standard Kalman filter
*/

/** \brief Kalman filter class.
<p>
The class implements a standard Kalman filter <http://en.wikipedia.org/wiki/Kalman_filter>,
\cite Welch95 . However, you can modify transitionMatrix, controlMatrix, and measurementMatrix to get
an extended Kalman filter functionality.
\note In C API when CvKalman\* kalmanFilter structure is not needed anymore, it should be released
with cvReleaseKalman(&kalmanFilter)
 */
@Namespace("cv") @NoOffset public static class KalmanFilter extends Pointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public KalmanFilter(Pointer p) { super(p); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public KalmanFilter(long size) { super((Pointer)null); allocateArray(size); }
    private native void allocateArray(long size);
    @Override public KalmanFilter position(long position) {
        return (KalmanFilter)super.position(position);
    }

    public KalmanFilter() { super((Pointer)null); allocate(); }
    private native void allocate();
    /** \overload
    @param dynamParams Dimensionality of the state.
    @param measureParams Dimensionality of the measurement.
    @param controlParams Dimensionality of the control vector.
    @param type Type of the created matrices that should be CV_32F or CV_64F.
    */
    public KalmanFilter( int dynamParams, int measureParams, int controlParams/*=0*/, int type/*=CV_32F*/ ) { super((Pointer)null); allocate(dynamParams, measureParams, controlParams, type); }
    private native void allocate( int dynamParams, int measureParams, int controlParams/*=0*/, int type/*=CV_32F*/ );
    public KalmanFilter( int dynamParams, int measureParams ) { super((Pointer)null); allocate(dynamParams, measureParams); }
    private native void allocate( int dynamParams, int measureParams );

    /** \brief Re-initializes Kalman filter. The previous content is destroyed.
    <p>
    @param dynamParams Dimensionality of the state.
    @param measureParams Dimensionality of the measurement.
    @param controlParams Dimensionality of the control vector.
    @param type Type of the created matrices that should be CV_32F or CV_64F.
     */
    public native void init( int dynamParams, int measureParams, int controlParams/*=0*/, int type/*=CV_32F*/ );
    public native void init( int dynamParams, int measureParams );

    /** \brief Computes a predicted state.
    <p>
    @param control The optional input control
     */
    public native @Const @ByRef Mat predict( @Const @ByRef(nullValue = "cv::Mat()") Mat control );
    public native @Const @ByRef Mat predict( );

    /** \brief Updates the predicted state from the measurement.
    <p>
    @param measurement The measured system parameters
     */
    public native @Const @ByRef Mat correct( @Const @ByRef Mat measurement );

    /** predicted state (x'(k)): x(k)=A*x(k-1)+B*u(k) */
    public native @ByRef Mat statePre(); public native KalmanFilter statePre(Mat statePre);
    /** corrected state (x(k)): x(k)=x'(k)+K(k)*(z(k)-H*x'(k)) */
    public native @ByRef Mat statePost(); public native KalmanFilter statePost(Mat statePost);
    /** state transition matrix (A) */
    public native @ByRef Mat transitionMatrix(); public native KalmanFilter transitionMatrix(Mat transitionMatrix);
    /** control matrix (B) (not used if there is no control) */
    public native @ByRef Mat controlMatrix(); public native KalmanFilter controlMatrix(Mat controlMatrix);
    /** measurement matrix (H) */
    public native @ByRef Mat measurementMatrix(); public native KalmanFilter measurementMatrix(Mat measurementMatrix);
    /** process noise covariance matrix (Q) */
    public native @ByRef Mat processNoiseCov(); public native KalmanFilter processNoiseCov(Mat processNoiseCov);
    /** measurement noise covariance matrix (R) */
    public native @ByRef Mat measurementNoiseCov(); public native KalmanFilter measurementNoiseCov(Mat measurementNoiseCov);
    /** priori error estimate covariance matrix (P'(k)): P'(k)=A*P(k-1)*At + Q)*/
    public native @ByRef Mat errorCovPre(); public native KalmanFilter errorCovPre(Mat errorCovPre);
    /** Kalman gain matrix (K(k)): K(k)=P'(k)*Ht*inv(H*P'(k)*Ht+R) */
    public native @ByRef Mat gain(); public native KalmanFilter gain(Mat gain);
    /** posteriori error estimate covariance matrix (P(k)): P(k)=(I-K(k)*H)*P'(k) */
    public native @ByRef Mat errorCovPost(); public native KalmanFilter errorCovPost(Mat errorCovPost);

    // temporary matrices
    public native @ByRef Mat temp1(); public native KalmanFilter temp1(Mat temp1);
    public native @ByRef Mat temp2(); public native KalmanFilter temp2(Mat temp2);
    public native @ByRef Mat temp3(); public native KalmanFilter temp3(Mat temp3);
    public native @ByRef Mat temp4(); public native KalmanFilter temp4(Mat temp4);
    public native @ByRef Mat temp5(); public native KalmanFilter temp5(Mat temp5);
}


/** \brief Read a .flo file
 <p>
 @param path Path to the file to be loaded
 <p>
 The function readOpticalFlow loads a flow field from a file and returns it as a single matrix.
 Resulting Mat has a type CV_32FC2 - floating-point, 2-channel. First channel corresponds to the
 flow in the horizontal direction (u), second - vertical (v).
 */
@Namespace("cv") public static native @ByVal Mat readOpticalFlow( @Str BytePointer path );
@Namespace("cv") public static native @ByVal Mat readOpticalFlow( @Str String path );
/** \brief Write a .flo to disk
 <p>
 @param path Path to the file to be written
 @param flow Flow field to be stored
 <p>
 The function stores a flow field in a file, returns true on success, false otherwise.
 The flow field must be a 2-channel, floating-point matrix (CV_32FC2). First channel corresponds
 to the flow in the horizontal direction (u), second - vertical (v).
 */
@Namespace("cv") public static native @Cast("bool") boolean writeOpticalFlow( @Str BytePointer path, @ByVal Mat flow );
@Namespace("cv") public static native @Cast("bool") boolean writeOpticalFlow( @Str String path, @ByVal Mat flow );
@Namespace("cv") public static native @Cast("bool") boolean writeOpticalFlow( @Str String path, @ByVal UMat flow );
@Namespace("cv") public static native @Cast("bool") boolean writeOpticalFlow( @Str BytePointer path, @ByVal UMat flow );
@Namespace("cv") public static native @Cast("bool") boolean writeOpticalFlow( @Str BytePointer path, @ByVal GpuMat flow );
@Namespace("cv") public static native @Cast("bool") boolean writeOpticalFlow( @Str String path, @ByVal GpuMat flow );

/**
   Base class for dense optical flow algorithms
*/
@Namespace("cv") public static class DenseOpticalFlow extends Algorithm {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public DenseOpticalFlow(Pointer p) { super(p); }

    /** \brief Calculates an optical flow.
    <p>
    @param I0 first 8-bit single-channel input image.
    @param I1 second input image of the same size and the same type as prev.
    @param flow computed flow image that has the same size as prev and type CV_32FC2.
     */
    public native void calc( @ByVal Mat I0, @ByVal Mat I1, @ByVal Mat flow );
    public native void calc( @ByVal UMat I0, @ByVal UMat I1, @ByVal UMat flow );
    public native void calc( @ByVal GpuMat I0, @ByVal GpuMat I1, @ByVal GpuMat flow );
    /** \brief Releases all inner buffers.
    */
    public native void collectGarbage();
}

/** \brief Base interface for sparse optical flow algorithms.
 */
@Namespace("cv") public static class SparseOpticalFlow extends Algorithm {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public SparseOpticalFlow(Pointer p) { super(p); }

    /** \brief Calculates a sparse optical flow.
    <p>
    @param prevImg First input image.
    @param nextImg Second input image of the same size and the same type as prevImg.
    @param prevPts Vector of 2D points for which the flow needs to be found.
    @param nextPts Output vector of 2D points containing the calculated new positions of input features in the second image.
    @param status Output status vector. Each element of the vector is set to 1 if the
                  flow for the corresponding features has been found. Otherwise, it is set to 0.
    @param err Optional output vector that contains error response for each point (inverse confidence).
     */
    public native void calc(@ByVal Mat prevImg, @ByVal Mat nextImg,
                          @ByVal Mat prevPts, @ByVal Mat nextPts,
                          @ByVal Mat status,
                          @ByVal(nullValue = "cv::OutputArray(cv::noArray())") Mat err);
    public native void calc(@ByVal Mat prevImg, @ByVal Mat nextImg,
                          @ByVal Mat prevPts, @ByVal Mat nextPts,
                          @ByVal Mat status);
    public native void calc(@ByVal UMat prevImg, @ByVal UMat nextImg,
                          @ByVal UMat prevPts, @ByVal UMat nextPts,
                          @ByVal UMat status,
                          @ByVal(nullValue = "cv::OutputArray(cv::noArray())") UMat err);
    public native void calc(@ByVal UMat prevImg, @ByVal UMat nextImg,
                          @ByVal UMat prevPts, @ByVal UMat nextPts,
                          @ByVal UMat status);
    public native void calc(@ByVal GpuMat prevImg, @ByVal GpuMat nextImg,
                          @ByVal GpuMat prevPts, @ByVal GpuMat nextPts,
                          @ByVal GpuMat status,
                          @ByVal(nullValue = "cv::OutputArray(cv::noArray())") GpuMat err);
    public native void calc(@ByVal GpuMat prevImg, @ByVal GpuMat nextImg,
                          @ByVal GpuMat prevPts, @ByVal GpuMat nextPts,
                          @ByVal GpuMat status);
}


/** \brief Class computing a dense optical flow using the Gunnar Farneback's algorithm.
 */
@Namespace("cv") public static class FarnebackOpticalFlow extends DenseOpticalFlow {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public FarnebackOpticalFlow(Pointer p) { super(p); }

    public native int getNumLevels();
    public native void setNumLevels(int numLevels);

    public native double getPyrScale();
    public native void setPyrScale(double pyrScale);

    public native @Cast("bool") boolean getFastPyramids();
    public native void setFastPyramids(@Cast("bool") boolean fastPyramids);

    public native int getWinSize();
    public native void setWinSize(int winSize);

    public native int getNumIters();
    public native void setNumIters(int numIters);

    public native int getPolyN();
    public native void setPolyN(int polyN);

    public native double getPolySigma();
    public native void setPolySigma(double polySigma);

    public native int getFlags();
    public native void setFlags(int flags);

    public static native @Ptr FarnebackOpticalFlow create(
                int numLevels/*=5*/,
                double pyrScale/*=0.5*/,
                @Cast("bool") boolean fastPyramids/*=false*/,
                int winSize/*=13*/,
                int numIters/*=10*/,
                int polyN/*=5*/,
                double polySigma/*=1.1*/,
                int flags/*=0*/);
    public static native @Ptr FarnebackOpticalFlow create();
}

/** \brief Variational optical flow refinement
<p>
This class implements variational refinement of the input flow field, i.e.
it uses input flow to initialize the minimization of the following functional:
\f$E(U) = \int_{\Omega} \delta \Psi(E_I) + \gamma \Psi(E_G) + \alpha \Psi(E_S) \f$,
where \f$E_I,E_G,E_S\f$ are color constancy, gradient constancy and smoothness terms
respectively. \f$\Psi(s^2)=\sqrt{s^2+\epsilon^2}\f$ is a robust penalizer to limit the
influence of outliers. A complete formulation and a description of the minimization
procedure can be found in \cite Brox2004
*/
@Namespace("cv") public static class VariationalRefinement extends DenseOpticalFlow {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public VariationalRefinement(Pointer p) { super(p); }

    /** \brief \ref calc function overload to handle separate horizontal (u) and vertical (v) flow components
    (to avoid extra splits/merges) */
    public native void calcUV(@ByVal Mat I0, @ByVal Mat I1, @ByVal Mat flow_u, @ByVal Mat flow_v);
    public native void calcUV(@ByVal UMat I0, @ByVal UMat I1, @ByVal UMat flow_u, @ByVal UMat flow_v);
    public native void calcUV(@ByVal GpuMat I0, @ByVal GpuMat I1, @ByVal GpuMat flow_u, @ByVal GpuMat flow_v);

    /** \brief Number of outer (fixed-point) iterations in the minimization procedure.
    @see setFixedPointIterations */
    public native int getFixedPointIterations();
    /** \copybrief getFixedPointIterations @see getFixedPointIterations */
    public native void setFixedPointIterations(int val);

    /** \brief Number of inner successive over-relaxation (SOR) iterations
        in the minimization procedure to solve the respective linear system.
    @see setSorIterations */
    public native int getSorIterations();
    /** \copybrief getSorIterations @see getSorIterations */
    public native void setSorIterations(int val);

    /** \brief Relaxation factor in SOR
    @see setOmega */
    public native float getOmega();
    /** \copybrief getOmega @see getOmega */
    public native void setOmega(float val);

    /** \brief Weight of the smoothness term
    @see setAlpha */
    public native float getAlpha();
    /** \copybrief getAlpha @see getAlpha */
    public native void setAlpha(float val);

    /** \brief Weight of the color constancy term
    @see setDelta */
    public native float getDelta();
    /** \copybrief getDelta @see getDelta */
    public native void setDelta(float val);

    /** \brief Weight of the gradient constancy term
    @see setGamma */
    public native float getGamma();
    /** \copybrief getGamma @see getGamma */
    public native void setGamma(float val);

    /** \brief Creates an instance of VariationalRefinement
    */
    public static native @Ptr VariationalRefinement create();
}

/** \brief DIS optical flow algorithm.
<p>
This class implements the Dense Inverse Search (DIS) optical flow algorithm. More
details about the algorithm can be found at \cite Kroeger2016 . Includes three presets with preselected
parameters to provide reasonable trade-off between speed and quality. However, even the slowest preset is
still relatively fast, use DeepFlow if you need better quality and don't care about speed.
<p>
This implementation includes several additional features compared to the algorithm described in the paper,
including spatial propagation of flow vectors (\ref getUseSpatialPropagation), as well as an option to
utilize an initial flow approximation passed to \ref calc (which is, essentially, temporal propagation,
if the previous frame's flow field is passed).
*/
@Namespace("cv") public static class DISOpticalFlow extends DenseOpticalFlow {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public DISOpticalFlow(Pointer p) { super(p); }

    /** enum cv::DISOpticalFlow:: */
    public static final int
        PRESET_ULTRAFAST = 0,
        PRESET_FAST = 1,
        PRESET_MEDIUM = 2;

    /** \brief Finest level of the Gaussian pyramid on which the flow is computed (zero level
        corresponds to the original image resolution). The final flow is obtained by bilinear upscaling.
        @see setFinestScale */
    public native int getFinestScale();
    /** \copybrief getFinestScale @see getFinestScale */
    public native void setFinestScale(int val);

    /** \brief Size of an image patch for matching (in pixels). Normally, default 8x8 patches work well
        enough in most cases.
        @see setPatchSize */
    public native int getPatchSize();
    /** \copybrief getPatchSize @see getPatchSize */
    public native void setPatchSize(int val);

    /** \brief Stride between neighbor patches. Must be less than patch size. Lower values correspond
        to higher flow quality.
        @see setPatchStride */
    public native int getPatchStride();
    /** \copybrief getPatchStride @see getPatchStride */
    public native void setPatchStride(int val);

    /** \brief Maximum number of gradient descent iterations in the patch inverse search stage. Higher values
        may improve quality in some cases.
        @see setGradientDescentIterations */
    public native int getGradientDescentIterations();
    /** \copybrief getGradientDescentIterations @see getGradientDescentIterations */
    public native void setGradientDescentIterations(int val);

    /** \brief Number of fixed point iterations of variational refinement per scale. Set to zero to
        disable variational refinement completely. Higher values will typically result in more smooth and
        high-quality flow.
    @see setGradientDescentIterations */
    public native int getVariationalRefinementIterations();
    /** \copybrief getGradientDescentIterations @see getGradientDescentIterations */
    public native void setVariationalRefinementIterations(int val);

    /** \brief Weight of the smoothness term
    @see setVariationalRefinementAlpha */
    public native float getVariationalRefinementAlpha();
    /** \copybrief getVariationalRefinementAlpha @see getVariationalRefinementAlpha */
    public native void setVariationalRefinementAlpha(float val);

    /** \brief Weight of the color constancy term
    @see setVariationalRefinementDelta */
    public native float getVariationalRefinementDelta();
    /** \copybrief getVariationalRefinementDelta @see getVariationalRefinementDelta */
    public native void setVariationalRefinementDelta(float val);

    /** \brief Weight of the gradient constancy term
    @see setVariationalRefinementGamma */
    public native float getVariationalRefinementGamma();
    /** \copybrief getVariationalRefinementGamma @see getVariationalRefinementGamma */
    public native void setVariationalRefinementGamma(float val);


    /** \brief Whether to use mean-normalization of patches when computing patch distance. It is turned on
        by default as it typically provides a noticeable quality boost because of increased robustness to
        illumination variations. Turn it off if you are certain that your sequence doesn't contain any changes
        in illumination.
    @see setUseMeanNormalization */
    public native @Cast("bool") boolean getUseMeanNormalization();
    /** \copybrief getUseMeanNormalization @see getUseMeanNormalization */
    public native void setUseMeanNormalization(@Cast("bool") boolean val);

    /** \brief Whether to use spatial propagation of good optical flow vectors. This option is turned on by
        default, as it tends to work better on average and can sometimes help recover from major errors
        introduced by the coarse-to-fine scheme employed by the DIS optical flow algorithm. Turning this
        option off can make the output flow field a bit smoother, however.
    @see setUseSpatialPropagation */
    public native @Cast("bool") boolean getUseSpatialPropagation();
    /** \copybrief getUseSpatialPropagation @see getUseSpatialPropagation */
    public native void setUseSpatialPropagation(@Cast("bool") boolean val);

    /** \brief Creates an instance of DISOpticalFlow
    <p>
    @param preset one of PRESET_ULTRAFAST, PRESET_FAST and PRESET_MEDIUM
    */
    public static native @Ptr DISOpticalFlow create(int preset/*=cv::DISOpticalFlow::PRESET_FAST*/);
    public static native @Ptr DISOpticalFlow create();
}

/** \brief Class used for calculating a sparse optical flow.
<p>
The class can calculate an optical flow for a sparse feature set using the
iterative Lucas-Kanade method with pyramids.
<p>
\sa calcOpticalFlowPyrLK
<p>
*/
@Namespace("cv") public static class SparsePyrLKOpticalFlow extends SparseOpticalFlow {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public SparsePyrLKOpticalFlow(Pointer p) { super(p); }

    public native @ByVal Size getWinSize();
    public native void setWinSize(@ByVal Size winSize);

    public native int getMaxLevel();
    public native void setMaxLevel(int maxLevel);

    public native @ByVal TermCriteria getTermCriteria();
    public native void setTermCriteria(@ByRef TermCriteria crit);

    public native int getFlags();
    public native void setFlags(int flags);

    public native double getMinEigThreshold();
    public native void setMinEigThreshold(double minEigThreshold);

    public static native @Ptr SparsePyrLKOpticalFlow create(
                @ByVal(nullValue = "cv::Size(21, 21)") Size winSize,
                int maxLevel/*=3*/, @ByVal(nullValue = "cv::TermCriteria(cv::TermCriteria::COUNT+cv::TermCriteria::EPS, 30, 0.01)") TermCriteria crit,
                int flags/*=0*/,
                double minEigThreshold/*=1e-4*/);
    public static native @Ptr SparsePyrLKOpticalFlow create();
}

/** \} video_track */

 // cv

// #endif


// Parsed from <opencv2/video/background_segm.hpp>

/*M///////////////////////////////////////////////////////////////////////////////////////
//
//  IMPORTANT: READ BEFORE DOWNLOADING, COPYING, INSTALLING OR USING.
//
//  By downloading, copying, installing or using the software you agree to this license.
//  If you do not agree to this license, do not download, install,
//  copy or use the software.
//
//
//                          License Agreement
//                For Open Source Computer Vision Library
//
// Copyright (C) 2000-2008, Intel Corporation, all rights reserved.
// Copyright (C) 2009, Willow Garage Inc., all rights reserved.
// Copyright (C) 2013, OpenCV Foundation, all rights reserved.
// Third party copyrights are property of their respective owners.
//
// Redistribution and use in source and binary forms, with or without modification,
// are permitted provided that the following conditions are met:
//
//   * Redistribution's of source code must retain the above copyright notice,
//     this list of conditions and the following disclaimer.
//
//   * Redistribution's in binary form must reproduce the above copyright notice,
//     this list of conditions and the following disclaimer in the documentation
//     and/or other materials provided with the distribution.
//
//   * The name of the copyright holders may not be used to endorse or promote products
//     derived from this software without specific prior written permission.
//
// This software is provided by the copyright holders and contributors "as is" and
// any express or implied warranties, including, but not limited to, the implied
// warranties of merchantability and fitness for a particular purpose are disclaimed.
// In no event shall the Intel Corporation or contributors be liable for any direct,
// indirect, incidental, special, exemplary, or consequential damages
// (including, but not limited to, procurement of substitute goods or services;
// loss of use, data, or profits; or business interruption) however caused
// and on any theory of liability, whether in contract, strict liability,
// or tort (including negligence or otherwise) arising in any way out of
// the use of this software, even if advised of the possibility of such damage.
//
//M*/

// #ifndef OPENCV_BACKGROUND_SEGM_HPP
// #define OPENCV_BACKGROUND_SEGM_HPP

// #include "opencv2/core.hpp"

/** \addtogroup video_motion
 *  \{
<p>
/** \brief Base class for background/foreground segmentation. :
<p>
The class is only used to define the common interface for the whole family of background/foreground
segmentation algorithms.
 */
@Namespace("cv") public static class BackgroundSubtractor extends Algorithm {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public BackgroundSubtractor(Pointer p) { super(p); }

    /** \brief Computes a foreground mask.
    <p>
    @param image Next video frame.
    @param fgmask The output foreground mask as an 8-bit binary image.
    @param learningRate The value between 0 and 1 that indicates how fast the background model is
    learnt. Negative parameter value makes the algorithm to use some automatically chosen learning
    rate. 0 means that the background model is not updated at all, 1 means that the background model
    is completely reinitialized from the last frame.
     */
    public native void apply(@ByVal Mat image, @ByVal Mat fgmask, double learningRate/*=-1*/);
    public native void apply(@ByVal Mat image, @ByVal Mat fgmask);
    public native void apply(@ByVal UMat image, @ByVal UMat fgmask, double learningRate/*=-1*/);
    public native void apply(@ByVal UMat image, @ByVal UMat fgmask);
    public native void apply(@ByVal GpuMat image, @ByVal GpuMat fgmask, double learningRate/*=-1*/);
    public native void apply(@ByVal GpuMat image, @ByVal GpuMat fgmask);

    /** \brief Computes a background image.
    <p>
    @param backgroundImage The output background image.
    <p>
    \note Sometimes the background image can be very blurry, as it contain the average background
    statistics.
     */
    public native void getBackgroundImage(@ByVal Mat backgroundImage);
    public native void getBackgroundImage(@ByVal UMat backgroundImage);
    public native void getBackgroundImage(@ByVal GpuMat backgroundImage);
}


/** \brief Gaussian Mixture-based Background/Foreground Segmentation Algorithm.
<p>
The class implements the Gaussian mixture model background subtraction described in \cite Zivkovic2004
and \cite Zivkovic2006 .
 */
@Namespace("cv") public static class BackgroundSubtractorMOG2 extends BackgroundSubtractor {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public BackgroundSubtractorMOG2(Pointer p) { super(p); }

    /** \brief Returns the number of last frames that affect the background model
    */
    public native int getHistory();
    /** \brief Sets the number of last frames that affect the background model
    */
    public native void setHistory(int history);

    /** \brief Returns the number of gaussian components in the background model
    */
    public native int getNMixtures();
    /** \brief Sets the number of gaussian components in the background model.
    <p>
    The model needs to be reinitalized to reserve memory.
    */
    public native void setNMixtures(int nmixtures);//needs reinitialization!

    /** \brief Returns the "background ratio" parameter of the algorithm
    <p>
    If a foreground pixel keeps semi-constant value for about backgroundRatio\*history frames, it's
    considered background and added to the model as a center of a new component. It corresponds to TB
    parameter in the paper.
     */
    public native double getBackgroundRatio();
    /** \brief Sets the "background ratio" parameter of the algorithm
    */
    public native void setBackgroundRatio(double ratio);

    /** \brief Returns the variance threshold for the pixel-model match
    <p>
    The main threshold on the squared Mahalanobis distance to decide if the sample is well described by
    the background model or not. Related to Cthr from the paper.
     */
    public native double getVarThreshold();
    /** \brief Sets the variance threshold for the pixel-model match
    */
    public native void setVarThreshold(double varThreshold);

    /** \brief Returns the variance threshold for the pixel-model match used for new mixture component generation
    <p>
    Threshold for the squared Mahalanobis distance that helps decide when a sample is close to the
    existing components (corresponds to Tg in the paper). If a pixel is not close to any component, it
    is considered foreground or added as a new component. 3 sigma =\> Tg=3\*3=9 is default. A smaller Tg
    value generates more components. A higher Tg value may result in a small number of components but
    they can grow too large.
     */
    public native double getVarThresholdGen();
    /** \brief Sets the variance threshold for the pixel-model match used for new mixture component generation
    */
    public native void setVarThresholdGen(double varThresholdGen);

    /** \brief Returns the initial variance of each gaussian component
    */
    public native double getVarInit();
    /** \brief Sets the initial variance of each gaussian component
    */
    public native void setVarInit(double varInit);

    public native double getVarMin();
    public native void setVarMin(double varMin);

    public native double getVarMax();
    public native void setVarMax(double varMax);

    /** \brief Returns the complexity reduction threshold
    <p>
    This parameter defines the number of samples needed to accept to prove the component exists. CT=0.05
    is a default value for all the samples. By setting CT=0 you get an algorithm very similar to the
    standard Stauffer&Grimson algorithm.
     */
    public native double getComplexityReductionThreshold();
    /** \brief Sets the complexity reduction threshold
    */
    public native void setComplexityReductionThreshold(double ct);

    /** \brief Returns the shadow detection flag
    <p>
    If true, the algorithm detects shadows and marks them. See createBackgroundSubtractorMOG2 for
    details.
     */
    public native @Cast("bool") boolean getDetectShadows();
    /** \brief Enables or disables shadow detection
    */
    public native void setDetectShadows(@Cast("bool") boolean detectShadows);

    /** \brief Returns the shadow value
    <p>
    Shadow value is the value used to mark shadows in the foreground mask. Default value is 127. Value 0
    in the mask always means background, 255 means foreground.
     */
    public native int getShadowValue();
    /** \brief Sets the shadow value
    */
    public native void setShadowValue(int value);

    /** \brief Returns the shadow threshold
    <p>
    A shadow is detected if pixel is a darker version of the background. The shadow threshold (Tau in
    the paper) is a threshold defining how much darker the shadow can be. Tau= 0.5 means that if a pixel
    is more than twice darker then it is not shadow. See Prati, Mikic, Trivedi and Cucchiara,
    *Detecting Moving Shadows...*, IEEE PAMI,2003.
     */
    public native double getShadowThreshold();
    /** \brief Sets the shadow threshold
    */
    public native void setShadowThreshold(double threshold);

    /** \brief Computes a foreground mask.
    <p>
    @param image Next video frame. Floating point frame will be used without scaling and should be in range \f$[0,255]\f$.
    @param fgmask The output foreground mask as an 8-bit binary image.
    @param learningRate The value between 0 and 1 that indicates how fast the background model is
    learnt. Negative parameter value makes the algorithm to use some automatically chosen learning
    rate. 0 means that the background model is not updated at all, 1 means that the background model
    is completely reinitialized from the last frame.
     */
    public native @Override void apply(@ByVal Mat image, @ByVal Mat fgmask, double learningRate/*=-1*/);
    public native void apply(@ByVal Mat image, @ByVal Mat fgmask);
    public native @Override void apply(@ByVal UMat image, @ByVal UMat fgmask, double learningRate/*=-1*/);
    public native void apply(@ByVal UMat image, @ByVal UMat fgmask);
    public native @Override void apply(@ByVal GpuMat image, @ByVal GpuMat fgmask, double learningRate/*=-1*/);
    public native void apply(@ByVal GpuMat image, @ByVal GpuMat fgmask);
}

/** \brief Creates MOG2 Background Subtractor
<p>
@param history Length of the history.
@param varThreshold Threshold on the squared Mahalanobis distance between the pixel and the model
to decide whether a pixel is well described by the background model. This parameter does not
affect the background update.
@param detectShadows If true, the algorithm will detect shadows and mark them. It decreases the
speed a bit, so if you do not need this feature, set the parameter to false.
 */
@Namespace("cv") public static native @Ptr BackgroundSubtractorMOG2 createBackgroundSubtractorMOG2(int history/*=500*/, double varThreshold/*=16*/,
                                   @Cast("bool") boolean detectShadows/*=true*/);
@Namespace("cv") public static native @Ptr BackgroundSubtractorMOG2 createBackgroundSubtractorMOG2();

/** \brief K-nearest neighbours - based Background/Foreground Segmentation Algorithm.
<p>
The class implements the K-nearest neighbours background subtraction described in \cite Zivkovic2006 .
Very efficient if number of foreground pixels is low.
 */
@Namespace("cv") public static class BackgroundSubtractorKNN extends BackgroundSubtractor {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public BackgroundSubtractorKNN(Pointer p) { super(p); }

    /** \brief Returns the number of last frames that affect the background model
    */
    public native int getHistory();
    /** \brief Sets the number of last frames that affect the background model
    */
    public native void setHistory(int history);

    /** \brief Returns the number of data samples in the background model
    */
    public native int getNSamples();
    /** \brief Sets the number of data samples in the background model.
    <p>
    The model needs to be reinitalized to reserve memory.
    */
    public native void setNSamples(int _nN);//needs reinitialization!

    /** \brief Returns the threshold on the squared distance between the pixel and the sample
    <p>
    The threshold on the squared distance between the pixel and the sample to decide whether a pixel is
    close to a data sample.
     */
    public native double getDist2Threshold();
    /** \brief Sets the threshold on the squared distance
    */
    public native void setDist2Threshold(double _dist2Threshold);

    /** \brief Returns the number of neighbours, the k in the kNN.
    <p>
    K is the number of samples that need to be within dist2Threshold in order to decide that that
    pixel is matching the kNN background model.
     */
    public native int getkNNSamples();
    /** \brief Sets the k in the kNN. How many nearest neighbours need to match.
    */
    public native void setkNNSamples(int _nkNN);

    /** \brief Returns the shadow detection flag
    <p>
    If true, the algorithm detects shadows and marks them. See createBackgroundSubtractorKNN for
    details.
     */
    public native @Cast("bool") boolean getDetectShadows();
    /** \brief Enables or disables shadow detection
    */
    public native void setDetectShadows(@Cast("bool") boolean detectShadows);

    /** \brief Returns the shadow value
    <p>
    Shadow value is the value used to mark shadows in the foreground mask. Default value is 127. Value 0
    in the mask always means background, 255 means foreground.
     */
    public native int getShadowValue();
    /** \brief Sets the shadow value
    */
    public native void setShadowValue(int value);

    /** \brief Returns the shadow threshold
    <p>
    A shadow is detected if pixel is a darker version of the background. The shadow threshold (Tau in
    the paper) is a threshold defining how much darker the shadow can be. Tau= 0.5 means that if a pixel
    is more than twice darker then it is not shadow. See Prati, Mikic, Trivedi and Cucchiara,
    *Detecting Moving Shadows...*, IEEE PAMI,2003.
     */
    public native double getShadowThreshold();
    /** \brief Sets the shadow threshold
     */
    public native void setShadowThreshold(double threshold);
}

/** \brief Creates KNN Background Subtractor
<p>
@param history Length of the history.
@param dist2Threshold Threshold on the squared distance between the pixel and the sample to decide
whether a pixel is close to that sample. This parameter does not affect the background update.
@param detectShadows If true, the algorithm will detect shadows and mark them. It decreases the
speed a bit, so if you do not need this feature, set the parameter to false.
 */
@Namespace("cv") public static native @Ptr BackgroundSubtractorKNN createBackgroundSubtractorKNN(int history/*=500*/, double dist2Threshold/*=400.0*/,
                                   @Cast("bool") boolean detectShadows/*=true*/);
@Namespace("cv") public static native @Ptr BackgroundSubtractorKNN createBackgroundSubtractorKNN();

/** \} video_motion */

 // cv

// #endif


}
