/*
 * Decompiled with CFR 0.152.
 */
package com.strobel.reflection.emit;

import com.strobel.core.ReadOnlyList;
import com.strobel.core.StringUtilities;
import com.strobel.core.VerifyArgument;
import com.strobel.reflection.MemberInfo;
import com.strobel.reflection.MethodBase;
import com.strobel.reflection.MethodInfo;
import com.strobel.reflection.MethodList;
import com.strobel.reflection.Type;
import com.strobel.reflection.TypeList;
import com.strobel.reflection.Types;
import com.strobel.reflection.emit.AnnotationBuilder;
import com.strobel.reflection.emit.CodeGenerator;
import com.strobel.reflection.emit.CodeStream;
import com.strobel.reflection.emit.CompilationTarget;
import com.strobel.reflection.emit.ConstructorBuilder;
import com.strobel.reflection.emit.Error;
import com.strobel.reflection.emit.FieldBuilder;
import com.strobel.reflection.emit.LocalBuilder;
import com.strobel.reflection.emit.MethodBuilder;
import com.strobel.reflection.emit.OpCode;
import com.strobel.reflection.emit.ParameterBuilder;
import com.strobel.reflection.emit.TypeBuilder;
import com.strobel.reflection.emit.__ExceptionInfo;
import com.strobel.util.TypeUtils;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

final class ClassWriter {
    private static final int JAVA_MAGIC = -889275714;
    private static final int DATA_BUFFER_SIZE = 65520;
    private static final int POOL_BUFFER_SIZE = 131056;
    private final CodeStream _dataBuffer;
    private final CodeStream _poolBuffer;
    private final CodeStream _signatureBuffer;
    private final TypeBuilder<?> _typeBuilder;

    ClassWriter(TypeBuilder<?> typeBuilder) {
        this._typeBuilder = (TypeBuilder)VerifyArgument.notNull(typeBuilder, (String)"typeBuilder");
        this._dataBuffer = new CodeStream(65520);
        this._poolBuffer = new CodeStream(131056);
        this._signatureBuffer = new CodeStream();
    }

    public void writeClass(OutputStream out) throws IOException {
        this.writeCore();
        out.write(this._poolBuffer.getData(), 0, this._poolBuffer.getLength());
    }

    public void writeClass(CodeStream out) throws IOException {
        this.writeCore();
        out.putByteArray(this._poolBuffer.getData(), 0, this._poolBuffer.getLength());
    }

    private void writeCore() {
        boolean signatureRequired;
        TypeBuilder<Object> t = this._typeBuilder;
        assert ((t.getModifiers() & 0x1000000) == 0);
        this._dataBuffer.reset(65520);
        this._poolBuffer.reset(131056);
        this._signatureBuffer.reset();
        Type<?> baseType = t.getBaseType();
        TypeList interfaceTypes = t.getInterfaces();
        int flags = t.getModifiers();
        if ((flags & 4) != 0) {
            flags |= 1;
        }
        if (((flags = flags & 0x7E11 & 0xFFFFF7FF) & 0x200) == 0) {
            flags |= 0x20;
        }
        if (t.isNested() && StringUtilities.isNullOrEmpty((String)t.getName())) {
            flags &= 0xFFFFFFEF;
        }
        this._dataBuffer.putShort(flags);
        this._dataBuffer.putShort(t.getTypeToken(t));
        if (baseType != null && baseType.isClass()) {
            this._dataBuffer.putShort(t.getTypeToken(baseType));
        } else {
            this._dataBuffer.putShort(t.getTypeToken(Types.Object));
        }
        this._dataBuffer.putShort(interfaceTypes.size());
        Iterator iterator = interfaceTypes.iterator();
        while (iterator.hasNext()) {
            Type interfaceType = (Type)iterator.next();
            this._dataBuffer.putShort(t.getTypeToken(interfaceType));
        }
        int fieldCount = t.fieldBuilders.size();
        int methodCount = t.methodBuilders.size();
        this._dataBuffer.putShort(fieldCount);
        this.writeFields();
        this._dataBuffer.putShort(methodCount);
        this.writeMethods();
        int attributeCountIndex = this.beginAttributes();
        int attributeCount = 0;
        boolean bl = signatureRequired = t.isGenericType() || baseType != null && baseType.isGenericType();
        if (!signatureRequired) {
            Iterator iterator2 = interfaceTypes.iterator();
            while (iterator2.hasNext()) {
                Type interfaceType = (Type)iterator2.next();
                signatureRequired |= interfaceType.isGenericType();
            }
        }
        if (signatureRequired) {
            int attributeLengthIndex = this.writeAttribute("Signature");
            this._dataBuffer.putShort(t.getUtf8StringToken(t.getGenericSignature()));
            this.endAttribute(attributeLengthIndex);
            ++attributeCount;
        }
        attributeCount += this.writeFlagAttributes(flags);
        attributeCount += this.writeJavaAnnotations(t.getCustomAnnotations());
        attributeCount += this.writeEnclosingMethodAttribute(t);
        attributeCount += this.writeInnerTypes();
        this._poolBuffer.putInt(-889275714);
        this._poolBuffer.putShort(CompilationTarget.JDK1_5.minorVersion);
        this._poolBuffer.putShort(CompilationTarget.JDK1_5.majorVersion);
        t.constantPool.write(this._poolBuffer);
        this.endAttributes(attributeCountIndex, attributeCount);
        this._poolBuffer.putByteArray(this._dataBuffer.getData(), 0, this._dataBuffer.getLength());
    }

    private int writeEnclosingMethodAttribute(TypeBuilder<?> t) {
        MethodBase method = t.getDeclaringMethod();
        if (method == null) {
            return 0;
        }
        int enclosingMethodStart = this.writeAttribute("EnclosingMethod");
        Type declaringType = method.getDeclaringType();
        this._dataBuffer.putShort(declaringType != null ? (int)t.getTypeToken(declaringType) : 0);
        this._dataBuffer.putShort(t.getMethodToken(method));
        this.endAttribute(enclosingMethodStart);
        return 1;
    }

    private int writeInnerTypes() {
        HashSet<Type<?>> innerTypeSet = this._typeBuilder.constantPool.referencedInnerTypes;
        if (innerTypeSet.isEmpty()) {
            return 0;
        }
        Type[] innerTypes = innerTypeSet.toArray(new Type[innerTypeSet.size()]);
        int innerClassesStart = this.writeAttribute("InnerClasses");
        this._dataBuffer.putShort(innerTypes.length);
        for (Type type : innerTypes) {
            this.writeInnerTypeInfo(type);
        }
        this.endAttribute(innerClassesStart);
        return 1;
    }

    private void writeInnerTypeInfo(Type<?> type) {
        Type declaringType = type.getDeclaringType();
        MethodBase declaringMethod = type.getDeclaringMethod();
        this._dataBuffer.putShort(this._typeBuilder.getTypeToken(type));
        if (declaringType != null) {
            this._dataBuffer.putShort(this._typeBuilder.getTypeToken(declaringType));
        } else if (declaringMethod != null) {
            Type methodDeclaringType = declaringMethod.getDeclaringType();
            if (methodDeclaringType != null) {
                this._dataBuffer.putShort(this._typeBuilder.getTypeToken(methodDeclaringType));
            } else {
                this._dataBuffer.putShort(0);
            }
        }
        String shortName = type.getShortName();
        if (StringUtilities.isNullOrWhitespace((String)shortName)) {
            this._dataBuffer.putShort(0);
        } else {
            this._dataBuffer.putShort(this._typeBuilder.getUtf8StringToken(shortName));
        }
        this._dataBuffer.putShort(type.getModifiers() & 0x5E17);
    }

    private void writeFields() {
        for (FieldBuilder field : this._typeBuilder.fieldBuilders) {
            this.writeField(field);
        }
    }

    private void writeField(FieldBuilder field) {
        TypeBuilder t = field.getDeclaringType();
        this._dataBuffer.putShort(field.getModifiers());
        this._dataBuffer.putShort(t.getUtf8StringToken(field.getName()));
        this._dataBuffer.putShort(t.getUtf8StringToken(field.getErasedSignature()));
        Object constantValue = field.getConstantValue();
        int attributeCountPosition = this.beginAttributes();
        int attributeCount = 0;
        if (constantValue != null) {
            Type<?> constantType = TypeUtils.getUnderlyingPrimitiveOrSelf(Type.of(constantValue.getClass()));
            int attributeLengthIndex = this.writeAttribute("ConstantValue");
            switch (constantType.getKind()) {
                case BOOLEAN: {
                    this._dataBuffer.putShort(t.getConstantToken((Boolean)constantValue != false ? 1 : 0));
                    break;
                }
                case BYTE: 
                case SHORT: 
                case INT: {
                    this._dataBuffer.putShort(t.getConstantToken(((Number)constantValue).intValue()));
                    break;
                }
                case LONG: {
                    this._dataBuffer.putShort(t.getConstantToken(((Number)constantValue).longValue()));
                    break;
                }
                case CHAR: {
                    this._dataBuffer.putShort(t.getConstantToken(((Character)constantValue).charValue()));
                    break;
                }
                case FLOAT: {
                    this._dataBuffer.putShort(t.getConstantToken(((Number)constantValue).floatValue()));
                    break;
                }
                case DOUBLE: {
                    this._dataBuffer.putShort(t.getConstantToken(((Number)constantValue).doubleValue()));
                    break;
                }
                default: {
                    throw Error.valueMustBeConstant();
                }
            }
            this.endAttribute(attributeLengthIndex);
            ++attributeCount;
        }
        this.endAttributes(attributeCountPosition, attributeCount += this.writeMemberAttributes(field));
    }

    private void writeMethods() {
        for (MethodBuilder method : this._typeBuilder.methodBuilders) {
            this.writeMethod(method);
        }
    }

    private void writeMethod(MethodBuilder method) {
        Object defaultValue;
        TypeList exceptions;
        TypeBuilder<?> t = this._typeBuilder;
        this._dataBuffer.putShort(method.getModifiers());
        this._dataBuffer.putShort(t.getUtf8StringToken(method.getName()));
        this._dataBuffer.putShort(t.getUtf8StringToken(method.getErasedSignature()));
        int attributeCount = 0;
        int attributeCountIndex = this.beginAttributes();
        byte[] body = method.getBody();
        if (body != null) {
            int attributeLengthIndex = this.writeAttribute("Code");
            this.writeBody(method);
            this.endAttribute(attributeLengthIndex);
            ++attributeCount;
        }
        if (!(exceptions = method.getThrownTypes()).isEmpty()) {
            int attributeLengthIndex = this.writeAttribute("Exceptions");
            this._dataBuffer.putShort(exceptions.size());
            Iterator iterator = exceptions.iterator();
            while (iterator.hasNext()) {
                Type exceptionType = (Type)iterator.next();
                this._dataBuffer.putShort(t.getTypeToken(exceptionType));
            }
            this.endAttribute(attributeLengthIndex);
            ++attributeCount;
        }
        if ((defaultValue = method.getDefaultValue()) != null) {
            int attributeLengthIndex = this.writeAttribute("AnnotationDefault");
            this.writeAttributeType(body);
            this.endAttribute(attributeLengthIndex);
            ++attributeCount;
        }
        attributeCount += this.writeMemberAttributes(method);
        this.endAttributes(attributeCountIndex, attributeCount += this.writeParameterAttributes(method));
    }

    private void writeBody(MethodBuilder method) {
        CodeGenerator generator = method.getCodeGenerator();
        this._dataBuffer.putShort(generator.getMaxStackSize());
        int maxLocals = generator.translateLocal(generator.localCount);
        this._dataBuffer.putShort(maxLocals);
        this._dataBuffer.putInt(generator.offset());
        byte[] body = method.getBody();
        this._dataBuffer.putByteArray(body, 0, body.length);
        __ExceptionInfo[] exceptionsInfo = generator.getExceptions();
        if (exceptionsInfo != null) {
            int tryCatchTableEntries = 0;
            for (__ExceptionInfo exception : exceptionsInfo) {
                if (exception.getFinallyEndAddress() != -1) {
                    if (exception.getNumberOfCatches() == 1) {
                        tryCatchTableEntries += 2;
                        continue;
                    }
                    tryCatchTableEntries += (exception.getNumberOfCatches() - 1) * 3;
                    continue;
                }
                tryCatchTableEntries += exception.getNumberOfCatches();
            }
            this._dataBuffer.putShort(tryCatchTableEntries);
            for (__ExceptionInfo exception : exceptionsInfo) {
                int i;
                int[] catchAddresses = exception.getCatchAddresses();
                Object catchEndAddresses = exception.getCatchEndAddresses();
                Type[] catchTypes = exception.getCatchClass();
                int finallyIndex = -1;
                int n = exception.getNumberOfCatches();
                for (i = 0; i < n; ++i) {
                    if (catchTypes[i] != null) continue;
                    finallyIndex = i;
                    break;
                }
                n = exception.getNumberOfCatches();
                for (i = 0; i < n; ++i) {
                    if (catchTypes[i] == null) continue;
                    this._dataBuffer.putShort(exception.getStartAddress());
                    this._dataBuffer.putShort(exception.getEndAddress());
                    this._dataBuffer.putShort(catchAddresses[i]);
                    this._dataBuffer.putShort(this._typeBuilder.getTypeToken(catchTypes[i]));
                    if (finallyIndex == -1) continue;
                    this._dataBuffer.putShort(exception.getStartAddress());
                    this._dataBuffer.putShort(exception.getEndAddress());
                    this._dataBuffer.putShort(catchAddresses[finallyIndex]);
                    this._dataBuffer.putShort(0);
                    this._dataBuffer.putShort(catchAddresses[i]);
                    this._dataBuffer.putShort((int)catchEndAddresses[i]);
                    this._dataBuffer.putShort(catchAddresses[finallyIndex]);
                    this._dataBuffer.putShort(0);
                }
                if (finallyIndex == -1 || exception.getNumberOfCatches() != 1) continue;
                this._dataBuffer.putShort(exception.getStartAddress());
                this._dataBuffer.putShort(exception.getEndAddress());
                this._dataBuffer.putShort(catchAddresses[finallyIndex]);
                this._dataBuffer.putShort(0);
                int storeOpSize = OpCode.get(body[exception.getFinallyEndAddress()]).getSizeWithOperands();
                this._dataBuffer.putShort(catchAddresses[finallyIndex]);
                this._dataBuffer.putShort(exception.getFinallyEndAddress() + storeOpSize);
                this._dataBuffer.putShort(catchAddresses[finallyIndex]);
                this._dataBuffer.putShort(0);
            }
        } else {
            this._dataBuffer.putShort(0);
        }
        int attributeCountIndex = this.beginAttributes();
        int attributeCount = 0;
        int genericParameterCount = 0;
        List<LocalInfo> locals = this.getLocalInfo(method);
        int localCount = locals.size();
        if (localCount > 0) {
            int attributeLengthIndex = this.writeAttribute("LocalVariableTable");
            this._dataBuffer.putShort(localCount);
            for (LocalInfo local : locals) {
                this._dataBuffer.putShort(local.start);
                this._dataBuffer.putShort(local.end - local.start);
                Type<?> localType = local.type;
                this._dataBuffer.putShort(this._typeBuilder.getUtf8StringToken(local.name));
                if (this.needsLocalVariableTableEntry(localType)) {
                    ++genericParameterCount;
                }
                this._dataBuffer.putShort(this._typeBuilder.getUtf8StringToken(localType.getErasedSignature()));
                this._dataBuffer.putShort(local.position);
            }
            this.endAttribute(attributeLengthIndex);
            ++attributeCount;
        }
        if (genericParameterCount > 0) {
            int attributeLengthIndex = this.writeAttribute("LocalVariableTypeTable");
            this._dataBuffer.putShort(genericParameterCount);
            int count = 0;
            for (LocalInfo local : locals) {
                if (!this.needsLocalVariableTableEntry(local.type)) continue;
                ++count;
                this._dataBuffer.putShort(local.start);
                this._dataBuffer.putShort(local.end - local.start);
                this._dataBuffer.putShort(this._typeBuilder.getUtf8StringToken(local.name));
                this._dataBuffer.putShort(this._typeBuilder.getUtf8StringToken(local.type.getSignature()));
                this._dataBuffer.putShort(local.position);
            }
            assert (count == genericParameterCount);
            this.endAttribute(attributeLengthIndex);
            ++attributeCount;
        }
        this.endAttributes(attributeCountIndex, attributeCount);
    }

    private boolean needsLocalVariableTableEntry(Type<?> localType) {
        return !localType.isEquivalentTo(localType.getErasedType()) && !localType.isCompoundType();
    }

    private List<LocalInfo> getLocalInfo(MethodBuilder builder) {
        boolean hasThis = !builder.isStatic();
        ArrayList<LocalInfo> localInfo = new ArrayList<LocalInfo>();
        if (hasThis) {
            LocalInfo localInfo2 = new LocalInfo("this", builder.getDeclaringType(), 0, 0, builder.generator.offset());
            localInfo.add(localInfo2);
        }
        for (ParameterBuilder p : builder.parameterBuilders) {
            LocalInfo pInfo = new LocalInfo(p.getName(), p.getParameterType(), builder.generator.translateParameter(p.getPosition()), 0, builder.generator.offset());
            localInfo.add(pInfo);
        }
        LocalBuilder[] localBuilderArray = builder.generator.locals;
        if (localBuilderArray != null) {
            int n = builder.generator.localCount;
            for (int i = 0; i < n; ++i) {
                LocalBuilder l = localBuilderArray[i];
                if (l == null) continue;
                LocalInfo lInfo = new LocalInfo(l.getName(), l.getLocalType(), builder.generator.translateLocal(l.getLocalIndex()), l.startOffset < 0 ? 0 : l.startOffset, l.endOffset < 0 ? builder.generator.offset() : l.endOffset);
                localInfo.add(lInfo);
            }
        }
        return localInfo;
    }

    private int writeMemberAttributes(MemberInfo member) {
        Object annotations;
        String signature;
        long flags = member.getModifiers();
        int attributeCount = this.writeFlagAttributes(member.getModifiers());
        switch (member.getMemberType()) {
            case Field: {
                FieldBuilder field = (FieldBuilder)member;
                signature = field.getFieldType().getSignature();
                annotations = field.getCustomAnnotations();
                break;
            }
            case Method: {
                MethodBuilder method = (MethodBuilder)member;
                signature = method.getSignature();
                annotations = method.getCustomAnnotations();
                break;
            }
            case Constructor: {
                ConstructorBuilder constructor = (ConstructorBuilder)member;
                signature = constructor.getSignature();
                annotations = constructor.getCustomAnnotations();
                break;
            }
            default: {
                signature = member.getSignature();
                annotations = member instanceof TypeBuilder ? ((TypeBuilder)member).getCustomAnnotations() : ReadOnlyList.emptyList();
            }
        }
        if ((flags & 0x80001000L) != 4096L && (flags & 0x20000000L) == 0L) {
            int attributeIndex = this.writeAttribute("Signature");
            this._dataBuffer.putShort(this._typeBuilder.getUtf8StringToken(signature));
            this.endAttribute(attributeIndex);
            ++attributeCount;
        }
        return attributeCount += this.writeJavaAnnotations((ReadOnlyList<AnnotationBuilder<? extends Annotation>>)annotations);
    }

    private int writeParameterAttributes(MethodBuilder method) {
        ArrayList<AnnotationBuilder> annotations;
        int attributeIndex;
        boolean hasVisible = false;
        boolean hasInvisible = false;
        ParameterBuilder[] parameters = method.parameterBuilders;
        if (parameters != null) {
            for (ParameterBuilder parameter : parameters) {
                for (AnnotationBuilder a : parameter.getCustomAnnotations()) {
                    switch (this.getAnnotationRetention(a)) {
                        case SOURCE: {
                            break;
                        }
                        case CLASS: {
                            hasInvisible = true;
                            break;
                        }
                        case RUNTIME: {
                            hasVisible = true;
                        }
                    }
                }
            }
        }
        int attributeCount = 0;
        if (hasVisible) {
            attributeIndex = this.writeAttribute("RuntimeVisibleParameterAnnotations");
            this._dataBuffer.putByte(parameters.length);
            for (ParameterBuilder p : parameters) {
                annotations = new ArrayList<AnnotationBuilder>(p.getCustomAnnotations().size());
                for (AnnotationBuilder a : p.getCustomAnnotations()) {
                    if (this.getAnnotationRetention(a) != RetentionPolicy.RUNTIME) continue;
                    annotations.add(a);
                }
                this._dataBuffer.putShort(annotations.size());
                for (AnnotationBuilder a : annotations) {
                    this.writeAnnotation(a);
                }
            }
            this.endAttribute(attributeIndex);
            ++attributeCount;
        }
        if (hasInvisible) {
            attributeIndex = this.writeAttribute("RuntimeInvisibleParameterAnnotations");
            this._dataBuffer.putByte(parameters.length);
            for (ParameterBuilder p : parameters) {
                annotations = new ArrayList(p.getCustomAnnotations().size());
                for (AnnotationBuilder a : p.getCustomAnnotations()) {
                    if (this.getAnnotationRetention(a) != RetentionPolicy.CLASS) continue;
                    annotations.add(a);
                }
                this._dataBuffer.putShort(annotations.size());
                for (AnnotationBuilder a : annotations) {
                    this.writeAnnotation(a);
                }
            }
            this.endAttribute(attributeIndex);
            ++attributeCount;
        }
        return attributeCount;
    }

    private RetentionPolicy getAnnotationRetention(AnnotationBuilder<? extends Annotation> a) {
        if (a.getAnnotationType().isAnnotationPresent(Retention.class)) {
            return a.getAnnotationType().getAnnotation(Retention.class).value();
        }
        return RetentionPolicy.CLASS;
    }

    private int writeJavaAnnotations(ReadOnlyList<AnnotationBuilder<? extends Annotation>> annotations) {
        if (annotations == null || annotations.isEmpty()) {
            return 0;
        }
        ArrayList<AnnotationBuilder> visible = new ArrayList<AnnotationBuilder>();
        ArrayList<AnnotationBuilder> invisible = new ArrayList<AnnotationBuilder>();
        for (AnnotationBuilder a : annotations) {
            switch (this.getAnnotationRetention(a)) {
                case SOURCE: {
                    break;
                }
                case CLASS: {
                    invisible.add(a);
                    break;
                }
                case RUNTIME: {
                    visible.add(a);
                }
            }
        }
        int attributeCount = 0;
        if (!visible.isEmpty()) {
            int attributeIndex = this.writeAttribute("RuntimeVisibleAnnotations");
            this._dataBuffer.putShort(visible.size());
            for (AnnotationBuilder a : visible) {
                this.writeAnnotation(a);
            }
            this.endAttribute(attributeIndex);
            ++attributeCount;
        }
        if (!invisible.isEmpty()) {
            int attributeIndex = this.writeAttribute("RuntimeInvisibleAnnotations");
            this._dataBuffer.putShort(invisible.size());
            for (AnnotationBuilder a : invisible) {
                this.writeAnnotation(a);
            }
            this.endAttribute(attributeIndex);
            ++attributeCount;
        }
        return attributeCount;
    }

    private void writeAnnotation(AnnotationBuilder<? extends Annotation> a) {
        this._dataBuffer.putShort(this._typeBuilder.getUtf8StringToken(a.getAnnotationType().getSignature()));
        this._dataBuffer.putShort(a.getValues().size());
        MethodList attributes = a.getAttributes();
        ReadOnlyList<Object> values = a.getValues();
        int n = attributes.size();
        for (int i = 0; i < n; ++i) {
            MethodInfo attribute = (MethodInfo)attributes.get(i);
            this._dataBuffer.putShort(this._typeBuilder.getUtf8StringToken(attribute.getName()));
            this.writeAttributeType(values.get(i));
        }
    }

    private void writeAttributeType(Object value) {
        Type<?> valueType = TypeUtils.getUnderlyingPrimitiveOrSelf(Type.of(value.getClass()));
        switch (valueType.getKind()) {
            case BOOLEAN: {
                this._dataBuffer.putByte(valueType.getErasedSignature().charAt(0));
                this._dataBuffer.putShort(this._typeBuilder.getConstantToken((Boolean)value != false ? 1 : 0));
                break;
            }
            case BYTE: 
            case SHORT: 
            case INT: {
                this._dataBuffer.putByte(valueType.getErasedSignature().charAt(0));
                this._dataBuffer.putShort(this._typeBuilder.getConstantToken(((Number)value).intValue()));
                break;
            }
            case LONG: {
                this._dataBuffer.putByte(valueType.getErasedSignature().charAt(0));
                this._dataBuffer.putShort(this._typeBuilder.getConstantToken(((Number)value).longValue()));
                break;
            }
            case CHAR: {
                this._dataBuffer.putByte(valueType.getErasedSignature().charAt(0));
                this._dataBuffer.putShort(this._typeBuilder.getConstantToken(((Character)value).charValue()));
                break;
            }
            case FLOAT: {
                this._dataBuffer.putByte(valueType.getErasedSignature().charAt(0));
                this._dataBuffer.putShort(this._typeBuilder.getConstantToken(((Number)value).floatValue()));
                break;
            }
            case DOUBLE: {
                this._dataBuffer.putByte(valueType.getErasedSignature().charAt(0));
                this._dataBuffer.putShort(this._typeBuilder.getConstantToken(((Number)value).doubleValue()));
                break;
            }
            case ARRAY: {
                int arrayLength = Array.getLength(value);
                this._dataBuffer.putByte(91);
                this._dataBuffer.putShort(arrayLength);
                for (int i = 0; i < arrayLength; ++i) {
                    this.writeAttributeType(Array.get(value, i));
                }
                break;
            }
            case DECLARED: {
                if (valueType.isEnum()) {
                    this._dataBuffer.putByte(101);
                    this._dataBuffer.putShort(this._typeBuilder.getUtf8StringToken(valueType.getSignature()));
                    this._dataBuffer.putShort(this._typeBuilder.getUtf8StringToken(value.toString()));
                    break;
                }
                if (valueType == Types.String) {
                    this._dataBuffer.putByte(115);
                    this._dataBuffer.putShort(this._typeBuilder.getUtf8StringToken(value.toString()));
                    break;
                }
                if (valueType == Types.Class) {
                    Type type = Type.of((Class)value);
                    this._dataBuffer.putByte(99);
                    this._dataBuffer.putShort(this._typeBuilder.getUtf8StringToken(type.getSignature()));
                    break;
                }
                if (Type.of(Type.class).isAssignableFrom(valueType)) {
                    this._dataBuffer.putByte(99);
                    this._dataBuffer.putShort(this._typeBuilder.getUtf8StringToken(((Type)value).getSignature()));
                    break;
                }
                this._dataBuffer.putByte(64);
                this.writeAnnotation((AnnotationBuilder)value);
            }
        }
    }

    private int writeAttribute(String attributeName) {
        this._dataBuffer.putShort(this._typeBuilder.getUtf8StringToken(attributeName));
        this._dataBuffer.putInt(0);
        return this._dataBuffer.getLength();
    }

    private int beginAttributes() {
        this._dataBuffer.putShort(0);
        return this._dataBuffer.getLength();
    }

    private void endAttributes(int index, int count) {
        this.putChar(this._dataBuffer, index - 2, count);
    }

    private void endAttribute(int index) {
        this.putInt(this._dataBuffer, index - 4, this._dataBuffer.getLength() - index);
    }

    private int writeFlagAttributes(long flags) {
        int count = 0;
        if ((flags & 0x20000L) != 0L) {
            this.endAttribute(this.writeAttribute("Deprecated"));
            ++count;
        }
        if ((flags & 0x4000L) != 0L) {
            this.endAttribute(this.writeAttribute("Enum"));
            ++count;
        }
        if ((flags & 0x1000L) != 0L) {
            this.endAttribute(this.writeAttribute("Synthetic"));
            ++count;
        }
        if ((flags & 0x80000000L) != 0L) {
            this.endAttribute(this.writeAttribute("Bridge"));
            ++count;
        }
        if ((flags & 0x400000000L) != 0L) {
            this.endAttribute(this.writeAttribute("Varargs"));
            ++count;
        }
        if ((flags & 0x2000L) != 0L) {
            this.endAttribute(this.writeAttribute("Annotation"));
            ++count;
        }
        return count;
    }

    void putChar(CodeStream buf, int op, int x) {
        buf.ensureCapacity(op + 2);
        byte[] data = buf.getData();
        data[op] = (byte)(x >> 8 & 0xFF);
        data[op + 1] = (byte)(x & 0xFF);
    }

    void putInt(CodeStream buf, int adr, int x) {
        buf.ensureCapacity(adr + 4);
        byte[] data = buf.getData();
        data[adr] = (byte)(x >> 24 & 0xFF);
        data[adr + 1] = (byte)(x >> 16 & 0xFF);
        data[adr + 2] = (byte)(x >> 8 & 0xFF);
        data[adr + 3] = (byte)(x & 0xFF);
    }

    private static final class LocalInfo {
        final String name;
        final Type<?> type;
        final int position;
        final int start;
        final int end;

        LocalInfo(String name, Type<?> type, int position, int start, int end) {
            this.name = name;
            this.type = type;
            this.position = position;
            this.start = start;
            this.end = end;
        }

        public String toString() {
            return "LocalInfo{name='" + this.name + '\'' + ", type=" + this.type + ", position=" + this.position + ", start=" + this.start + ", end=" + this.end + '}';
        }
    }
}

