/*
 * Decompiled with CFR 0.152.
 */
package com.strobel.reflection;

import com.strobel.annotations.NotNull;
import com.strobel.core.VerifyArgument;
import com.strobel.reflection.ConstructorList;
import com.strobel.reflection.FieldList;
import com.strobel.reflection.Helper;
import com.strobel.reflection.MemberType;
import com.strobel.reflection.MethodList;
import com.strobel.reflection.Type;
import com.strobel.reflection.TypeBinder;
import com.strobel.reflection.TypeBindings;
import com.strobel.reflection.TypeList;
import com.strobel.reflection.TypeMapping;
import com.strobel.reflection.TypeVisitor;
import java.lang.annotation.Annotation;

final class RuntimeType<T>
extends Type<T> {
    static final TypeBinder GenericBinder = new TypeBinder();
    private final Type<?> _reflectedType;
    private final Class<T> _erasedClass;
    private final Type<T> _basedOn;
    private final TypeBindings _typeBindings;
    private final TypeBindings _allBindings;
    private Type<? super T> _baseType;
    private TypeList _interfaces;
    private FieldList _fields;
    private ConstructorList _constructors;
    private MethodList _methods;
    private TypeList _nestedTypes;

    RuntimeType(Type<?> reflectedType, Type<T> basedOn, TypeBindings allBindings) {
        this._reflectedType = (Type)VerifyArgument.notNull(reflectedType, (String)"reflectedType");
        this._allBindings = (TypeBindings)VerifyArgument.notNull((Object)allBindings, (String)"allBindings");
        this._erasedClass = basedOn.getErasedClass();
        this._basedOn = (Type)VerifyArgument.notNull(basedOn, (String)"basedOn");
        this._typeBindings = basedOn.getTypeBindings();
    }

    @Override
    public Type getReflectedType() {
        return this._reflectedType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureBaseType() {
        if (this._baseType == null) {
            Object object = CACHE_LOCK;
            synchronized (object) {
                if (this._baseType == null) {
                    Type<T> genericBaseType = this._basedOn.getBaseType();
                    this._baseType = genericBaseType == null || genericBaseType == NullType ? NullType : (Type)GenericBinder.visit(genericBaseType, this._allBindings);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureInterfaces() {
        if (this._interfaces == null) {
            Object object = CACHE_LOCK;
            synchronized (object) {
                if (this._interfaces == null) {
                    this._interfaces = GenericBinder.visit(this._basedOn.getExplicitInterfaces(), this._allBindings);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureFields() {
        if (this._fields == null) {
            Object object = CACHE_LOCK;
            synchronized (object) {
                if (this._fields == null) {
                    this._fields = GenericBinder.visit(this, this._basedOn.getDeclaredFields(), this._allBindings);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureConstructors() {
        if (this._constructors == null) {
            Object object = CACHE_LOCK;
            synchronized (object) {
                if (this._constructors == null) {
                    this._constructors = GenericBinder.visit(this, this._basedOn.getDeclaredConstructors(), this._allBindings);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureMethods() {
        if (this._methods == null) {
            Object object = CACHE_LOCK;
            synchronized (object) {
                if (this._methods == null) {
                    this._methods = GenericBinder.visit(this, this._basedOn.getDeclaredMethods(), this._allBindings);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureNestedTypes() {
        if (this._nestedTypes == null) {
            Object object = CACHE_LOCK;
            synchronized (object) {
                if (this._nestedTypes == null) {
                    this._nestedTypes = Helper.map(this._basedOn.getDeclaredTypes(), new TypeMapping(){

                        public Type<?> apply(Type<?> type) {
                            return new RuntimeType(RuntimeType.this, type, RuntimeType.this._allBindings);
                        }
                    });
                }
            }
        }
    }

    @Override
    public Class<T> getErasedClass() {
        return this._erasedClass;
    }

    @Override
    public TypeList getExplicitInterfaces() {
        this.ensureInterfaces();
        return this._interfaces;
    }

    @Override
    public Type<? super T> getBaseType() {
        this.ensureBaseType();
        Type<? super T> baseType = this._baseType;
        return baseType == NullType ? null : baseType;
    }

    @Override
    public Type getGenericTypeDefinition() {
        return this._basedOn;
    }

    @Override
    public MemberType getMemberType() {
        return MemberType.TypeInfo;
    }

    @Override
    public Type getDeclaringType() {
        return this._basedOn.getDeclaringType();
    }

    @Override
    public final boolean isGenericType() {
        return true;
    }

    @Override
    public TypeBindings getTypeBindings() {
        return this._typeBindings;
    }

    @Override
    public int getModifiers() {
        return this._basedOn.getModifiers();
    }

    @Override
    public boolean isAnnotationPresent(Class<? extends Annotation> annotationClass) {
        return this._basedOn.isAnnotationPresent(annotationClass);
    }

    @Override
    public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
        return this._basedOn.getAnnotation(annotationClass);
    }

    @Override
    @NotNull
    public Annotation[] getAnnotations() {
        return this._basedOn.getAnnotations();
    }

    @Override
    @NotNull
    public Annotation[] getDeclaredAnnotations() {
        return this._basedOn.getDeclaredAnnotations();
    }

    @Override
    public <P, R> R accept(TypeVisitor<P, R> typeVisitor, P parameter) {
        return typeVisitor.visitClassType(this, parameter);
    }

    @Override
    protected ConstructorList getDeclaredConstructors() {
        this.ensureConstructors();
        return this._constructors;
    }

    @Override
    protected MethodList getDeclaredMethods() {
        this.ensureMethods();
        return this._methods;
    }

    @Override
    protected FieldList getDeclaredFields() {
        this.ensureFields();
        return this._fields;
    }

    @Override
    protected TypeList getDeclaredTypes() {
        this.ensureNestedTypes();
        return this._nestedTypes;
    }

    @Override
    public boolean isEquivalentTo(Type other) {
        if (other == this) {
            return true;
        }
        if (other instanceof RuntimeType) {
            return this.isEquivalentTo((Type)((RuntimeType)other)._basedOn);
        }
        return this._basedOn.isEquivalentTo(other);
    }
}

