/*
 * Decompiled with CFR 0.152.
 */
package com.strobel.expressions;

import com.strobel.expressions.ConstantExpression;
import com.strobel.expressions.Expression;
import com.strobel.expressions.ExpressionType;
import com.strobel.expressions.ExpressionVisitor;
import com.strobel.expressions.MethodCallExpression;
import com.strobel.expressions.ParameterExpression;
import com.strobel.expressions.ParameterExpressionList;
import com.strobel.reflection.PrimitiveTypes;
import com.strobel.reflection.Type;
import com.strobel.reflection.Types;
import com.strobel.util.TypeUtils;

public final class TypeBinaryExpression
extends Expression {
    private final Expression _operand;
    private final Type _typeOperand;
    private final ExpressionType _nodeType;

    TypeBinaryExpression(Expression operand, Type typeOperand, ExpressionType nodeType) {
        this._operand = operand;
        this._typeOperand = typeOperand;
        this._nodeType = nodeType;
    }

    public final Expression getOperand() {
        return this._operand;
    }

    public final Type getTypeOperand() {
        return this._typeOperand;
    }

    @Override
    public final ExpressionType getNodeType() {
        return this._nodeType;
    }

    @Override
    public final Type<?> getType() {
        return PrimitiveTypes.Boolean;
    }

    @Override
    public final boolean canReduce() {
        return this._nodeType == ExpressionType.TypeEqual;
    }

    @Override
    public final Expression reduce() {
        if (this._nodeType == ExpressionType.TypeEqual) {
            return this.reduceTypeEqual();
        }
        return this;
    }

    private Expression reduceConstantTypeEqual() {
        Object constantValue = ((ConstantExpression)this._operand).getValue();
        if (constantValue == null) {
            return TypeBinaryExpression.constant(false);
        }
        return TypeBinaryExpression.constant(this._typeOperand.getErasedClass().isInstance(constantValue));
    }

    private Expression reduceParameterTypeEqual(ParameterExpression value) {
        MethodCallExpression getClass = TypeBinaryExpression.call((Expression)value, value.getType().getMethod("getClass", new Type[0]), new Expression[0]);
        return TypeBinaryExpression.andAlso((Expression)TypeBinaryExpression.referenceNotEqual(value, TypeBinaryExpression.constant(null)), (Expression)TypeBinaryExpression.referenceEqual(getClass, TypeBinaryExpression.constant(this._typeOperand.getErasedClass())));
    }

    final Expression reduceTypeEqual() {
        Type<?> cType = this._operand.getType();
        if (this._operand.getNodeType() == ExpressionType.Constant) {
            return this.reduceConstantTypeEqual();
        }
        if (cType.isPrimitive()) {
            return Expression.block(this._operand, (Expression)TypeBinaryExpression.constant(TypeUtils.hasIdentityPrimitiveOrBoxingConversion(cType, (Type)this._typeOperand)));
        }
        if (cType.isFinal() && TypeUtils.areEquivalent(cType, (Type)this._typeOperand)) {
            return TypeBinaryExpression.isNotNull(this._operand);
        }
        if (this._operand instanceof ParameterExpression) {
            return this.reduceParameterTypeEqual((ParameterExpression)this._operand);
        }
        ParameterExpression parameter = TypeBinaryExpression.variable(Types.Object);
        Expression operand = this._operand;
        if (!TypeUtils.areReferenceAssignable((Type)Types.Object, cType)) {
            operand = TypeBinaryExpression.convert(operand, Types.Object);
        }
        return TypeBinaryExpression.block(new ParameterExpressionList(parameter), TypeBinaryExpression.assign(parameter, operand), this.reduceParameterTypeEqual(parameter));
    }

    @Override
    protected final Expression accept(ExpressionVisitor visitor) {
        return visitor.visitTypeBinary(this);
    }

    public final TypeBinaryExpression update(Expression operand) {
        if (operand == this.getOperand()) {
            return this;
        }
        if (this.getNodeType() == ExpressionType.InstanceOf) {
            return TypeBinaryExpression.instanceOf(operand, this.getTypeOperand());
        }
        return TypeBinaryExpression.typeEqual(operand, this.getTypeOperand());
    }
}

