/*
 * Decompiled with CFR 0.152.
 */
package com.strobel.decompiler.ast;

import com.strobel.annotations.NotNull;
import com.strobel.assembler.flowanalysis.ControlFlowEdge;
import com.strobel.assembler.flowanalysis.ControlFlowGraph;
import com.strobel.assembler.flowanalysis.ControlFlowNode;
import com.strobel.assembler.flowanalysis.ControlFlowNodeType;
import com.strobel.assembler.flowanalysis.JumpType;
import com.strobel.assembler.metadata.SwitchInfo;
import com.strobel.core.ArrayUtilities;
import com.strobel.core.CollectionUtilities;
import com.strobel.core.Pair;
import com.strobel.core.Predicate;
import com.strobel.core.StrongBox;
import com.strobel.decompiler.DecompilerContext;
import com.strobel.decompiler.ast.AstCode;
import com.strobel.decompiler.ast.AstKeys;
import com.strobel.decompiler.ast.AstOptimizer;
import com.strobel.decompiler.ast.BasicBlock;
import com.strobel.decompiler.ast.Block;
import com.strobel.decompiler.ast.CaseBlock;
import com.strobel.decompiler.ast.CatchBlock;
import com.strobel.decompiler.ast.Condition;
import com.strobel.decompiler.ast.Expression;
import com.strobel.decompiler.ast.Label;
import com.strobel.decompiler.ast.Loop;
import com.strobel.decompiler.ast.LoopType;
import com.strobel.decompiler.ast.Node;
import com.strobel.decompiler.ast.PatternMatching;
import com.strobel.decompiler.ast.Switch;
import com.strobel.decompiler.ast.TryCatchBlock;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;

final class LoopsAndConditions {
    private final Map<Label, ControlFlowNode> labelsToNodes = new IdentityHashMap<Label, ControlFlowNode>();
    private final DecompilerContext context;
    private int _nextLabelIndex;

    LoopsAndConditions(DecompilerContext context) {
        this.context = context;
    }

    public final void findConditions(Block block) {
        List<Node> body = block.getBody();
        if (body.isEmpty() || block.getEntryGoto() == null) {
            return;
        }
        ControlFlowGraph graph = this.buildGraph(body, (Label)block.getEntryGoto().getOperand());
        graph.computeDominance();
        graph.computeDominanceFrontier();
        LinkedHashSet<ControlFlowNode> cfNodes = new LinkedHashSet<ControlFlowNode>();
        List<ControlFlowNode> graphNodes = graph.getNodes();
        for (int i = 3; i < graphNodes.size(); ++i) {
            cfNodes.add(graphNodes.get(i));
        }
        List<Node> newBody = this.findConditions(cfNodes, graph.getEntryPoint());
        block.getBody().clear();
        block.getBody().addAll(newBody);
    }

    public final void findLoops(Block block) {
        List<Node> body = block.getBody();
        if (body.isEmpty() || block.getEntryGoto() == null) {
            return;
        }
        ControlFlowGraph graph = this.buildGraph(body, (Label)block.getEntryGoto().getOperand());
        graph.computeDominance();
        graph.computeDominanceFrontier();
        LinkedHashSet<ControlFlowNode> cfNodes = new LinkedHashSet<ControlFlowNode>();
        List<ControlFlowNode> graphNodes = graph.getNodes();
        for (int i = 3; i < graphNodes.size(); ++i) {
            cfNodes.add(graphNodes.get(i));
        }
        List<Node> newBody = this.findLoops(cfNodes, graph.getEntryPoint(), false);
        block.getBody().clear();
        block.getBody().addAll(newBody);
    }

    private ControlFlowGraph buildGraph(List<Node> nodes, Label entryLabel) {
        int index = 0;
        ArrayList<ControlFlowNode> cfNodes = new ArrayList<ControlFlowNode>();
        ControlFlowNode entryPoint = new ControlFlowNode(index++, 0, ControlFlowNodeType.EntryPoint);
        ControlFlowNode regularExit = new ControlFlowNode(index++, -1, ControlFlowNodeType.RegularExit);
        ControlFlowNode exceptionalExit = new ControlFlowNode(index++, -1, ControlFlowNodeType.ExceptionalExit);
        cfNodes.add(entryPoint);
        cfNodes.add(regularExit);
        cfNodes.add(exceptionalExit);
        this.labelsToNodes.clear();
        IdentityHashMap<Node, ControlFlowNode> astNodesToControlFlowNodes = new IdentityHashMap<Node, ControlFlowNode>();
        for (Node node : nodes) {
            ControlFlowNode cfNode = new ControlFlowNode(index++, -1, ControlFlowNodeType.Normal);
            cfNodes.add(cfNode);
            astNodesToControlFlowNodes.put(node, cfNode);
            cfNode.setUserData(node);
            for (Label label : node.getSelfAndChildrenRecursive(Label.class)) {
                this.labelsToNodes.put(label, cfNode);
            }
        }
        ControlFlowNode entryNode = this.labelsToNodes.get(entryLabel);
        ControlFlowEdge entryEdge = new ControlFlowEdge(entryPoint, entryNode, JumpType.Normal);
        entryPoint.getOutgoing().add(entryEdge);
        entryNode.getIncoming().add(entryEdge);
        for (Node node : nodes) {
            ControlFlowNode source = (ControlFlowNode)astNodesToControlFlowNodes.get(node);
            for (Expression e : node.getSelfAndChildrenRecursive(Expression.class)) {
                if (!e.isBranch()) continue;
                for (Label target : e.getBranchTargets()) {
                    ControlFlowNode destination = this.labelsToNodes.get(target);
                    if (destination == null || destination == source && !this.canBeSelfContainedLoop((BasicBlock)node, e, target)) continue;
                    ControlFlowEdge edge = new ControlFlowEdge(source, destination, JumpType.Normal);
                    if (!source.getOutgoing().contains(edge)) {
                        source.getOutgoing().add(edge);
                    }
                    if (destination.getIncoming().contains(edge)) continue;
                    destination.getIncoming().add(edge);
                }
            }
        }
        return new ControlFlowGraph(cfNodes.toArray(new ControlFlowNode[cfNodes.size()]));
    }

    private boolean canBeSelfContainedLoop(BasicBlock node, Expression branch, final Label target) {
        List<Node> nodeBody = node.getBody();
        if (target == null || nodeBody.isEmpty()) {
            return false;
        }
        if (target == nodeBody.get(0)) {
            return true;
        }
        Node secondNode = (Node)CollectionUtilities.getOrDefault(nodeBody, (int)1);
        if (secondNode instanceof TryCatchBlock) {
            Node next = (Node)CollectionUtilities.getOrDefault(nodeBody, (int)2);
            if (next != branch) {
                return false;
            }
            TryCatchBlock tryCatch = (TryCatchBlock)secondNode;
            final Block tryBlock = tryCatch.getTryBlock();
            Predicate<Expression> labelMatch = new Predicate<Expression>(){

                public boolean test(Expression e) {
                    return e != tryBlock.getEntryGoto() && e.getBranchTargets().contains(target);
                }
            };
            for (CatchBlock catchBlock : tryCatch.getCatchBlocks()) {
                if (!CollectionUtilities.any(catchBlock.getSelfAndChildrenRecursive(Expression.class), (Predicate)labelMatch)) continue;
                return true;
            }
            if (tryCatch.getFinallyBlock() != null && CollectionUtilities.any(tryCatch.getFinallyBlock().getSelfAndChildrenRecursive(Expression.class), (Predicate)labelMatch)) {
                return true;
            }
            return true;
        }
        return false;
    }

    private List<Node> findLoops(Set<ControlFlowNode> scopeNodes, ControlFlowNode entryPoint, boolean excludeEntryPoint) {
        ArrayList<Node> result = new ArrayList<Node>();
        StrongBox switchLabels = new StrongBox();
        LinkedHashSet<ControlFlowNode> scope = new LinkedHashSet<ControlFlowNode>(scopeNodes);
        ArrayDeque<ControlFlowNode> agenda = new ArrayDeque<ControlFlowNode>();
        agenda.addLast(entryPoint);
        while (!agenda.isEmpty()) {
            ControlFlowNode node = (ControlFlowNode)agenda.pollFirst();
            if (scope.contains(node) && node.getDominanceFrontier().contains(node) && (node != entryPoint || !excludeEntryPoint)) {
                Object basicBlockBody;
                Set<ControlFlowNode> loopContents = LoopsAndConditions.findLoopContents(scope, node);
                BasicBlock basicBlock = (BasicBlock)node.getUserData();
                StrongBox condition = new StrongBox();
                StrongBox trueLabel = new StrongBox();
                StrongBox falseLabel = new StrongBox();
                ControlFlowNode lastInLoop = (ControlFlowNode)CollectionUtilities.lastOrDefault((Iterable)loopContents);
                BasicBlock lastBlock = (BasicBlock)lastInLoop.getUserData();
                if (loopContents.size() == 1 && PatternMatching.matchSimpleBreak(basicBlock, (StrongBox<Label>)trueLabel) && trueLabel.get() == CollectionUtilities.first(basicBlock.getBody())) {
                    Loop emptyLoop = new Loop();
                    emptyLoop.setBody(new Block());
                    BasicBlock block = new BasicBlock();
                    List<Node> blockBody = block.getBody();
                    blockBody.add(basicBlock.getBody().get(0));
                    blockBody.add(emptyLoop);
                    result.add(block);
                    scope.remove(lastInLoop);
                    continue;
                }
                for (int pass = 0; pass < 2; ++pass) {
                    BasicBlock block;
                    boolean canWriteConditionalLoop;
                    boolean flipped;
                    boolean foundCondition;
                    boolean isPostCondition = pass == 1;
                    boolean bl = foundCondition = isPostCondition ? PatternMatching.matchLastAndBreak(lastBlock, AstCode.IfTrue, trueLabel, (StrongBox<Expression>)condition, (StrongBox<Label>)falseLabel) : PatternMatching.matchSingleAndBreak(basicBlock, AstCode.IfTrue, trueLabel, (StrongBox<Expression>)condition, (StrongBox<Label>)falseLabel);
                    if (!foundCondition) continue;
                    ControlFlowNode trueTarget = this.labelsToNodes.get(trueLabel.get());
                    ControlFlowNode falseTarget = this.labelsToNodes.get(falseLabel.get());
                    if ((!loopContents.contains(falseTarget) || loopContents.contains(trueTarget)) && (!loopContents.contains(trueTarget) || loopContents.contains(falseTarget))) continue;
                    boolean bl2 = flipped = loopContents.contains(falseTarget) || falseTarget == node;
                    if (flipped) {
                        Label temp = (Label)trueLabel.get();
                        trueLabel.set(falseLabel.get());
                        falseLabel.set((Object)temp);
                        condition.set((Object)AstOptimizer.simplifyLogicalNot(new Expression(AstCode.LogicalNot, null, ((Expression)condition.get()).getOffset(), (Expression)condition.get())));
                    }
                    if (isPostCondition) {
                        Expression continueGoto = flipped ? (Expression)CollectionUtilities.last(lastBlock.getBody()) : (Expression)lastBlock.getBody().get(lastBlock.getBody().size() - 2);
                        canWriteConditionalLoop = this.countJumps(loopContents, (Label)trueLabel.get(), continueGoto) == 0;
                    } else {
                        canWriteConditionalLoop = true;
                    }
                    if (!canWriteConditionalLoop) continue;
                    AstOptimizer.removeOrThrow(loopContents, node);
                    AstOptimizer.removeOrThrow(scope, node);
                    ControlFlowNode postLoopTarget = this.labelsToNodes.get(falseLabel.get());
                    if (postLoopTarget != null) {
                        Set<ControlFlowNode> postLoopContents = LoopsAndConditions.findDominatedNodes(scope, postLoopTarget);
                        LinkedHashSet<ControlFlowNode> pullIn = new LinkedHashSet<ControlFlowNode>(scope);
                        pullIn.removeAll(postLoopContents);
                        for (ControlFlowNode n : pullIn) {
                            if (!node.dominates(n)) continue;
                            loopContents.add(n);
                        }
                    }
                    if (isPostCondition) {
                        Label loopLabel;
                        block = new BasicBlock();
                        basicBlockBody = block.getBody();
                        AstOptimizer.removeTail(lastBlock.getBody(), AstCode.IfTrue, AstCode.Goto);
                        if (lastBlock.getBody().size() > 1) {
                            lastBlock.getBody().add(new Expression(AstCode.Goto, trueLabel.get(), -34, new Expression[0]));
                            loopLabel = new Label("Loop_" + this._nextLabelIndex++);
                        } else {
                            scope.remove(lastInLoop);
                            loopContents.remove(lastInLoop);
                            loopLabel = (Label)lastBlock.getBody().get(0);
                        }
                        basicBlockBody.add(loopLabel);
                    } else {
                        block = basicBlock;
                        basicBlockBody = block.getBody();
                        AstOptimizer.removeTail(basicBlockBody, new AstCode[]{AstCode.IfTrue, AstCode.Goto});
                    }
                    Loop loop = new Loop();
                    Block bodyBlock = new Block();
                    loop.setCondition((Expression)condition.get());
                    loop.setBody(bodyBlock);
                    if (isPostCondition) {
                        loop.setLoopType(LoopType.PostCondition);
                        bodyBlock.getBody().add(basicBlock);
                    }
                    bodyBlock.setEntryGoto(new Expression(AstCode.Goto, trueLabel.get(), -34, new Expression[0]));
                    bodyBlock.getBody().addAll(this.findLoops(loopContents, node, isPostCondition));
                    basicBlockBody.add(loop);
                    if (isPostCondition) {
                        basicBlockBody.add(new Expression(AstCode.Goto, falseLabel.get(), -34, new Expression[0]));
                    } else {
                        basicBlockBody.add(new Expression(AstCode.Goto, falseLabel.get(), -34, new Expression[0]));
                    }
                    result.add(block);
                    scope.removeAll(loopContents);
                    break;
                }
                if (scope.contains(node)) {
                    BasicBlock block = new BasicBlock();
                    List<Node> blockBody = block.getBody();
                    Loop loop = new Loop();
                    Block bodyBlock = new Block();
                    loop.setBody(bodyBlock);
                    LoopExitInfo exitInfo = this.findLoopExitInfo(loopContents);
                    if (exitInfo.exitLabel != null) {
                        BasicBlock b;
                        ControlFlowNode predecessor;
                        ControlFlowNode postLoopTarget = this.labelsToNodes.get(exitInfo.exitLabel);
                        if (postLoopTarget.getIncoming().size() == 1 && (predecessor = (ControlFlowNode)CollectionUtilities.firstOrDefault(postLoopTarget.getPredecessors())) != null && loopContents.contains(predecessor) && PatternMatching.matchLast(b = (BasicBlock)predecessor.getUserData(), AstCode.Switch, switchLabels, (StrongBox<Expression>)condition) && !ArrayUtilities.isNullOrEmpty((Object[])((Object[])switchLabels.get())) && exitInfo.exitLabel == ((Label[])switchLabels.get())[0]) {
                            Set<ControlFlowNode> defaultContents = LoopsAndConditions.findDominatedNodes(scope, postLoopTarget);
                            basicBlockBody = defaultContents.iterator();
                            while (basicBlockBody.hasNext()) {
                                ControlFlowNode n = (ControlFlowNode)basicBlockBody.next();
                                if (!scope.contains(n) || !node.dominates(n)) continue;
                                loopContents.add(n);
                            }
                        }
                        if (!loopContents.contains(postLoopTarget)) {
                            Set<ControlFlowNode> postLoopContents = LoopsAndConditions.findDominatedNodes(scope, postLoopTarget);
                            LinkedHashSet<ControlFlowNode> pullIn = new LinkedHashSet<ControlFlowNode>(scope);
                            pullIn.removeAll(postLoopContents);
                            for (ControlFlowNode n : pullIn) {
                                if (n.getBlockIndex() >= postLoopTarget.getBlockIndex() || !scope.contains(n) || !node.dominates(n)) continue;
                                loopContents.add(n);
                            }
                        }
                    } else if (exitInfo.additionalNodes.size() == 1) {
                        BasicBlock b;
                        ControlFlowNode postLoopTarget = (ControlFlowNode)CollectionUtilities.first(exitInfo.additionalNodes);
                        BasicBlock postLoopBlock = (BasicBlock)postLoopTarget.getUserData();
                        Node postLoopBlockHead = (Node)CollectionUtilities.firstOrDefault(postLoopBlock.getBody());
                        ControlFlowNode predecessor = (ControlFlowNode)CollectionUtilities.single(postLoopTarget.getPredecessors());
                        if (postLoopBlockHead instanceof Label && loopContents.contains(predecessor) && PatternMatching.matchLast(b = (BasicBlock)predecessor.getUserData(), AstCode.Switch, switchLabels, (StrongBox<Expression>)condition) && !ArrayUtilities.isNullOrEmpty((Object[])((Object[])switchLabels.get())) && postLoopBlockHead == ((Label[])switchLabels.get())[0]) {
                            Set<ControlFlowNode> defaultContents = LoopsAndConditions.findDominatedNodes(scope, postLoopTarget);
                            for (ControlFlowNode n : defaultContents) {
                                if (!scope.contains(n) || !node.dominates(n)) continue;
                                loopContents.add(n);
                            }
                        }
                    } else if (exitInfo.additionalNodes.size() > 1) {
                        LinkedHashSet<ControlFlowNode> auxNodes = new LinkedHashSet<ControlFlowNode>();
                        for (ControlFlowNode n : exitInfo.additionalNodes) {
                            if (!scope.contains(n) || !node.dominates(n)) continue;
                            auxNodes.addAll(LoopsAndConditions.findDominatedNodes(scope, n));
                        }
                        List sortedNodes = CollectionUtilities.toList(auxNodes);
                        Collections.sort(sortedNodes);
                        loopContents.addAll(sortedNodes);
                    }
                    bodyBlock.setEntryGoto(new Expression(AstCode.Goto, (Object)basicBlock.getBody().get(0), -34, new Expression[0]));
                    bodyBlock.getBody().addAll(this.findLoops(loopContents, node, true));
                    blockBody.add(new Label("Loop_" + this._nextLabelIndex++));
                    blockBody.add(loop);
                    result.add(block);
                    scope.removeAll(loopContents);
                }
            }
            for (ControlFlowNode child : node.getDominatorTreeChildren()) {
                agenda.addLast(child);
            }
        }
        for (ControlFlowNode node : scope) {
            result.add((Node)node.getUserData());
        }
        scope.clear();
        return result;
    }

    private LoopExitInfo findLoopExitInfo(Set<ControlFlowNode> contents) {
        LoopExitInfo exitInfo = new LoopExitInfo();
        boolean noCommonExit = false;
        for (ControlFlowNode node : contents) {
            BasicBlock basicBlock = (BasicBlock)node.getUserData();
            for (Expression e : basicBlock.getSelfAndChildrenRecursive(Expression.class)) {
                for (Label target : e.getBranchTargets()) {
                    ControlFlowNode targetNode = this.labelsToNodes.get(target);
                    if (targetNode == null || contents.contains(targetNode)) continue;
                    if (targetNode.getIncoming().size() == 1) {
                        exitInfo.additionalNodes.add(targetNode);
                        continue;
                    }
                    if (exitInfo.exitLabel == null) {
                        exitInfo.exitLabel = target;
                        continue;
                    }
                    if (exitInfo.exitLabel == target) continue;
                    noCommonExit = true;
                }
            }
        }
        if (noCommonExit) {
            exitInfo.exitLabel = null;
        }
        return exitInfo;
    }

    private int countJumps(Set<ControlFlowNode> nodes, Label target, Expression ignore) {
        int jumpCount = 0;
        for (ControlFlowNode node : nodes) {
            BasicBlock basicBlock = (BasicBlock)node.getUserData();
            for (Expression e : basicBlock.getSelfAndChildrenRecursive(Expression.class)) {
                if (e == ignore || !e.getBranchTargets().contains(target)) continue;
                ++jumpCount;
            }
        }
        return jumpCount;
    }

    private static Set<ControlFlowNode> findLoopContents(Set<ControlFlowNode> scope, ControlFlowNode head) {
        LinkedHashSet<ControlFlowNode> viaBackEdges = new LinkedHashSet<ControlFlowNode>();
        for (ControlFlowNode predecessor : head.getPredecessors()) {
            if (!head.dominates(predecessor)) continue;
            viaBackEdges.add(predecessor);
        }
        LinkedHashSet<ControlFlowNode> agenda = new LinkedHashSet<ControlFlowNode>(viaBackEdges);
        LinkedHashSet<ControlFlowNode> result = new LinkedHashSet<ControlFlowNode>();
        while (!agenda.isEmpty()) {
            ControlFlowNode addNode = (ControlFlowNode)agenda.iterator().next();
            agenda.remove(addNode);
            if (!scope.contains(addNode) || !head.dominates(addNode) || !result.add(addNode)) continue;
            for (ControlFlowNode predecessor : addNode.getPredecessors()) {
                agenda.add(predecessor);
            }
        }
        if (scope.contains(head)) {
            result.add(head);
        }
        if (result.size() <= 1) {
            return result;
        }
        ArrayList<ControlFlowNode> sortedResult = new ArrayList<ControlFlowNode>(result);
        Collections.sort(sortedResult, new Comparator<ControlFlowNode>(){

            @Override
            public int compare(@NotNull ControlFlowNode o1, @NotNull ControlFlowNode o2) {
                return Integer.compare(o1.getBlockIndex(), o2.getBlockIndex());
            }
        });
        result.clear();
        result.addAll(sortedResult);
        return result;
    }

    private List<Node> findConditions(Set<ControlFlowNode> scopeNodes, ControlFlowNode entryNode) {
        ArrayList<Node> result = new ArrayList<Node>();
        HashSet<ControlFlowNode> scope = new HashSet<ControlFlowNode>(scopeNodes);
        Stack<ControlFlowNode> agenda = new Stack<ControlFlowNode>();
        agenda.push(entryNode);
        while (!agenda.isEmpty()) {
            ControlFlowNode node = (ControlFlowNode)agenda.pop();
            if (node == null) continue;
            if (scope.contains(node)) {
                StrongBox falseLabel;
                StrongBox condition;
                StrongBox trueLabel;
                BasicBlock block = (BasicBlock)node.getUserData();
                List<Node> blockBody = block.getBody();
                StrongBox caseLabels = new StrongBox();
                StrongBox switchArgument = new StrongBox();
                StrongBox tempTarget = new StrongBox();
                if (PatternMatching.matchLast(block, AstCode.Switch, caseLabels, (StrongBox<Expression>)switchArgument)) {
                    Expression switchExpression = (Expression)blockBody.get(blockBody.size() - 1);
                    Switch switchNode = new Switch();
                    switchNode.setCondition((Expression)switchArgument.get());
                    AstOptimizer.removeTail(blockBody, AstCode.Switch);
                    blockBody.add(switchNode);
                    result.add(block);
                    AstOptimizer.removeOrThrow(scope, node);
                    Object[] labels = (Label[])caseLabels.get();
                    SwitchInfo switchInfo = switchExpression.getUserData(AstKeys.SWITCH_INFO);
                    int lowValue = switchInfo.getLowValue();
                    int[] keys = switchInfo.getKeys();
                    Label defaultLabel = labels[0];
                    ControlFlowNode defaultTarget = this.labelsToNodes.get(defaultLabel);
                    boolean defaultFollowsSwitch = false;
                    for (int i = 1; i < labels.length; ++i) {
                        Label caseLabel = labels[i];
                        if (caseLabel == defaultLabel) continue;
                        CaseBlock caseBlock = null;
                        for (CaseBlock cb : switchNode.getCaseBlocks()) {
                            if (cb.getEntryGoto().getOperand() != caseLabel) continue;
                            caseBlock = cb;
                            break;
                        }
                        if (caseBlock == null) {
                            caseBlock = new CaseBlock();
                            caseBlock.setEntryGoto(new Expression(AstCode.Goto, (Object)caseLabel, -34, new Expression[0]));
                            ControlFlowNode caseTarget = this.labelsToNodes.get(caseLabel);
                            List<Node> caseBody = caseBlock.getBody();
                            switchNode.getCaseBlocks().add(caseBlock);
                            if (caseTarget != null) {
                                if (caseTarget.getDominanceFrontier().contains(defaultTarget)) {
                                    defaultFollowsSwitch = true;
                                }
                                Set<ControlFlowNode> content = LoopsAndConditions.findDominatedNodes(scope, caseTarget);
                                scope.removeAll(content);
                                caseBody.addAll(this.findConditions(content, caseTarget));
                            } else {
                                BasicBlock explicitGoto = new BasicBlock();
                                explicitGoto.getBody().add(new Label("SwitchGoto_" + this._nextLabelIndex++));
                                explicitGoto.getBody().add(new Expression(AstCode.Goto, (Object)caseLabel, -34, new Expression[0]));
                                caseBody.add(explicitGoto);
                            }
                            if (caseBody.isEmpty() || !PatternMatching.matchLast((BasicBlock)caseBody.get(caseBody.size() - 1), AstCode.Goto, tempTarget) || !ArrayUtilities.contains((Object[])labels, (Object)tempTarget.get())) {
                                BasicBlock explicitBreak = new BasicBlock();
                                explicitBreak.getBody().add(new Label("SwitchBreak_" + this._nextLabelIndex++));
                                explicitBreak.getBody().add(new Expression(AstCode.LoopOrSwitchBreak, null, -34, new Expression[0]));
                                caseBody.add(explicitBreak);
                            }
                        }
                        if (switchInfo.hasKeys()) {
                            caseBlock.getValues().add(keys[i - 1]);
                            continue;
                        }
                        caseBlock.getValues().add(lowValue + i - 1);
                    }
                    if (!defaultFollowsSwitch) {
                        CaseBlock defaultBlock = new CaseBlock();
                        defaultBlock.setEntryGoto(new Expression(AstCode.Goto, (Object)defaultLabel, -34, new Expression[0]));
                        switchNode.getCaseBlocks().add(defaultBlock);
                        Set<ControlFlowNode> content = LoopsAndConditions.findDominatedNodes(scope, defaultTarget);
                        scope.removeAll(content);
                        defaultBlock.getBody().addAll(this.findConditions(content, defaultTarget));
                        BasicBlock explicitBreak = new BasicBlock();
                        explicitBreak.getBody().add(new Label("SwitchBreak_" + this._nextLabelIndex++));
                        explicitBreak.getBody().add(new Expression(AstCode.LoopOrSwitchBreak, null, -34, new Expression[0]));
                        defaultBlock.getBody().add(explicitBreak);
                    }
                    this.reorderCaseBlocks(switchNode);
                }
                if (PatternMatching.matchLastAndBreak(block, AstCode.IfTrue, trueLabel = new StrongBox(), (StrongBox<Expression>)(condition = new StrongBox()), (StrongBox<Label>)(falseLabel = new StrongBox()))) {
                    Label temp = (Label)trueLabel.get();
                    trueLabel.set(falseLabel.get());
                    falseLabel.set((Object)temp);
                    condition.set((Object)AstOptimizer.simplifyLogicalNot(new Expression(AstCode.LogicalNot, null, ((Expression)condition.get()).getOffset(), (Expression)condition.get())));
                    Condition conditionNode = new Condition();
                    Block trueBlock = new Block();
                    Block falseBlock = new Block();
                    conditionNode.setCondition((Expression)condition.get());
                    conditionNode.setTrueBlock(trueBlock);
                    conditionNode.setFalseBlock(falseBlock);
                    AstOptimizer.removeTail(blockBody, AstCode.IfTrue, AstCode.Goto);
                    blockBody.add(conditionNode);
                    result.add(block);
                    AstOptimizer.removeOrThrow(scope, node);
                    if (falseLabel.get() != trueLabel.get()) {
                        trueBlock.setEntryGoto(new Expression(AstCode.Goto, trueLabel.get(), -34, new Expression[0]));
                        falseBlock.setEntryGoto(new Expression(AstCode.Goto, falseLabel.get(), -34, new Expression[0]));
                        ControlFlowNode trueTarget = this.labelsToNodes.get(trueLabel.get());
                        ControlFlowNode falseTarget = this.labelsToNodes.get(falseLabel.get());
                        if (trueTarget != null && LoopsAndConditions.hasSingleEdgeEnteringBlock(trueTarget)) {
                            Set<ControlFlowNode> content = LoopsAndConditions.findDominatedNodes(scope, trueTarget);
                            scope.removeAll(content);
                            conditionNode.getTrueBlock().getBody().addAll(this.findConditions(content, trueTarget));
                        }
                        if (falseTarget != null && LoopsAndConditions.hasSingleEdgeEnteringBlock(falseTarget)) {
                            Set<ControlFlowNode> content = LoopsAndConditions.findDominatedNodes(scope, falseTarget);
                            scope.removeAll(content);
                            conditionNode.getFalseBlock().getBody().addAll(this.findConditions(content, falseTarget));
                        }
                    }
                }
                if (scope.contains(node)) {
                    result.add((Node)node.getUserData());
                    scope.remove(node);
                }
            }
            List<ControlFlowNode> dominatorTreeChildren = node.getDominatorTreeChildren();
            for (int i = dominatorTreeChildren.size() - 1; i >= 0; --i) {
                agenda.push(dominatorTreeChildren.get(i));
            }
        }
        for (ControlFlowNode node : scope) {
            result.add((Node)node.getUserData());
        }
        return result;
    }

    private void reorderCaseBlocks(Switch switchNode) {
        Collections.sort(switchNode.getCaseBlocks(), new Comparator<CaseBlock>(){

            @Override
            public int compare(@NotNull CaseBlock o1, @NotNull CaseBlock o2) {
                Label l1 = (Label)o1.getEntryGoto().getOperand();
                Label l2 = (Label)o2.getEntryGoto().getOperand();
                return Integer.compare(l1.getOffset(), l2.getOffset());
            }
        });
        List<CaseBlock> caseBlocks = switchNode.getCaseBlocks();
        IdentityHashMap<Label, Pair> caseLookup = new IdentityHashMap<Label, Pair>();
        for (int i = 0; i < caseBlocks.size(); ++i) {
            CaseBlock block = caseBlocks.get(i);
            caseLookup.put((Label)block.getEntryGoto().getOperand(), Pair.create((Object)block, (Object)i));
        }
        StrongBox label = new StrongBox();
        HashSet<CaseBlock> movedBlocks = new HashSet<CaseBlock>();
        for (int i = 0; i < caseBlocks.size(); ++i) {
            int targetIndex;
            Pair caseInfo;
            CaseBlock block = caseBlocks.get(i);
            List<Node> caseBody = block.getBody();
            Node lastInCase = (Node)CollectionUtilities.lastOrDefault(caseBody);
            if (lastInCase instanceof BasicBlock) {
                lastInCase = (Node)CollectionUtilities.lastOrDefault(((BasicBlock)lastInCase).getBody());
            } else if (lastInCase instanceof Block) {
                lastInCase = (Node)CollectionUtilities.lastOrDefault(((Block)lastInCase).getBody());
            }
            if (!PatternMatching.matchGetOperand(lastInCase, AstCode.Goto, label) || (caseInfo = (Pair)caseLookup.get(label.get())) == null || (targetIndex = ((Integer)caseInfo.getSecond()).intValue()) == i + 1 || movedBlocks.contains(block)) continue;
            caseBlocks.remove(i);
            caseBlocks.add(targetIndex, block);
            movedBlocks.add(block);
            if (targetIndex <= i) continue;
            --i;
        }
    }

    private static boolean hasSingleEdgeEnteringBlock(ControlFlowNode node) {
        int count = 0;
        for (ControlFlowEdge edge : node.getIncoming()) {
            if (node.dominates(edge.getSource()) || ++count <= 1) continue;
            return false;
        }
        return count == 1;
    }

    private static Set<ControlFlowNode> findDominatedNodes(Set<ControlFlowNode> scope, ControlFlowNode head) {
        LinkedHashSet<ControlFlowNode> agenda = new LinkedHashSet<ControlFlowNode>();
        LinkedHashSet<ControlFlowNode> result = new LinkedHashSet<ControlFlowNode>();
        agenda.add(head);
        while (!agenda.isEmpty()) {
            ControlFlowNode addNode = (ControlFlowNode)agenda.iterator().next();
            agenda.remove(addNode);
            if (!scope.contains(addNode) || !head.dominates(addNode) || !result.add(addNode)) continue;
            for (ControlFlowNode successor : addNode.getSuccessors()) {
                agenda.add(successor);
            }
        }
        return result;
    }

    private static final class LoopExitInfo {
        Label exitLabel;
        final Set<ControlFlowNode> additionalNodes = new LinkedHashSet<ControlFlowNode>();

        private LoopExitInfo() {
        }
    }
}

