/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.adaptors.jdbc.config;

import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.adaptors.jdbc.BindModeSearchDatabaseAuthenticationHandler;
import org.apereo.cas.adaptors.jdbc.QueryAndEncodeDatabaseAuthenticationHandler;
import org.apereo.cas.adaptors.jdbc.QueryDatabaseAuthenticationHandler;
import org.apereo.cas.adaptors.jdbc.SearchModeSearchDatabaseAuthenticationHandler;
import org.apereo.cas.authentication.AuthenticationEventExecutionPlanConfigurer;
import org.apereo.cas.authentication.AuthenticationHandler;
import org.apereo.cas.authentication.CoreAuthenticationUtils;
import org.apereo.cas.authentication.principal.PrincipalFactory;
import org.apereo.cas.authentication.principal.PrincipalFactoryUtils;
import org.apereo.cas.authentication.principal.PrincipalNameTransformerUtils;
import org.apereo.cas.authentication.principal.PrincipalResolver;
import org.apereo.cas.authentication.support.password.PasswordEncoderUtils;
import org.apereo.cas.authentication.support.password.PasswordPolicyConfiguration;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.core.authentication.PasswordEncoderProperties;
import org.apereo.cas.configuration.model.core.authentication.PrincipalTransformationProperties;
import org.apereo.cas.configuration.model.support.jdbc.BindJdbcAuthenticationProperties;
import org.apereo.cas.configuration.model.support.jdbc.JdbcAuthenticationProperties;
import org.apereo.cas.configuration.model.support.jdbc.QueryEncodeJdbcAuthenticationProperties;
import org.apereo.cas.configuration.model.support.jdbc.QueryJdbcAuthenticationProperties;
import org.apereo.cas.configuration.model.support.jdbc.SearchJdbcAuthenticationProperties;
import org.apereo.cas.configuration.model.support.jpa.AbstractJpaProperties;
import org.apereo.cas.configuration.support.JpaBeans;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.util.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(value="CasJdbcAuthenticationConfiguration")
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
public class CasJdbcAuthenticationConfiguration {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(CasJdbcAuthenticationConfiguration.class);
    @Autowired(required=false)
    @Qualifier(value="queryAndEncodePasswordPolicyConfiguration")
    private PasswordPolicyConfiguration queryAndEncodePasswordPolicyConfiguration;
    @Autowired(required=false)
    @Qualifier(value="searchModePasswordPolicyConfiguration")
    private PasswordPolicyConfiguration searchModePasswordPolicyConfiguration;
    @Autowired(required=false)
    @Qualifier(value="queryPasswordPolicyConfiguration")
    private PasswordPolicyConfiguration queryPasswordPolicyConfiguration;
    @Autowired(required=false)
    @Qualifier(value="bindSearchPasswordPolicyConfiguration")
    private PasswordPolicyConfiguration bindSearchPasswordPolicyConfiguration;
    @Autowired
    @Qualifier(value="servicesManager")
    private ServicesManager servicesManager;
    @Autowired
    private CasConfigurationProperties casProperties;
    @Autowired
    @Qualifier(value="personDirectoryPrincipalResolver")
    private PrincipalResolver personDirectoryPrincipalResolver;

    @ConditionalOnMissingBean(name={"jdbcAuthenticationHandlers"})
    @Bean
    @RefreshScope
    public Collection<AuthenticationHandler> jdbcAuthenticationHandlers() {
        HashSet<AuthenticationHandler> handlers = new HashSet<AuthenticationHandler>();
        JdbcAuthenticationProperties jdbc = this.casProperties.getAuthn().getJdbc();
        jdbc.getBind().forEach(b -> handlers.add(this.bindModeSearchDatabaseAuthenticationHandler((BindJdbcAuthenticationProperties)b)));
        jdbc.getEncode().forEach(b -> handlers.add(this.queryAndEncodeDatabaseAuthenticationHandler((QueryEncodeJdbcAuthenticationProperties)b)));
        jdbc.getQuery().forEach(b -> handlers.add(this.queryDatabaseAuthenticationHandler((QueryJdbcAuthenticationProperties)b)));
        jdbc.getSearch().forEach(b -> handlers.add(this.searchModeSearchDatabaseAuthenticationHandler((SearchJdbcAuthenticationProperties)b)));
        return handlers;
    }

    private AuthenticationHandler bindModeSearchDatabaseAuthenticationHandler(BindJdbcAuthenticationProperties b) {
        BindModeSearchDatabaseAuthenticationHandler h = new BindModeSearchDatabaseAuthenticationHandler(b.getName(), this.servicesManager, this.jdbcPrincipalFactory(), Integer.valueOf(b.getOrder()), JpaBeans.newDataSource((AbstractJpaProperties)b));
        h.setPasswordEncoder(PasswordEncoderUtils.newPasswordEncoder((PasswordEncoderProperties)b.getPasswordEncoder()));
        h.setPrincipalNameTransformer(PrincipalNameTransformerUtils.newPrincipalNameTransformer((PrincipalTransformationProperties)b.getPrincipalTransformation()));
        if (this.bindSearchPasswordPolicyConfiguration != null) {
            h.setPasswordPolicyConfiguration(this.bindSearchPasswordPolicyConfiguration);
        }
        h.setPrincipalNameTransformer(PrincipalNameTransformerUtils.newPrincipalNameTransformer((PrincipalTransformationProperties)b.getPrincipalTransformation()));
        if (StringUtils.isNotBlank((CharSequence)b.getCredentialCriteria())) {
            h.setCredentialSelectionPredicate(CoreAuthenticationUtils.newCredentialSelectionPredicate((String)b.getCredentialCriteria()));
        }
        LOGGER.debug("Created authentication handler [{}] to handle database url at [{}]", (Object)h.getName(), (Object)b.getUrl());
        return h;
    }

    private AuthenticationHandler queryAndEncodeDatabaseAuthenticationHandler(QueryEncodeJdbcAuthenticationProperties b) {
        QueryAndEncodeDatabaseAuthenticationHandler h = new QueryAndEncodeDatabaseAuthenticationHandler(b.getName(), this.servicesManager, this.jdbcPrincipalFactory(), Integer.valueOf(b.getOrder()), JpaBeans.newDataSource((AbstractJpaProperties)b), b.getAlgorithmName(), b.getSql(), b.getPasswordFieldName(), b.getSaltFieldName(), b.getExpiredFieldName(), b.getDisabledFieldName(), b.getNumberOfIterationsFieldName(), b.getNumberOfIterations(), b.getStaticSalt());
        h.setPasswordEncoder(PasswordEncoderUtils.newPasswordEncoder((PasswordEncoderProperties)b.getPasswordEncoder()));
        h.setPrincipalNameTransformer(PrincipalNameTransformerUtils.newPrincipalNameTransformer((PrincipalTransformationProperties)b.getPrincipalTransformation()));
        if (this.queryAndEncodePasswordPolicyConfiguration != null) {
            h.setPasswordPolicyConfiguration(this.queryAndEncodePasswordPolicyConfiguration);
        }
        h.setPrincipalNameTransformer(PrincipalNameTransformerUtils.newPrincipalNameTransformer((PrincipalTransformationProperties)b.getPrincipalTransformation()));
        if (StringUtils.isNotBlank((CharSequence)b.getCredentialCriteria())) {
            h.setCredentialSelectionPredicate(CoreAuthenticationUtils.newCredentialSelectionPredicate((String)b.getCredentialCriteria()));
        }
        LOGGER.debug("Created authentication handler [{}] to handle database url at [{}]", (Object)h.getName(), (Object)b.getUrl());
        return h;
    }

    private AuthenticationHandler queryDatabaseAuthenticationHandler(QueryJdbcAuthenticationProperties b) {
        Multimap attributes = CoreAuthenticationUtils.transformPrincipalAttributesListIntoMultiMap((List)b.getPrincipalAttributeList());
        LOGGER.debug("Created and mapped principal attributes [{}] for [{}]...", (Object)attributes, (Object)b.getUrl());
        QueryDatabaseAuthenticationHandler h = new QueryDatabaseAuthenticationHandler(b.getName(), this.servicesManager, this.jdbcPrincipalFactory(), Integer.valueOf(b.getOrder()), JpaBeans.newDataSource((AbstractJpaProperties)b), b.getSql(), b.getFieldPassword(), b.getFieldExpired(), b.getFieldDisabled(), CollectionUtils.wrap((Multimap)attributes));
        h.setPasswordEncoder(PasswordEncoderUtils.newPasswordEncoder((PasswordEncoderProperties)b.getPasswordEncoder()));
        h.setPrincipalNameTransformer(PrincipalNameTransformerUtils.newPrincipalNameTransformer((PrincipalTransformationProperties)b.getPrincipalTransformation()));
        if (this.queryPasswordPolicyConfiguration != null) {
            h.setPasswordPolicyConfiguration(this.queryPasswordPolicyConfiguration);
        }
        h.setPrincipalNameTransformer(PrincipalNameTransformerUtils.newPrincipalNameTransformer((PrincipalTransformationProperties)b.getPrincipalTransformation()));
        if (StringUtils.isNotBlank((CharSequence)b.getCredentialCriteria())) {
            h.setCredentialSelectionPredicate(CoreAuthenticationUtils.newCredentialSelectionPredicate((String)b.getCredentialCriteria()));
        }
        LOGGER.debug("Created authentication handler [{}] to handle database url at [{}]", (Object)h.getName(), (Object)b.getUrl());
        return h;
    }

    private AuthenticationHandler searchModeSearchDatabaseAuthenticationHandler(SearchJdbcAuthenticationProperties b) {
        SearchModeSearchDatabaseAuthenticationHandler h = new SearchModeSearchDatabaseAuthenticationHandler(b.getName(), this.servicesManager, this.jdbcPrincipalFactory(), Integer.valueOf(b.getOrder()), JpaBeans.newDataSource((AbstractJpaProperties)b), b.getFieldUser(), b.getFieldPassword(), b.getTableUsers());
        h.setPasswordEncoder(PasswordEncoderUtils.newPasswordEncoder((PasswordEncoderProperties)b.getPasswordEncoder()));
        h.setPrincipalNameTransformer(PrincipalNameTransformerUtils.newPrincipalNameTransformer((PrincipalTransformationProperties)b.getPrincipalTransformation()));
        h.setPrincipalNameTransformer(PrincipalNameTransformerUtils.newPrincipalNameTransformer((PrincipalTransformationProperties)b.getPrincipalTransformation()));
        if (this.searchModePasswordPolicyConfiguration != null) {
            h.setPasswordPolicyConfiguration(this.searchModePasswordPolicyConfiguration);
        }
        if (StringUtils.isNotBlank((CharSequence)b.getCredentialCriteria())) {
            h.setCredentialSelectionPredicate(CoreAuthenticationUtils.newCredentialSelectionPredicate((String)b.getCredentialCriteria()));
        }
        LOGGER.debug("Created authentication handler [{}] to handle database url at [{}]", (Object)h.getName(), (Object)b.getUrl());
        return h;
    }

    @ConditionalOnMissingBean(name={"jdbcPrincipalFactory"})
    @Bean
    @RefreshScope
    public PrincipalFactory jdbcPrincipalFactory() {
        return PrincipalFactoryUtils.newPrincipalFactory();
    }

    @ConditionalOnMissingBean(name={"jdbcAuthenticationEventExecutionPlanConfigurer"})
    @Bean
    public AuthenticationEventExecutionPlanConfigurer jdbcAuthenticationEventExecutionPlanConfigurer() {
        return plan -> this.jdbcAuthenticationHandlers().forEach(h -> plan.registerAuthenticationHandlerWithPrincipalResolver(h, this.personDirectoryPrincipalResolver));
    }
}

